/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.type.eventmesh;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseDialect;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.type.SQLType;
import org.apache.eventmesh.connector.jdbc.type.AbstractType;

public class DateTimeEventMeshDataType
extends AbstractType<LocalDateTime> {
    public static final DateTimeEventMeshDataType INSTANCE = new DateTimeEventMeshDataType();

    private DateTimeEventMeshDataType() {
        super(LocalDateTime.class, SQLType.TIMESTAMP, "DATETIME");
    }

    @Override
    public List<String> ofRegistrationKeys() {
        return Arrays.asList(this.getName());
    }

    @Override
    public String getDefaultValue(DatabaseDialect<?> databaseDialect, Column<?> column) {
        if (column.getDefaultValue() == null) {
            return "NULL";
        }
        LocalDateTime localDateTime = LocalDateTime.parse(column.getDefaultValue().toString());
        if (Optional.ofNullable(column.getColumnLength()).orElse(0L) > 0L) {
            return "'" + localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S")) + "'";
        }
        return "'" + localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + "'";
    }
}

