/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source.dialect.snapshot;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.config.connector.rdb.jdbc.JdbcSourceConfig;
import org.apache.eventmesh.connector.jdbc.DataChanges;
import org.apache.eventmesh.connector.jdbc.Field;
import org.apache.eventmesh.connector.jdbc.JdbcContext;
import org.apache.eventmesh.connector.jdbc.OffsetContext;
import org.apache.eventmesh.connector.jdbc.Partition;
import org.apache.eventmesh.connector.jdbc.Payload;
import org.apache.eventmesh.connector.jdbc.Schema;
import org.apache.eventmesh.connector.jdbc.UniversalJdbcContext;
import org.apache.eventmesh.connector.jdbc.connection.JdbcConnection;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseDialect;
import org.apache.eventmesh.connector.jdbc.event.Event;
import org.apache.eventmesh.connector.jdbc.event.InsertDataEvent;
import org.apache.eventmesh.connector.jdbc.source.AbstractEngine;
import org.apache.eventmesh.connector.jdbc.source.SourceMateData;
import org.apache.eventmesh.connector.jdbc.source.dialect.snapshot.SnapshotEngine;
import org.apache.eventmesh.connector.jdbc.source.dialect.snapshot.SnapshotResult;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSnapshotEngine<DbDialect extends DatabaseDialect<Jconn>, Jc extends JdbcContext<Part, Offset>, Part extends Partition, Offset extends OffsetContext, Jconn extends JdbcConnection>
extends AbstractEngine<DbDialect>
implements SnapshotEngine<Jc> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractSnapshotEngine.class);
    private final Jconn jdbcConnection;
    private Jc context;
    private Part partition;
    private Offset offsetContext;
    protected BlockingQueue<Event> eventQueue = new LinkedBlockingQueue<Event>(10000);

    public AbstractSnapshotEngine(JdbcSourceConfig jdbcSourceConfig, DbDialect databaseDialect, Jc jdbcContext, Part partition, Offset context) {
        super(jdbcSourceConfig, databaseDialect);
        this.context = jdbcContext;
        this.partition = partition;
        this.offsetContext = context;
        this.jdbcConnection = databaseDialect.getConnection();
    }

    @Override
    public SnapshotResult<Jc> execute() {
        if (this.jdbcSourceConfig.getSourceConnectorConfig().isSkipSnapshot()) {
            return new SnapshotResult<Object>(SnapshotResult.SnapshotResultStatus.SKIPPED, null);
        }
        SnapshotContext<Part, Offset> snapshotContext = new SnapshotContext<Part, Offset>(this.partition, this.offsetContext);
        return this.doExecute(this.context, snapshotContext);
    }

    protected SnapshotResult<Jc> doExecute(Jc context, SnapshotContext<Part, Offset> snapshotContext) {
        Connection masterConnection = null;
        Queue<JdbcConnection> connectionPool = null;
        try {
            masterConnection = this.createMasterConnection();
            log.info("Snapshot 1: Preparations for Snapshot Work");
            this.preSnapshot(context, snapshotContext);
            log.info("Snapshot 2: Retrieve tables requiring snapshot handling");
            this.determineTable2Process(context, snapshotContext);
            log.info("Snapshot 3: Put locks on the tables that need to be processed");
            if (this.sourceConnectorConfig.isSnapshotSchema()) {
                this.lockTables4SchemaSnapshot(context, snapshotContext);
            }
            log.info("Snapshot 4: Determining snapshot offset");
            this.determineSnapshotOffset(context, snapshotContext);
            log.info("Snapshot 5: Obtain the schema of the captured tables");
            this.readStructureOfTables(context, snapshotContext);
            this.releaseSnapshotLocks(context, snapshotContext);
            if (this.sourceConnectorConfig.isSnapshotData()) {
                connectionPool = this.createConnectionPool(snapshotContext);
                this.createDataEvents(context, snapshotContext, connectionPool);
            }
            log.info("Snapshot 6: Release the locks");
            this.releaseSnapshotLocks(context, snapshotContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (CollectionUtils.isNotEmpty(connectionPool)) {
                    for (JdbcConnection conn : connectionPool) {
                        conn.close();
                    }
                }
                this.rollbackMasterConnTransaction(masterConnection);
            }
            catch (Exception e) {
                log.warn("Handle snapshot finally error", (Throwable)e);
            }
        }
        return new SnapshotResult<Jc>(SnapshotResult.SnapshotResultStatus.COMPLETED, context);
    }

    private void rollbackMasterConnTransaction(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Connection createMasterConnection() throws SQLException {
        Object connection = this.databaseDialect.getConnection();
        ((JdbcConnection)connection).setAutoCommit(false);
        return ((JdbcConnection)connection).connection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDataEvents(Jc context, SnapshotContext<Part, Offset> snapshotContext, Queue<JdbcConnection> connectionPool) throws Exception {
        int handleDataThreadNum = connectionPool.size();
        ThreadPoolExecutor tableDataPoolExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)handleDataThreadNum, (int)handleDataThreadNum, (String)"snapshot-table-data-thread");
        ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(tableDataPoolExecutor);
        try {
            for (TableId tableId : snapshotContext.determineTables) {
                String sql = this.getSnapshotTableSelectSql(context, snapshotContext, tableId).get();
                Callable<Void> callable = this.createSnapshotDataEvent4TableCallable(context, snapshotContext, connectionPool, sql, tableId);
                completionService.submit(callable);
            }
            int tableSize = snapshotContext.determineTables.size();
            for (int index = 0; index < tableSize; ++index) {
                completionService.take().get();
            }
        }
        finally {
            tableDataPoolExecutor.shutdownNow();
        }
    }

    private Callable<Void> createSnapshotDataEvent4TableCallable(Jc context, SnapshotContext<Part, Offset> snapshotContext, Queue<JdbcConnection> connectionPool, String sql, TableId tableId) {
        UniversalJdbcContext universalJdbcContext = (UniversalJdbcContext)context;
        return () -> {
            JdbcConnection connection = (JdbcConnection)connectionPool.poll();
            SourceMateData sourceMateData = this.buildSourceMateData(context, snapshotContext, tableId);
            TableSchema tableSchema = universalJdbcContext.getCatalogTableSet().getTableSchema(tableId);
            Field field = new Field().withField("after").withName("payload.after").withRequired(false);
            List<Column<?>> columns = tableSchema.getColumns();
            if (CollectionUtils.isNotEmpty(columns)) {
                List<Field> fields = columns.stream().map(col -> {
                    Column rebuild = Column.newBuilder().withName(col.getName()).withDataType(col.getDataType()).withJdbcType(col.getJdbcType()).withNativeType(col.getNativeType()).withOrder(col.getOrder()).build();
                    return new Field(rebuild, col.isNotNull(), col.getName(), tableId.toString());
                }).collect(Collectors.toList());
                field.withRequired(true).withFields(fields);
            }
            try (Statement statement = connection.createStatement(this.jdbcSourceConfig.getSourceConnectorConfig().getSnapshotFetchSize(), 100);){
                ResultSet resultSet = statement.executeQuery(sql);
                while (resultSet.next()) {
                    int columnCount = resultSet.getMetaData().getColumnCount();
                    InsertDataEvent event = new InsertDataEvent(tableId);
                    HashMap<String, Object> values = new HashMap<String, Object>(columnCount);
                    for (int index = 1; index <= columnCount; ++index) {
                        values.put(resultSet.getMetaData().getColumnName(index), resultSet.getObject(index));
                    }
                    DataChanges.Builder builder = DataChanges.newBuilder();
                    builder.withAfter(values);
                    builder.withType(event.getDataChangeEventType().ofCode());
                    Payload payload = event.getJdbcConnectData().getPayload();
                    payload.withDataChanges(builder.build());
                    payload.withSource(sourceMateData);
                    event.getJdbcConnectData().setSchema(new Schema(Collections.singletonList(field)));
                    this.eventQueue.put(event);
                }
            }
            finally {
                connectionPool.add(connection);
            }
            return null;
        };
    }

    private Queue<JdbcConnection> createConnectionPool(SnapshotContext<Part, Offset> snapshotContext) throws SQLException {
        ConcurrentLinkedQueue<JdbcConnection> connectionPool = new ConcurrentLinkedQueue<JdbcConnection>();
        int snapshotMaxThreads = Math.max(1, Math.min(this.jdbcSourceConfig.getSourceConnectorConfig().getSnapshotMaxThreads(), snapshotContext.determineTables.size()));
        for (int i = 0; i < snapshotMaxThreads; ++i) {
            JdbcConnection conn = ((JdbcConnection)this.databaseDialect.newConnection()).setAutoCommit(false);
            conn.connection().setTransactionIsolation(((JdbcConnection)this.jdbcConnection).connection().getTransactionIsolation());
            connectionPool.add(conn);
        }
        log.info("Created connection pool with {} number", (Object)snapshotMaxThreads);
        return connectionPool;
    }

    protected abstract SourceMateData buildSourceMateData(Jc var1, SnapshotContext<Part, Offset> var2, TableId var3);

    protected abstract void preSnapshot(Jc var1, SnapshotContext<Part, Offset> var2);

    protected abstract void determineTable2Process(Jc var1, SnapshotContext<Part, Offset> var2);

    protected abstract void lockTables4SchemaSnapshot(Jc var1, SnapshotContext<Part, Offset> var2) throws SQLException;

    protected abstract void determineSnapshotOffset(Jc var1, SnapshotContext<Part, Offset> var2) throws SQLException;

    protected abstract void readStructureOfTables(Jc var1, SnapshotContext<Part, Offset> var2) throws SQLException, InterruptedException;

    protected abstract void releaseSnapshotLocks(Jc var1, SnapshotContext<Part, Offset> var2) throws Exception;

    protected abstract Optional<String> getSnapshotTableSelectSql(Jc var1, SnapshotContext<Part, Offset> var2, TableId var3);

    protected OptionalLong getRowCount4Table(TableId tableId) {
        return OptionalLong.empty();
    }

    public static class SnapshotContext<P extends Partition, O extends OffsetContext>
    implements AutoCloseable {
        protected P partition;
        protected O offset;
        protected Set<TableId> determineTables = new HashSet<TableId>();

        public SnapshotContext(P partition, O offset) {
            this.partition = partition;
            this.offset = offset;
        }

        @Override
        public void close() throws Exception {
        }

        public void add(TableId tableId) {
            this.determineTables.add(tableId);
        }

        public void addAll(Set<TableId> tableIds) {
            if (tableIds != null) {
                this.determineTables.addAll(tableIds);
            }
        }

        public P getPartition() {
            return this.partition;
        }

        public O getOffset() {
            return this.offset;
        }

        public Set<TableId> getDetermineTables() {
            return this.determineTables;
        }
    }
}

