/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.listener;

import java.util.List;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.connector.rdb.jdbc.SourceConnectorConfig;
import org.apache.eventmesh.connector.jdbc.CatalogChanges;
import org.apache.eventmesh.connector.jdbc.Payload;
import org.apache.eventmesh.connector.jdbc.antlr4.autogeneration.MySqlParser;
import org.apache.eventmesh.connector.jdbc.event.CreateTableEvent;
import org.apache.eventmesh.connector.jdbc.event.SchemaChangeEventType;
import org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.MysqlAntlr4DdlParser;
import org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.listener.TableBaseParserListener;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.MysqlSourceMateData;
import org.apache.eventmesh.connector.jdbc.table.catalog.Table;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;
import org.apache.eventmesh.connector.jdbc.table.catalog.mysql.MysqlOptions;
import org.apache.eventmesh.connector.jdbc.table.catalog.mysql.MysqlTableEditor;
import org.apache.eventmesh.connector.jdbc.table.catalog.mysql.MysqlTableSchema;
import org.apache.eventmesh.connector.jdbc.utils.Antlr4Utils;

public class CreateTableParserListener
extends TableBaseParserListener {
    public CreateTableParserListener(List<ParseTreeListener> listeners, MysqlAntlr4DdlParser parser) {
        super(listeners, parser);
    }

    @Override
    public void enterCopyCreateTable(MySqlParser.CopyCreateTableContext ctx) {
        super.enterCopyCreateTable(ctx);
    }

    @Override
    public void enterQueryCreateTable(MySqlParser.QueryCreateTableContext ctx) {
        super.enterQueryCreateTable(ctx);
    }

    @Override
    public void enterColumnCreateTable(MySqlParser.ColumnCreateTableContext ctx) {
        String tableName = ctx.tableName().fullId().getText();
        this.tableEditor = this.createTableEditor(tableName);
        super.enterColumnCreateTable(ctx);
    }

    @Override
    public void exitColumnCreateTable(MySqlParser.ColumnCreateTableContext ctx) {
        String ddl = Antlr4Utils.getText(ctx);
        this.parser.runIfAllNotNull(() -> {
            this.listeners.remove(this.columnDefinitionListener);
            this.columnDefinitionListener = null;
            MysqlTableSchema tableSchema = (MysqlTableSchema)this.tableEditor.build();
            this.parser.getCatalogTableSet().overrideTable(tableSchema);
            String currentDatabase = this.parser.getCurrentDatabase();
            CreateTableEvent event = new CreateTableEvent(new TableId(currentDatabase, null, tableSchema.getSimpleName()));
            Payload payload = event.getJdbcConnectData().getPayload();
            SourceConnectorConfig sourceConnectorConfig = this.parser.getSourceConfig().getSourceConnectorConfig();
            MysqlSourceMateData sourceMateData = MysqlSourceMateData.newBuilder().name(sourceConnectorConfig.getName()).catalogName(currentDatabase).serverId(sourceConnectorConfig.getMysqlConfig().getServerId()).build();
            Table table = Table.newBuilder().withTableId(tableSchema.getTableId()).withPrimaryKey(tableSchema.getPrimaryKey()).withUniqueKeys(tableSchema.getUniqueKeys()).withComment(tableSchema.getComment()).withOptions(tableSchema.getTableOptions()).build();
            CatalogChanges changes = CatalogChanges.newBuilder().operationType(SchemaChangeEventType.TABLE_CREATE).table(table).columns(tableSchema.getColumns()).build();
            payload.withSource(sourceMateData).withDdl(ddl).withCatalogChanges(changes);
            this.parser.handleEvent(event);
        }, this.tableEditor);
        this.columnOrder.set(1);
        super.exitColumnCreateTable(ctx);
    }

    private MysqlTableEditor createTableEditor(String tableName) {
        TableId tableId = this.parser.parseTableId(tableName);
        if (StringUtils.isBlank((CharSequence)tableId.getCatalogName())) {
            tableId.setCatalogName(this.parser.getCurrentDatabase());
        }
        return MysqlTableEditor.ofCatalogTableEditor(tableId);
    }

    @Override
    public void enterTableOptionEngine(MySqlParser.TableOptionEngineContext ctx) {
        if (ctx.ENGINE() != null) {
            this.tableEditor.withOption(MysqlOptions.MysqlTableOptions.ENGINE, ctx.engineName().getText());
        }
        super.enterTableOptionEngine(ctx);
    }

    @Override
    public void enterTableOptionCharset(MySqlParser.TableOptionCharsetContext ctx) {
        List<TerminalNode> nodes = ctx.DEFAULT();
        if (CollectionUtils.isNotEmpty(nodes) && nodes.size() == 2) {
            TerminalNode node = nodes.get(1);
            this.tableEditor.withOption(MysqlOptions.MysqlTableOptions.CHARSET, node.getText());
        } else {
            this.tableEditor.withOption(MysqlOptions.MysqlTableOptions.CHARSET, ctx.charsetName().getText());
        }
        super.enterTableOptionCharset(ctx);
    }

    @Override
    public void enterTableOptionAutoIncrement(MySqlParser.TableOptionAutoIncrementContext ctx) {
        MySqlParser.DecimalLiteralContext decimalLiteralContext = ctx.decimalLiteral();
        if (decimalLiteralContext != null) {
            String autoIncrementNumber = Antlr4Utils.getText(decimalLiteralContext);
            this.tableEditor.withOption(MysqlOptions.MysqlTableOptions.AUTO_INCREMENT, autoIncrementNumber);
        }
        super.enterTableOptionAutoIncrement(ctx);
    }

    @Override
    public void enterTableOptionCollate(MySqlParser.TableOptionCollateContext ctx) {
        if (ctx.COLLATE() != null) {
            this.tableEditor.withOption(MysqlOptions.MysqlTableOptions.COLLATE, ctx.collationName().getText());
        }
        super.enterTableOptionCollate(ctx);
    }
}

