/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.connector.jdbc.source.JdbcTaskManager;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerCoordinator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskManagerCoordinator.class);
    private final BlockingQueue<ConnectRecord> recordBlockingQueue;
    private final Map<String, JdbcTaskManager> taskManagerCache = new HashMap<String, JdbcTaskManager>(8);
    private final int maxBatchSize;
    private final long maxPollTimeout;

    public TaskManagerCoordinator(int capacity, int maxBatchSize, long maxPollTimeout) {
        this.recordBlockingQueue = new LinkedBlockingQueue<ConnectRecord>(capacity);
        this.maxBatchSize = maxBatchSize;
        this.maxPollTimeout = maxPollTimeout;
    }

    public void registerTaskManager(String name, JdbcTaskManager taskManager) {
        this.taskManagerCache.put(name, taskManager);
    }

    public void init() {
        this.taskManagerCache.values().forEach(JdbcTaskManager::init);
        this.taskManagerCache.values().forEach(taskManager -> taskManager.registerListener(records -> {
            if (CollectionUtils.isEmpty((Collection)records)) {
                return;
            }
            records.forEach(record -> {
                try {
                    this.recordBlockingQueue.put((ConnectRecord)record);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
        }));
    }

    public void start() {
        this.taskManagerCache.values().forEach(JdbcTaskManager::start);
    }

    public List<ConnectRecord> poll() {
        long startTime = System.currentTimeMillis();
        long remainingTime = this.maxPollTimeout;
        ArrayList<ConnectRecord> records = new ArrayList<ConnectRecord>(this.maxBatchSize);
        for (int index = 0; index < this.maxBatchSize; ++index) {
            try {
                ConnectRecord record = this.recordBlockingQueue.poll(remainingTime, TimeUnit.MILLISECONDS);
                if (Objects.isNull(record)) break;
                if (log.isDebugEnabled()) {
                    log.debug("record:{}", (Object)JsonUtils.toJSONString((Object)record));
                }
                records.add(record);
                long elapsedTime = System.currentTimeMillis() - startTime;
                remainingTime = this.maxPollTimeout > elapsedTime ? this.maxPollTimeout - elapsedTime : 0L;
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return records;
    }
}

