/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.http.source.protocol.impl;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.config.connector.http.SourceConnectorConfig;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.connector.http.source.data.CommonResponse;
import org.apache.eventmesh.connector.http.source.data.WebhookRequest;
import org.apache.eventmesh.connector.http.source.protocol.Protocol;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonProtocol
implements Protocol {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonProtocol.class);
    public static final String PROTOCOL_NAME = "Common";
    private SourceConnectorConfig sourceConnectorConfig;

    @Override
    public void initialize(SourceConnectorConfig sourceConnectorConfig) {
        this.sourceConnectorConfig = sourceConnectorConfig;
    }

    @Override
    public void setHandler(Route route, BlockingQueue<Object> queue) {
        route.method(HttpMethod.POST).handler((Handler)BodyHandler.create()).handler(ctx -> {
            Object payload = ctx.body().asString(Constants.DEFAULT_CHARSET.toString());
            payload = JsonUtils.parseObject((String)payload.toString(), String.class);
            Map<String, String> headerMap = ctx.request().headers().entries().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            WebhookRequest webhookRequest = new WebhookRequest(PROTOCOL_NAME, ctx.request().absoluteURI(), headerMap, payload, (RoutingContext)ctx);
            if (!queue.offer(webhookRequest)) {
                throw new IllegalStateException("Failed to store the request.");
            }
            if (!this.sourceConnectorConfig.isDataConsistencyEnabled()) {
                ctx.response().setStatusCode(HttpResponseStatus.OK.code()).end(CommonResponse.success().toJsonStr());
            }
        }).failureHandler(ctx -> {
            log.error("Failed to handle the request. ", ctx.failure());
            ctx.response().setStatusCode(ctx.statusCode()).end(CommonResponse.base(ctx.failure().getMessage()).toJsonStr());
        });
    }

    @Override
    public ConnectRecord convertToConnectRecord(Object message) {
        WebhookRequest request = (WebhookRequest)message;
        ConnectRecord connectRecord = new ConnectRecord(null, null, Long.valueOf(System.currentTimeMillis()), request.getPayload());
        connectRecord.addExtension("source", (Object)request.getProtocolName());
        connectRecord.addExtension("url", (Object)request.getUrl());
        request.getHeaders().forEach((k, v) -> {
            if (k.equalsIgnoreCase("extension")) {
                JsonObject extension = new JsonObject(v);
                extension.forEach(e -> connectRecord.addExtension((String)e.getKey(), e.getValue()));
            }
        });
        if (!connectRecord.getExtensions().containsKey("recordUniqueId")) {
            connectRecord.addExtension("recordUniqueId", (Object)connectRecord.getRecordId());
        }
        if (connectRecord.getExtensionObj("isBase64") != null && Boolean.parseBoolean(connectRecord.getExtensionObj("isBase64").toString())) {
            byte[] data = Base64.getDecoder().decode(connectRecord.getData().toString());
            connectRecord.setData((Object)data);
        }
        if (request.getRoutingContext() != null) {
            connectRecord.addExtension("routingContext", (Object)request.getRoutingContext());
        }
        return connectRecord;
    }
}

