/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.http.source.protocol.impl;

import io.cloudevents.CloudEvent;
import io.cloudevents.http.vertx.VertxMessageFactory;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.Route;
import java.util.concurrent.BlockingQueue;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.http.SourceConnectorConfig;
import org.apache.eventmesh.connector.http.source.data.CommonResponse;
import org.apache.eventmesh.connector.http.source.protocol.Protocol;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.CloudEventUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventProtocol
implements Protocol {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudEventProtocol.class);
    public static final String PROTOCOL_NAME = "CloudEvent";

    @Override
    public void initialize(SourceConnectorConfig sourceConnectorConfig) {
    }

    @Override
    public void setHandler(Route route, BlockingQueue<Object> queue) {
        route.method(HttpMethod.POST).handler(ctx -> VertxMessageFactory.createReader((HttpServerRequest)ctx.request()).map(reader -> {
            CloudEvent event = reader.toEvent();
            if (event.getSubject() == null) {
                throw new IllegalStateException("attribute 'subject' cannot be null");
            }
            if (event.getDataContentType() == null) {
                throw new IllegalStateException("attribute 'datacontenttype' cannot be null");
            }
            if (event.getData() == null) {
                throw new IllegalStateException("attribute 'data' cannot be null");
            }
            return event;
        }).onSuccess(event -> {
            if (!queue.offer(event)) {
                throw new IllegalStateException("Failed to store the request.");
            }
            log.info("[HttpSourceConnector] Succeed to convert payload into CloudEvent. StatusCode={}", (Object)HttpResponseStatus.OK.code());
            ctx.response().setStatusCode(HttpResponseStatus.OK.code()).end(CommonResponse.success().toJsonStr());
        }).onFailure(t -> {
            log.error("[HttpSourceConnector] Malformed request. StatusCode={}", (Object)HttpResponseStatus.BAD_REQUEST.code(), t);
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end(CommonResponse.base(t.getMessage()).toJsonStr());
        }));
    }

    @Override
    public ConnectRecord convertToConnectRecord(Object message) {
        return CloudEventUtil.convertEventToRecord((CloudEvent)((CloudEvent)message));
    }
}

