/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.http.source;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.LoggerHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.http.HttpSourceConfig;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.connector.http.source.data.CommonResponse;
import org.apache.eventmesh.connector.http.source.protocol.Protocol;
import org.apache.eventmesh.connector.http.source.protocol.ProtocolFactory;
import org.apache.eventmesh.openconnect.api.ConnectorCreateService;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSourceConnector
implements Source,
ConnectorCreateService<Source> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpSourceConnector.class);
    private HttpSourceConfig sourceConfig;
    private BlockingQueue<Object> queue;
    private int batchSize;
    private Route route;
    private Protocol protocol;
    private HttpServer server;
    private volatile boolean started = false;
    private volatile boolean destroyed = false;

    public Class<? extends Config> configClass() {
        return HttpSourceConfig.class;
    }

    public Source create() {
        return new HttpSourceConnector();
    }

    public void init(Config config) {
        this.sourceConfig = (HttpSourceConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (HttpSourceConfig)sourceConnectorContext.getSourceConfig();
        this.doInit();
    }

    private void doInit() {
        int maxQueueSize = this.sourceConfig.getConnectorConfig().getMaxStorageSize();
        this.queue = new LinkedBlockingQueue<Object>(maxQueueSize);
        this.batchSize = this.sourceConfig.getConnectorConfig().getBatchSize();
        String protocolName = this.sourceConfig.getConnectorConfig().getProtocol();
        this.protocol = ProtocolFactory.getInstance(this.sourceConfig.connectorConfig, protocolName);
        Vertx vertx = Vertx.vertx();
        Router router = Router.router((Vertx)vertx);
        this.route = router.route().path(this.sourceConfig.connectorConfig.getPath()).handler((Handler)LoggerHandler.create());
        this.protocol.setHandler(this.route, this.queue);
        this.server = vertx.createHttpServer(new HttpServerOptions().setPort(this.sourceConfig.connectorConfig.getPort()).setMaxFormAttributeSize(this.sourceConfig.connectorConfig.getMaxFormAttributeSize()).setIdleTimeout(this.sourceConfig.connectorConfig.getIdleTimeout()).setIdleTimeoutUnit(TimeUnit.MILLISECONDS)).requestHandler((Handler)router);
    }

    public void start() {
        this.server.listen(res -> {
            if (!res.succeeded()) {
                log.error("HttpSourceConnector failed to start on port: {}", (Object)this.sourceConfig.getConnectorConfig().getPort());
                throw new EventMeshException("failed to start Vertx server", res.cause());
            }
            this.started = true;
            log.info("HttpSourceConnector started on port: {}", (Object)this.sourceConfig.getConnectorConfig().getPort());
        });
    }

    public void commit(ConnectRecord record) {
        if (this.sourceConfig.getConnectorConfig().isDataConsistencyEnabled()) {
            log.debug("HttpSourceConnector commit record: {}", (Object)record.getRecordId());
            RoutingContext routingContext = (RoutingContext)record.getExtensionObj("routingContext");
            if (routingContext != null) {
                routingContext.response().putHeader("content-type", "application/json").setStatusCode(HttpResponseStatus.OK.code()).end(CommonResponse.success().toJsonStr());
            } else {
                log.error("Failed to commit the record, routingContext is null, recordId: {}", (Object)record.getRecordId());
            }
        }
    }

    public String name() {
        return this.sourceConfig.getConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
        if (this.route != null) {
            this.route.failureHandler(ctx -> {
                log.error("Failed to handle the request, recordId {}. ", (Object)record.getRecordId(), (Object)ctx.failure());
                ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end("{\"status\":\"failed\",\"recordId\":\"" + record.getRecordId() + "\"}");
            });
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.close(res -> {
                if (!res.succeeded()) {
                    log.error("HttpSourceConnector failed to stop on port: {}", (Object)this.sourceConfig.getConnectorConfig().getPort());
                    throw new EventMeshException("failed to stop Vertx server", res.cause());
                }
                this.destroyed = true;
                log.info("HttpSourceConnector stopped on port: {}", (Object)this.sourceConfig.getConnectorConfig().getPort());
            });
        } else {
            log.warn("HttpSourceConnector server is null, ignore.");
        }
    }

    public List<ConnectRecord> poll() {
        long maxPollWaitTime;
        long startTime = System.currentTimeMillis();
        long remainingTime = maxPollWaitTime = 5000L;
        ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>(this.batchSize);
        for (int i = 0; i < this.batchSize; ++i) {
            try {
                Object obj = this.queue.poll(remainingTime, TimeUnit.MILLISECONDS);
                if (obj == null) break;
                ConnectRecord connectRecord = this.protocol.convertToConnectRecord(obj);
                connectRecords.add(connectRecord);
                long elapsedTime = System.currentTimeMillis() - startTime;
                remainingTime = maxPollWaitTime > elapsedTime ? maxPollWaitTime - elapsedTime : 0L;
                continue;
            }
            catch (Exception e) {
                log.error("Failed to poll from queue.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return connectRecords;
    }

    @Generated
    public boolean isStarted() {
        return this.started;
    }

    @Generated
    public boolean isDestroyed() {
        return this.destroyed;
    }
}

