/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.http.sink.handler;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.http.SinkConnectorConfig;
import org.apache.eventmesh.connector.http.sink.data.HttpAttemptEvent;
import org.apache.eventmesh.connector.http.sink.data.HttpConnectRecord;
import org.apache.eventmesh.connector.http.sink.data.MultiHttpRequestContext;
import org.apache.eventmesh.connector.http.sink.handler.HttpDeliveryStrategy;
import org.apache.eventmesh.connector.http.sink.handler.HttpSinkHandler;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;

public abstract class AbstractHttpSinkHandler
implements HttpSinkHandler {
    private final SinkConnectorConfig sinkConnectorConfig;
    private final List<URI> urls;
    private final HttpDeliveryStrategy deliveryStrategy;
    private int roundRobinIndex = 0;

    protected AbstractHttpSinkHandler(SinkConnectorConfig sinkConnectorConfig) {
        this.sinkConnectorConfig = sinkConnectorConfig;
        this.deliveryStrategy = HttpDeliveryStrategy.valueOf(sinkConnectorConfig.getDeliveryStrategy());
        String[] urlStrings = sinkConnectorConfig.getUrls();
        this.urls = Arrays.stream(urlStrings).map(URI::create).collect(Collectors.toList());
    }

    @Override
    public void handle(ConnectRecord record) {
        ConcurrentHashMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
        switch (this.deliveryStrategy) {
            case ROUND_ROBIN: {
                attributes.put("multi-http-request-context", new MultiHttpRequestContext(1));
                URI url = this.urls.get(this.roundRobinIndex);
                this.roundRobinIndex = (this.roundRobinIndex + 1) % this.urls.size();
                this.sendRecordToUrl(record, attributes, url);
                break;
            }
            case BROADCAST: {
                for (URI broadcastUrl : this.urls) {
                    attributes.put("multi-http-request-context", new MultiHttpRequestContext(this.urls.size()));
                    this.sendRecordToUrl(record, attributes, broadcastUrl);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown delivery strategy: " + (Object)((Object)this.deliveryStrategy));
            }
        }
    }

    private void sendRecordToUrl(ConnectRecord record, Map<String, Object> attributes, URI url) {
        String type = String.format("%s.%s.%s", this.sinkConnectorConfig.getConnectorName(), url.getScheme(), this.sinkConnectorConfig.getWebhookConfig().isActivate() ? "webhook" : "common");
        HttpConnectRecord httpConnectRecord = HttpConnectRecord.convertConnectRecord(record, type);
        HttpAttemptEvent attemptEvent = new HttpAttemptEvent(this.sinkConnectorConfig.getRetryConfig().getMaxRetries() + 1);
        attributes.put("http-attempt-event-" + httpConnectRecord.getHttpRecordId(), attemptEvent);
        this.deliver(url, httpConnectRecord, attributes, record);
    }

    @Generated
    public SinkConnectorConfig getSinkConnectorConfig() {
        return this.sinkConnectorConfig;
    }

    @Generated
    public List<URI> getUrls() {
        return this.urls;
    }
}

