/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.http.resolver;

import com.fasterxml.jackson.core.type.TypeReference;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.v1.CloudEventBuilder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;

public class HttpRequestProtocolResolver {
    public static CloudEvent buildEvent(HttpEventWrapper httpEventWrapper) throws ProtocolHandleException {
        try {
            CloudEventBuilder builder = new CloudEventBuilder();
            Map requestHeaderMap = httpEventWrapper.getHeaderMap();
            Map sysHeaderMap = httpEventWrapper.getSysHeaderMap();
            String id = ((Object)sysHeaderMap.getOrDefault("id", UUID.randomUUID())).toString();
            String source = sysHeaderMap.getOrDefault("source", "/").toString();
            String type = sysHeaderMap.getOrDefault("type", "http_request").toString();
            String subject = sysHeaderMap.getOrDefault("subject", "").toString();
            String dataContentType = requestHeaderMap.getOrDefault("Content-Type", "application/json").toString();
            builder.withId(id).withType(type).withSource(URI.create("source:" + source)).withSubject(subject).withDataContentType(dataContentType);
            for (Map.Entry extension : sysHeaderMap.entrySet()) {
                if (StringUtils.equals((CharSequence)"id", (CharSequence)((CharSequence)extension.getKey())) || StringUtils.equals((CharSequence)"source", (CharSequence)((CharSequence)extension.getKey())) || StringUtils.equals((CharSequence)"type", (CharSequence)((CharSequence)extension.getKey())) || StringUtils.equals((CharSequence)"subject", (CharSequence)((CharSequence)extension.getKey()))) continue;
                String lowerExtensionKey = ((String)extension.getKey()).toLowerCase(Locale.getDefault());
                builder.withExtension(lowerExtensionKey, sysHeaderMap.get(extension.getKey()).toString());
            }
            byte[] requestBody = httpEventWrapper.getBody();
            if (StringUtils.equals((CharSequence)dataContentType, (CharSequence)"application/json")) {
                Map requestBodyMap = (Map)JsonUtils.parseTypeReferenceObject((String)new String(requestBody), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                String requestURI = httpEventWrapper.getRequestURI();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("headers", requestHeaderMap);
                data.put("body", requestBodyMap);
                data.put("path", requestURI);
                data.put("method", httpEventWrapper.getHttpMethod());
                builder = (CloudEventBuilder)builder.withData(JsonUtils.toJSONString(data).getBytes(StandardCharsets.UTF_8));
            } else if (StringUtils.equals((CharSequence)dataContentType, (CharSequence)"application/x-protobuf")) {
                builder = (CloudEventBuilder)builder.withData(requestBody);
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new ProtocolHandleException(e.getMessage(), (Throwable)e);
        }
    }
}

