/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.collections;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.StampedLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class ConcurrentOpenHashMap<K, V> {
    private static final Object EmptyKey = null;
    private static final Object DeletedKey = new Object();
    private static final Object EmptyValue = new Object(){

        @SuppressFBWarnings
        public boolean equals(Object obj) {
            return obj == null;
        }

        public int hashCode() {
            return super.hashCode();
        }
    };
    private static final int DefaultExpectedItems = 256;
    private static final int DefaultConcurrencyLevel = 16;
    private static final float DefaultMapFillFactor = 0.66f;
    private static final float DefaultMapIdleFactor = 0.15f;
    private static final float DefaultExpandFactor = 2.0f;
    private static final float DefaultShrinkFactor = 2.0f;
    private static final boolean DefaultAutoShrink = false;
    private final Section<K, V>[] sections;
    private static final long HashMixer = -4132994306676758123L;
    private static final int R = 47;

    public static <K, V> Builder<K, V> newBuilder() {
        return new Builder();
    }

    @Deprecated
    public ConcurrentOpenHashMap() {
        this(256);
    }

    @Deprecated
    public ConcurrentOpenHashMap(int expectedItems) {
        this(expectedItems, 16);
    }

    @Deprecated
    public ConcurrentOpenHashMap(int expectedItems, int concurrencyLevel) {
        this(expectedItems, concurrencyLevel, 0.66f, 0.15f, false, 2.0f, 2.0f);
    }

    public ConcurrentOpenHashMap(int expectedItems, int concurrencyLevel, float mapFillFactor, float mapIdleFactor, boolean autoShrink, float expandFactor, float shrinkFactor) {
        Preconditions.checkArgument(expectedItems > 0);
        Preconditions.checkArgument(concurrencyLevel > 0);
        Preconditions.checkArgument(expectedItems >= concurrencyLevel);
        Preconditions.checkArgument(mapFillFactor > 0.0f && mapFillFactor < 1.0f);
        Preconditions.checkArgument(mapIdleFactor > 0.0f && mapIdleFactor < 1.0f);
        Preconditions.checkArgument(mapFillFactor > mapIdleFactor);
        Preconditions.checkArgument(expandFactor > 1.0f);
        Preconditions.checkArgument(shrinkFactor > 1.0f);
        int numSections = concurrencyLevel;
        int perSectionExpectedItems = expectedItems / numSections;
        int perSectionCapacity = (int)((float)perSectionExpectedItems / mapFillFactor);
        this.sections = new Section[numSections];
        for (int i = 0; i < numSections; ++i) {
            this.sections[i] = new Section(perSectionCapacity, mapFillFactor, mapIdleFactor, autoShrink, expandFactor, shrinkFactor);
        }
    }

    long getUsedBucketCount() {
        long usedBucketCount = 0L;
        for (Section<K, V> s2 : this.sections) {
            usedBucketCount += (long)((Section)s2).usedBuckets;
        }
        return usedBucketCount;
    }

    public long size() {
        long size = 0L;
        for (Section<K, V> s2 : this.sections) {
            size += (long)((Section)s2).size;
        }
        return size;
    }

    public long capacity() {
        long capacity = 0L;
        for (Section<K, V> s2 : this.sections) {
            capacity += (long)((Section)s2).capacity;
        }
        return capacity;
    }

    public boolean isEmpty() {
        for (Section<K, V> s2 : this.sections) {
            if (((Section)s2).size == 0) continue;
            return false;
        }
        return true;
    }

    public V get(K key) {
        Objects.requireNonNull(key);
        long h2 = ConcurrentOpenHashMap.hash(key);
        return this.getSection(h2).get(key, (int)h2);
    }

    public boolean containsKey(K key) {
        return this.get(key) != null;
    }

    public V put(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        long h2 = ConcurrentOpenHashMap.hash(key);
        return this.getSection(h2).put(key, value, (int)h2, false, null);
    }

    public V putIfAbsent(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        long h2 = ConcurrentOpenHashMap.hash(key);
        return this.getSection(h2).put(key, value, (int)h2, true, null);
    }

    public V computeIfAbsent(K key, Function<K, V> provider) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(provider);
        long h2 = ConcurrentOpenHashMap.hash(key);
        return this.getSection(h2).put(key, null, (int)h2, true, provider);
    }

    public V remove(K key) {
        Objects.requireNonNull(key);
        long h2 = ConcurrentOpenHashMap.hash(key);
        return (V)((Section)this.getSection(h2)).remove(key, null, (int)h2);
    }

    public boolean remove(K key, Object value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        long h2 = ConcurrentOpenHashMap.hash(key);
        return ((Section)this.getSection(h2)).remove(key, value, (int)h2) != null;
    }

    public void removeNullValue(K key) {
        this.remove(key, EmptyValue);
    }

    private Section<K, V> getSection(long hash) {
        int sectionIdx = (int)(hash >>> 32) & this.sections.length - 1;
        return this.sections[sectionIdx];
    }

    public void clear() {
        for (int i = 0; i < this.sections.length; ++i) {
            this.sections[i].clear();
        }
    }

    public void forEach(BiConsumer<? super K, ? super V> processor) {
        for (int i = 0; i < this.sections.length; ++i) {
            this.sections[i].forEach(processor);
        }
    }

    public List<K> keys() {
        ArrayList keys = new ArrayList((int)this.size());
        this.forEach((key, value) -> keys.add(key));
        return keys;
    }

    public List<V> values() {
        ArrayList values = new ArrayList((int)this.size());
        this.forEach((key, value) -> values.add(value));
        return values;
    }

    static final <K> long hash(K key) {
        long hash = (long)key.hashCode() * -4132994306676758123L;
        hash ^= hash >>> 47;
        return hash *= -4132994306676758123L;
    }

    static final int signSafeMod(long n, int max) {
        return (int)(n & (long)(max - 1)) << 1;
    }

    private static int alignToPowerOfTwo(int n) {
        return (int)Math.pow(2.0, 32 - Integer.numberOfLeadingZeros(n - 1));
    }

    public static class Builder<K, V> {
        int expectedItems = 256;
        int concurrencyLevel = 16;
        float mapFillFactor = 0.66f;
        float mapIdleFactor = 0.15f;
        float expandFactor = 2.0f;
        float shrinkFactor = 2.0f;
        boolean autoShrink = false;

        public Builder<K, V> expectedItems(int expectedItems) {
            this.expectedItems = expectedItems;
            return this;
        }

        public Builder<K, V> concurrencyLevel(int concurrencyLevel) {
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder<K, V> mapFillFactor(float mapFillFactor) {
            this.mapFillFactor = mapFillFactor;
            return this;
        }

        public Builder<K, V> mapIdleFactor(float mapIdleFactor) {
            this.mapIdleFactor = mapIdleFactor;
            return this;
        }

        public Builder<K, V> expandFactor(float expandFactor) {
            this.expandFactor = expandFactor;
            return this;
        }

        public Builder<K, V> shrinkFactor(float shrinkFactor) {
            this.shrinkFactor = shrinkFactor;
            return this;
        }

        public Builder<K, V> autoShrink(boolean autoShrink) {
            this.autoShrink = autoShrink;
            return this;
        }

        public ConcurrentOpenHashMap<K, V> build() {
            return new ConcurrentOpenHashMap(this.expectedItems, this.concurrencyLevel, this.mapFillFactor, this.mapIdleFactor, this.autoShrink, this.expandFactor, this.shrinkFactor);
        }
    }

    private static final class Section<K, V>
    extends StampedLock {
        private static final int ITEM_SIZE = 2;
        private volatile Object[] table;
        private volatile int capacity;
        private final int initCapacity;
        private static final AtomicIntegerFieldUpdater<Section> SIZE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Section.class, "size");
        private volatile int size;
        private int usedBuckets;
        private int resizeThresholdUp;
        private int resizeThresholdBelow;
        private final float mapFillFactor;
        private final float mapIdleFactor;
        private final float expandFactor;
        private final float shrinkFactor;
        private final boolean autoShrink;

        Section(int capacity, float mapFillFactor, float mapIdleFactor, boolean autoShrink, float expandFactor, float shrinkFactor) {
            this.initCapacity = this.capacity = ConcurrentOpenHashMap.alignToPowerOfTwo(capacity);
            this.table = new Object[2 * this.capacity];
            this.size = 0;
            this.usedBuckets = 0;
            this.autoShrink = autoShrink;
            this.mapFillFactor = mapFillFactor;
            this.mapIdleFactor = mapIdleFactor;
            this.expandFactor = expandFactor;
            this.shrinkFactor = shrinkFactor;
            this.resizeThresholdUp = (int)((float)this.capacity * mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * mapIdleFactor);
        }

        V get(K key, int keyHash) {
            long stamp = this.tryOptimisticRead();
            boolean acquiredLock = false;
            Object[] table = this.table;
            int bucket = ConcurrentOpenHashMap.signSafeMod(keyHash, table.length / 2);
            try {
                while (true) {
                    Object storedKey = table[bucket];
                    Object storedValue = table[bucket + 1];
                    if (!acquiredLock && this.validate(stamp)) {
                        if (key.equals(storedKey)) {
                            Object object = storedValue;
                            return (V)object;
                        }
                        if (storedKey == EmptyKey) {
                            V v = null;
                            return v;
                        }
                    } else {
                        if (!acquiredLock) {
                            stamp = this.readLock();
                            acquiredLock = true;
                            table = this.table;
                            bucket = ConcurrentOpenHashMap.signSafeMod(keyHash, table.length / 2);
                            storedKey = table[bucket];
                            storedValue = table[bucket + 1];
                        }
                        if (key.equals(storedKey)) {
                            Object object = storedValue;
                            return (V)object;
                        }
                        if (storedKey == EmptyKey) {
                            V v = null;
                            return v;
                        }
                    }
                    bucket = bucket + 2 & table.length - 1;
                }
            }
            finally {
                if (acquiredLock) {
                    this.unlockRead(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K key, V value, int keyHash, boolean onlyIfAbsent, Function<K, V> valueProvider) {
            long stamp = this.writeLock();
            int bucket = ConcurrentOpenHashMap.signSafeMod(keyHash, this.capacity);
            int firstDeletedKey = -1;
            try {
                while (true) {
                    Object storedKey = this.table[bucket];
                    Object storedValue = this.table[bucket + 1];
                    if (key.equals(storedKey)) {
                        if (!onlyIfAbsent) {
                            this.table[bucket + 1] = value;
                            Object object = storedValue;
                            return (V)object;
                        }
                        Object object = storedValue;
                        return (V)object;
                    }
                    if (storedKey == EmptyKey) {
                        if (firstDeletedKey != -1) {
                            bucket = firstDeletedKey;
                        } else {
                            ++this.usedBuckets;
                        }
                        if (value == null) {
                            value = valueProvider.apply(key);
                        }
                        this.table[bucket] = key;
                        this.table[bucket + 1] = value;
                        SIZE_UPDATER.incrementAndGet(this);
                        V v = valueProvider != null ? value : null;
                        return v;
                    }
                    if (storedKey == DeletedKey && firstDeletedKey == -1) {
                        firstDeletedKey = bucket;
                    }
                    bucket = bucket + 2 & this.table.length - 1;
                }
            }
            finally {
                if (this.usedBuckets > this.resizeThresholdUp) {
                    try {
                        int newCapacity = ConcurrentOpenHashMap.alignToPowerOfTwo((int)((float)this.capacity * this.expandFactor));
                        this.rehash(newCapacity);
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private V remove(K key, Object value, int keyHash) {
            stamp = this.writeLock();
            bucket = ConcurrentOpenHashMap.signSafeMod(keyHash, this.capacity);
            try {
                while (true) {
                    storedKey = this.table[bucket];
                    storedValue = this.table[bucket + 1];
                    if (key.equals(storedKey)) {
                        if (value == null || value.equals(storedValue)) {
                            Section.SIZE_UPDATER.decrementAndGet(this);
                            nextInArray = bucket + 2 & this.table.length - 1;
                            if (this.table[nextInArray] == ConcurrentOpenHashMap.access$500()) {
                                this.table[bucket] = ConcurrentOpenHashMap.access$500();
                                this.table[bucket + 1] = null;
                                --this.usedBuckets;
                                lastBucket = bucket - 2 & this.table.length - 1;
                                while (this.table[lastBucket] == ConcurrentOpenHashMap.access$600()) {
                                    this.table[lastBucket] = ConcurrentOpenHashMap.access$500();
                                    this.table[lastBucket + 1] = null;
                                    --this.usedBuckets;
                                    lastBucket = lastBucket - 2 & this.table.length - 1;
                                }
                            } else {
                                this.table[bucket] = ConcurrentOpenHashMap.access$600();
                                this.table[bucket + 1] = null;
                            }
                            lastBucket = storedValue;
                            return (V)lastBucket;
                        }
                        var9_9 = null;
                        return var9_9;
                    }
                    if (storedKey == ConcurrentOpenHashMap.access$500()) {
                        var9_10 = null;
                        return var9_10;
                    }
                    bucket = bucket + 2 & this.table.length - 1;
                }
            }
            finally {
                if (this.autoShrink && this.size < this.resizeThresholdBelow) {
                    try {
                        newCapacity = Math.max(ConcurrentOpenHashMap.access$400((int)((float)this.capacity / this.shrinkFactor)), this.initCapacity);
                        newResizeThresholdUp = (int)((float)newCapacity * this.mapFillFactor);
                        if (newCapacity >= this.capacity || newResizeThresholdUp <= this.size) ** GOTO lbl47
                        this.rehash(newCapacity);
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
lbl47:
                // 3 sources

            }
        }

        void clear() {
            long stamp = this.writeLock();
            try {
                if (this.autoShrink && this.capacity > this.initCapacity) {
                    this.shrinkToInitCapacity();
                } else {
                    Arrays.fill(this.table, EmptyKey);
                    this.size = 0;
                    this.usedBuckets = 0;
                }
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(BiConsumer<? super K, ? super V> processor) {
            Object[] table = this.table;
            long stamp = 0L;
            for (int bucket = 0; bucket < table.length; bucket += 2) {
                if (stamp == 0L) {
                    stamp = this.tryOptimisticRead();
                }
                Object storedKey = table[bucket];
                Object storedValue = table[bucket + 1];
                if (!this.validate(stamp)) {
                    stamp = this.readLock();
                    try {
                        storedKey = table[bucket];
                        storedValue = table[bucket + 1];
                    }
                    finally {
                        this.unlockRead(stamp);
                    }
                    stamp = 0L;
                }
                if (storedKey == DeletedKey || storedKey == EmptyKey) continue;
                processor.accept(storedKey, storedValue);
            }
        }

        private void rehash(int newCapacity) {
            Object[] newTable = new Object[2 * newCapacity];
            for (int i = 0; i < this.table.length; i += 2) {
                Object storedKey = this.table[i];
                Object storedValue = this.table[i + 1];
                if (storedKey == EmptyKey || storedKey == DeletedKey) continue;
                Section.insertKeyValueNoLock(newTable, newCapacity, storedKey, storedValue);
            }
            this.table = newTable;
            this.capacity = newCapacity;
            this.usedBuckets = this.size;
            this.resizeThresholdUp = (int)((float)this.capacity * this.mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * this.mapIdleFactor);
        }

        private void shrinkToInitCapacity() {
            Object[] newTable = new Object[2 * this.initCapacity];
            this.table = newTable;
            this.size = 0;
            this.usedBuckets = 0;
            this.capacity = this.initCapacity;
            this.resizeThresholdUp = (int)((float)this.capacity * this.mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * this.mapIdleFactor);
        }

        private static <K, V> void insertKeyValueNoLock(Object[] table, int capacity, K key, V value) {
            int bucket = ConcurrentOpenHashMap.signSafeMod(ConcurrentOpenHashMap.hash(key), capacity);
            while (true) {
                Object storedKey;
                if ((storedKey = table[bucket]) == EmptyKey) {
                    table[bucket] = key;
                    table[bucket + 1] = value;
                    return;
                }
                bucket = bucket + 2 & table.length - 1;
            }
        }
    }
}

