/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.standalone.broker.task;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.WorkHandler;
import io.cloudevents.CloudEvent;
import lombok.Generated;
import org.apache.eventmesh.api.AsyncConsumeContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.storage.standalone.broker.StandaloneBroker;
import org.apache.eventmesh.storage.standalone.broker.model.MessageEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subscribe
implements WorkHandler<MessageEntity>,
EventHandler<MessageEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Subscribe.class);
    private final String topicName;
    private final StandaloneBroker standaloneBroker;
    private final EventListener listener;
    private volatile boolean isRunning;

    public Subscribe(String topicName, StandaloneBroker standaloneBroker, EventListener listener) {
        this.topicName = topicName;
        this.standaloneBroker = standaloneBroker;
        this.listener = listener;
        this.isRunning = true;
    }

    public void subscribe() {
        this.standaloneBroker.subscribed(this.topicName, this);
    }

    public void shutdown() {
        this.isRunning = false;
        this.standaloneBroker.deleteTopicIfExist(this.topicName);
    }

    public void onEvent(MessageEntity event, long sequence, boolean endOfBatch) {
        this.onEvent(event);
    }

    public void onEvent(final MessageEntity event) {
        try {
            if (!this.isRunning) {
                return;
            }
            CloudEvent message = event.getMessage();
            if (message != null) {
                EventMeshAsyncConsumeContext consumeContext = new EventMeshAsyncConsumeContext(){

                    public void commit(EventMeshAction action) {
                        switch (action) {
                            case CommitMessage: {
                                log.info("message commit, topic: {}, current offset:{}", (Object)Subscribe.this.topicName, (Object)event.getOffset());
                                break;
                            }
                            case ManualAck: {
                                log.info("message ack, topic: {}, current offset:{}", (Object)Subscribe.this.topicName, (Object)event.getOffset());
                                break;
                            }
                        }
                    }
                };
                this.listener.consume(message, (AsyncConsumeContext)consumeContext);
            }
        }
        catch (Exception ex) {
            log.error("consumer error, topic: {}, offset: {}", new Object[]{this.topicName, event.getOffset(), ex});
        }
    }

    @Generated
    public String getTopicName() {
        return this.topicName;
    }

    @Generated
    public boolean isRunning() {
        return this.isRunning;
    }
}

