/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.rocketmq.producer;

import io.cloudevents.CloudEvent;
import java.util.Properties;
import lombok.Generated;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.producer.Producer;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.storage.rocketmq.config.ClientConfiguration;
import org.apache.eventmesh.storage.rocketmq.producer.ProducerImpl;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Config(field="clientConfiguration")
public class RocketMQProducerImpl
implements Producer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocketMQProducerImpl.class);
    private ProducerImpl producer;
    private ClientConfiguration clientConfiguration;

    public synchronized void init(Properties keyValue) {
        String producerGroup = keyValue.getProperty("producerGroup") == null ? "RMQ-producerGroup" : keyValue.getProperty("producerGroup");
        String omsNamesrv = this.clientConfiguration.getNamesrvAddr();
        Properties properties = new Properties();
        properties.put("ACCESS_POINTS", omsNamesrv);
        properties.put("REGION", "namespace");
        properties.put("RMQ_PRODUCER_GROUP", producerGroup);
        properties.put("OPERATION_TIMEOUT", (Object)3000);
        properties.put("PRODUCER_ID", producerGroup);
        this.producer = new ProducerImpl(properties);
    }

    public boolean isStarted() {
        return this.producer.isStarted();
    }

    public boolean isClosed() {
        return this.producer.isClosed();
    }

    public void start() {
        this.producer.start();
    }

    public synchronized void shutdown() {
        this.producer.shutdown();
    }

    public void publish(CloudEvent message, SendCallback sendCallback) throws Exception {
        this.producer.sendAsync(message, sendCallback);
    }

    public void request(CloudEvent message, RequestReplyCallback rrCallback, long timeout) throws InterruptedException, RemotingException, MQClientException, MQBrokerException {
        this.producer.request(message, rrCallback, timeout);
    }

    public boolean reply(CloudEvent message, SendCallback sendCallback) throws Exception {
        this.producer.reply(message, sendCallback);
        return true;
    }

    public void checkTopicExist(String topic) throws Exception {
        this.producer.getRocketmqProducer().getDefaultMQProducerImpl().getmQClientFactory().getMQClientAPIImpl().getDefaultTopicRouteInfoFromNameServer(topic, 3000L);
    }

    public void setExtFields() {
        this.producer.setExtFields();
    }

    public void sendOneway(CloudEvent message) {
        this.producer.sendOneway(message);
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }
}

