/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event.deserialization;

import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.TableMapEventMetadata;
import com.github.shyiko.mysql.binlog.event.deserialization.ColumnType;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.TableMapEventMetadataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TableMapEventDataDeserializer
implements EventDataDeserializer<TableMapEventData> {
    private final TableMapEventMetadataDeserializer metadataDeserializer = new TableMapEventMetadataDeserializer();

    @Override
    public TableMapEventData deserialize(ByteArrayInputStream inputStream) throws IOException {
        TableMapEventData eventData = new TableMapEventData();
        eventData.setTableId(inputStream.readLong(6));
        inputStream.skip(3L);
        eventData.setDatabase(inputStream.readZeroTerminatedString());
        inputStream.skip(1L);
        eventData.setTable(inputStream.readZeroTerminatedString());
        int numberOfColumns = inputStream.readPackedInteger();
        eventData.setColumnTypes(inputStream.read(numberOfColumns));
        inputStream.readPackedInteger();
        eventData.setColumnMetadata(this.readMetadata(inputStream, eventData.getColumnTypes()));
        eventData.setColumnNullability(inputStream.readBitSet(numberOfColumns, true));
        int metadataLength = inputStream.available();
        TableMapEventMetadata metadata = null;
        if (metadataLength > 0) {
            metadata = this.metadataDeserializer.deserialize(new ByteArrayInputStream(inputStream.read(metadataLength)), eventData.getColumnTypes().length, eventData.getColumnTypes());
        }
        eventData.setEventMetadata(metadata);
        return eventData;
    }

    private List<Integer> numericColumnIndex(byte[] types) {
        ArrayList<Integer> numericColumnIndexList = new ArrayList<Integer>();
        block3: for (int i = 0; i < types.length; ++i) {
            switch (ColumnType.byCode(types[i] & 0xFF)) {
                case TINY: 
                case SHORT: 
                case INT24: 
                case LONG: 
                case LONGLONG: 
                case NEWDECIMAL: 
                case FLOAT: 
                case DOUBLE: 
                case YEAR: {
                    numericColumnIndexList.add(i);
                    continue block3;
                }
            }
        }
        return numericColumnIndexList;
    }

    private int numericColumnCount(byte[] types) {
        int count = 0;
        block3: for (int i = 0; i < types.length; ++i) {
            switch (ColumnType.byCode(types[i] & 0xFF)) {
                case TINY: 
                case SHORT: 
                case INT24: 
                case LONG: 
                case LONGLONG: 
                case NEWDECIMAL: 
                case FLOAT: 
                case DOUBLE: 
                case YEAR: {
                    ++count;
                    continue block3;
                }
            }
        }
        return count;
    }

    private int[] readMetadata(ByteArrayInputStream inputStream, byte[] columnTypes) throws IOException {
        int[] metadata = new int[columnTypes.length];
        block6: for (int i = 0; i < columnTypes.length; ++i) {
            switch (ColumnType.byCode(columnTypes[i] & 0xFF)) {
                case FLOAT: 
                case DOUBLE: 
                case BLOB: 
                case JSON: 
                case GEOMETRY: {
                    metadata[i] = inputStream.readInteger(1);
                    continue block6;
                }
                case NEWDECIMAL: 
                case BIT: 
                case VARCHAR: {
                    metadata[i] = inputStream.readInteger(2);
                    continue block6;
                }
                case SET: 
                case ENUM: 
                case STRING: {
                    metadata[i] = TableMapEventDataDeserializer.bigEndianInteger(inputStream.read(2), 0, 2);
                    continue block6;
                }
                case TIME_V2: 
                case DATETIME_V2: 
                case TIMESTAMP_V2: {
                    metadata[i] = inputStream.readInteger(1);
                    continue block6;
                }
                default: {
                    metadata[i] = 0;
                }
            }
        }
        return metadata;
    }

    private static int bigEndianInteger(byte[] bytes, int offset, int length) {
        int result = 0;
        for (int i = offset; i < offset + length; ++i) {
            int b = bytes[i];
            result = result << 8 | (b >= 0 ? b : b + 256);
        }
        return result;
    }
}

