/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.cluster.ClusterNodeInfo;
import org.redisson.cluster.ClusterSlotRange;

public class ClusterNodesDecoder
implements Decoder<List<ClusterNodeInfo>> {
    private final boolean ssl;

    public ClusterNodesDecoder(boolean ssl) {
        this.ssl = ssl;
    }

    @Override
    public List<ClusterNodeInfo> decode(ByteBuf buf, State state) throws IOException {
        String response = buf.toString(CharsetUtil.UTF_8);
        ArrayList<ClusterNodeInfo> nodes = new ArrayList<ClusterNodeInfo>();
        for (String nodeInfo : response.split("\n")) {
            String slaveOf;
            ClusterNodeInfo node = new ClusterNodeInfo(nodeInfo);
            String[] params = nodeInfo.split(" ");
            String nodeId = params[0];
            node.setNodeId(nodeId);
            String flags = params[2];
            block1: for (String flag : flags.split(",")) {
                for (ClusterNodeInfo.Flag nodeInfoFlag : ClusterNodeInfo.Flag.values()) {
                    if (!nodeInfoFlag.getValue().equalsIgnoreCase(flag)) continue;
                    node.addFlag(nodeInfoFlag);
                    continue block1;
                }
            }
            if (!node.containsFlag(ClusterNodeInfo.Flag.NOADDR)) {
                String uri = this.createUri(params);
                if (uri == null) continue;
                node.setAddress(uri);
            }
            if (!"-".equals(slaveOf = params[3])) {
                node.setSlaveOf(slaveOf);
            }
            if (params.length > 8) {
                for (int i = 0; i < params.length - 8; ++i) {
                    String slots = params[i + 8];
                    if (slots.contains("-<-") || slots.contains("->-")) continue;
                    String[] parts = slots.split("-");
                    if (parts.length == 1) {
                        node.addSlotRange(new ClusterSlotRange(Integer.valueOf(parts[0]), Integer.valueOf(parts[0])));
                        continue;
                    }
                    if (parts.length != 2) continue;
                    node.addSlotRange(new ClusterSlotRange(Integer.valueOf(parts[0]), Integer.valueOf(parts[1])));
                }
            }
            nodes.add(node);
        }
        return nodes;
    }

    private String createUri(String[] params) {
        String[] parts;
        String addr;
        String name;
        String protocol = "redis://";
        if (this.ssl) {
            protocol = "rediss://";
        }
        if ((name = (addr = (parts = params[1].split(","))[0].split("@")[0]).substring(0, addr.lastIndexOf(":"))).isEmpty()) {
            return null;
        }
        if (parts.length == 2) {
            String port = addr.substring(name.length() + 1);
            addr = parts[1] + ":" + port;
        }
        return protocol + addr;
    }
}

