/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jdkhttp;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.StandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.jdkhttp.JdkHttpClientFactory;
import io.fabric8.kubernetes.client.jdkhttp.JdkHttpClientImpl;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLParameters;

class JdkHttpClientBuilderImpl
extends StandardHttpClientBuilder<JdkHttpClientImpl, JdkHttpClientFactory, JdkHttpClientBuilderImpl> {
    public JdkHttpClientBuilderImpl(JdkHttpClientFactory factory) {
        super((HttpClient.Factory)factory);
    }

    public HttpClient build() {
        if (this.client != null) {
            return new JdkHttpClientImpl(this, ((JdkHttpClientImpl)this.client).getHttpClient(), ((JdkHttpClientImpl)this.client).getClosed());
        }
        HttpClient.Builder builder = ((JdkHttpClientFactory)this.clientFactory).createNewHttpClientBuilder();
        if (this.connectTimeout != null && !Duration.ZERO.equals(this.connectTimeout)) {
            builder.connectTimeout(this.connectTimeout);
        }
        if (this.sslContext != null) {
            builder.sslContext(this.sslContext);
        }
        if (this.followRedirects) {
            builder.followRedirects(HttpClient.Redirect.ALWAYS);
        }
        if (this.proxyType == HttpClient.ProxyType.DIRECT) {
            builder.proxy(HttpClient.Builder.NO_PROXY);
        } else if (this.proxyAddress != null) {
            if (this.proxyType != HttpClient.ProxyType.HTTP) {
                throw new KubernetesClientException("JDK HttpClient only support HTTP proxies");
            }
            builder.proxy(ProxySelector.of(this.proxyAddress));
            this.addProxyAuthInterceptor();
        }
        if (this.preferHttp11) {
            builder.version(HttpClient.Version.HTTP_1_1);
        }
        if (this.tlsVersions != null && this.tlsVersions.length > 0) {
            builder.sslParameters(new SSLParameters(null, (String[])Arrays.asList(this.tlsVersions).stream().map(TlsVersion::javaName).toArray(String[]::new)));
        }
        ((JdkHttpClientFactory)this.clientFactory).additionalConfig(builder);
        return new JdkHttpClientImpl(this, builder.build(), new AtomicBoolean());
    }

    protected JdkHttpClientBuilderImpl newInstance(JdkHttpClientFactory clientFactory) {
        return new JdkHttpClientBuilderImpl(clientFactory);
    }
}

