/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V2HPAScalingPolicy;
import io.kubernetes.client.openapi.models.V2HPAScalingPolicyBuilder;
import io.kubernetes.client.openapi.models.V2HPAScalingPolicyFluentImpl;
import io.kubernetes.client.openapi.models.V2HPAScalingRules;
import io.kubernetes.client.openapi.models.V2HPAScalingRulesFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V2HPAScalingRulesFluentImpl<A extends V2HPAScalingRulesFluent<A>>
extends BaseFluent<A>
implements V2HPAScalingRulesFluent<A> {
    private ArrayList<V2HPAScalingPolicyBuilder> policies;
    private String selectPolicy;
    private Integer stabilizationWindowSeconds;

    public V2HPAScalingRulesFluentImpl() {
    }

    public V2HPAScalingRulesFluentImpl(V2HPAScalingRules instance) {
        if (instance != null) {
            this.withPolicies(instance.getPolicies());
            this.withSelectPolicy(instance.getSelectPolicy());
            this.withStabilizationWindowSeconds(instance.getStabilizationWindowSeconds());
        }
    }

    @Override
    public A addToPolicies(int index, V2HPAScalingPolicy item) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        V2HPAScalingPolicyBuilder builder = new V2HPAScalingPolicyBuilder(item);
        if (index < 0 || index >= this.policies.size()) {
            this._visitables.get("policies").add(builder);
            this.policies.add(builder);
        } else {
            this._visitables.get("policies").add(index, builder);
            this.policies.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToPolicies(int index, V2HPAScalingPolicy item) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        V2HPAScalingPolicyBuilder builder = new V2HPAScalingPolicyBuilder(item);
        if (index < 0 || index >= this.policies.size()) {
            this._visitables.get("policies").add(builder);
            this.policies.add(builder);
        } else {
            this._visitables.get("policies").set(index, builder);
            this.policies.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPolicies(V2HPAScalingPolicy ... items) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        for (V2HPAScalingPolicy item : items) {
            V2HPAScalingPolicyBuilder builder = new V2HPAScalingPolicyBuilder(item);
            this._visitables.get("policies").add(builder);
            this.policies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPolicies(Collection<V2HPAScalingPolicy> items) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        for (V2HPAScalingPolicy item : items) {
            V2HPAScalingPolicyBuilder builder = new V2HPAScalingPolicyBuilder(item);
            this._visitables.get("policies").add(builder);
            this.policies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPolicies(V2HPAScalingPolicy ... items) {
        for (V2HPAScalingPolicy item : items) {
            V2HPAScalingPolicyBuilder builder = new V2HPAScalingPolicyBuilder(item);
            this._visitables.get("policies").remove(builder);
            if (this.policies == null) continue;
            this.policies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPolicies(Collection<V2HPAScalingPolicy> items) {
        for (V2HPAScalingPolicy item : items) {
            V2HPAScalingPolicyBuilder builder = new V2HPAScalingPolicyBuilder(item);
            this._visitables.get("policies").remove(builder);
            if (this.policies == null) continue;
            this.policies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPolicies(Predicate<V2HPAScalingPolicyBuilder> predicate) {
        if (this.policies == null) {
            return (A)this;
        }
        Iterator<V2HPAScalingPolicyBuilder> each = this.policies.iterator();
        Object visitables = this._visitables.get("policies");
        while (each.hasNext()) {
            V2HPAScalingPolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V2HPAScalingPolicy> getPolicies() {
        return this.policies != null ? V2HPAScalingRulesFluentImpl.build(this.policies) : null;
    }

    @Override
    public List<V2HPAScalingPolicy> buildPolicies() {
        return this.policies != null ? V2HPAScalingRulesFluentImpl.build(this.policies) : null;
    }

    @Override
    public V2HPAScalingPolicy buildPolicy(int index) {
        return this.policies.get(index).build();
    }

    @Override
    public V2HPAScalingPolicy buildFirstPolicy() {
        return this.policies.get(0).build();
    }

    @Override
    public V2HPAScalingPolicy buildLastPolicy() {
        return this.policies.get(this.policies.size() - 1).build();
    }

    @Override
    public V2HPAScalingPolicy buildMatchingPolicy(Predicate<V2HPAScalingPolicyBuilder> predicate) {
        for (V2HPAScalingPolicyBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPolicy(Predicate<V2HPAScalingPolicyBuilder> predicate) {
        for (V2HPAScalingPolicyBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPolicies(List<V2HPAScalingPolicy> policies) {
        if (this.policies != null) {
            this._visitables.get("policies").clear();
        }
        if (policies != null) {
            this.policies = new ArrayList();
            for (V2HPAScalingPolicy item : policies) {
                this.addToPolicies(item);
            }
        } else {
            this.policies = null;
        }
        return (A)this;
    }

    @Override
    public A withPolicies(V2HPAScalingPolicy ... policies) {
        if (this.policies != null) {
            this.policies.clear();
            this._visitables.remove("policies");
        }
        if (policies != null) {
            for (V2HPAScalingPolicy item : policies) {
                this.addToPolicies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPolicies() {
        return this.policies != null && !this.policies.isEmpty();
    }

    @Override
    public V2HPAScalingRulesFluent.PoliciesNested<A> addNewPolicy() {
        return new PoliciesNestedImpl();
    }

    @Override
    public V2HPAScalingRulesFluent.PoliciesNested<A> addNewPolicyLike(V2HPAScalingPolicy item) {
        return new PoliciesNestedImpl(-1, item);
    }

    @Override
    public V2HPAScalingRulesFluent.PoliciesNested<A> setNewPolicyLike(int index, V2HPAScalingPolicy item) {
        return new PoliciesNestedImpl(index, item);
    }

    @Override
    public V2HPAScalingRulesFluent.PoliciesNested<A> editPolicy(int index) {
        if (this.policies.size() <= index) {
            throw new RuntimeException("Can't edit policies. Index exceeds size.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    @Override
    public V2HPAScalingRulesFluent.PoliciesNested<A> editFirstPolicy() {
        if (this.policies.size() == 0) {
            throw new RuntimeException("Can't edit first policies. The list is empty.");
        }
        return this.setNewPolicyLike(0, this.buildPolicy(0));
    }

    @Override
    public V2HPAScalingRulesFluent.PoliciesNested<A> editLastPolicy() {
        int index = this.policies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last policies. The list is empty.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    @Override
    public V2HPAScalingRulesFluent.PoliciesNested<A> editMatchingPolicy(Predicate<V2HPAScalingPolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.policies.size(); ++i) {
            if (!predicate.test(this.policies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching policies. No match found.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    @Override
    public String getSelectPolicy() {
        return this.selectPolicy;
    }

    @Override
    public A withSelectPolicy(String selectPolicy) {
        this.selectPolicy = selectPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasSelectPolicy() {
        return this.selectPolicy != null;
    }

    @Override
    public Integer getStabilizationWindowSeconds() {
        return this.stabilizationWindowSeconds;
    }

    @Override
    public A withStabilizationWindowSeconds(Integer stabilizationWindowSeconds) {
        this.stabilizationWindowSeconds = stabilizationWindowSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasStabilizationWindowSeconds() {
        return this.stabilizationWindowSeconds != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V2HPAScalingRulesFluentImpl that = (V2HPAScalingRulesFluentImpl)o;
        if (!Objects.equals(this.policies, that.policies)) {
            return false;
        }
        if (!Objects.equals(this.selectPolicy, that.selectPolicy)) {
            return false;
        }
        return Objects.equals(this.stabilizationWindowSeconds, that.stabilizationWindowSeconds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.policies, this.selectPolicy, this.stabilizationWindowSeconds, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policies != null) {
            sb.append("policies:");
            sb.append(this.policies + ",");
        }
        if (this.selectPolicy != null) {
            sb.append("selectPolicy:");
            sb.append(this.selectPolicy + ",");
        }
        if (this.stabilizationWindowSeconds != null) {
            sb.append("stabilizationWindowSeconds:");
            sb.append(this.stabilizationWindowSeconds);
        }
        sb.append("}");
        return sb.toString();
    }

    class PoliciesNestedImpl<N>
    extends V2HPAScalingPolicyFluentImpl<V2HPAScalingRulesFluent.PoliciesNested<N>>
    implements V2HPAScalingRulesFluent.PoliciesNested<N>,
    Nested<N> {
        V2HPAScalingPolicyBuilder builder;
        int index;

        PoliciesNestedImpl(int index, V2HPAScalingPolicy item) {
            this.index = index;
            this.builder = new V2HPAScalingPolicyBuilder(this, item);
        }

        PoliciesNestedImpl() {
            this.index = -1;
            this.builder = new V2HPAScalingPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)V2HPAScalingRulesFluentImpl.this.setToPolicies(this.index, this.builder.build());
        }

        @Override
        public N endPolicy() {
            return this.and();
        }
    }
}

