/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1IngressLoadBalancerIngress;
import io.kubernetes.client.openapi.models.V1IngressLoadBalancerIngressBuilder;
import io.kubernetes.client.openapi.models.V1IngressLoadBalancerIngressFluentImpl;
import io.kubernetes.client.openapi.models.V1IngressLoadBalancerStatus;
import io.kubernetes.client.openapi.models.V1IngressLoadBalancerStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1IngressLoadBalancerStatusFluentImpl<A extends V1IngressLoadBalancerStatusFluent<A>>
extends BaseFluent<A>
implements V1IngressLoadBalancerStatusFluent<A> {
    private ArrayList<V1IngressLoadBalancerIngressBuilder> ingress;

    public V1IngressLoadBalancerStatusFluentImpl() {
    }

    public V1IngressLoadBalancerStatusFluentImpl(V1IngressLoadBalancerStatus instance) {
        if (instance != null) {
            this.withIngress(instance.getIngress());
        }
    }

    @Override
    public A addToIngress(int index, V1IngressLoadBalancerIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        V1IngressLoadBalancerIngressBuilder builder = new V1IngressLoadBalancerIngressBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get("ingress").add(index, builder);
            this.ingress.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToIngress(int index, V1IngressLoadBalancerIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        V1IngressLoadBalancerIngressBuilder builder = new V1IngressLoadBalancerIngressBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get("ingress").set(index, builder);
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIngress(V1IngressLoadBalancerIngress ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (V1IngressLoadBalancerIngress item : items) {
            V1IngressLoadBalancerIngressBuilder builder = new V1IngressLoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIngress(Collection<V1IngressLoadBalancerIngress> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (V1IngressLoadBalancerIngress item : items) {
            V1IngressLoadBalancerIngressBuilder builder = new V1IngressLoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIngress(V1IngressLoadBalancerIngress ... items) {
        for (V1IngressLoadBalancerIngress item : items) {
            V1IngressLoadBalancerIngressBuilder builder = new V1IngressLoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIngress(Collection<V1IngressLoadBalancerIngress> items) {
        for (V1IngressLoadBalancerIngress item : items) {
            V1IngressLoadBalancerIngressBuilder builder = new V1IngressLoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromIngress(Predicate<V1IngressLoadBalancerIngressBuilder> predicate) {
        if (this.ingress == null) {
            return (A)this;
        }
        Iterator<V1IngressLoadBalancerIngressBuilder> each = this.ingress.iterator();
        Object visitables = this._visitables.get("ingress");
        while (each.hasNext()) {
            V1IngressLoadBalancerIngressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1IngressLoadBalancerIngress> getIngress() {
        return this.ingress != null ? V1IngressLoadBalancerStatusFluentImpl.build(this.ingress) : null;
    }

    @Override
    public List<V1IngressLoadBalancerIngress> buildIngress() {
        return this.ingress != null ? V1IngressLoadBalancerStatusFluentImpl.build(this.ingress) : null;
    }

    @Override
    public V1IngressLoadBalancerIngress buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    @Override
    public V1IngressLoadBalancerIngress buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    @Override
    public V1IngressLoadBalancerIngress buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    @Override
    public V1IngressLoadBalancerIngress buildMatchingIngress(Predicate<V1IngressLoadBalancerIngressBuilder> predicate) {
        for (V1IngressLoadBalancerIngressBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIngress(Predicate<V1IngressLoadBalancerIngressBuilder> predicate) {
        for (V1IngressLoadBalancerIngressBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIngress(List<V1IngressLoadBalancerIngress> ingress) {
        if (this.ingress != null) {
            this._visitables.get("ingress").clear();
        }
        if (ingress != null) {
            this.ingress = new ArrayList();
            for (V1IngressLoadBalancerIngress item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)this;
    }

    @Override
    public A withIngress(V1IngressLoadBalancerIngress ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
            this._visitables.remove("ingress");
        }
        if (ingress != null) {
            for (V1IngressLoadBalancerIngress item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    @Override
    public V1IngressLoadBalancerStatusFluent.IngressNested<A> addNewIngress() {
        return new IngressNestedImpl();
    }

    @Override
    public V1IngressLoadBalancerStatusFluent.IngressNested<A> addNewIngressLike(V1IngressLoadBalancerIngress item) {
        return new IngressNestedImpl(-1, item);
    }

    @Override
    public V1IngressLoadBalancerStatusFluent.IngressNested<A> setNewIngressLike(int index, V1IngressLoadBalancerIngress item) {
        return new IngressNestedImpl(index, item);
    }

    @Override
    public V1IngressLoadBalancerStatusFluent.IngressNested<A> editIngress(int index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public V1IngressLoadBalancerStatusFluent.IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    @Override
    public V1IngressLoadBalancerStatusFluent.IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public V1IngressLoadBalancerStatusFluent.IngressNested<A> editMatchingIngress(Predicate<V1IngressLoadBalancerIngressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.test(this.ingress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1IngressLoadBalancerStatusFluentImpl that = (V1IngressLoadBalancerStatusFluentImpl)o;
        return Objects.equals(this.ingress, that.ingress);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ingress, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ingress != null) {
            sb.append("ingress:");
            sb.append(this.ingress);
        }
        sb.append("}");
        return sb.toString();
    }

    class IngressNestedImpl<N>
    extends V1IngressLoadBalancerIngressFluentImpl<V1IngressLoadBalancerStatusFluent.IngressNested<N>>
    implements V1IngressLoadBalancerStatusFluent.IngressNested<N>,
    Nested<N> {
        V1IngressLoadBalancerIngressBuilder builder;
        int index;

        IngressNestedImpl(int index, V1IngressLoadBalancerIngress item) {
            this.index = index;
            this.builder = new V1IngressLoadBalancerIngressBuilder(this, item);
        }

        IngressNestedImpl() {
            this.index = -1;
            this.builder = new V1IngressLoadBalancerIngressBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1IngressLoadBalancerStatusFluentImpl.this.setToIngress(this.index, this.builder.build());
        }

        @Override
        public N endIngress() {
            return this.and();
        }
    }
}

