/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import javax.annotation.Nullable;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesUnion;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.ColumnValueSelector;

public class DoublesSketchMergeAggregator
implements Aggregator {
    private final ColumnValueSelector selector;
    @Nullable
    private DoublesUnion union;

    public DoublesSketchMergeAggregator(ColumnValueSelector selector, int k) {
        this.selector = selector;
        this.union = DoublesUnion.builder().setMaxK(k).build();
    }

    public synchronized void aggregate() {
        DoublesSketchMergeAggregator.updateUnion(this.selector, this.union);
    }

    public synchronized Object get() {
        return this.union.getResult();
    }

    public float getFloat() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public synchronized void close() {
        this.union = null;
    }

    static void updateUnion(ColumnValueSelector selector, DoublesUnion union) {
        Object object = selector.getObject();
        if (object == null) {
            return;
        }
        if (object instanceof DoublesSketch) {
            union.union((DoublesSketch)object);
        } else {
            union.update(selector.getDouble());
        }
    }
}

