/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.aws.rds;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.rds.auth.GetIamAuthTokenRequest;
import com.amazonaws.services.rds.auth.RdsIamAuthTokenGenerator;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.PasswordProvider;

public class AWSRDSTokenPasswordProvider
implements PasswordProvider {
    private static final Logger LOGGER = new Logger(AWSRDSTokenPasswordProvider.class);
    private final String user;
    private final String host;
    private final int port;
    private final String region;
    private final AWSCredentialsProvider awsCredentialsProvider;

    @JsonCreator
    public AWSRDSTokenPasswordProvider(@JsonProperty(value="user") String user, @JsonProperty(value="host") String host, @JsonProperty(value="port") int port, @JsonProperty(value="region") String region, @JacksonInject AWSCredentialsProvider awsCredentialsProvider) {
        this.user = (String)Preconditions.checkNotNull((Object)user, (Object)"null metadataStorage user");
        this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"null metadataStorage host");
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"must provide port");
        this.port = port;
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"null region");
        LOGGER.info("AWS RDS Config user[%s], host[%s], port[%d], region[%s]", new Object[]{this.user, this.host, port, this.region});
        this.awsCredentialsProvider = (AWSCredentialsProvider)Preconditions.checkNotNull((Object)awsCredentialsProvider, (Object)"null AWSCredentialsProvider");
    }

    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public String getRegion() {
        return this.region;
    }

    @JsonIgnore
    public String getPassword() {
        try {
            RdsIamAuthTokenGenerator generator = RdsIamAuthTokenGenerator.builder().credentials(this.awsCredentialsProvider).region(this.region).build();
            String authToken = generator.getAuthToken(GetIamAuthTokenRequest.builder().hostname(this.host).port(this.port).userName(this.user).build());
            return authToken;
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex, "Couldn't generate AWS token.", new Object[0]);
            throw new RE((Throwable)ex, "Couldn't generate AWS token.", new Object[0]);
        }
    }
}

