/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authentication.db.cache;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.EscalatedClient;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.security.basic.BasicAuthDBConfig;
import org.apache.druid.security.basic.CommonCacheNotifier;
import org.apache.druid.security.basic.authentication.BasicHTTPAuthenticator;
import org.apache.druid.security.basic.authentication.db.cache.BasicAuthenticatorCacheNotifier;
import org.apache.druid.server.security.Authenticator;
import org.apache.druid.server.security.AuthenticatorMapper;

@ManageLifecycle
public class CoordinatorBasicAuthenticatorCacheNotifier
implements BasicAuthenticatorCacheNotifier {
    private final LifecycleLock lifecycleLock = new LifecycleLock();
    private final CommonCacheNotifier userCacheNotifier;

    @Inject
    public CoordinatorBasicAuthenticatorCacheNotifier(AuthenticatorMapper authenticatorMapper, DruidNodeDiscoveryProvider discoveryProvider, @EscalatedClient HttpClient httpClient) {
        this.userCacheNotifier = new CommonCacheNotifier(this.initAuthenticatorConfigMap(authenticatorMapper), discoveryProvider, httpClient, "/druid-ext/basic-security/authentication/listen/%s", "CoordinatorBasicAuthenticatorCacheNotifier");
    }

    @LifecycleStart
    public void start() {
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("Can't start.", new Object[0]);
        }
        try {
            this.userCacheNotifier.start();
            this.lifecycleLock.started();
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @LifecycleStop
    public void stop() {
        if (!this.lifecycleLock.canStop()) {
            return;
        }
        try {
            this.userCacheNotifier.stop();
        }
        finally {
            this.lifecycleLock.exitStop();
        }
    }

    @Override
    public void addUserUpdate(String updatedAuthenticatorPrefix, byte[] updatedUserMap) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.userCacheNotifier.addUpdate(updatedAuthenticatorPrefix, updatedUserMap);
    }

    private Map<String, BasicAuthDBConfig> initAuthenticatorConfigMap(AuthenticatorMapper mapper) {
        Preconditions.checkNotNull((Object)mapper);
        Preconditions.checkNotNull((Object)mapper.getAuthenticatorMap());
        HashMap<String, BasicAuthDBConfig> authenticatorConfigMap = new HashMap<String, BasicAuthDBConfig>();
        for (Map.Entry entry : mapper.getAuthenticatorMap().entrySet()) {
            Authenticator authenticator = (Authenticator)entry.getValue();
            if (!(authenticator instanceof BasicHTTPAuthenticator)) continue;
            String authenticatorName = (String)entry.getKey();
            BasicHTTPAuthenticator basicHTTPAuthenticator = (BasicHTTPAuthenticator)authenticator;
            BasicAuthDBConfig dbConfig = basicHTTPAuthenticator.getDbConfig();
            authenticatorConfigMap.put(authenticatorName, dbConfig);
        }
        return authenticatorConfigMap;
    }
}

