/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.util.Strings;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Relationship;

public class Hier
extends FortEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Op op;
    public Type type;
    private List<Relationship> relationships;

    public Hier() {
    }

    public Hier(List<Relationship> relationships) {
        this.relationships = relationships;
    }

    public Hier(Type type) {
        this.type = type;
    }

    public Hier(Type type, String child, String parent) {
        this.type = type;
        this.setRelationship(child, parent);
    }

    public Hier(String child, String parent) {
        this.setRelationship(child, parent);
    }

    public Op getOp() {
        return this.op;
    }

    public void setOp(Op op) {
        this.op = op;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isRelationship(String role, String parent) {
        boolean result = false;
        if (this.relationships != null) {
            result = this.relationships.contains(new Relationship(Strings.toUpperCase((String)role), Strings.toUpperCase((String)parent)));
        }
        return result;
    }

    public void setRelationship(String role, String parent) {
        if (this.relationships == null) {
            this.relationships = new ArrayList<Relationship>();
        }
        this.relationships.add(new Relationship(Strings.toUpperCase((String)role), Strings.toUpperCase((String)parent)));
    }

    public void setRelationship(Relationship rel) {
        if (this.relationships == null) {
            this.relationships = new ArrayList<Relationship>();
        }
        this.relationships.add(rel);
    }

    public void removeRelationship(String role, String parent) {
        if (this.relationships != null) {
            this.relationships.remove(new Relationship(Strings.toUpperCase((String)role), Strings.toUpperCase((String)parent)));
        }
    }

    public List<Relationship> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<Relationship> relationships) {
        this.relationships = relationships;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Hier object: \n");
        sb.append("    operation :").append((Object)this.op).append('\n');
        sb.append("    type :").append((Object)this.type).append('\n');
        if (this.relationships != null) {
            sb.append("    relationships : ");
            boolean isFirst = true;
            for (Relationship relationship : this.relationships) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(relationship);
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static enum Type {
        ROLE,
        AROLE,
        USER,
        PERM;

    }

    public static enum Op {
        ADD,
        MOD,
        REM;

    }
}

