/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jpa.impl.entitymanager;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.persistence.FlushModeType;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Set;
import org.apache.deltaspike.jpa.api.entitymanager.EntityManagerConfig;
import org.apache.deltaspike.jpa.api.entitymanager.EntityManagerResolver;
import org.apache.deltaspike.jpa.api.transaction.Transactional;

public class EntityManagerMetadata {
    private Class<? extends EntityManagerResolver> entityManagerResolverClass;
    private EntityManagerResolver unmanagedResolver;
    private Class<? extends Annotation>[] qualifiers;
    private boolean entityManagerResolverIsNormalScope;
    private FlushModeType entityManagerFlushMode;
    private boolean readOnly = false;

    public Class<? extends EntityManagerResolver> getEntityManagerResolverClass() {
        return this.entityManagerResolverClass;
    }

    public void setEntityManagerResolverClass(Class<? extends EntityManagerResolver> entityManagerResolverClass) {
        this.entityManagerResolverClass = entityManagerResolverClass;
    }

    public FlushModeType getEntityManagerFlushMode() {
        return this.entityManagerFlushMode;
    }

    public void setEntityManagerFlushMode(FlushModeType entityManagerFlushMode) {
        this.entityManagerFlushMode = entityManagerFlushMode;
    }

    public boolean isEntityManagerResolverIsNormalScope() {
        return this.entityManagerResolverIsNormalScope;
    }

    public void setEntityManagerResolverIsNormalScope(boolean entityManagerResolverIsNormalScope) {
        this.entityManagerResolverIsNormalScope = entityManagerResolverIsNormalScope;
    }

    public Class<? extends Annotation>[] getQualifiers() {
        return this.qualifiers;
    }

    public void setQualifiers(Class<? extends Annotation>[] qualifiers) {
        this.qualifiers = qualifiers;
    }

    public EntityManagerResolver getUnmanagedResolver() {
        return this.unmanagedResolver;
    }

    public void setUnmanagedResolver(EntityManagerResolver unmanagedResolver) {
        this.unmanagedResolver = unmanagedResolver;
    }

    public boolean readFrom(AnnotatedElement method, BeanManager beanManager) {
        EntityManagerConfig entityManagerConfig = method.getAnnotation(EntityManagerConfig.class);
        boolean processed = this.processEntityManagerConfig(beanManager, entityManagerConfig);
        Transactional transactional = method.getAnnotation(Transactional.class);
        processed = this.processTransactional(processed, transactional);
        return processed;
    }

    private boolean processTransactional(boolean processed, Transactional transactional) {
        if (transactional != null && this.qualifiers == null) {
            processed = true;
            this.setQualifiers(transactional.qualifier());
        }
        if (transactional != null) {
            this.readOnly = transactional.readOnly();
        }
        return processed;
    }

    private boolean processEntityManagerConfig(BeanManager beanManager, EntityManagerConfig entityManagerConfig) {
        boolean processed = false;
        if (entityManagerConfig != null) {
            processed = true;
            this.setEntityManagerFlushMode(entityManagerConfig.flushMode());
            this.setQualifiers(entityManagerConfig.qualifier());
            Class resolverClass = entityManagerConfig.entityManagerResolver();
            if (!resolverClass.equals(EntityManagerResolver.class)) {
                this.setEntityManagerResolverClass(resolverClass);
                Set beans = beanManager.getBeans((Type)resolverClass, new Annotation[0]);
                Class scope = beanManager.resolve(beans).getScope();
                this.setEntityManagerResolverIsNormalScope(beanManager.isNormalScope(scope));
            } else {
                this.setEntityManagerResolverIsNormalScope(false);
            }
        }
        return processed;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }
}

