/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.decoding.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.Resolver;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.MessageException;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.binding.EndpointResolver;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.binding.artifact.SAMLArtifact;
import org.opensaml.saml.common.binding.artifact.SAMLSourceLocationArtifact;
import org.opensaml.saml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml.common.binding.impl.BaseSAMLHttpServletRequestDecoder;
import org.opensaml.saml.common.binding.impl.DefaultEndpointResolver;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.soap.SAMLSOAPClientContextBuilder;
import org.opensaml.saml.config.SAMLConfigurationSupport;
import org.opensaml.saml.criterion.ArtifactCriterion;
import org.opensaml.saml.criterion.EndpointCriterion;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.binding.artifact.SAML2Artifact;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactBuilderFactory;
import org.opensaml.saml.saml2.core.Artifact;
import org.opensaml.saml.saml2.core.ArtifactResolve;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.security.SecurityException;
import org.opensaml.soap.client.SOAPClient;
import org.opensaml.soap.common.SOAPException;
import org.slf4j.Logger;

public class HTTPArtifactDecoder
extends BaseSAMLHttpServletRequestDecoder
implements SAMLMessageDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPArtifactDecoder.class);
    @Nullable
    private BindingDescriptor bindingDescriptor;
    @NonnullAfterInit
    private SAML2ArtifactBuilderFactory artifactBuilderFactory;
    @NonnullAfterInit
    private EndpointResolver<ArtifactResolutionService> artifactEndpointResolver;
    @NonnullAfterInit
    private RoleDescriptorResolver roleDescriptorResolver;
    @NonnullAfterInit
    private QName peerEntityRole;
    @NonnullAfterInit
    private Resolver<String, CriteriaSet> selfEntityIDResolver;
    @NonnullAfterInit
    private SOAPClient soapClient;
    @Nullable
    private String soapPipelineName;
    @Nullable
    private String soapClientSecurityConfigurationProfileId;
    @NonnullAfterInit
    private IdentifierGenerationStrategy idStrategy;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.selfEntityIDResolver == null) {
            throw new ComponentInitializationException("Self entityID resolver cannot be null");
        }
        if (this.roleDescriptorResolver == null) {
            throw new ComponentInitializationException("RoleDescriptorResolver cannot be null");
        }
        if (this.peerEntityRole == null) {
            throw new ComponentInitializationException("Peer entity role cannot be null");
        }
        if (this.soapClient == null) {
            throw new ComponentInitializationException("SOAPClient cannot be null");
        }
        if (this.idStrategy == null) {
            this.idStrategy = IdentifierGenerationStrategy.getInstance((IdentifierGenerationStrategy.ProviderType)IdentifierGenerationStrategy.ProviderType.SECURE);
        }
        if (this.artifactBuilderFactory == null) {
            this.artifactBuilderFactory = SAMLConfigurationSupport.getSAML2ArtifactBuilderFactory();
            if (this.artifactBuilderFactory == null) {
                throw new ComponentInitializationException("Could not obtain a required instance of SAML2ArtifactBuilderFactory");
            }
        }
        if (this.artifactEndpointResolver == null) {
            this.artifactEndpointResolver = new DefaultEndpointResolver();
        }
    }

    @NonnullAfterInit
    public IdentifierGenerationStrategy getIdentifierGenerationStrategy() {
        return this.idStrategy;
    }

    public void setIdentifierGenerationStrategy(@Nonnull IdentifierGenerationStrategy strategy) {
        this.checkSetterPreconditions();
        this.idStrategy = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)strategy, (String)"IdentifierGenerationStrategy cannot be null");
    }

    @NonnullAfterInit
    public Resolver<String, CriteriaSet> getSelfEntityIDResolver() {
        return this.selfEntityIDResolver;
    }

    public void setSelfEntityIDResolver(@Nullable Resolver<String, CriteriaSet> resolver) {
        this.checkSetterPreconditions();
        this.selfEntityIDResolver = resolver;
    }

    @NonnullAfterInit
    public QName getPeerEntityRole() {
        return this.peerEntityRole;
    }

    public void setPeerEntityRole(@Nullable QName role) {
        this.checkSetterPreconditions();
        this.peerEntityRole = role;
    }

    @NonnullAfterInit
    public EndpointResolver<ArtifactResolutionService> getArtifactEndpointResolver() {
        return this.artifactEndpointResolver;
    }

    public void setArtifactEndpointResolver(@Nullable EndpointResolver<ArtifactResolutionService> resolver) {
        this.checkSetterPreconditions();
        this.artifactEndpointResolver = resolver;
    }

    @NonnullAfterInit
    public RoleDescriptorResolver getRoleDescriptorResolver() {
        return this.roleDescriptorResolver;
    }

    public void setRoleDescriptorResolver(@Nullable RoleDescriptorResolver resolver) {
        this.checkSetterPreconditions();
        this.roleDescriptorResolver = resolver;
    }

    @NonnullAfterInit
    public SAML2ArtifactBuilderFactory getArtifactBuilderFactory() {
        return this.artifactBuilderFactory;
    }

    public void setArtifactBuilderFactory(@Nullable SAML2ArtifactBuilderFactory factory) {
        this.checkSetterPreconditions();
        this.artifactBuilderFactory = factory;
    }

    @NonnullAfterInit
    public SOAPClient getSOAPClient() {
        return this.soapClient;
    }

    public void setSOAPClient(@Nullable SOAPClient client) {
        this.checkSetterPreconditions();
        this.soapClient = client;
    }

    @Nullable
    public String getSOAPPipelineName() {
        return this.soapPipelineName;
    }

    public void setSOAPPipelineName(@Nullable String name) {
        this.checkSetterPreconditions();
        this.soapPipelineName = StringSupport.trimOrNull((String)name);
    }

    @Nullable
    public String getSOAPClientSecurityConfigurationProfileId() {
        return this.soapClientSecurityConfigurationProfileId;
    }

    public void setSOAPClientSecurityConfigurationProfileId(@Nullable String profileId) {
        this.soapClientSecurityConfigurationProfileId = StringSupport.trimOrNull((String)profileId);
    }

    @Nonnull
    @NotEmpty
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact";
    }

    @Nullable
    public BindingDescriptor getBindingDescriptor() {
        return this.bindingDescriptor;
    }

    public void setBindingDescriptor(@Nullable BindingDescriptor descriptor) {
        this.checkSetterPreconditions();
        this.bindingDescriptor = descriptor;
    }

    protected void doDecode() throws MessageDecodingException {
        MessageContext messageContext = new MessageContext();
        HttpServletRequest request = this.getHttpServletRequest();
        String relayState = StringSupport.trim((String)request.getParameter("RelayState"));
        this.log.debug("Decoded SAML relay state of: {}", (Object)relayState);
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)relayState);
        this.processArtifact(messageContext, request);
        this.populateBindingContext(messageContext);
        this.setMessageContext(messageContext);
    }

    private void processArtifact(@Nonnull MessageContext messageContext, @Nonnull HttpServletRequest request) throws MessageDecodingException {
        String encodedArtifact = StringSupport.trimOrNull((String)request.getParameter("SAMLart"));
        if (encodedArtifact == null) {
            this.log.error("URL SAMLart parameter was missing or did not contain a value");
            throw new MessageDecodingException("URL SAMLart parameter was missing or did not contain a value");
        }
        try {
            SAML2Artifact artifact = this.parseArtifact(encodedArtifact);
            RoleDescriptor peerRoleDescriptor = this.resolvePeerRoleDescriptor(artifact);
            String resolutionEndpoint = this.resolveArtifactEndpoint(artifact, peerRoleDescriptor);
            SAMLObject inboundMessage = this.dereferenceArtifact(artifact, peerRoleDescriptor, resolutionEndpoint);
            messageContext.setMessage((Object)inboundMessage);
        }
        catch (MessageDecodingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageDecodingException("Fatal error decoding or resolving inbound artifact", e);
        }
    }

    @Nonnull
    private SAMLObject dereferenceArtifact(@Nonnull SAML2Artifact artifact, @Nonnull RoleDescriptor peerRoleDescriptor, @Nonnull String endpoint) throws MessageDecodingException {
        try {
            Object response;
            String selfEntityID = this.resolveSelfEntityID(peerRoleDescriptor);
            InOutOperationContext opContext = new SAMLSOAPClientContextBuilder().setOutboundMessage((SAMLObject)this.buildArtifactResolveRequestMessage(artifact, endpoint, peerRoleDescriptor, selfEntityID)).setProtocol("urn:oasis:names:tc:SAML:2.0:protocol").setPipelineName(this.getSOAPPipelineName()).setSecurityConfigurationProfileId(this.getSOAPClientSecurityConfigurationProfileId()).setPeerRoleDescriptor(peerRoleDescriptor).setSelfEntityID(selfEntityID).build();
            this.log.trace("Executing ArtifactResolve over SOAP 1.1 binding to endpoint: {}", (Object)endpoint);
            this.soapClient.send(endpoint, opContext);
            MessageContext inboundContext = opContext.getInboundMessageContext();
            Object object = response = inboundContext != null ? inboundContext.getMessage() : null;
            if (response instanceof ArtifactResponse) {
                return this.validateAndExtractResponseMessage((ArtifactResponse)response);
            }
            throw new MessageDecodingException("SOAP message payload was not an instance of ArtifactResponse: " + (response != null ? response.getClass().getName() : "(null)"));
        }
        catch (EncodingException | MessageException | SecurityException | SOAPException e) {
            throw new MessageDecodingException("Error dereferencing artifact", (Exception)e);
        }
    }

    @Nonnull
    private SAMLObject validateAndExtractResponseMessage(@Nonnull ArtifactResponse artifactResponse) throws MessageDecodingException {
        StatusCode statusCode;
        Status status = artifactResponse.getStatus();
        StatusCode statusCode2 = statusCode = status != null ? status.getStatusCode() : null;
        if (statusCode == null || statusCode.getValue() == null) {
            throw new MessageDecodingException("ArtifactResponse included no StatusCode, could not validate");
        }
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode.getValue())) {
            throw new MessageDecodingException("ArtifactResponse carried non-success StatusCode: " + statusCode.getValue());
        }
        SAMLObject msg = artifactResponse.getMessage();
        if (msg == null) {
            throw new MessageDecodingException("ArtifactResponse carried an empty message payload");
        }
        return msg;
    }

    @Nonnull
    private ArtifactResolve buildArtifactResolveRequestMessage(@Nonnull SAML2Artifact artifact, @Nonnull String endpoint, @Nonnull RoleDescriptor peerRoleDescriptor, @Nonnull String selfEntityID) throws EncodingException {
        ArtifactResolve request = (ArtifactResolve)XMLObjectSupport.buildXMLObject((QName)ArtifactResolve.DEFAULT_ELEMENT_NAME);
        Artifact requestArtifact = (Artifact)XMLObjectSupport.buildXMLObject((QName)Artifact.DEFAULT_ELEMENT_NAME);
        requestArtifact.setValue(Base64Support.encode((byte[])artifact.getArtifactBytes(), (boolean)false));
        request.setArtifact(requestArtifact);
        request.setID(this.idStrategy.generateIdentifier(true));
        request.setDestination(endpoint);
        request.setIssueInstant(Instant.now());
        request.setIssuer(this.buildIssuer(selfEntityID));
        return request;
    }

    @Nonnull
    private String resolveSelfEntityID(@Nonnull RoleDescriptor peerRoleDescriptor) throws MessageDecodingException {
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new RoleDescriptorCriterion(peerRoleDescriptor)});
        try {
            String selfEntityID = (String)this.getSelfEntityIDResolver().resolveSingle((Object)criteria);
            if (selfEntityID == null) {
                throw new MessageDecodingException("Unable to resolve self entityID from peer RoleDescriptor");
            }
            return selfEntityID;
        }
        catch (ResolverException e) {
            throw new MessageDecodingException("Fatal error resolving self entityID from peer RoleDescriptor", (Exception)((Object)e));
        }
    }

    @Nonnull
    private Issuer buildIssuer(@Nonnull String selfEntityID) {
        Issuer issuer = (Issuer)XMLObjectSupport.buildXMLObject((QName)Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(selfEntityID);
        return issuer;
    }

    @Nonnull
    private String resolveArtifactEndpoint(@Nonnull SAML2Artifact artifact, @Nonnull RoleDescriptor peerRoleDescriptor) throws MessageDecodingException {
        RoleDescriptorCriterion roleDescriptorCriterion = new RoleDescriptorCriterion(peerRoleDescriptor);
        ArtifactResolutionService arsTemplate = (ArtifactResolutionService)XMLObjectSupport.buildXMLObject((QName)ArtifactResolutionService.DEFAULT_ELEMENT_NAME);
        arsTemplate.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        if (artifact instanceof SAMLSourceLocationArtifact) {
            arsTemplate.setLocation(((SAMLSourceLocationArtifact)artifact).getSourceLocation());
        }
        Integer endpointIndex = SAMLBindingSupport.convertSAML2ArtifactEndpointIndex((byte[])artifact.getEndpointIndex());
        arsTemplate.setIndex(endpointIndex);
        EndpointCriterion endpointCriterion = new EndpointCriterion((Endpoint)arsTemplate, false);
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{roleDescriptorCriterion, endpointCriterion});
        try {
            String loc;
            ArtifactResolutionService ars = (ArtifactResolutionService)this.artifactEndpointResolver.resolveSingle((Object)criteriaSet);
            if (ars != null && (loc = ars.getLocation()) != null) {
                return loc;
            }
            throw new MessageDecodingException("Unable to resolve ArtifactResolutionService endpoint");
        }
        catch (ResolverException e) {
            throw new MessageDecodingException("Unable to resolve ArtifactResolutionService endpoint");
        }
    }

    @Nonnull
    private RoleDescriptor resolvePeerRoleDescriptor(@Nonnull SAML2Artifact artifact) throws MessageDecodingException {
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new ArtifactCriterion((SAMLArtifact)artifact), new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol"), new EntityRoleCriterion(this.getPeerEntityRole())});
        try {
            RoleDescriptor rd = (RoleDescriptor)this.roleDescriptorResolver.resolveSingle((Object)criteriaSet);
            if (rd == null) {
                throw new MessageDecodingException("Unable to resolve peer RoleDescriptor from supplied artifact");
            }
            return rd;
        }
        catch (ResolverException e) {
            throw new MessageDecodingException("Error resolving peer entity RoleDescriptor", (Exception)((Object)e));
        }
    }

    @Nonnull
    private SAML2Artifact parseArtifact(@Nonnull String encodedArtifact) throws MessageDecodingException {
        try {
            SAML2Artifact artifact = this.artifactBuilderFactory.buildArtifact(encodedArtifact);
            if (artifact == null) {
                throw new MessageDecodingException("Could not build SAML2Artifact instance from encoded artifact");
            }
            return artifact;
        }
        catch (DecodingException e) {
            throw new MessageDecodingException("Could not base64 decode SAML2Artifact instance from encoded artifact", (Exception)((Object)e));
        }
    }

    protected void populateBindingContext(@Nonnull MessageContext messageContext) {
        SAMLBindingContext bindingContext = (SAMLBindingContext)messageContext.ensureSubcontext(SAMLBindingContext.class);
        bindingContext.setBindingUri(this.getBindingURI());
        bindingContext.setBindingDescriptor(this.bindingDescriptor);
        bindingContext.setHasBindingSignature(false);
        bindingContext.setIntendedDestinationEndpointURIRequired(false);
    }
}

