/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JVar;
import com.sun.codemodel.util.ClassNameComparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class JDocComment
extends JCommentPart
implements JGenerable {
    private static final long serialVersionUID = 1L;
    private final transient Map<String, JCommentPart> atParams = new TreeMap<String, JCommentPart>();
    private final transient Map<String, Map<String, String>> atXdoclets = new TreeMap<String, Map<String, String>>();
    private final transient Map<JClass, JCommentPart> atThrows = new TreeMap<JClass, JCommentPart>(ClassNameComparator.theInstance);
    private JCommentPart atReturn = null;
    private JCommentPart atDeprecated = null;
    private final transient JCodeModel owner;
    private static final String INDENT = " *     ";

    public JDocComment(JCodeModel owner) {
        this.owner = owner;
    }

    @Override
    public JDocComment append(Object o) {
        this.add(o);
        return this;
    }

    public JCommentPart addParam(String param) {
        JCommentPart p = this.atParams.get(param);
        if (p == null) {
            p = new JCommentPart();
            this.atParams.put(param, p);
        }
        return p;
    }

    public JCommentPart addParam(JVar param) {
        return this.addParam(param.name());
    }

    public JCommentPart addThrows(Class<? extends Throwable> exception) {
        return this.addThrows(this.owner.ref(exception));
    }

    public JCommentPart addThrows(JClass exception) {
        JCommentPart p = this.atThrows.get(exception);
        if (p == null) {
            p = new JCommentPart();
            this.atThrows.put(exception, p);
        }
        return p;
    }

    public JCommentPart addReturn() {
        if (this.atReturn == null) {
            this.atReturn = new JCommentPart();
        }
        return this.atReturn;
    }

    public JCommentPart addDeprecated() {
        if (this.atDeprecated == null) {
            this.atDeprecated = new JCommentPart();
        }
        return this.atDeprecated;
    }

    public Map<String, String> addXdoclet(String name) {
        return this.atXdoclets.computeIfAbsent(name, k -> new HashMap());
    }

    public Map<String, String> addXdoclet(String name, Map<String, String> attributes) {
        Map p = this.atXdoclets.computeIfAbsent(name, k -> new HashMap());
        p.putAll(attributes);
        return p;
    }

    public Map<String, String> addXdoclet(String name, String attribute, String value) {
        Map p = this.atXdoclets.computeIfAbsent(name, k -> new HashMap());
        p.put(attribute, value);
        return p;
    }

    @Override
    public void generate(JFormatter f) {
        f.p("/**").nl();
        this.format(f, " * ");
        f.p(" * ").nl();
        for (Map.Entry<String, JCommentPart> entry : this.atParams.entrySet()) {
            f.p(" * @param ").p(entry.getKey()).nl();
            entry.getValue().format(f, INDENT);
        }
        if (this.atReturn != null) {
            f.p(" * @return").nl();
            this.atReturn.format(f, INDENT);
        }
        for (Map.Entry<Object, JCommentPart> entry : this.atThrows.entrySet()) {
            f.p(" * @throws ").t((JClass)entry.getKey()).nl();
            entry.getValue().format(f, INDENT);
        }
        if (this.atDeprecated != null) {
            f.p(" * @deprecated").nl();
            this.atDeprecated.format(f, INDENT);
        }
        for (Map.Entry<Object, Object> entry : this.atXdoclets.entrySet()) {
            f.p(" * @").p((String)entry.getKey());
            if (entry.getValue() != null) {
                for (Map.Entry a : ((Map)entry.getValue()).entrySet()) {
                    f.p(" ").p((String)a.getKey()).p("= \"").p((String)a.getValue()).p("\"");
                }
            }
            f.nl();
        }
        f.p(" */").nl();
    }
}

