/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.common;

import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.common.AbstractJoseProducer;
import org.apache.cxf.rs.security.jose.common.JoseException;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;

public class JoseProducer
extends AbstractJoseProducer {
    public String processData(String data) {
        super.checkProcessRequirements();
        JweEncryptionProvider theEncProvider = null;
        JweHeaders jweHeaders = new JweHeaders();
        if (this.isJweRequired() && (theEncProvider = this.getInitializedEncryptionProvider(jweHeaders)) == null) {
            throw new JoseException("Unable to encrypt the data");
        }
        if (this.isJwsRequired()) {
            JwsHeaders jwsHeaders = new JwsHeaders();
            JwsCompactProducer jws = new JwsCompactProducer(jwsHeaders, data);
            JwsSignatureProvider theSigProvider = this.getInitializedSignatureProvider(jwsHeaders);
            if (theSigProvider == null) {
                throw new JoseException("Unable to sign the data");
            }
            data = jws.signWith(theSigProvider);
        }
        if (theEncProvider != null) {
            data = theEncProvider.encrypt(StringUtils.toBytesUTF8((String)data), jweHeaders);
        }
        return data;
    }
}

