/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.collection.TransformedCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TransformedCollectionTest
extends AbstractCollectionTest<Object> {
    public static final Transformer<Object, Object> NOOP_TRANSFORMER = TransformerUtils.nopTransformer();
    public static final Transformer<Object, Object> STRING_TO_INTEGER_TRANSFORMER = new StringToInteger();
    public static final Transformer<Object, Object> TO_LOWER_CASE_TRANSFORMER = new ToLowerCase();

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public Object[] getFullElements() {
        return new Object[]{"1", "3", "5", "7", "2", "4", "6"};
    }

    @Override
    public Object[] getOtherElements() {
        return new Object[]{"9", "88", "678", "87", "98", "78", "99"};
    }

    @Override
    public Collection<Object> makeConfirmedCollection() {
        return new ArrayList<Object>();
    }

    @Override
    public Collection<Object> makeConfirmedFullCollection() {
        return new ArrayList<Object>(Arrays.asList(this.getFullElements()));
    }

    @Override
    public Collection<Object> makeFullCollection() {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(this.getFullElements()));
        return TransformedCollection.transformingCollection(list, NOOP_TRANSFORMER);
    }

    @Override
    public Collection<Object> makeObject() {
        return TransformedCollection.transformingCollection(new ArrayList(), NOOP_TRANSFORMER);
    }

    @Test
    public void testTransformedCollection() {
        TransformedCollection coll = TransformedCollection.transformingCollection(new ArrayList(), STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)0, (int)coll.size());
        Object[] elements = this.getFullElements();
        for (int i = 0; i < elements.length; ++i) {
            coll.add(elements[i]);
            Assertions.assertEquals((int)(i + 1), (int)coll.size());
            Assertions.assertTrue((boolean)coll.contains(Integer.valueOf((String)elements[i])));
            Assertions.assertFalse((boolean)coll.contains(elements[i]));
        }
        Assertions.assertTrue((boolean)coll.remove(Integer.valueOf((String)elements[0])));
    }

    @Test
    public void testTransformedCollection_decorateTransform() {
        ArrayList originalCollection = new ArrayList();
        Object[] elements = this.getFullElements();
        Collections.addAll(originalCollection, elements);
        TransformedCollection collection = TransformedCollection.transformedCollection(originalCollection, STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)elements.length, (int)collection.size());
        for (Object element : elements) {
            Assertions.assertTrue((boolean)collection.contains(Integer.valueOf((String)element)));
            Assertions.assertFalse((boolean)collection.contains(element));
        }
        Assertions.assertFalse((boolean)collection.remove(elements[0]));
        Assertions.assertTrue((boolean)collection.remove(Integer.valueOf((String)elements[0])));
    }

    private static final class StringToInteger
    implements Transformer<Object, Object> {
        private StringToInteger() {
        }

        public Object transform(Object input) {
            return Integer.valueOf((String)input);
        }
    }

    private static final class ToLowerCase
    implements Transformer<Object, Object> {
        private ToLowerCase() {
        }

        public Object transform(Object input) {
            return ((String)input).toLowerCase();
        }
    }
}

