/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.ShuffleClientImpl;
import org.apache.celeborn.client.read.CelebornInputStream;
import org.apache.celeborn.client.read.MetricsCallback;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.util.ExceptionMaker;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.write.LocationPushFailedBatches;
import org.apache.celeborn.common.write.PushState;
import org.apache.celeborn.shaded.org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class DummyShuffleClient
extends ShuffleClient {
    private static final Logger LOG = LoggerFactory.getLogger(DummyShuffleClient.class);
    private final OutputStream os;
    private final CelebornConf conf;
    private final Map<Integer, ConcurrentHashMap<Integer, PartitionLocation>> reducePartitionMap = new HashMap<Integer, ConcurrentHashMap<Integer, PartitionLocation>>();
    public AtomicInteger fetchFailureCount = new AtomicInteger();

    public DummyShuffleClient(CelebornConf conf, File file) throws Exception {
        this.os = new BufferedOutputStream(new FileOutputStream(file));
        this.conf = conf;
    }

    @Override
    public void setupLifecycleManagerRef(String host, int port) {
    }

    @Override
    public void setupLifecycleManagerRef(RpcEndpointRef endpointRef) {
    }

    @Override
    public void setExtension(byte[] extension2) {
    }

    @Override
    public int pushData(int shuffleId, int mapId, int attemptId, int partitionId, byte[] data, int offset, int length, int numMappers, int numPartitions) throws IOException {
        this.os.write(data, offset, length);
        return length;
    }

    @Override
    public void prepareForMergeData(int shuffleId, int mapId, int attemptId) throws IOException {
    }

    @Override
    public int mergeData(int shuffleId, int mapId, int attemptId, int partitionId, byte[] data, int offset, int length, int numMappers, int numPartitions) throws IOException {
        this.os.write(data, offset, length);
        return length;
    }

    @Override
    public void pushMergedData(int shuffleId, int mapId, int attemptId) {
    }

    @Override
    public void mapperEnd(int shuffleId, int mapId, int attemptId, int numMappers, int numPartitions) {
    }

    @Override
    public void readReducerPartitionEnd(int shuffleId, int partitionId, int startMapIndex, int endMapIndex, int crc32, long bytes) throws IOException {
    }

    @Override
    public void mapPartitionMapperEnd(int shuffleId, int mapId, int attemptId, int numMappers, int numPartitions, int partitionId) throws IOException {
    }

    @Override
    public void cleanup(int shuffleId, int mapId, int attemptId) {
    }

    @Override
    public ShuffleClientImpl.ReduceFileGroups updateFileGroup(int shuffleId, int partitionId) throws CelebornIOException {
        return null;
    }

    @Override
    public boolean isShuffleStageEnd(int shuffleId) throws Exception {
        return true;
    }

    @Override
    public CelebornInputStream readPartition(int shuffleId, int appShuffleId, int partitionId, int attemptNumber, long taskId, int startMapIndex, int endMapIndex, ExceptionMaker exceptionMaker, ArrayList<PartitionLocation> locations, ArrayList<PbStreamHandler> streamHandlers, Map<String, LocationPushFailedBatches> failedBatchSetMap, Map<String, Pair<Integer, Integer>> chunksRange, int[] mapAttempts, MetricsCallback metricsCallback, boolean needDecompress) throws IOException {
        return null;
    }

    @Override
    public boolean cleanupShuffle(int shuffleId) {
        return false;
    }

    @Override
    public void shutdown() {
        try {
            this.os.close();
        }
        catch (IOException e) {
            LOG.error("Closing file failed.", (Throwable)e);
        }
    }

    @Override
    public PartitionLocation registerMapPartitionTask(int shuffleId, int numMappers, int mapId, int attemptId, int partitionId) {
        return null;
    }

    @Override
    public ConcurrentHashMap<Integer, PartitionLocation> getPartitionLocation(int shuffleId, int numMappers, int numPartitions) {
        return this.reducePartitionMap.get(shuffleId);
    }

    @Override
    public PushState getPushState(String mapKey) {
        return new PushState(this.conf);
    }

    @Override
    public Tuple2<Integer, Boolean> getShuffleId(int appShuffleId, String appShuffleIdentifier, boolean isWriter, boolean isBarrierStage) {
        return Tuple2.apply((Object)appShuffleId, (Object)true);
    }

    @Override
    public boolean reportShuffleFetchFailure(int appShuffleId, int shuffleId, long taskId) {
        this.fetchFailureCount.incrementAndGet();
        return true;
    }

    @Override
    public boolean reportBarrierTaskFailure(int appShuffleId, String appShuffleIdentifier) {
        return true;
    }

    @Override
    public TransportClientFactory getDataClientFactory() {
        return null;
    }

    @Override
    public void excludeFailedFetchLocation(String hostAndFetchPort, Exception e) {
    }

    public void initReducePartitionMap(int shuffleId, int numPartitions, int workerNum) {
        int i;
        ConcurrentHashMap map = JavaUtils.newConcurrentHashMap();
        String host = "host";
        ArrayList<PartitionLocation> partitionLocationList = new ArrayList<PartitionLocation>();
        for (i = 0; i < workerNum; ++i) {
            partitionLocationList.add(new PartitionLocation(0, 0, host, 1000 + i, 2000 + i, 3000 + i, 4000 + i, PartitionLocation.Mode.PRIMARY));
        }
        for (i = 0; i < numPartitions; ++i) {
            map.put(i, partitionLocationList.get(i % workerNum));
        }
        this.reducePartitionMap.put(shuffleId, map);
    }

    public Map<Integer, ConcurrentHashMap<Integer, PartitionLocation>> getReducePartitionMap() {
        return this.reducePartitionMap;
    }
}

