/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.meta;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.WorkerInfo$;
import org.apache.celeborn.common.meta.WorkerStatus;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.quota.ResourceConsumption$;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.util.JavaUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUf\u0001\u0002#F\u0001AC\u0001\u0002\u0019\u0001\u0003\u0006\u0004%\t!\u0019\u0005\t[\u0002\u0011\t\u0011)A\u0005E\"Aa\u000e\u0001BC\u0002\u0013\u0005q\u000e\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003q\u0011!!\bA!b\u0001\n\u0003y\u0007\u0002C;\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0011Y\u0004!Q1A\u0005\u0002=D\u0001b\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\tq\u0002\u0011)\u0019!C\u0001_\"A\u0011\u0010\u0001B\u0001B\u0003%\u0001\u000f\u0003\u0005{\u0001\t\u0015\r\u0011\"\u0001p\u0011!Y\bA!A!\u0002\u0013\u0001\b\u0002\u0003?\u0001\u0005\u0003\u0005\u000b\u0011B?\t\u0015\u0005M\u0001A!A!\u0002\u0013\t)\u0002C\u0004\u00020\u0001!\t!!\r\t\u0013\u0005\u0015\u0003\u00011A\u0005\u0002\u0005\u001d\u0003\"CA*\u0001\u0001\u0007I\u0011AA+\u0011!\t\t\u0007\u0001Q!\n\u0005%\u0003\"CA2\u0001\u0001\u0007I\u0011AA3\u0011%\ti\u0007\u0001a\u0001\n\u0003\ty\u0007\u0003\u0005\u0002t\u0001\u0001\u000b\u0015BA4\u0011%\t)\b\u0001a\u0001\n\u0003\t9\bC\u0005\u0002\u0000\u0001\u0001\r\u0011\"\u0001\u0002\u0002\"A\u0011Q\u0011\u0001!B\u0013\tI\bC\u0005\u0002\b\u0002\u0011\r\u0011\"\u0001\u0002\n\"A\u0011q\u0013\u0001!\u0002\u0013\tY\tC\u0005\u0002\u001a\u0002\u0011\r\u0011\"\u0001\u0002\u001c\"A\u0011\u0011\u0016\u0001!\u0002\u0013\ti\nC\u0005\u0002,\u0002\u0011\r\u0011\"\u0001\u0002.\"A\u0011\u0011\u0017\u0001!\u0002\u0013\ty\u000bC\u0005\u00024\u0002\u0001\r\u0011\"\u0001\u00026\"I\u00111\u0019\u0001A\u0002\u0013\u0005\u0011Q\u0019\u0005\t\u0003\u0013\u0004\u0001\u0015)\u0003\u00028\"9\u0011q\u0006\u0001\u0005\u0002\u0005-\u0007bBA\u0018\u0001\u0011\u0005\u0011q\u001b\u0005\b\u0003K\u0004A\u0011AAt\u0011\u001d\ty\u000f\u0001C\u0001\u0003cDq!a=\u0001\t\u0003\t)\u0010C\u0004\u0003\b\u0001!\tA!\u0003\t\u000f\t\u001d\u0001\u0001\"\u0001\u0003\u0012!9!Q\u0003\u0001\u0005\u0002\t]\u0001b\u0002B\u0010\u0001\u0011\u0005!q\u0003\u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u0011\u001d\u0011I\u0003\u0001C\u0001\u0005WAqA!\r\u0001\t\u0003\u0011\u0019\u0004C\u0005\u00036\u0001A)\u0019!C\u0001C\"9!q\u0007\u0001\u0005\u0002\te\u0002b\u0002B\u001e\u0001\u0011\u0005\u0011\u0011\u001f\u0005\b\u0005{\u0001A\u0011\u0001B \u0011\u001d\u0011\t\u0005\u0001C\u0001\u0005\u0007BqAa\u0012\u0001\t\u0003\u0011I\u0005C\u0004\u0003P\u0001!\t!!=\t\u000f\tE\u0003\u0001\"\u0001\u0002r\"9!1\u000b\u0001\u0005\u0002\u0005E\bb\u0002B+\u0001\u0011\u0005!q\u000b\u0005\n\u0005K\u0002\u0011\u0013!C\u0001\u0005OBqA! \u0001\t\u0003\u0011y\bC\u0004\u0003\u0006\u0002!\tEa\r\t\u000f\t\u001d\u0005\u0001\"\u0011\u0003\n\"9!1\u0013\u0001\u0005B\tU\u0005b\u0002BL\u0001\u0011%\u0011q\u001d\u0005\b\u00053\u0003A\u0011\u0001B\u001d\u000f\u001d\u0011Y*\u0012E\u0001\u0005;3a\u0001R#\t\u0002\t}\u0005bBA\u0018\u0001\u0012\u0005!\u0011\u0015\u0005\b\u0005G\u0003E\u0011\u0001BS\u0011%\u0011Y\u000bQA\u0001\n\u0013\u0011iK\u0001\u0006X_J\\WM]%oM>T!AR$\u0002\t5,G/\u0019\u0006\u0003\u0011&\u000baaY8n[>t'B\u0001&L\u0003!\u0019W\r\\3c_Jt'B\u0001'N\u0003\u0019\t\u0007/Y2iK*\ta*A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001#^S\u0006C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&AB!osJ+g\r\u0005\u0002S1&\u0011\u0011l\u0015\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\u001e\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003?r\u0013q\u0001T8hO&tw-\u0001\u0003i_N$X#\u00012\u0011\u0005\rTgB\u00013i!\t)7+D\u0001g\u0015\t9w*\u0001\u0004=e>|GOP\u0005\u0003SN\u000ba\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011nU\u0001\u0006Q>\u001cH\u000fI\u0001\beB\u001c\u0007k\u001c:u+\u0005\u0001\bC\u0001*r\u0013\t\u00118KA\u0002J]R\f\u0001B\u001d9d!>\u0014H\u000fI\u0001\taV\u001c\b\u000eU8si\u0006I\u0001/^:i!>\u0014H\u000fI\u0001\nM\u0016$8\r\u001b)peR\f!BZ3uG\"\u0004vN\u001d;!\u00035\u0011X\r\u001d7jG\u0006$X\rU8si\u0006q!/\u001a9mS\u000e\fG/\u001a)peR\u0004\u0013\u0001D5oi\u0016\u0014h.\u00197Q_J$\u0018!D5oi\u0016\u0014h.\u00197Q_J$\b%\u0001\u0006`I&\u001c8.\u00138g_N\u0004bA`A\u0004E\u0006-Q\"A@\u000b\t\u0005\u0005\u00111A\u0001\u0005kRLGN\u0003\u0002\u0002\u0006\u0005!!.\u0019<b\u0013\r\tIa \u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0007\u0003\u001fi\u0011!R\u0005\u0004\u0003#)%\u0001\u0003#jg.LeNZ8\u00021}+8/\u001a:SKN|WO]2f\u0007>t7/^7qi&|g\u000eE\u0004\u007f\u0003\u000f\t9\"a\t\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\bH\u0003!IG-\u001a8uSRL\u0018\u0002BA\u0011\u00037\u0011a\"V:fe&#WM\u001c;jM&,'\u000f\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\r\tIcR\u0001\u0006cV|G/Y\u0005\u0005\u0003[\t9CA\nSKN|WO]2f\u0007>t7/^7qi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003g\t)$a\u000e\u0002:\u0005m\u0012QHA \u0003\u0003\n\u0019\u0005E\u0002\u0002\u000e\u0001AQ\u0001Y\bA\u0002\tDQA\\\bA\u0002ADQ\u0001^\bA\u0002ADQA^\bA\u0002ADQ\u0001_\bA\u0002ADQA_\bA\u0002ADQ\u0001`\bA\u0002uDq!a\u0005\u0010\u0001\u0004\t)\"A\boKR<xN]6M_\u000e\fG/[8o+\t\tI\u0005\u0005\u0003\u0002L\u0005ESBAA'\u0015\u0011\ty%a\u0001\u0002\t1\fgnZ\u0005\u0004W\u00065\u0013a\u00058fi^|'o\u001b'pG\u0006$\u0018n\u001c8`I\u0015\fH\u0003BA,\u0003;\u00022AUA-\u0013\r\tYf\u0015\u0002\u0005+:LG\u000fC\u0005\u0002`E\t\t\u00111\u0001\u0002J\u0005\u0019\u0001\u0010J\u0019\u0002!9,Go^8sW2{7-\u0019;j_:\u0004\u0013!\u00047bgRDU-\u0019:uE\u0016\fG/\u0006\u0002\u0002hA\u0019!+!\u001b\n\u0007\u0005-4K\u0001\u0003M_:<\u0017!\u00057bgRDU-\u0019:uE\u0016\fGo\u0018\u0013fcR!\u0011qKA9\u0011%\ty\u0006FA\u0001\u0002\u0004\t9'\u0001\bmCN$\b*Z1si\n,\u0017\r\u001e\u0011\u0002\u0019]|'o[3s'R\fG/^:\u0016\u0005\u0005e\u0004\u0003BA\u0007\u0003wJ1!! F\u000519vN]6feN#\u0018\r^;t\u0003A9xN]6feN#\u0018\r^;t?\u0012*\u0017\u000f\u0006\u0003\u0002X\u0005\r\u0005\"CA0/\u0005\u0005\t\u0019AA=\u000359xN]6feN#\u0018\r^;tA\u0005IA-[:l\u0013:4wn]\u000b\u0003\u0003\u0017\u0003r!!$\u0002\u0014\n\fY!\u0004\u0002\u0002\u0010*\u0019\u0011\u0011S@\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\u0016\u0006=%!E\"p]\u000e,(O]3oi\"\u000b7\u000f['ba\u0006QA-[:l\u0013:4wn\u001d\u0011\u0002\u001b]|'o[3s\u0011\u0006\u001cH)[:l+\t\ti\n\u0005\u0003\u0002 \u0006\u0015VBAAQ\u0015\u0011\t\u0019+a$\u0002\r\u0005$x.\\5d\u0013\u0011\t9+!)\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u000399xN]6fe\"\u000b7\u000fR5tW\u0002\nq#^:feJ+7o\\;sG\u0016\u001cuN\\:v[B$\u0018n\u001c8\u0016\u0005\u0005=\u0006\u0003CAG\u0003'\u000b9\"a\t\u00021U\u001cXM\u001d*fg>,(oY3D_:\u001cX/\u001c9uS>t\u0007%\u0001\u0005f]\u0012\u0004x.\u001b8u+\t\t9\f\u0005\u0003\u0002:\u0006}VBAA^\u0015\r\tilR\u0001\u0004eB\u001c\u0017\u0002BAa\u0003w\u0013aB\u00159d\u000b:$\u0007o\\5oiJ+g-\u0001\u0007f]\u0012\u0004x.\u001b8u?\u0012*\u0017\u000f\u0006\u0003\u0002X\u0005\u001d\u0007\"CA0A\u0005\u0005\t\u0019AA\\\u0003%)g\u000e\u001a9pS:$\b\u0005\u0006\u0007\u00024\u00055\u0017qZAi\u0003'\f)\u000eC\u0003aE\u0001\u0007!\rC\u0003oE\u0001\u0007\u0001\u000fC\u0003uE\u0001\u0007\u0001\u000fC\u0003wE\u0001\u0007\u0001\u000fC\u0003yE\u0001\u0007\u0001\u000f\u0006\b\u00024\u0005e\u00171\\Ao\u0003?\f\t/a9\t\u000b\u0001\u001c\u0003\u0019\u00012\t\u000b9\u001c\u0003\u0019\u00019\t\u000bQ\u001c\u0003\u0019\u00019\t\u000bY\u001c\u0003\u0019\u00019\t\u000ba\u001c\u0003\u0019\u00019\t\u000bi\u001c\u0003\u0019\u00019\u0002\u0011%\u001c\u0018i\u0019;jm\u0016,\"!!;\u0011\u0007I\u000bY/C\u0002\u0002nN\u0013qAQ8pY\u0016\fg.A\u0005vg\u0016$7\u000b\\8ugR\u0011\u0011qM\u0001\u000eC2dwnY1uKNcw\u000e^:\u0015\r\u0005]\u0013q_A~\u0011\u0019\tIP\na\u0001E\u0006Q1\u000f[;gM2,7*Z=\t\u000f\u0005uh\u00051\u0001\u0002\u0000\u0006a1\u000f\\8ugB+'\u000fR5tWB1a0a\u0002c\u0005\u0003\u0001B!a\u0013\u0003\u0004%!!QAA'\u0005\u001dIe\u000e^3hKJ\fAB]3mK\u0006\u001cXm\u00157piN$b!a\u0016\u0003\f\t5\u0001BBA}O\u0001\u0007!\rC\u0004\u0003\u0010\u001d\u0002\r!a@\u0002\u000bMdw\u000e^:\u0015\t\u0005]#1\u0003\u0005\u0007\u0003sD\u0003\u0019\u00012\u0002!\u001d,Go\u00155vM\u001adWmS3z'\u0016$XC\u0001B\r!\u0011q(1\u00042\n\u0007\tuqPA\u0004ICND7+\u001a;\u0002'\u001d,G/\u00119qY&\u001c\u0017\r^5p]&#7+\u001a;\u0002\u001f!\f7oU1nK&sgm\\,ji\"$B!!;\u0003&!9!qE\u0016A\u0002\u0005M\u0012!B8uQ\u0016\u0014\u0018!D:fiV\u0004XI\u001c3q_&tG\u000f\u0006\u0003\u0002X\t5\u0002b\u0002B\u0018Y\u0001\u0007\u0011qW\u0001\fK:$\u0007o\\5oiJ+g-A\bsK\u0006$\u0017M\u00197f\u0003\u0012$'/Z:t)\u0005\u0011\u0017A\u0003;p+:L\u0017/^3JI\u0006i1\u000f\\8u\u0003Z\f\u0017\u000e\\1cY\u0016$\"!!;\u0002\u001b\u001d,G\u000fV8uC2\u001cFn\u001c;t\u0003=9W\r^,pe.,'o\u0015;biV\u001cHCAA=\u0003=\u0019X\r^,pe.,'o\u0015;biV\u001cH\u0003BA,\u0005\u000bBq!!\u001e3\u0001\u0004\tI(A\bva\u0012\fG/\u001a#jg.\u001cFn\u001c;t)\u0011\t9Fa\u0013\t\u000f\t53\u00071\u0001\u0002h\u00051Rm\u001d;j[\u0006$X\r\u001a)beRLG/[8o'&TX-A\nu_R\fG.\u0011<bS2\f'\r\\3TY>$8/\u0001\u0006u_R\fGn\u00159bG\u0016\fa\u0003^8uC2\f5\r^;bYV\u001b\u0018M\u00197f'B\f7-Z\u0001\u0017kB$\u0017\r^3UQ\u0016tw)\u001a;ESN\\\u0017J\u001c4pgR)QP!\u0017\u0003^!1!1L\u001cA\u0002u\fAB\\3x\t&\u001c8.\u00138g_ND\u0011B!\u00148!\u0003\u0005\rAa\u0018\u0011\u000bI\u0013\t'a\u001a\n\u0007\t\r4K\u0001\u0004PaRLwN\\\u0001!kB$\u0017\r^3UQ\u0016tw)\u001a;ESN\\\u0017J\u001c4pg\u0012\"WMZ1vYR$#'\u0006\u0002\u0003j)\"!q\fB6W\t\u0011i\u0007\u0005\u0003\u0003p\teTB\u0001B9\u0015\u0011\u0011\u0019H!\u001e\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B<'\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tm$\u0011\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001J;qI\u0006$X\r\u00165f]\u001e+G/V:feJ+7o\\;sG\u0016\u001cuN\\:v[B$\u0018n\u001c8\u0015\t\u0005U!\u0011\u0011\u0005\b\u0005\u0007K\u0004\u0019AA\u000b\u0003Q\u0011Xm]8ve\u000e,7i\u001c8tk6\u0004H/[8og\u0006AAo\\*ue&tw-\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003S\u0014Y\tC\u0004\u0003(m\u0002\rA!$\u0011\u0007I\u0013y)C\u0002\u0003\u0012N\u00131!\u00118z\u0003!A\u0017m\u001d5D_\u0012,G#\u00019\u0002+\r|W\u000e];uK^{'o[3s\u0011\u00064X\rR5tW\u0006A\u0001.\u0019<f\t&\u001c8.\u0001\u0006X_J\\WM]%oM>\u00042!!\u0004A'\r\u0001\u0015k\u0016\u000b\u0003\u0005;\u000bAB\u001a:p[Vs\u0017.];f\u0013\u0012$B!a\r\u0003(\"1!\u0011\u0016\"A\u0002\t\f!!\u001b3\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005_\u0003B!a\u0013\u00032&!!1WA'\u0005\u0019y%M[3di\u0002")
public class WorkerInfo
implements scala.Serializable,
Logging {
    private String toUniqueId;
    private final String host;
    private final int rpcPort;
    private final int pushPort;
    private final int fetchPort;
    private final int replicatePort;
    private final int internalPort;
    private String networkLocation;
    private long lastHeartbeat;
    private WorkerStatus workerStatus;
    private final ConcurrentHashMap<String, DiskInfo> diskInfos;
    private final AtomicBoolean workerHasDisk;
    private final ConcurrentHashMap<UserIdentifier, ResourceConsumption> userResourceConsumption;
    private RpcEndpointRef endpoint;
    private transient Logger log;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static WorkerInfo fromUniqueId(String string) {
        return WorkerInfo$.MODULE$.fromUniqueId(string);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        WorkerInfo workerInfo = this;
        synchronized (workerInfo) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public String host() {
        return this.host;
    }

    public int rpcPort() {
        return this.rpcPort;
    }

    public int pushPort() {
        return this.pushPort;
    }

    public int fetchPort() {
        return this.fetchPort;
    }

    public int replicatePort() {
        return this.replicatePort;
    }

    public int internalPort() {
        return this.internalPort;
    }

    public String networkLocation() {
        return this.networkLocation;
    }

    public void networkLocation_$eq(String x$1) {
        this.networkLocation = x$1;
    }

    public long lastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void lastHeartbeat_$eq(long x$1) {
        this.lastHeartbeat = x$1;
    }

    public WorkerStatus workerStatus() {
        return this.workerStatus;
    }

    public void workerStatus_$eq(WorkerStatus x$1) {
        this.workerStatus = x$1;
    }

    public ConcurrentHashMap<String, DiskInfo> diskInfos() {
        return this.diskInfos;
    }

    public AtomicBoolean workerHasDisk() {
        return this.workerHasDisk;
    }

    public ConcurrentHashMap<UserIdentifier, ResourceConsumption> userResourceConsumption() {
        return this.userResourceConsumption;
    }

    public RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    public void endpoint_$eq(RpcEndpointRef x$1) {
        this.endpoint = x$1;
    }

    public boolean isActive() {
        return ((NettyRpcEndpointRef)this.endpoint()).client().isActive();
    }

    public synchronized long usedSlots() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$usedSlots$1(x$1)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public void allocateSlots(String shuffleKey, Map<String, Integer> slotsPerDisk) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Shuffle ").append(shuffleKey).append(", allocations ").append(slotsPerDisk).toString());
        WorkerInfo workerInfo = this;
        synchronized (workerInfo) {
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(slotsPerDisk).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                WorkerInfo.$anonfun$allocateSlots$2(this, shuffleKey, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public synchronized void releaseSlots(String shuffleKey, Map<String, Integer> slots) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(slots).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            WorkerInfo.$anonfun$releaseSlots$1(this, shuffleKey, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void releaseSlots(String shuffleKey) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            WorkerInfo.$anonfun$releaseSlots$2(shuffleKey, x$2);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized HashSet<String> getShuffleKeySet() {
        HashSet<String> shuffleKeySet = new HashSet<String>();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)diskInfo -> BoxesRunTime.boxToBoolean((boolean)shuffleKeySet.addAll(diskInfo.getShuffleKeySet())));
        return shuffleKeySet;
    }

    public synchronized HashSet<String> getApplicationIdSet() {
        HashSet<String> applicationIdSet = new HashSet<String>();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)diskInfo -> BoxesRunTime.boxToBoolean((boolean)applicationIdSet.addAll(diskInfo.getApplicationIdSet())));
        return applicationIdSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasSameInfoWith(WorkerInfo other) {
        if (this.rpcPort() != other.rpcPort()) return false;
        if (this.pushPort() != other.pushPort()) return false;
        String string = this.host();
        String string2 = other.host();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.fetchPort() != other.fetchPort()) return false;
        if (this.replicatePort() != other.replicatePort()) return false;
        return true;
    }

    public void setupEndpoint(RpcEndpointRef endpointRef) {
        if (this.endpoint() == null) {
            this.endpoint_$eq(endpointRef);
            return;
        }
    }

    public String readableAddress() {
        return new StringBuilder(50).append("Host:").append(this.host()).append(":RpcPort:").append(this.rpcPort()).append(":PushPort:").append(this.pushPort()).append(":").append("FetchPort:").append(this.fetchPort()).append(":ReplicatePort:").append(this.replicatePort()).append((Object)(this.internalPort() > 0 ? new StringBuilder(14).append(":InternalPort:").append(this.internalPort()).toString() : "")).toString();
    }

    private String toUniqueId$lzycompute() {
        WorkerInfo workerInfo = this;
        synchronized (workerInfo) {
            if (!this.bitmap$0) {
                this.toUniqueId = new StringBuilder(4).append(this.host()).append(":").append(this.rpcPort()).append(":").append(this.pushPort()).append(":").append(this.fetchPort()).append(":").append(this.replicatePort()).toString();
                this.bitmap$0 = true;
            }
        }
        return this.toUniqueId;
    }

    public String toUniqueId() {
        if (!this.bitmap$0) {
            return this.toUniqueId$lzycompute();
        }
        return this.toUniqueId;
    }

    public synchronized boolean slotAvailable() {
        return ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)WorkerInfo.$anonfun$slotAvailable$1(x0$1)));
    }

    public synchronized long getTotalSlots() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$getTotalSlots$1(x$3)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public WorkerStatus getWorkerStatus() {
        return this.workerStatus();
    }

    public void setWorkerStatus(WorkerStatus workerStatus) {
        this.workerStatus_$eq(workerStatus);
    }

    public synchronized void updateDiskSlots(long estimatedPartitionSize) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            WorkerInfo.$anonfun$updateDiskSlots$1(estimatedPartitionSize, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized long totalAvailableSlots() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$totalAvailableSlots$1(x$4)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public synchronized long totalSpace() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$totalSpace$1(x$5)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public synchronized long totalActualUsableSpace() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$totalActualUsableSpace$1(x$6)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public synchronized Map<String, DiskInfo> updateThenGetDiskInfos(Map<String, DiskInfo> newDiskInfos, Option<Object> estimatedPartitionSize) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(newDiskInfos.values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)newDisk -> {
            String mountPoint;
            block8: {
                mountPoint = newDisk.mountPoint();
                DiskInfo curDisk = this.diskInfos().get(mountPoint);
                if (curDisk != null) {
                    curDisk.actualUsableSpace_$eq(newDisk.actualUsableSpace());
                    curDisk.totalSpace_$eq(newDisk.totalSpace());
                    curDisk.activeSlots_$eq(newDisk.activeSlots());
                    curDisk.avgFlushTime_$eq(newDisk.avgFlushTime());
                    curDisk.avgFetchTime_$eq(newDisk.avgFetchTime());
                    if (estimatedPartitionSize.nonEmpty()) {
                        StorageInfo.Type type = curDisk.storageType();
                        StorageInfo.Type type2 = StorageInfo.Type.HDFS;
                        if (type == null ? type2 != null : !((Object)((Object)type)).equals((Object)type2)) {
                            StorageInfo.Type type3 = curDisk.storageType();
                            StorageInfo.Type type4 = StorageInfo.Type.S3;
                            if (type3 == null ? type4 != null : !((Object)((Object)type3)).equals((Object)type4)) {
                                StorageInfo.Type type5 = curDisk.storageType();
                                StorageInfo.Type type6 = StorageInfo.Type.OSS;
                                if (type5 == null ? type6 != null : !((Object)((Object)type5)).equals((Object)type6)) {
                                    curDisk.maxSlots_$eq(curDisk.totalSpace() / BoxesRunTime.unboxToLong((Object)estimatedPartitionSize.get()));
                                    curDisk.availableSlots_$eq(curDisk.actualUsableSpace() / BoxesRunTime.unboxToLong((Object)estimatedPartitionSize.get()));
                                }
                            }
                        }
                    }
                    return curDisk.setStatus(newDisk.status());
                }
                if (!estimatedPartitionSize.nonEmpty()) break block8;
                StorageInfo.Type type = newDisk.storageType();
                StorageInfo.Type type7 = StorageInfo.Type.HDFS;
                if (type == null ? type7 != null : !((Object)((Object)type)).equals((Object)type7)) {
                    StorageInfo.Type type8 = newDisk.storageType();
                    StorageInfo.Type type9 = StorageInfo.Type.S3;
                    if (type8 == null ? type9 != null : !((Object)((Object)type8)).equals((Object)type9)) {
                        StorageInfo.Type type10 = newDisk.storageType();
                        StorageInfo.Type type11 = StorageInfo.Type.OSS;
                        if (type10 == null ? type11 != null : !((Object)((Object)type10)).equals((Object)type11)) {
                            newDisk.maxSlots_$eq(newDisk.totalSpace() / BoxesRunTime.unboxToLong((Object)estimatedPartitionSize.get()));
                            newDisk.availableSlots_$eq(newDisk.actualUsableSpace() / BoxesRunTime.unboxToLong((Object)estimatedPartitionSize.get()));
                        }
                    }
                }
            }
            return this.diskInfos().put(mountPoint, (DiskInfo)newDisk);
        });
        HashSet nonExistsMountPoints = new HashSet();
        nonExistsMountPoints.addAll(this.diskInfos().keySet());
        nonExistsMountPoints.removeAll(newDiskInfos.keySet());
        if (!nonExistsMountPoints.isEmpty()) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(nonExistsMountPoints).asScala()).foreach((Function1 & Serializable & scala.Serializable)nonExistsMountPoint -> this.diskInfos().remove(nonExistsMountPoint));
        }
        this.workerHasDisk().set(this.computeWorkerHaveDisk());
        return JavaUtils.newConcurrentHashMap(this.diskInfos());
    }

    public Option<Object> updateThenGetDiskInfos$default$2() {
        return None$.MODULE$;
    }

    public Map<UserIdentifier, ResourceConsumption> updateThenGetUserResourceConsumption(Map<UserIdentifier, ResourceConsumption> resourceConsumptions) {
        ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(this.userResourceConsumption().keys()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)resourceConsumptions.containsKey(x$1))).foreach((Function1 & Serializable & scala.Serializable)identifier -> this.userResourceConsumption().put((UserIdentifier)identifier, new ResourceConsumption(0L, 0L, 0L, 0L, ResourceConsumption$.MODULE$.apply$default$5())));
        this.userResourceConsumption().putAll(resourceConsumptions);
        return this.userResourceConsumption();
    }

    public String toString() {
        Tuple2 tuple2;
        Tuple2 tuple22;
        if (this.diskInfos() == null || this.diskInfos().isEmpty()) {
            tuple22 = new Tuple2((Object)"empty", (Object)BoxesRunTime.boxToInteger((int)0));
        } else if (this.diskInfos() != null) {
            String str = ((TraversableOnce)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).zipWithIndex(scala.collection.Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    DiskInfo diskInfo = (DiskInfo)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    return new StringBuilder(13).append("\n  DiskInfo").append(index).append(": ").append(diskInfo).toString();
                }
                throw new MatchError((Object)tuple2);
            }, scala.collection.Iterable$.MODULE$.canBuildFrom())).mkString("");
            tuple22 = new Tuple2((Object)str, (Object)BoxesRunTime.boxToLong((long)this.usedSlots()));
        } else {
            tuple22 = tuple2 = BoxedUnit.UNIT;
        }
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2 tuple23 = tuple2;
        Object diskInfosString = tuple23._1();
        Object slots = tuple23._2();
        Tuple2 tuple24 = new Tuple2(diskInfosString, slots);
        Object diskInfosString2 = tuple24._1();
        Object slots2 = tuple24._2();
        String userResourceConsumptionString = this.userResourceConsumption() == null || this.userResourceConsumption().isEmpty() ? "empty" : (this.userResourceConsumption() != null ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.userResourceConsumption()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                UserIdentifier userIdentifier = (UserIdentifier)tuple2._1();
                ResourceConsumption resourceConsumption = (ResourceConsumption)tuple2._2();
                return new StringBuilder(42).append("\n  UserIdentifier: ").append(userIdentifier).append(", ResourceConsumption: ").append(resourceConsumption).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).mkString("") : BoxedUnit.UNIT);
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(325).append("\n       |Host: ").append(this.host()).append("\n       |RpcPort: ").append(this.rpcPort()).append("\n       |PushPort: ").append(this.pushPort()).append("\n       |FetchPort: ").append(this.fetchPort()).append("\n       |ReplicatePort: ").append(this.replicatePort()).append("\n       |InternalPort: ").append(this.internalPort()).append("\n       |SlotsUsed: ").append(slots2).append("\n       |LastHeartbeat: ").append(this.lastHeartbeat()).append("\n       |HeartbeatElapsedSeconds: ").append(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.lastHeartbeat())).append("\n       |Disks: ").append(diskInfosString2).append("\n       |UserResourceConsumption: ").append((Object)userResourceConsumptionString).append("\n       |WorkerRef: ").append(this.endpoint()).append("\n       |WorkerStatus: ").append(this.workerStatus()).append("\n       |NetworkLocation: ").append(this.networkLocation()).append("\n       |").toString())).stripMargin();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof WorkerInfo)) return false;
        WorkerInfo workerInfo = (WorkerInfo)object;
        String string = this.host();
        String string2 = workerInfo.host();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.rpcPort() != workerInfo.rpcPort()) return false;
        if (this.pushPort() != workerInfo.pushPort()) return false;
        if (this.fetchPort() != workerInfo.fetchPort()) return false;
        if (this.replicatePort() != workerInfo.replicatePort()) return false;
        return true;
    }

    public int hashCode() {
        int result = this.host().hashCode();
        result = 31 * result + Integer.hashCode(this.rpcPort());
        result = 31 * result + Integer.hashCode(this.pushPort());
        result = 31 * result + Integer.hashCode(this.fetchPort());
        result = 31 * result + Integer.hashCode(this.replicatePort());
        return result;
    }

    private boolean computeWorkerHaveDisk() {
        if (this.diskInfos() != null) {
            return ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)WorkerInfo.$anonfun$computeWorkerHaveDisk$1(p)));
        }
        return false;
    }

    public boolean haveDisk() {
        return this.workerHasDisk().get();
    }

    public static final /* synthetic */ long $anonfun$usedSlots$1(Tuple2 x$1) {
        return ((DiskInfo)x$1._2()).activeSlots();
    }

    public static final /* synthetic */ void $anonfun$allocateSlots$2(WorkerInfo $this, String shuffleKey$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String disk = (String)tuple2._1();
            Integer slots = (Integer)tuple2._2();
            DiskInfo diskInfo = $this.diskInfos().get(disk);
            if (diskInfo == null) {
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Unknown disk ").append(disk).append(" when allocateSlots").toString());
                return;
            }
            diskInfo.allocateSlots(shuffleKey$1, Predef$.MODULE$.Integer2int(slots));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$releaseSlots$1(WorkerInfo $this, String shuffleKey$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String disk = (String)tuple2._1();
            Integer slot = (Integer)tuple2._2();
            if ($this.diskInfos().containsKey(disk)) {
                $this.diskInfos().get(disk).releaseSlots(shuffleKey$2, Predef$.MODULE$.Integer2int(slot));
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$releaseSlots$2(String shuffleKey$3, Tuple2 x$2) {
        ((DiskInfo)x$2._2()).releaseSlots(shuffleKey$3);
    }

    public static final /* synthetic */ boolean $anonfun$slotAvailable$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            DiskInfo disk = (DiskInfo)tuple2._2();
            return disk.availableSlots() > 0L;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$getTotalSlots$1(Tuple2 x$3) {
        return ((DiskInfo)x$3._2()).maxSlots();
    }

    public static final /* synthetic */ void $anonfun$updateDiskSlots$1(long estimatedPartitionSize$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            DiskInfo disk = (DiskInfo)tuple2._2();
            disk.maxSlots_$eq(disk.totalSpace() / estimatedPartitionSize$1);
            disk.availableSlots_$eq(disk.actualUsableSpace() / estimatedPartitionSize$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$totalAvailableSlots$1(Tuple2 x$4) {
        return ((DiskInfo)x$4._2()).getAvailableSlots();
    }

    public static final /* synthetic */ long $anonfun$totalSpace$1(Tuple2 x$5) {
        return ((DiskInfo)x$5._2()).totalSpace();
    }

    public static final /* synthetic */ long $anonfun$totalActualUsableSpace$1(Tuple2 x$6) {
        return ((DiskInfo)x$6._2()).actualUsableSpace();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$computeWorkerHaveDisk$1(DiskInfo p) {
        StorageInfo.Type type = p.storageType();
        StorageInfo.Type type2 = StorageInfo.Type.SSD;
        if (type == null) {
            if (type2 == null) return true;
        } else if (((Object)((Object)type)).equals((Object)type2)) return true;
        StorageInfo.Type type3 = p.storageType();
        StorageInfo.Type type4 = StorageInfo.Type.HDD;
        if (type3 != null) {
            if (!((Object)((Object)type3)).equals((Object)type4)) return false;
            return true;
        }
        if (type4 == null) return true;
        return false;
    }

    public WorkerInfo(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, int internalPort, Map<String, DiskInfo> _diskInfos, Map<UserIdentifier, ResourceConsumption> _userResourceConsumption) {
        this.host = host;
        this.rpcPort = rpcPort;
        this.pushPort = pushPort;
        this.fetchPort = fetchPort;
        this.replicatePort = replicatePort;
        this.internalPort = internalPort;
        Logging.$init$(this);
        this.networkLocation = "/default-rack";
        this.lastHeartbeat = 0L;
        this.workerStatus = WorkerStatus.normalWorkerStatus();
        this.diskInfos = _diskInfos != null ? JavaUtils.newConcurrentHashMap(_diskInfos) : null;
        this.workerHasDisk = new AtomicBoolean(this.computeWorkerHaveDisk());
        this.userResourceConsumption = _userResourceConsumption != null ? JavaUtils.newConcurrentHashMap(_userResourceConsumption) : null;
        this.endpoint = null;
    }

    public WorkerInfo(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort) {
        this(host, rpcPort, pushPort, fetchPort, replicatePort, -1, new HashMap<String, DiskInfo>(), new HashMap<UserIdentifier, ResourceConsumption>());
    }

    public WorkerInfo(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, int internalPort) {
        this(host, rpcPort, pushPort, fetchPort, replicatePort, internalPort, new HashMap<String, DiskInfo>(), new HashMap<UserIdentifier, ResourceConsumption>());
    }
}

