/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.celeborn.client.ClientUtils$;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.ShuffleClientImpl;
import org.apache.celeborn.client.read.CelebornInputStream;
import org.apache.celeborn.client.read.MetricsCallback;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornBroadcastException;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.exception.CelebornRuntimeException;
import org.apache.celeborn.common.exception.PartitionUnRetryAbleException;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PbOpenStreamList;
import org.apache.celeborn.common.protocol.PbOpenStreamListResponse;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.common.protocol.PbStreamHandlerOpt;
import org.apache.celeborn.common.protocol.message.StatusCode;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.celeborn.shaded.org.apache.commons.lang3.tuple.Pair;
import org.apache.spark.Aggregator;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.TaskContext;
import org.apache.spark.celeborn.ExceptionMakerHelper$;
import org.apache.spark.internal.Logging;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.celeborn.CelebornPartitionUtil;
import org.apache.spark.shuffle.celeborn.CelebornShuffleHandle;
import org.apache.spark.shuffle.celeborn.CelebornShuffleReader$;
import org.apache.spark.shuffle.celeborn.ExecutorShuffleIdTracker;
import org.apache.spark.shuffle.celeborn.SparkCommonUtils;
import org.apache.spark.shuffle.celeborn.SparkUtils;
import org.apache.spark.util.CompletionIterator;
import org.apache.spark.util.CompletionIterator$;
import org.apache.spark.util.collection.ExternalSorter;
import org.apache.spark.util.collection.ExternalSorter$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t=d\u0001B\u0012%\u0001=B\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\t1\u0002\u0011\t\u0011)A\u00053\"AA\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003Z\u0011!q\u0006A!A!\u0002\u0013I\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u0011\u0011\u0004!\u0011!Q\u0001\n\u0015D\u0001\u0002\u001c\u0001\u0003\u0002\u0003\u0006I!\u001c\u0005\ta\u0002\u0011\t\u0011)A\u0005c\"AA\u000f\u0001B\u0001B\u0003%Q\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010\u0003\u0004y\u0001\u0011\u0005\u00111\u0003\u0005\n\u0003c\u0001!\u0019!C\u0005\u0003gA\u0001\"!\u0011\u0001A\u0003%\u0011Q\u0007\u0005\n\u0003\u0007\u0002!\u0019!C\u0001\u0003\u000bB\u0001\"a\u0015\u0001A\u0003%\u0011q\t\u0005\n\u0003[\u0002!\u0019!C\u0005\u0003_B\u0001\"!&\u0001A\u0003%\u0011\u0011\u000f\u0005\n\u0003/\u0003!\u0019!C\u0005\u00033Cq!a'\u0001A\u0003%Q\u000fC\u0005\u0002\u001e\u0002\u0011\r\u0011\"\u0003\u0002 \"9\u0011\u0011\u0015\u0001!\u0002\u0013I\u0006bBAR\u0001\u0011\u0005\u0013Q\u0015\u0005\b\u0003\u000b\u0004A\u0011AAd\u0011\u001d\ty\u000e\u0001C\u0001\u0003CDq!a=\u0001\t\u0003\t)pB\u0004\u0003\u0010\u0011B\tA!\u0005\u0007\r\r\"\u0003\u0012\u0001B\n\u0011\u0019AH\u0004\"\u0001\u0003\u0016!I!q\u0003\u000fA\u0002\u0013\u0005!\u0011\u0004\u0005\n\u0005Ga\u0002\u0019!C\u0001\u0005KA\u0001Ba\u000b\u001dA\u0003&!1\u0004\u0005\n\u0005[a\u0012\u0013!C\u0001\u0005_A\u0011Ba\u0013\u001d#\u0003%\tA!\u0014\u0003+\r+G.\u001a2pe:\u001c\u0006.\u001e4gY\u0016\u0014V-\u00193fe*\u0011QEJ\u0001\tG\u0016dWMY8s]*\u0011q\u0005K\u0001\bg\",hM\u001a7f\u0015\tI#&A\u0003ta\u0006\u00148N\u0003\u0002,Y\u00051\u0011\r]1dQ\u0016T\u0011!L\u0001\u0004_J<7\u0001A\u000b\u0004au:5\u0003\u0002\u00012o%\u0003\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012a!\u00118z%\u00164\u0007\u0003\u0002\u001d:w\u0019k\u0011AJ\u0005\u0003u\u0019\u0012Qb\u00155vM\u001adWMU3bI\u0016\u0014\bC\u0001\u001f>\u0019\u0001!QA\u0010\u0001C\u0002}\u0012\u0011aS\t\u0003\u0001\u000e\u0003\"AM!\n\u0005\t\u001b$a\u0002(pi\"Lgn\u001a\t\u0003e\u0011K!!R\u001a\u0003\u0007\u0005s\u0017\u0010\u0005\u0002=\u000f\u0012)\u0001\n\u0001b\u0001\u007f\t\t1\t\u0005\u0002K\u001b6\t1J\u0003\u0002MQ\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002O\u0017\n9Aj\\4hS:<\u0017A\u00025b]\u0012dW\r\r\u0002R-B)!kU\u001eV\r6\tA%\u0003\u0002UI\t)2)\u001a7fE>\u0014hn\u00155vM\u001adW\rS1oI2,\u0007C\u0001\u001fW\t%9\u0016!!A\u0001\u0002\u000b\u0005qHA\u0002`IE\nab\u001d;beR\u0004\u0016M\u001d;ji&|g\u000e\u0005\u000235&\u00111l\r\u0002\u0004\u0013:$\u0018\u0001D3oIB\u000b'\u000f^5uS>t\u0017!D:uCJ$X*\u00199J]\u0012,\u00070A\u0006f]\u0012l\u0015\r]%oI\u0016D\u0018aB2p]R,\u0007\u0010\u001e\t\u0003C\nl\u0011\u0001K\u0005\u0003G\"\u00121\u0002V1tW\u000e{g\u000e^3yi\u0006!1m\u001c8g!\t1'.D\u0001h\u0015\tA\u0017.\u0001\u0004d_6lwN\u001c\u0006\u0003K)J!a[4\u0003\u0019\r+G.\u001a2pe:\u001cuN\u001c4\u0002\u000f5,GO]5dgB\u0011\u0001H\\\u0005\u0003_\u001a\u0012!d\u00155vM\u001adWMU3bI6+GO]5dgJ+\u0007o\u001c:uKJ\f\u0001c\u001d5vM\u001adW-\u00133Ue\u0006\u001c7.\u001a:\u0011\u0005I\u0013\u0018BA:%\u0005a)\u00050Z2vi>\u00148\u000b[;gM2,\u0017\n\u001a+sC\u000e\\WM]\u0001\u000f]\u0016,G\rR3d_6\u0004(/Z:t!\t\u0011d/\u0003\u0002xg\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u000b{w\u0006\u0005\u00111AA\u0003\u0003\u000f\tI!a\u0003\u0002\u000e\u0005=\u0011\u0011\u0003\t\u0005%\u0002Yd\tC\u0003P\u0017\u0001\u0007A\u0010\r\u0002~\u007fB)!kU\u001e\u007f\rB\u0011Ah \u0003\n/n\f\t\u0011!A\u0003\u0002}BQ\u0001W\u0006A\u0002eCQ\u0001X\u0006A\u0002eCq!X\u0006\u0011\u0002\u0003\u0007\u0011\fC\u0004_\u0017A\u0005\t\u0019A-\t\u000b}[\u0001\u0019\u00011\t\u000b\u0011\\\u0001\u0019A3\t\u000b1\\\u0001\u0019A7\t\u000bA\\\u0001\u0019A9\t\u000bQ\\\u0001\u0019A;\u0015'i\f)\"!\t\u0002$\u0005\u0015\u0012qEA\u0015\u0003W\ti#a\f\t\r=c\u0001\u0019AA\fa\u0011\tI\"!\b\u0011\rI\u001b6(a\u0007G!\ra\u0014Q\u0004\u0003\f\u0003?\t)\"!A\u0001\u0002\u000b\u0005qHA\u0002`IIBQ\u0001\u0017\u0007A\u0002eCQ\u0001\u0018\u0007A\u0002eCQ!\u0018\u0007A\u0002eCQA\u0018\u0007A\u0002eCQa\u0018\u0007A\u0002\u0001DQ\u0001\u001a\u0007A\u0002\u0015DQ\u0001\u001c\u0007A\u00025DQ\u0001\u001d\u0007A\u0002E\f1\u0001Z3q+\t\t)\u0004\r\u0003\u00028\u0005}\u0002cB1\u0002:m\niDR\u0005\u0004\u0003wA#!E*ik\u001a4G.\u001a#fa\u0016tG-\u001a8dsB\u0019A(a\u0010\u0005\u0013]\u000b\u0011\u0011!A\u0001\u0006\u0003y\u0014\u0001\u00023fa\u0002\nQb\u001d5vM\u001adWm\u00117jK:$XCAA$!\u0011\tI%a\u0014\u000e\u0005\u0005-#bAA'S\u000611\r\\5f]RLA!!\u0015\u0002L\ti1\u000b[;gM2,7\t\\5f]R\fab\u001d5vM\u001adWm\u00117jK:$\b\u0005K\u0002\u0011\u0003/\u0002B!!\u0017\u0002j5\u0011\u00111\f\u0006\u0005\u0003;\u0012\t'A\u0006b]:|G/\u0019;j_:\u001c(b\u00015\u0003n)!\u00111MA3\u0003\u00199wn\\4mK*\u0011\u0011qM\u0001\u0004G>l\u0017\u0002BA6\u00037\u0012\u0011CV5tS\ndWMR8s)\u0016\u001cH/\u001b8h\u00031)\u0007pY3qi&|gNU3g+\t\t\t\b\u0005\u0004\u0002t\u0005\u0015\u0015\u0011R\u0007\u0003\u0003kRA!a\u001e\u0002z\u00051\u0011\r^8nS\u000eTA!a\u001f\u0002~\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005}\u0014\u0011Q\u0001\u0005kRLGN\u0003\u0002\u0002\u0004\u0006!!.\u0019<b\u0013\u0011\t9)!\u001e\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004B!a#\u0002\u00126\u0011\u0011Q\u0012\u0006\u0005\u0003\u001f\u000b\t)\u0001\u0002j_&!\u00111SAG\u0005-Iu*\u0012=dKB$\u0018n\u001c8\u0002\u001b\u0015D8-\u001a9uS>t'+\u001a4!\u0003E\u0019H/Y4f%\u0016\u0014XO\\#oC\ndW\rZ\u000b\u0002k\u0006\u00112\u000f^1hKJ+'/\u001e8F]\u0006\u0014G.\u001a3!\u0003A)gnY8eK\u0012\fE\u000f^3naRLE-F\u0001Z\u0003E)gnY8eK\u0012\fE\u000f^3naRLE\rI\u0001\u0005e\u0016\fG\r\u0006\u0002\u0002(B1\u0011\u0011VA]\u0003\u007fsA!a+\u00026:!\u0011QVAZ\u001b\t\tyKC\u0002\u00022:\na\u0001\u0010:p_Rt\u0014\"\u0001\u001b\n\u0007\u0005]6'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0016Q\u0018\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011qW\u001a\u0011\u000bI\n\tm\u000f$\n\u0007\u0005\r7G\u0001\u0005Qe>$Wo\u0019;3\u0003M\u001a\u0007.Z2l\u0003:$'+\u001a9peR4U\r^2i\r\u0006LG.\u001e:f\r>\u0014X\u000b\u001d3bi\u00164\u0015\u000e\\3He>,\bOR1jYV\u0014X\r\u0006\u0004\u0002J\u0006=\u00171\u001b\t\u0004e\u0005-\u0017bAAgg\t!QK\\5u\u0011\u0019\t\t\u000e\u0007a\u00013\u0006\t2-\u001a7fE>\u0014hn\u00155vM\u001adW-\u00133\t\u000f\u0005U\u0007\u00041\u0001\u0002X\u0006\u00111-\u001a\t\u0005\u0003S\u000bI.\u0003\u0003\u0002\\\u0006u&!\u0003+ie><\u0018M\u00197fQ\rA\u0012qK\u0001\u0016Q\u0006tG\r\\3GKR\u001c\u0007.\u0012=dKB$\u0018n\u001c8t)%\u0001\u00151]At\u0003W\fy\u000f\u0003\u0004\u0002ff\u0001\r!W\u0001\rCB\u00048\u000b[;gM2,\u0017\n\u001a\u0005\u0007\u0003SL\u0002\u0019A-\u0002\u0013MDWO\u001a4mK&#\u0007BBAw3\u0001\u0007\u0011,A\u0006qCJ$\u0018\u000e^5p]&#\u0007bBAk3\u0001\u0007\u0011q\u001b\u0015\u00043\u0005]\u0013!\u00068foN+'/[1mSj,'/\u00138ti\u0006t7-\u001a\u000b\u0005\u0003o\u0014\u0019\u0001\u0005\u0003\u0002z\u0006}XBAA~\u0015\r\ti\u0010K\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018\u0002\u0002B\u0001\u0003w\u0014!cU3sS\u0006d\u0017N_3s\u0013:\u001cH/\u00198dK\"9\u0011\u0011\u0007\u000eA\u0002\t\u0015\u0001\u0007\u0002B\u0004\u0005\u0017\u0001r!YA\u001dw\t%a\tE\u0002=\u0005\u0017!1B!\u0004\u0003\u0004\u0005\u0005\t\u0011!B\u0001\u007f\t\u0019q\f\n\u001b\u0002+\r+G.\u001a2pe:\u001c\u0006.\u001e4gY\u0016\u0014V-\u00193feB\u0011!\u000bH\n\u00039E\"\"A!\u0005\u0002#M$(/Z1n\u0007J,\u0017\r^8s!>|G.\u0006\u0002\u0003\u001cA!!Q\u0004B\u0010\u001b\t\tI(\u0003\u0003\u0003\"\u0005e$A\u0005+ie\u0016\fG\rU8pY\u0016CXmY;u_J\fQc\u001d;sK\u0006l7I]3bi>\u0014\bk\\8m?\u0012*\u0017\u000f\u0006\u0003\u0002J\n\u001d\u0002\"\u0003B\u0015?\u0005\u0005\t\u0019\u0001B\u000e\u0003\rAH%M\u0001\u0013gR\u0014X-Y7De\u0016\fGo\u001c:Q_>d\u0007%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0007\u0005c\u00119E!\u0013\u0016\u0005\tM\"fA-\u00036-\u0012!q\u0007\t\u0005\u0005s\u0011\u0019%\u0004\u0002\u0003<)!!Q\bB \u0003%)hn\u00195fG.,GMC\u0002\u0003BM\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Ea\u000f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0003?C\t\u0007q\bB\u0003IC\t\u0007q(A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0007\u0005c\u0011yE!\u0015\u0005\u000by\u0012#\u0019A \u0005\u000b!\u0013#\u0019A \u000b\u00035R1a\u000bB*\u0015\r)#QK\u0001\u0007g\"\fG-\u001a3\u000b\t\te#q\u000b\u0006\u0005\u0003O\u0012YF\u0003\u0003\u0002d\tu#b\u00015\u0003`)\tQFC\u0002,\u0005GR1!\nB3\u0015\u0011\u0011IFa\u001a\u000b\t\u0005\u001d$\u0011\u000e\u0006\u0005\u0003G\u0012Y\u0007")
public class CelebornShuffleReader<K, C>
implements ShuffleReader<K, C>,
Logging {
    private final CelebornShuffleHandle<K, ?, C> handle;
    private final int startPartition;
    private final int endPartition;
    private final int startMapIndex;
    private final int endMapIndex;
    private final TaskContext context;
    private final CelebornConf conf;
    public final ShuffleReadMetricsReporter org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics;
    private final ExecutorShuffleIdTracker shuffleIdTracker;
    private final boolean needDecompress;
    private final ShuffleDependency<K, ?, C> dep;
    @VisibleForTesting
    private final ShuffleClient shuffleClient;
    private final AtomicReference<IOException> exceptionRef;
    private final boolean stageRerunEnabled;
    private final int encodedAttemptId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <K, C> int $lessinit$greater$default$5() {
        return CelebornShuffleReader$.MODULE$.$lessinit$greater$default$5();
    }

    public static <K, C> int $lessinit$greater$default$4() {
        return CelebornShuffleReader$.MODULE$.$lessinit$greater$default$4();
    }

    public static void streamCreatorPool_$eq(ThreadPoolExecutor threadPoolExecutor) {
        CelebornShuffleReader$.MODULE$.streamCreatorPool_$eq(threadPoolExecutor);
    }

    public static ThreadPoolExecutor streamCreatorPool() {
        return CelebornShuffleReader$.MODULE$.streamCreatorPool();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ShuffleDependency<K, ?, C> dep() {
        return this.dep;
    }

    public ShuffleClient shuffleClient() {
        return this.shuffleClient;
    }

    private AtomicReference<IOException> exceptionRef() {
        return this.exceptionRef;
    }

    private boolean stageRerunEnabled() {
        return this.stageRerunEnabled;
    }

    private int encodedAttemptId() {
        return this.encodedAttemptId;
    }

    public Iterator<Product2<K, C>> read() {
        InterruptibleIterator resultIter;
        InterruptibleIterator interruptibleIterator;
        int n;
        long startTime = System.currentTimeMillis();
        SerializerInstance serializerInstance = this.newSerializerInstance(this.dep());
        try {
            n = SparkUtils.celebornShuffleId(this.shuffleClient(), this.handle, this.context, Predef$.MODULE$.boolean2Boolean(false));
        }
        catch (CelebornRuntimeException e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to get shuffleId for appShuffleId ").append($this.handle.shuffleId()).toString(), e);
            if (this.stageRerunEnabled()) {
                throw new FetchFailedException(null, this.handle.shuffleId(), -1L, -1, this.startPartition, new StringBuilder(47).append("Celeborn FetchFailure appShuffleId/shuffleId: ").append(this.handle.shuffleId()).append("/").append(this.handle.shuffleId()).toString(), (Throwable)e);
            }
            throw e;
        }
        int shuffleId = n;
        this.shuffleIdTracker.track(this.handle.shuffleId(), shuffleId);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("get shuffleId ").append(shuffleId).append(" for appShuffleId ").append($this.handle.shuffleId()).append(" attemptNum ").append($this.context.stageAttemptNumber()).toString());
        MetricsCallback metricsCallback = new MetricsCallback(this){
            private final /* synthetic */ CelebornShuffleReader $outer;

            public void incDuplicateBytesRead(long x$1) {
                MetricsCallback.super.incDuplicateBytesRead(x$1);
            }

            public void incBytesRead(long bytesWritten) {
                this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics.incRemoteBytesRead(bytesWritten);
                this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics.incRemoteBlocksFetched(1L);
            }

            public void incReadTime(long time) {
                this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics.incFetchWaitTime(time);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        if (CelebornShuffleReader$.MODULE$.streamCreatorPool() == null) {
            CelebornShuffleReader$ celebornShuffleReader$ = CelebornShuffleReader$.MODULE$;
            synchronized (celebornShuffleReader$) {
                if (CelebornShuffleReader$.MODULE$.streamCreatorPool() == null) {
                    CelebornShuffleReader$.MODULE$.streamCreatorPool_$eq(ThreadUtils$.MODULE$.newDaemonCachedThreadPool("celeborn-create-stream-thread", this.conf.readStreamCreatorPoolThreads(), 60));
                }
            }
        }
        long fetchTimeoutMs = this.conf.clientFetchTimeoutMs();
        boolean localFetchEnabled = this.conf.enableReadLocalShuffleFile();
        String localHostAddress = Utils$.MODULE$.localHostName(this.conf);
        String shuffleKey = Utils$.MODULE$.makeShuffleKey(this.handle.appUniqueId(), shuffleId);
        ObjectRef fileGroups = ObjectRef.create(null);
        boolean isShuffleStageEnd = false;
        IntRef updateFileGroupsRetryTimes = IntRef.create((int)0);
        do {
            isShuffleStageEnd = this.liftedTree1$1(shuffleId);
            try {
                fileGroups.elem = this.shuffleClient().updateFileGroup(shuffleId, this.startPartition);
            }
            catch (Throwable throwable) {
                CelebornIOException celebornIOException;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof CelebornIOException && (celebornIOException = (CelebornIOException)throwable2).getCause() != null && celebornIOException.getCause() instanceof TimeoutException && !isShuffleStageEnd) {
                    ++updateFileGroupsRetryTimes.elem;
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("UpdateFileGroup for ").append(shuffleKey).append(" timeout due to shuffle stage not ended,").append(" retry again, retry times ").append(updateFileGroupsRetryTimes$1.elem).toString(), celebornIOException);
                    continue;
                }
                if (throwable2 instanceof CelebornIOException ? true : throwable2 instanceof PartitionUnRetryAbleException) {
                    this.checkAndReportFetchFailureForUpdateFileGroupFailure(shuffleId, throwable2);
                    continue;
                }
                throw throwable;
            }
        } while ((ShuffleClientImpl.ReduceFileGroups)fileGroups.elem == null);
        long batchOpenStreamStartTime = System.currentTimeMillis();
        HashMap workerRequestMap = new HashMap();
        HashMap partitionId2ChunkRange = new HashMap();
        HashMap partitionId2PartitionLocations = new HashMap();
        IntRef partCnt = IntRef.create((int)0);
        boolean splitSkewPartitionWithoutMapRange = ClientUtils$.MODULE$.readSkewPartitionWithoutMapRange(this.conf, this.startMapIndex, this.endMapIndex);
        List partitionIdList = (List)((TraversableLike)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)this.startPartition), (Object)BoxesRunTime.boxToInteger((int)this.endPartition), (Integral)Numeric.IntIsIntegral$.MODULE$)).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)p -> ((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).partitionGroups.containsKey(BoxesRunTime.boxToInteger((int)p)));
        partitionIdList.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
            if (((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).partitionGroups.containsKey(BoxesRunTime.boxToInteger((int)partitionId))) {
                Object object;
                Set locations = ((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).partitionGroups.get(BoxesRunTime.boxToInteger((int)partitionId));
                if (splitSkewPartitionWithoutMapRange) {
                    Map<String, Pair<Integer, Integer>> partitionLocation2ChunkRange = CelebornPartitionUtil.splitSkewedPartitionLocations(new ArrayList<PartitionLocation>(locations), $this.startMapIndex, $this.endMapIndex);
                    partitionId2ChunkRange.put(BoxesRunTime.boxToInteger((int)partitionId), partitionLocation2ChunkRange);
                    scala.collection.mutable.Set filterLocations = (scala.collection.mutable.Set)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(locations).asScala()).filter((Function1 & Serializable & scala.Serializable)location -> BoxesRunTime.boxToBoolean((boolean)CelebornShuffleReader.$anonfun$read$10(partitionLocation2ChunkRange, location)));
                    locations = (Set)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(filterLocations).asJava();
                    object = partitionId2PartitionLocations.put(BoxesRunTime.boxToInteger((int)partitionId), locations);
                } else {
                    object = BoxedUnit.UNIT;
                }
                this.makeOpenStreamList$1(locations, partCnt, workerRequestMap, shuffleKey, localFetchEnabled, localHostAddress);
                return;
            }
        });
        ConcurrentHashMap locationStreamHandlerMap = JavaUtils.newConcurrentHashMap();
        List futures = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(workerRequestMap.values()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> CelebornShuffleReader$.MODULE$.streamCreatorPool().submit(new Runnable(null, (Tuple3)entry, fetchTimeoutMs, locationStreamHandlerMap){
            private final Tuple3 entry$1;
            private final long fetchTimeoutMs$1;
            private final ConcurrentHashMap locationStreamHandlerMap$1;

            public void run() {
                PbOpenStreamListResponse pbOpenStreamListResponse;
                PbOpenStreamListResponse pbOpenStreamListResponse2;
                Tuple3 tuple3 = this.entry$1;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                TransportClient client = (TransportClient)tuple3._1();
                ArrayList locArr = (ArrayList)tuple3._2();
                PbOpenStreamList.Builder pbOpenStreamListBuilder = (PbOpenStreamList.Builder)tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)client, (Object)locArr, (Object)pbOpenStreamListBuilder);
                TransportClient client2 = (TransportClient)tuple32._1();
                ArrayList locArr2 = (ArrayList)tuple32._2();
                PbOpenStreamList.Builder pbOpenStreamListBuilder2 = (PbOpenStreamList.Builder)tuple32._3();
                TransportMessage msg = new TransportMessage(MessageType.BATCH_OPEN_STREAM, pbOpenStreamListBuilder2.build().toByteArray());
                try {
                    ByteBuffer response = client2.sendRpcSync(msg.toByteBuffer(), this.fetchTimeoutMs$1);
                    pbOpenStreamListResponse2 = (PbOpenStreamListResponse)TransportMessage.fromByteBuffer(response).getParsedPayload();
                }
                catch (Exception exception) {
                    pbOpenStreamListResponse2 = pbOpenStreamListResponse = null;
                }
                if (pbOpenStreamListResponse != null) {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), locArr2.size()).foreach((Function1 & Serializable & scala.Serializable)idx -> $anon$2.$anonfun$run$1(this, pbOpenStreamListResponse, locArr2, BoxesRunTime.unboxToInt((Object)idx)));
                    return;
                }
            }

            public static final /* synthetic */ Object $anonfun$run$1($anon$2 $this, PbOpenStreamListResponse pbOpenStreamListResponse$1, ArrayList locArr$1, int idx) {
                PbStreamHandlerOpt streamHandlerOpt = pbOpenStreamListResponse$1.getStreamHandlerOptList().get(idx);
                if (streamHandlerOpt.getStatus() == StatusCode.SUCCESS.getValue()) {
                    return $this.locationStreamHandlerMap$1.put(locArr$1.get(idx), streamHandlerOpt.getStreamHandler());
                }
                return BoxedUnit.UNIT;
            }
            {
                this.entry$1 = entry$1;
                this.fetchTimeoutMs$1 = fetchTimeoutMs$1;
                this.locationStreamHandlerMap$1 = locationStreamHandlerMap$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.spark.shuffle.celeborn.CelebornShuffleReader$$anon$2 org.apache.celeborn.common.protocol.PbOpenStreamListResponse java.util.ArrayList java.lang.Object )}, serializedLambda);
            }
        }), Iterable$.MODULE$.canBuildFrom())).toList();
        futures.foreach((Function1 & Serializable & scala.Serializable)f -> f.get());
        long end = System.currentTimeMillis();
        metricsCallback.incReadTime(end - startTime);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("BatchOpenStream for ").append(partCnt$1.elem).append(" cost ").append(end - batchOpenStreamStartTime).append("ms").toString());
        ConcurrentHashMap streams = JavaUtils.newConcurrentHashMap();
        int inputStreamCreationWindow = this.conf.clientInputStreamCreationWindow();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Math.min(inputStreamCreationWindow, partitionIdList.size())).foreach((Function1 & Serializable & scala.Serializable)listIndex -> CelebornShuffleReader.$anonfun$read$17(this, partitionIdList, splitSkewPartitionWithoutMapRange, partitionId2PartitionLocations, fileGroups, locationStreamHandlerMap, shuffleId, partitionId2ChunkRange, metricsCallback, streams, BoxesRunTime.unboxToInt((Object)listIndex)));
        IntRef curIndex = IntRef.create((int)0);
        Iterator recordIter = partitionIdList.iterator().map((Function1 & Serializable & scala.Serializable)partitionId -> CelebornShuffleReader.$anonfun$read$18(this, streams, shuffleId, metricsCallback, curIndex, inputStreamCreationWindow, partitionIdList, splitSkewPartitionWithoutMapRange, partitionId2PartitionLocations, fileGroups, locationStreamHandlerMap, partitionId2ChunkRange, BoxesRunTime.unboxToInt((Object)partitionId))).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CelebornShuffleReader.$anonfun$read$22(x0$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int partitionId = tuple2._1$mcI$sp();
                CelebornInputStream inputStream = (CelebornInputStream)tuple2._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)serializerInstance.deserializeStream((InputStream)inputStream).asKeyValueIterator());
            }
            throw new MatchError((Object)tuple2);
        }).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                Iterator iterator;
                int partitionId = tuple2._1$mcI$sp();
                Iterator iter = (Iterator)tuple2._2();
                try {
                    iterator = iter;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof CelebornIOException ? true : throwable2 instanceof PartitionUnRetryAbleException) {
                        throw this.handleFetchExceptions($this.handle.shuffleId(), shuffleId, partitionId, throwable2);
                    }
                    throw throwable;
                }
                return iterator;
            }
            throw new MatchError((Object)tuple2);
        });
        Iterator iterWithUpdatedRecordsRead = recordIter.map((Function1 & Serializable & scala.Serializable)record -> {
            $this.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics.incRecordsRead(1L);
            return record;
        });
        CompletionIterator metricIter = CompletionIterator$.MODULE$.apply(iterWithUpdatedRecordsRead, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.context.taskMetrics().mergeShuffleReadMetrics());
        InterruptibleIterator interruptibleIter = new InterruptibleIterator(this.context, (Iterator)metricIter);
        if (this.dep().keyOrdering().isDefined()) {
            ExternalSorter externalSorter;
            if (this.dep().aggregator().isDefined()) {
                if (this.dep().mapSideCombine()) {
                    TaskContext x$1 = this.context;
                    Option x$2 = Option$.MODULE$.apply((Object)new Aggregator((Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x), ((Aggregator)this.dep().aggregator().get()).mergeCombiners(), ((Aggregator)this.dep().aggregator().get()).mergeCombiners()));
                    Some x$32 = new Some(this.dep().keyOrdering().get());
                    Serializer x$4 = this.dep().serializer();
                    Option x$5 = ExternalSorter$.MODULE$.$lessinit$greater$default$3();
                    externalSorter = new ExternalSorter(x$1, x$2, x$5, (Option)x$32, x$4);
                } else {
                    TaskContext x$6 = this.context;
                    Option x$7 = this.dep().aggregator();
                    Some x$8 = new Some(this.dep().keyOrdering().get());
                    Serializer x$9 = this.dep().serializer();
                    Option x$10 = ExternalSorter$.MODULE$.$lessinit$greater$default$3();
                    externalSorter = new ExternalSorter(x$6, x$7, x$10, (Option)x$8, x$9);
                }
            } else {
                TaskContext x$11 = this.context;
                Some x$12 = new Some(this.dep().keyOrdering().get());
                Serializer x$13 = this.dep().serializer();
                None$ x$14 = ExternalSorter$.MODULE$.$lessinit$greater$default$2();
                Option x$15 = ExternalSorter$.MODULE$.$lessinit$greater$default$3();
                externalSorter = new ExternalSorter(x$11, (Option)x$14, x$15, (Option)x$12, x$13);
            }
            ExternalSorter sorter = externalSorter;
            sorter.insertAll((Iterator)interruptibleIter);
            this.context.taskMetrics().incMemoryBytesSpilled(sorter.memoryBytesSpilled());
            this.context.taskMetrics().incDiskBytesSpilled(sorter.diskBytesSpilled());
            this.context.taskMetrics().incPeakExecutionMemory(sorter.peakMemoryUsedBytes());
            this.context.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$3 -> {
                sorter.stop();
                return BoxedUnit.UNIT;
            });
            interruptibleIterator = CompletionIterator$.MODULE$.apply(sorter.iterator(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> sorter.stop());
        } else if (this.dep().aggregator().isDefined()) {
            if (this.dep().mapSideCombine()) {
                InterruptibleIterator combinedKeyValuesIterator = interruptibleIter;
                interruptibleIterator = ((Aggregator)this.dep().aggregator().get()).combineCombinersByKey((Iterator)combinedKeyValuesIterator, this.context);
            } else {
                InterruptibleIterator keyValuesIterator = interruptibleIter;
                interruptibleIterator = ((Aggregator)this.dep().aggregator().get()).combineValuesByKey((Iterator)keyValuesIterator, this.context);
            }
        } else {
            interruptibleIterator = interruptibleIter;
        }
        InterruptibleIterator interruptibleIterator2 = resultIter = interruptibleIterator;
        if (interruptibleIterator2 instanceof InterruptibleIterator) {
            return resultIter;
        }
        return new InterruptibleIterator(this.context, (Iterator)resultIter);
    }

    @VisibleForTesting
    public void checkAndReportFetchFailureForUpdateFileGroupFailure(int celebornShuffleId, Throwable ce) {
        if (ce.getCause() != null && (ce.getCause() instanceof InterruptedException || ce.getCause() instanceof TimeoutException || ce.getCause() instanceof CelebornBroadcastException)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("fetch shuffle ").append(celebornShuffleId).append(" timeout or interrupt or GetReducerFileGroupResponse failed via broadcast").toString(), ce);
            throw ce;
        }
        throw this.handleFetchExceptions(this.handle.shuffleId(), celebornShuffleId, 0, ce);
    }

    @VisibleForTesting
    public Nothing$ handleFetchExceptions(int appShuffleId, int shuffleId, int partitionId, Throwable ce) {
        if (this.stageRerunEnabled() && this.shuffleClient().reportShuffleFetchFailure(appShuffleId, shuffleId, this.context.taskAttemptId())) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Handle fetch exceptions for ").append(shuffleId).append("-").append(partitionId).toString(), ce);
            throw new FetchFailedException(null, appShuffleId, -1L, -1, partitionId, new StringBuilder(47).append("Celeborn FetchFailure appShuffleId/shuffleId: ").append(appShuffleId).append("/").append(shuffleId).toString(), ce);
        }
        throw ce;
    }

    public SerializerInstance newSerializerInstance(ShuffleDependency<K, ?, C> dep) {
        return dep.serializer().newInstance();
    }

    private final /* synthetic */ boolean liftedTree1$1(int shuffleId$1) {
        boolean bl;
        try {
            bl = this.shuffleClient().isShuffleStageEnd(shuffleId$1);
        }
        catch (Exception e) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Failed to check shuffle stage end for ").append(shuffleId$1).append(", assume ended").toString(), e);
            bl = true;
        }
        return bl;
    }

    private final void makeOpenStreamList$1(Set locations, IntRef partCnt$1, HashMap workerRequestMap$1, String shuffleKey$1, boolean localFetchEnabled$1, String localHostAddress$1) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(locations).asScala()).foreach((Function1 & Serializable & scala.Serializable)location -> {
            Tuple3 tuple3;
            BoxedUnit boxedUnit;
            ++partCnt$1.elem;
            String hostPort = location.hostAndFetchPort();
            if (!workerRequestMap$1.containsKey(hostPort)) {
                try {
                    TransportClient client = this.shuffleClient().getDataClientFactory().createClient(location.getHost(), location.getFetchPort());
                    PbOpenStreamList.Builder pbOpenStreamList = PbOpenStreamList.newBuilder();
                    pbOpenStreamList.setShuffleKey(shuffleKey$1);
                    boxedUnit = workerRequestMap$1.put(hostPort, new Tuple3((Object)client, new ArrayList(), (Object)pbOpenStreamList));
                }
                catch (Exception ex) {
                    this.shuffleClient().excludeFailedFetchLocation(hostPort, ex);
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Failed to create client for ").append(shuffleKey$1).append("-").append(location.getId()).append(" from host: ").append(hostPort).append(". ").append("Shuffle reader will try its replica if exists.").toString());
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if ((tuple3 = (Tuple3)workerRequestMap$1.get(hostPort)) != null) {
                ArrayList locArr = (ArrayList)tuple3._2();
                PbOpenStreamList.Builder pbOpenStreamListBuilder = (PbOpenStreamList.Builder)tuple3._3();
                locArr.add(location);
                pbOpenStreamListBuilder.addFileName(location.getFileName()).addStartIndex($this.startMapIndex).addEndIndex($this.endMapIndex);
                return pbOpenStreamListBuilder.addReadLocalShuffle(localFetchEnabled$1 && location.getHost().equals(localHostAddress$1));
            }
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Empty client for host ").append(hostPort).toString());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$read$10(Map partitionLocation2ChunkRange$1, PartitionLocation location) {
        return partitionLocation2ChunkRange$1 != null && partitionLocation2ChunkRange$1.containsKey(location.getUniqueId());
    }

    public final void org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$createInputStream$1(int partitionId, boolean splitSkewPartitionWithoutMapRange$1, HashMap partitionId2PartitionLocations$1, ObjectRef fileGroups$1, ConcurrentHashMap locationStreamHandlerMap$1, int shuffleId$1, HashMap partitionId2ChunkRange$1, MetricsCallback metricsCallback$1, ConcurrentHashMap streams$1) {
        ArrayList<PbStreamHandler> streamHandlers;
        ArrayList<PbStreamHandler> arrayList;
        ArrayList<PartitionLocation> locationList;
        Set<PartitionLocation> locations = splitSkewPartitionWithoutMapRange$1 ? (Set<PartitionLocation>)partitionId2PartitionLocations$1.get(BoxesRunTime.boxToInteger((int)partitionId)) : ((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).partitionGroups.get(BoxesRunTime.boxToInteger((int)partitionId));
        ArrayList<PartitionLocation> arrayList2 = locationList = locations == null ? new ArrayList<PartitionLocation>() : new ArrayList<PartitionLocation>(locations);
        if (locations != null) {
            ArrayList<PbStreamHandler> streamHandlerArr = new ArrayList<PbStreamHandler>(locationList.size());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(locationList).asScala()).foreach((Function1 & Serializable & scala.Serializable)loc -> BoxesRunTime.boxToBoolean((boolean)streamHandlerArr.add(locationStreamHandlerMap$1.get(loc))));
            arrayList = streamHandlerArr;
        } else {
            arrayList = streamHandlers = null;
        }
        if (this.exceptionRef().get() == null) {
            try {
                CelebornInputStream inputStream = this.shuffleClient().readPartition(shuffleId$1, this.handle.shuffleId(), partitionId, this.encodedAttemptId(), this.context.taskAttemptId(), this.startMapIndex, this.endMapIndex, this.stageRerunEnabled() ? ExceptionMakerHelper$.MODULE$.SHUFFLE_FETCH_FAILURE_EXCEPTION_MAKER() : null, locationList, streamHandlers, ((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).pushFailedBatches, (Map)partitionId2ChunkRange$1.get(BoxesRunTime.boxToInteger((int)partitionId)), ((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).mapAttempts, metricsCallback$1, this.needDecompress);
                streams$1.put(Predef$.MODULE$.int2Integer(partitionId), inputStream);
            }
            catch (IOException e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Exception caught when readPartition ").append(partitionId).append("!").toString(), e);
                this.exceptionRef().compareAndSet(null, e);
            }
            catch (Throwable e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Non IOException caught when readPartition ").append(partitionId).append("!").toString(), e);
                this.exceptionRef().compareAndSet(null, new CelebornIOException(e));
            }
            return;
        }
    }

    public static final /* synthetic */ Future $anonfun$read$17(CelebornShuffleReader $this, List partitionIdList$1, boolean splitSkewPartitionWithoutMapRange$1, HashMap partitionId2PartitionLocations$1, ObjectRef fileGroups$1, ConcurrentHashMap locationStreamHandlerMap$1, int shuffleId$1, HashMap partitionId2ChunkRange$1, MetricsCallback metricsCallback$1, ConcurrentHashMap streams$1, int listIndex) {
        return CelebornShuffleReader$.MODULE$.streamCreatorPool().submit(new Runnable($this, partitionIdList$1, listIndex, splitSkewPartitionWithoutMapRange$1, partitionId2PartitionLocations$1, fileGroups$1, locationStreamHandlerMap$1, shuffleId$1, partitionId2ChunkRange$1, metricsCallback$1, streams$1){
            private final /* synthetic */ CelebornShuffleReader $outer;
            private final List partitionIdList$1;
            private final int listIndex$1;
            private final boolean splitSkewPartitionWithoutMapRange$1;
            private final HashMap partitionId2PartitionLocations$1;
            private final ObjectRef fileGroups$1;
            private final ConcurrentHashMap locationStreamHandlerMap$1;
            private final int shuffleId$1;
            private final HashMap partitionId2ChunkRange$1;
            private final MetricsCallback metricsCallback$1;
            private final ConcurrentHashMap streams$1;

            public void run() {
                this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$createInputStream$1(BoxesRunTime.unboxToInt((Object)this.partitionIdList$1.apply(this.listIndex$1)), this.splitSkewPartitionWithoutMapRange$1, this.partitionId2PartitionLocations$1, this.fileGroups$1, this.locationStreamHandlerMap$1, this.shuffleId$1, this.partitionId2ChunkRange$1, this.metricsCallback$1, this.streams$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionIdList$1 = partitionIdList$1;
                this.listIndex$1 = listIndex$1;
                this.splitSkewPartitionWithoutMapRange$1 = splitSkewPartitionWithoutMapRange$1;
                this.partitionId2PartitionLocations$1 = partitionId2PartitionLocations$1;
                this.fileGroups$1 = fileGroups$1;
                this.locationStreamHandlerMap$1 = locationStreamHandlerMap$1;
                this.shuffleId$1 = shuffleId$1;
                this.partitionId2ChunkRange$1 = partitionId2ChunkRange$1;
                this.metricsCallback$1 = metricsCallback$1;
                this.streams$1 = streams$1;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$read$21(ObjectRef inputStream$1, TaskContext x$2) {
        ((CelebornInputStream)inputStream$1.elem).close();
    }

    public static final /* synthetic */ Tuple2 $anonfun$read$18(CelebornShuffleReader $this, ConcurrentHashMap streams$1, int shuffleId$1, MetricsCallback metricsCallback$1, IntRef curIndex$1, int inputStreamCreationWindow$1, List partitionIdList$1, boolean splitSkewPartitionWithoutMapRange$1, HashMap partitionId2PartitionLocations$1, ObjectRef fileGroups$1, ConcurrentHashMap locationStreamHandlerMap$1, HashMap partitionId2ChunkRange$1, int partitionId) {
        if ($this.handle.numMappers() > 0) {
            Object object;
            long startFetchWait = System.nanoTime();
            ObjectRef inputStream = ObjectRef.create((Object)((CelebornInputStream)streams$1.get(BoxesRunTime.boxToInteger((int)partitionId))));
            LongRef sleepCnt = LongRef.create((long)0L);
            while ((CelebornInputStream)inputStream.elem == null) {
                if ($this.exceptionRef().get() != null) {
                    IOException iOException = $this.exceptionRef().get();
                    if (iOException instanceof CelebornIOException ? true : iOException instanceof PartitionUnRetryAbleException) {
                        throw $this.handleFetchExceptions($this.handle.shuffleId(), shuffleId$1, partitionId, iOException);
                    }
                    throw iOException;
                }
                if (sleepCnt.elem == 0L) {
                    $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("inputStream for partition: ").append(partitionId).append(" is null, sleeping 5ms").toString());
                }
                ++sleepCnt.elem;
                Thread.sleep(5L);
                inputStream.elem = (CelebornInputStream)streams$1.get(BoxesRunTime.boxToInteger((int)partitionId));
            }
            if (sleepCnt.elem > 0L) {
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("inputStream for partition: ").append(partitionId).append(" is not null, sleep ").append(sleepCnt$1.elem).append(" times for ").append(5L * sleepCnt$1.elem).append(" ms").toString());
            }
            metricsCallback$1.incReadTime(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startFetchWait));
            $this.context.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$2 -> {
                CelebornShuffleReader.$anonfun$read$21(inputStream, x$2);
                return BoxedUnit.UNIT;
            });
            if (curIndex$1.elem + inputStreamCreationWindow$1 < partitionIdList$1.size()) {
                int nextPartitionId = BoxesRunTime.unboxToInt((Object)partitionIdList$1.apply(curIndex$1.elem + inputStreamCreationWindow$1));
                object = CelebornShuffleReader$.MODULE$.streamCreatorPool().submit(new Runnable($this, nextPartitionId, splitSkewPartitionWithoutMapRange$1, partitionId2PartitionLocations$1, fileGroups$1, locationStreamHandlerMap$1, shuffleId$1, partitionId2ChunkRange$1, metricsCallback$1, streams$1){
                    private final /* synthetic */ CelebornShuffleReader $outer;
                    private final int nextPartitionId$1;
                    private final boolean splitSkewPartitionWithoutMapRange$1;
                    private final HashMap partitionId2PartitionLocations$1;
                    private final ObjectRef fileGroups$1;
                    private final ConcurrentHashMap locationStreamHandlerMap$1;
                    private final int shuffleId$1;
                    private final HashMap partitionId2ChunkRange$1;
                    private final MetricsCallback metricsCallback$1;
                    private final ConcurrentHashMap streams$1;

                    public void run() {
                        this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$createInputStream$1(this.nextPartitionId$1, this.splitSkewPartitionWithoutMapRange$1, this.partitionId2PartitionLocations$1, this.fileGroups$1, this.locationStreamHandlerMap$1, this.shuffleId$1, this.partitionId2ChunkRange$1, this.metricsCallback$1, this.streams$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.nextPartitionId$1 = nextPartitionId$1;
                        this.splitSkewPartitionWithoutMapRange$1 = splitSkewPartitionWithoutMapRange$1;
                        this.partitionId2PartitionLocations$1 = partitionId2PartitionLocations$1;
                        this.fileGroups$1 = fileGroups$1;
                        this.locationStreamHandlerMap$1 = locationStreamHandlerMap$1;
                        this.shuffleId$1 = shuffleId$1;
                        this.partitionId2ChunkRange$1 = partitionId2ChunkRange$1;
                        this.metricsCallback$1 = metricsCallback$1;
                        this.streams$1 = streams$1;
                    }
                });
            } else {
                object = BoxedUnit.UNIT;
            }
            ++curIndex$1.elem;
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)((CelebornInputStream)inputStream.elem));
        }
        ++curIndex$1.elem;
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)CelebornInputStream.empty());
    }

    public static final /* synthetic */ boolean $anonfun$read$22(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            CelebornInputStream inputStream;
            CelebornInputStream celebornInputStream = inputStream = (CelebornInputStream)tuple2._2();
            CelebornInputStream celebornInputStream2 = CelebornInputStream.empty();
            return celebornInputStream == null ? celebornInputStream2 != null : !celebornInputStream.equals(celebornInputStream2);
        }
        throw new MatchError((Object)tuple2);
    }

    public CelebornShuffleReader(CelebornShuffleHandle<K, ?, C> handle, int startPartition, int endPartition, int startMapIndex, int endMapIndex, TaskContext context, CelebornConf conf, ShuffleReadMetricsReporter metrics, ExecutorShuffleIdTracker shuffleIdTracker, boolean needDecompress) {
        this.handle = handle;
        this.startPartition = startPartition;
        this.endPartition = endPartition;
        this.startMapIndex = startMapIndex;
        this.endMapIndex = endMapIndex;
        this.context = context;
        this.conf = conf;
        this.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics = metrics;
        this.shuffleIdTracker = shuffleIdTracker;
        this.needDecompress = needDecompress;
        Logging.$init$((Logging)this);
        this.dep = handle.dependency();
        this.shuffleClient = ShuffleClient.get(handle.appUniqueId(), handle.lifecycleManagerHost(), handle.lifecycleManagerPort(), conf, handle.userIdentifier(), handle.extension());
        this.exceptionRef = new AtomicReference();
        this.stageRerunEnabled = handle.stageRerunEnabled();
        this.encodedAttemptId = SparkCommonUtils.getEncodedAttemptNumber(context);
    }

    public CelebornShuffleReader(CelebornShuffleHandle<K, ?, C> handle, int startPartition, int endPartition, int startMapIndex, int endMapIndex, TaskContext context, CelebornConf conf, ShuffleReadMetricsReporter metrics, ExecutorShuffleIdTracker shuffleIdTracker) {
        this(handle, startPartition, endPartition, startMapIndex, endMapIndex, context, conf, metrics, shuffleIdTracker, true);
    }
}

