/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.read.CelebornInputStream;
import org.apache.celeborn.client.read.MetricsCallback;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.reflect.DynConstructors;
import org.apache.celeborn.reflect.DynMethods;
import org.apache.celeborn.util.HadoopUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.ShuffleConsumerPlugin;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.CelebornShuffleFetcher;
import org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import org.apache.hadoop.mapreduce.task.reduce.MergeManager;
import org.apache.hadoop.mapreduce.task.reduce.MergeManagerImpl;
import org.apache.hadoop.mapreduce.task.reduce.Shuffle;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;
import org.apache.hadoop.util.Progress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CelebornShuffleConsumer<K, V>
implements ShuffleConsumerPlugin<K, V>,
ExceptionReporter {
    private static final Logger logger = LoggerFactory.getLogger(CelebornShuffleConsumer.class);
    private JobConf mrJobConf;
    private MergeManager<K, V> merger;
    private Throwable throwable = null;
    private Progress copyPhase;
    private TaskStatus taskStatus;
    private TaskAttemptID reduceId;
    private TaskUmbilicalProtocol umbilical;
    private Reporter reporter;
    private ShuffleClientMetrics metrics;
    private Task reduceTask;
    private ShuffleClient shuffleClient;

    public void init(ShuffleConsumerPlugin.Context<K, V> context) {
        this.reduceId = context.getReduceId();
        this.mrJobConf = context.getJobConf();
        JobConf celebornJobConf = new JobConf("celeborn.xml");
        this.umbilical = context.getUmbilical();
        this.reporter = context.getReporter();
        try {
            this.metrics = this.createMetrics(this.reduceId, this.mrJobConf);
        }
        catch (Exception e) {
            logger.error("Fatal error occurred, failed to get shuffle client metrics.", (Throwable)e);
            this.reportException(e);
        }
        this.copyPhase = context.getCopyPhase();
        this.taskStatus = context.getStatus();
        this.reduceTask = context.getReduceTask();
        String appId = celebornJobConf.get("celeborn.applicationId");
        String lmHost = celebornJobConf.get("celeborn.lifecycleManager.host");
        int lmPort = Integer.parseInt(celebornJobConf.get("celeborn.lifecycleManager.port"));
        logger.info("Reducer initialized with celeborn {} {} {}", new Object[]{appId, lmHost, lmPort});
        CelebornConf celebornConf = HadoopUtils.fromYarnConf(this.mrJobConf);
        this.shuffleClient = ShuffleClient.get(appId, lmHost, lmPort, celebornConf, new UserIdentifier(celebornConf.userSpecificTenant(), celebornConf.userSpecificUserName()));
        this.merger = new MergeManagerImpl(this.reduceId, this.mrJobConf, context.getLocalFS(), context.getLocalDirAllocator(), this.reporter, context.getCodec(), context.getCombinerClass(), context.getCombineCollector(), context.getSpilledRecordsCounter(), context.getReduceCombineInputCounter(), context.getMergedMapOutputsCounter(), (ExceptionReporter)this, context.getMergePhase(), context.getMapOutputFile());
    }

    private ShuffleClientMetrics createMetrics(TaskAttemptID taskAttemptID, JobConf jobConf) throws NoSuchMethodException {
        try {
            return (ShuffleClientMetrics)DynMethods.builder("create").impl(ShuffleClientMetrics.class, TaskAttemptID.class, JobConf.class).buildStaticChecked().invoke(taskAttemptID, jobConf);
        }
        catch (Exception exception) {
            try {
                return (ShuffleClientMetrics)DynMethods.builder("create").impl(ShuffleClientMetrics.class, new Class[0]).buildStaticChecked().invoke(taskAttemptID, jobConf);
            }
            catch (Exception exception2) {
                return (ShuffleClientMetrics)DynConstructors.builder(ShuffleClientMetrics.class).hiddenImpl(new Class[]{TaskAttemptID.class, JobConf.class}).buildChecked().invoke(null, taskAttemptID, jobConf);
            }
        }
    }

    public RawKeyValueIterator run() throws IOException {
        RawKeyValueIterator kvIter;
        logger.info("In reduce:{}, Celeborn mr client start to read shuffle data. Create inputstream with params: shuffleId 0 reduceId:{} attemptId:{}", new Object[]{this.reduceId, this.reduceId.getTaskID().getId(), this.reduceId.getId()});
        MetricsCallback metricsCallback = new MetricsCallback(){

            @Override
            public void incBytesRead(long bytesRead) {
            }

            @Override
            public void incReadTime(long time) {
            }
        };
        CelebornInputStream shuffleInputStream = this.shuffleClient.readPartition(0, this.reduceId.getTaskID().getId(), this.reduceId.getId(), 0L, 0, Integer.MAX_VALUE, metricsCallback);
        CelebornShuffleFetcher<K, V> shuffleReader = new CelebornShuffleFetcher<K, V>(this.reduceId, this.taskStatus, this.merger, this.copyPhase, this.reporter, this.metrics, shuffleInputStream);
        shuffleReader.fetchAndMerge();
        this.copyPhase.complete();
        this.taskStatus.setPhase(TaskStatus.Phase.SORT);
        this.reduceTask.statusUpdate(this.umbilical);
        try {
            kvIter = this.merger.close();
        }
        catch (Throwable e) {
            throw new Shuffle.ShuffleError("Error while doing final merge ", e);
        }
        logger.info("In reduce: {} Celeborn mr client read shuffle data complete", (Object)this.reduceId);
        return kvIter;
    }

    public void close() {
    }

    public void reportException(Throwable throwable) {
        if (this.throwable == null) {
            this.throwable = throwable;
        }
    }
}

