/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.internal.Logging$class;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.network.TransportContext;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientBootstrap;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.sasl.SaslClientBootstrap;
import org.apache.celeborn.common.network.sasl.SaslServerBootstrap;
import org.apache.celeborn.common.network.sasl.registration.RegistrationClientBootstrap;
import org.apache.celeborn.common.network.sasl.registration.RegistrationServerBootstrap;
import org.apache.celeborn.common.network.server.TransportServer;
import org.apache.celeborn.common.network.server.TransportServerBootstrap;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.RpcNameConstants;
import org.apache.celeborn.common.rpc.ClientSaslContext;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.RpcEndpoint;
import org.apache.celeborn.common.rpc.RpcEndpointAddress;
import org.apache.celeborn.common.rpc.RpcEndpointNotFoundException;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.rpc.RpcEnv;
import org.apache.celeborn.common.rpc.RpcEnvConfig;
import org.apache.celeborn.common.rpc.RpcEnvStoppedException;
import org.apache.celeborn.common.rpc.RpcSecurityContext;
import org.apache.celeborn.common.rpc.RpcSource;
import org.apache.celeborn.common.rpc.RpcTimeout;
import org.apache.celeborn.common.rpc.ServerSaslContext;
import org.apache.celeborn.common.rpc.netty.Dispatcher;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.NettyRpcEnv$;
import org.apache.celeborn.common.rpc.netty.NettyRpcHandler;
import org.apache.celeborn.common.rpc.netty.OneWayOutboxMessage;
import org.apache.celeborn.common.rpc.netty.Outbox;
import org.apache.celeborn.common.rpc.netty.OutboxMessage;
import org.apache.celeborn.common.rpc.netty.RequestMessage;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier$;
import org.apache.celeborn.common.rpc.netty.RpcFailure;
import org.apache.celeborn.common.rpc.netty.RpcOutboxMessage;
import org.apache.celeborn.common.serializer.JavaSerializerInstance;
import org.apache.celeborn.common.serializer.SerializationStream;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r\rd\u0001B\u0001\u0003\u0001=\u00111BT3uif\u0014\u0006oY#om*\u00111\u0001B\u0001\u0006]\u0016$H/\u001f\u0006\u0003\u000b\u0019\t1A\u001d9d\u0015\t9\u0001\"\u0001\u0004d_6lwN\u001c\u0006\u0003\u0013)\t\u0001bY3mK\n|'O\u001c\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001B\u0003\u0005\u0002\u0012%5\tA!\u0003\u0002\u0014\t\t1!\u000b]2F]Z\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!!\u0007\f\u0003\u000f1{wmZ5oO\"A1\u0004\u0001BC\u0002\u0013\u0005A$\u0001\u0004d_:4\u0017nZ\u000b\u0002;A\u0011\u0011CH\u0005\u0003?\u0011\u0011AB\u00159d\u000b:48i\u001c8gS\u001eD\u0001\"\t\u0001\u0003\u0002\u0003\u0006I!H\u0001\bG>tg-[4!\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013A\u00066bm\u0006\u001cVM]5bY&TXM]%ogR\fgnY3\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d2\u0011AC:fe&\fG.\u001b>fe&\u0011\u0011F\n\u0002\u0017\u0015\u00064\u0018mU3sS\u0006d\u0017N_3s\u0013:\u001cH/\u00198dK\")1\u0006\u0001C\u0001Y\u00051A(\u001b8jiz\"2!L\u00181!\tq\u0003!D\u0001\u0003\u0011\u0015Y\"\u00061\u0001\u001e\u0011\u0015\u0019#\u00061\u0001%\u0011\u001d\u0011\u0004A1A\u0005\u0002M\nAbY3mK\n|'O\\\"p]\u001a,\u0012\u0001\u000e\t\u0003kYj\u0011AB\u0005\u0003o\u0019\u0011AbQ3mK\n|'O\\\"p]\u001aDa!\u000f\u0001!\u0002\u0013!\u0014!D2fY\u0016\u0014wN\u001d8D_:4\u0007\u0005C\u0004<\u0001\t\u0007I\u0011\u0001\u001f\u0002\u001fM,7-\u001e:jif\u001cuN\u001c;fqR,\u0012!\u0010\t\u0004}\u0005\u001bU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\r=\u0003H/[8o!\t\tB)\u0003\u0002F\t\t\u0011\"\u000b]2TK\u000e,(/\u001b;z\u0007>tG/\u001a=u\u0011\u00199\u0005\u0001)A\u0005{\u0005\u00012/Z2ve&$\u0018pQ8oi\u0016DH\u000f\t\u0005\t\u0013\u0002\u0011\r\u0011\"\u0001\t\u0015\u0006iAO]1ogB|'\u000f^\"p]\u001a,\u0012a\u0013\t\u0003\u0019Fk\u0011!\u0014\u0006\u0003\u001d>\u000bA!\u001e;jY*\u0011\u0001KB\u0001\b]\u0016$xo\u001c:l\u0013\t\u0011VJA\u0007Ue\u0006t7\u000f]8si\u000e{gN\u001a\u0005\u0007)\u0002\u0001\u000b\u0011B&\u0002\u001dQ\u0014\u0018M\\:q_J$8i\u001c8gA!9a\u000b\u0001b\u0001\n\u00139\u0016AC0sa\u000e\u001cv.\u001e:dKV\t\u0001\f\u0005\u0002\u00123&\u0011!\f\u0002\u0002\n%B\u001c7k\\;sG\u0016Da\u0001\u0018\u0001!\u0002\u0013A\u0016aC0sa\u000e\u001cv.\u001e:dK\u0002BqA\u0018\u0001C\u0002\u0013%q,\u0001\u0006eSN\u0004\u0018\r^2iKJ,\u0012\u0001\u0019\t\u0003]\u0005L!A\u0019\u0002\u0003\u0015\u0011K7\u000f]1uG\",'\u000f\u0003\u0004e\u0001\u0001\u0006I\u0001Y\u0001\fI&\u001c\b/\u0019;dQ\u0016\u0014\b\u0005C\u0004g\u0001\u0001\u0007I\u0011B4\u0002\r]|'o[3s+\u0005A\u0007CA\tj\u0013\tQGAA\u0006Sa\u000e,e\u000e\u001a9pS:$\bb\u00027\u0001\u0001\u0004%I!\\\u0001\u000bo>\u00148.\u001a:`I\u0015\fHC\u00018r!\tqt.\u0003\u0002q\u007f\t!QK\\5u\u0011\u001d\u00118.!AA\u0002!\f1\u0001\u001f\u00132\u0011\u0019!\b\u0001)Q\u0005Q\u00069qo\u001c:lKJ\u0004\u0003\u0002\u0003<\u0001\u0005\u0004%\tAA<\u0002!Q\u0014\u0018M\\:q_J$8i\u001c8uKb$X#\u0001=\u0011\u0005eTX\"A(\n\u0005m|%\u0001\u0005+sC:\u001c\bo\u001c:u\u0007>tG/\u001a=u\u0011\u0019i\b\u0001)A\u0005q\u0006\tBO]1ogB|'\u000f^\"p]R,\u0007\u0010\u001e\u0011\t\r}\u0004A\u0011BA\u0001\u0003Y\u0019'/Z1uK\u000ec\u0017.\u001a8u\u0005>|Go\u001d;sCB\u001cHCAA\u0002!\u0019\t)!!\u0004\u0002\u00125\u0011\u0011q\u0001\u0006\u0004\u001d\u0006%!BAA\u0006\u0003\u0011Q\u0017M^1\n\t\u0005=\u0011q\u0001\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9bT\u0001\u0007G2LWM\u001c;\n\t\u0005m\u0011Q\u0003\u0002\u0019)J\fgn\u001d9peR\u001cE.[3oi\n{w\u000e^:ue\u0006\u0004\b\"CA\u0010\u0001\t\u0007I\u0011AA\u0011\u00035\u0019G.[3oi\u001a\u000b7\r^8ssV\u0011\u00111\u0005\t\u0005\u0003'\t)#\u0003\u0003\u0002(\u0005U!A\u0006+sC:\u001c\bo\u001c:u\u00072LWM\u001c;GC\u000e$xN]=\t\u0011\u0005-\u0002\u0001)A\u0005\u0003G\tab\u00197jK:$h)Y2u_JL\b\u0005C\u0005\u00020\u0001\u0011\r\u0011\"\u0003\u00022\u0005\u0001B/[7f_V$8k\u00195fIVdWM]\u000b\u0003\u0003g\u0001B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0005\u0003s\t9!\u0001\u0006d_:\u001cWO\u001d:f]RLA!!\u0010\u00028\tA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003g\t\u0011\u0003^5nK>,HoU2iK\u0012,H.\u001a:!\u0011)\t)\u0005\u0001b\u0001\n\u0003A\u0011qI\u0001\u0019G2LWM\u001c;D_:tWm\u0019;j_:,\u00050Z2vi>\u0014XCAA%!\u0011\t)$a\u0013\n\t\u00055\u0013q\u0007\u0002\u0013)\"\u0014X-\u00193Q_>dW\t_3dkR|'\u000f\u0003\u0005\u0002R\u0001\u0001\u000b\u0011BA%\u0003e\u0019G.[3oi\u000e{gN\\3di&|g.\u0012=fGV$xN\u001d\u0011\t\u0017\u0005U\u0003\u00011AA\u0002\u0013%\u0011qK\u0001\u0007g\u0016\u0014h/\u001a:\u0016\u0005\u0005e\u0003\u0003BA.\u0003?j!!!\u0018\u000b\u0007\u0005Us*\u0003\u0003\u0002b\u0005u#a\u0004+sC:\u001c\bo\u001c:u'\u0016\u0014h/\u001a:\t\u0017\u0005\u0015\u0004\u00011AA\u0002\u0013%\u0011qM\u0001\u000bg\u0016\u0014h/\u001a:`I\u0015\fHc\u00018\u0002j!I!/a\u0019\u0002\u0002\u0003\u0007\u0011\u0011\f\u0005\t\u0003[\u0002\u0001\u0015)\u0003\u0002Z\u000591/\u001a:wKJ\u0004\u0003\u0006BA6\u0003c\u00022APA:\u0013\r\t)h\u0010\u0002\tm>d\u0017\r^5mK\"I\u0011\u0011\u0010\u0001C\u0002\u0013%\u00111P\u0001\bgR|\u0007\u000f]3e+\t\ti\b\u0005\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\u0011\t\u0019)a\u000e\u0002\r\u0005$x.\\5d\u0013\u0011\t9)!!\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0011!\tY\t\u0001Q\u0001\n\u0005u\u0014\u0001C:u_B\u0004X\r\u001a\u0011\t\u0013\u0005=\u0005A1A\u0005\n\u0005E\u0015\u0001C8vi\n|\u00070Z:\u0016\u0005\u0005M\u0005\u0003CA\u001b\u0003+\u000bI*a(\n\t\u0005]\u0015q\u0007\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bcA\t\u0002\u001c&\u0019\u0011Q\u0014\u0003\u0003\u0015I\u00038-\u00113ee\u0016\u001c8\u000fE\u0002/\u0003CK1!a)\u0003\u0005\u0019yU\u000f\u001e2pq\"A\u0011q\u0015\u0001!\u0002\u0013\t\u0019*A\u0005pkR\u0014w\u000e_3tA!A\u00111\u0016\u0001\u0005\u0002!\ti+\u0001\u0007sK6|g/Z(vi\n|\u0007\u0010F\u0002o\u0003_C\u0001\"!-\u0002*\u0002\u0007\u0011\u0011T\u0001\bC\u0012$'/Z:t\u0011\u001d\t)\f\u0001C\u0005\u0003o\u000bac\u0019:fCR,7+\u001a:wKJ\u0014un\u001c;tiJ\f\u0007o\u001d\u000b\u0003\u0003s\u0003b!!\u0002\u0002\u000e\u0005m\u0006\u0003BA.\u0003{KA!a0\u0002^\tABK]1ogB|'\u000f^*feZ,'OQ8piN$(/\u00199\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\u0006Y1\u000f^1siN+'O^3s)\u0015q\u0017qYAm\u0011!\tI-!1A\u0002\u0005-\u0017a\u00032j]\u0012\fE\r\u001a:fgN\u0004B!!4\u0002T:\u0019a(a4\n\u0007\u0005Ew(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003+\f9N\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003#|\u0004\u0002CAn\u0003\u0003\u0004\r!!8\u0002\tA|'\u000f\u001e\t\u0004}\u0005}\u0017bAAq\u007f\t\u0019\u0011J\u001c;\t\u0015\u0005E\u0006\u0001#b\u0001\n\u0003\n)/\u0006\u0002\u0002\u001a\"Q\u0011\u0011\u001e\u0001\t\u0002\u0003\u0006K!!'\u0002\u0011\u0005$GM]3tg\u0002BC!a:\u0002nB!\u0011q^A}\u001b\t\t\tP\u0003\u0003\u0002t\u0006U\u0018AC1o]>$\u0018\r^5p]*\u0011\u0011q_\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003w\f\tP\u0001\u0005Ok2d\u0017M\u00197f\u0011\u001d\ty\u0010\u0001C!\u0005\u0003\tQb]3ukB,e\u000e\u001a9pS:$HC\u0002B\u0002\u0005\u0013\u0011i\u0001E\u0002\u0012\u0005\u000bI1Aa\u0002\u0005\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001aD\u0001Ba\u0003\u0002~\u0002\u0007\u00111Z\u0001\u0005]\u0006lW\rC\u0004\u0003\u0010\u0005u\b\u0019\u00015\u0002\u0011\u0015tG\r]8j]RDqAa\u0005\u0001\t\u0003\u0011)\"A\bdQ\u0016\u001c7NU3hSN$XM]3e)\t\u00119\u0002E\u0002?\u00053I1Aa\u0007@\u0005\u001d\u0011un\u001c7fC:DqAa\b\u0001\t\u0003\u0011\t#A\u000ebgft7mU3ukB,e\u000e\u001a9pS:$(+\u001a4Cs\u0006#GM\u001d\u000b\u0005\u0005G\u0011i\u0003\u0005\u0004\u0003&\t%\"1A\u0007\u0003\u0005OQ1!!\u000f@\u0013\u0011\u0011YCa\n\u0003\r\u0019+H/\u001e:f\u0011!\u0011yC!\bA\u0002\tE\u0012\u0001B1eIJ\u00042!\u0005B\u001a\u0013\r\u0011)\u0004\u0002\u0002\u0013%B\u001cWI\u001c3q_&tG/\u00113ee\u0016\u001c8\u000fC\u0004\u0003:\u0001!\tEa\u000f\u0002\tM$x\u000e\u001d\u000b\u0004]\nu\u0002\u0002\u0003B \u0005o\u0001\rAa\u0001\u0002\u0017\u0015tG\r]8j]R\u0014VM\u001a\u0005\b\u0005\u0007\u0002A\u0011\u0002B#\u00031\u0001xn\u001d;U_>+HOY8y)\u0015q'q\tB)\u0011!\u0011IE!\u0011A\u0002\t-\u0013\u0001\u0003:fG\u0016Lg/\u001a:\u0011\u00079\u0012i%C\u0002\u0003P\t\u00111CT3uif\u0014\u0006oY#oIB|\u0017N\u001c;SK\u001aD\u0001Ba\u0015\u0003B\u0001\u0007!QK\u0001\b[\u0016\u001c8/Y4f!\rq#qK\u0005\u0004\u00053\u0012!!D(vi\n|\u00070T3tg\u0006<W\r\u0003\u0005\u0003^\u0001!\t\u0001\u0003B0\u0003\u0011\u0019XM\u001c3\u0015\u00079\u0014\t\u0007\u0003\u0005\u0003T\tm\u0003\u0019\u0001B2!\rq#QM\u0005\u0004\u0005O\u0012!A\u0004*fcV,7\u000f^'fgN\fw-\u001a\u0005\t\u0005W\u0002A\u0011\u0001\u0005\u0003n\u0005a1M]3bi\u0016\u001cE.[3oiR!!q\u000eB;!\u0011\t\u0019B!\u001d\n\t\tM\u0014Q\u0003\u0002\u0010)J\fgn\u001d9peR\u001cE.[3oi\"A\u0011\u0011\u0017B5\u0001\u0004\tI\n\u0003\u0005\u0003z\u0001!\t\u0001\u0003B>\u0003\r\t7o[\u000b\u0005\u0005{\u00129\t\u0006\u0004\u0003\u0000\t%&1\u0016\u000b\u0005\u0005\u0003\u0013I\n\u0005\u0004\u0003&\t%\"1\u0011\t\u0005\u0005\u000b\u00139\t\u0004\u0001\u0005\u0011\t%%q\u000fb\u0001\u0005\u0017\u0013\u0011\u0001V\t\u0005\u0005\u001b\u0013\u0019\nE\u0002?\u0005\u001fK1A!%@\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A\u0010BK\u0013\r\u00119j\u0010\u0002\u0004\u0003:L\bB\u0003BN\u0005o\n\t\u0011q\u0001\u0003\u001e\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\r\t}%Q\u0015BB\u001b\t\u0011\tKC\u0002\u0003$~\nqA]3gY\u0016\u001cG/\u0003\u0003\u0003(\n\u0005&\u0001C\"mCN\u001cH+Y4\t\u0011\tM#q\u000fa\u0001\u0005GB\u0001B!,\u0003x\u0001\u0007!qV\u0001\bi&lWm\\;u!\r\t\"\u0011W\u0005\u0004\u0005g#!A\u0003*qGRKW.Z8vi\"A!q\u0017\u0001\u0005\u0002!\u0011I,A\u0005tKJL\u0017\r\\5{KR!!1\u0018Bd!\u0011\u0011iLa1\u000e\u0005\t}&\u0002\u0002Ba\u0003\u0013\t1A\\5p\u0013\u0011\u0011)Ma0\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000f\u0003\u0005\u0003J\nU\u0006\u0019\u0001BJ\u0003\u001d\u0019wN\u001c;f]RD\u0001B!4\u0001\t\u0003A!qZ\u0001\u0010g\u0016\u0014\u0018.\u00197ju\u0016\u001cFO]3b[R!!\u0011\u001bBl!\r)#1[\u0005\u0004\u0005+4#aE*fe&\fG.\u001b>bi&|gn\u0015;sK\u0006l\u0007\u0002\u0003Bm\u0005\u0017\u0004\rAa7\u0002\u0007=,H\u000f\u0005\u0003\u0003^\n\rXB\u0001Bp\u0015\u0011\u0011\t/!\u0003\u0002\u0005%|\u0017\u0002\u0002Bs\u0005?\u0014AbT;uaV$8\u000b\u001e:fC6D\u0001B!;\u0001\t\u0003A!1^\u0001\fI\u0016\u001cXM]5bY&TX-\u0006\u0003\u0003n\nMHC\u0002Bx\u0005w\u0014i\u0010\u0006\u0003\u0003r\nU\b\u0003\u0002BC\u0005g$\u0001B!#\u0003h\n\u0007!1\u0012\u0005\u000b\u0005o\u00149/!AA\u0004\te\u0018AC3wS\u0012,gnY3%eA1!q\u0014BS\u0005cD\u0001\"a\u0006\u0003h\u0002\u0007!q\u000e\u0005\t\u0005\u007f\u00149\u000f1\u0001\u0003<\u0006)!-\u001f;fg\"9!q\b\u0001\u0005B\r\rA\u0003\u0002B\u0002\u0007\u000bAqAa\u0004\u0004\u0002\u0001\u0007\u0001\u000eC\u0004\u0004\n\u0001!\tea\u0003\u0002\u0011MDW\u000f\u001e3po:$\u0012A\u001c\u0005\b\u0007\u001f\u0001A\u0011IB\u0006\u0003A\tw/Y5u)\u0016\u0014X.\u001b8bi&|g\u000eC\u0004\u0004\u0014\u0001!Iaa\u0003\u0002\u000f\rdW-\u00198va\"9!\u0011\u001e\u0001\u0005B\r]Q\u0003BB\r\u0007;!Baa\u0007\u0004 A!!QQB\u000f\t!\u0011Ii!\u0006C\u0002\t-\u0005\u0002CB\u0011\u0007+\u0001\raa\t\u0002+\u0011,7/\u001a:jC2L'0\u0019;j_:\f5\r^5p]B)ah!\n\u0004\u001c%\u00191qE \u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004bBB\u0016\u0001\u0011\u00053QF\u0001\neB\u001c7k\\;sG\u0016$\u0012\u0001W\u0004\t\u0007c\u0011\u0001\u0012\u0001\u0005\u00044\u0005Ya*\u001a;usJ\u00038-\u00128w!\rq3Q\u0007\u0004\b\u0003\tA\t\u0001CB\u001c'\u0015\u0019)d!\u000f\u0015!\rq41H\u0005\u0004\u0007{y$AB!osJ+g\rC\u0004,\u0007k!\ta!\u0011\u0015\u0005\rM\u0002bCB#\u0007k\u0011\r\u0011\"\u0001\t\u0007\u000f\n!bY;se\u0016tG/\u00128w+\t\u0019I\u0005E\u0003\u0004L\r=S&\u0004\u0002\u0004N)\u0011ajP\u0005\u0005\u0007#\u001aiEA\bEs:\fW.[2WCJL\u0017M\u00197f\u0011%\u0019)f!\u000e!\u0002\u0013\u0019I%A\u0006dkJ\u0014XM\u001c;F]Z\u0004\u0003bCB-\u0007k\u0011\r\u0011\"\u0001\t\u00077\nQbY;se\u0016tGo\u00117jK:$XCAB/!\u0019\u0019Yea\u0014\u0003p!I1\u0011MB\u001bA\u0003%1QL\u0001\u000fGV\u0014(/\u001a8u\u00072LWM\u001c;!\u0001")
public class NettyRpcEnv
extends RpcEnv
implements Logging {
    private final RpcEnvConfig config;
    public final JavaSerializerInstance org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$javaSerializerInstance;
    private final CelebornConf celebornConf;
    private final Option<RpcSecurityContext> securityContext;
    private final TransportConf transportConf;
    private final RpcSource _rpcSource;
    private final Dispatcher dispatcher;
    private RpcEndpoint worker;
    private final TransportContext transportContext;
    private final TransportClientFactory clientFactory;
    private final ScheduledExecutorService timeoutScheduler;
    private final ThreadPoolExecutor clientConnectionExecutor;
    private volatile TransportServer server;
    private final AtomicBoolean stopped;
    private final ConcurrentHashMap<RpcAddress, Outbox> outboxes;
    @Nullable
    private RpcAddress address;
    private final transient Logger log;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    private RpcAddress address$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$0) {
                this.address = this.server() == null ? null : new RpcAddress(this.config().advertiseAddress(), this.server().getPort());
                this.bitmap$0 = true;
            }
            return this.address;
        }
    }

    private Logger log$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$trans$0) {
                this.log = Logging$class.log(this);
                this.bitmap$trans$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$trans$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    public RpcEnvConfig config() {
        return this.config;
    }

    public CelebornConf celebornConf() {
        return this.celebornConf;
    }

    public Option<RpcSecurityContext> securityContext() {
        return this.securityContext;
    }

    public TransportConf transportConf() {
        return this.transportConf;
    }

    private RpcSource _rpcSource() {
        return this._rpcSource;
    }

    private Dispatcher dispatcher() {
        return this.dispatcher;
    }

    private RpcEndpoint worker() {
        return this.worker;
    }

    private void worker_$eq(RpcEndpoint x$1) {
        this.worker = x$1;
    }

    public TransportContext transportContext() {
        return this.transportContext;
    }

    private List<TransportClientBootstrap> createClientBootstraps() {
        Option bootstrapOpt = this.securityContext().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyRpcEnv $outer;

            public final Option<TransportClientBootstrap> apply(RpcSecurityContext x$1) {
                return x$1.clientSaslContext().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final TransportClientBootstrap apply(ClientSaslContext clientSaslContext) {
                        TransportClientBootstrap transportClientBootstrap;
                        if (clientSaslContext.addRegistrationBootstrap()) {
                            this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().logInfo((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Add registration client bootstrap";
                                }
                            });
                            transportClientBootstrap = new RegistrationClientBootstrap(this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().transportConf(), clientSaslContext.appId(), clientSaslContext.saslCredentials(), clientSaslContext.registrationInfo());
                        } else {
                            this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().logInfo((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Add sasl client bootstrap";
                                }
                            });
                            transportClientBootstrap = new SaslClientBootstrap(this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().transportConf(), clientSaslContext.appId(), clientSaslContext.saslCredentials());
                        }
                        return transportClientBootstrap;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ NettyRpcEnv org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bootstrapOpt.toList()).asJava();
    }

    public TransportClientFactory clientFactory() {
        return this.clientFactory;
    }

    private ScheduledExecutorService timeoutScheduler() {
        return this.timeoutScheduler;
    }

    public ThreadPoolExecutor clientConnectionExecutor() {
        return this.clientConnectionExecutor;
    }

    private TransportServer server() {
        return this.server;
    }

    private void server_$eq(TransportServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private ConcurrentHashMap<RpcAddress, Outbox> outboxes() {
        return this.outboxes;
    }

    public void removeOutbox(RpcAddress address) {
        Outbox outbox = this.outboxes().remove(address);
        if (outbox != null) {
            outbox.stop();
        }
    }

    private List<TransportServerBootstrap> createServerBootstraps() {
        Option bootstrapOpt = this.securityContext().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyRpcEnv $outer;

            public final Option<TransportServerBootstrap> apply(RpcSecurityContext x$2) {
                return x$2.serverSaslContext().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final TransportServerBootstrap apply(ServerSaslContext serverSaslContext) {
                        TransportServerBootstrap transportServerBootstrap;
                        if (serverSaslContext.addRegistrationBootstrap()) {
                            this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().logInfo((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Add registration server bootstrap";
                                }
                            });
                            transportServerBootstrap = new RegistrationServerBootstrap(this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().transportConf(), serverSaslContext.secretRegistry());
                        } else {
                            this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().logInfo((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Add sasl server bootstrap";
                                }
                            });
                            transportServerBootstrap = new SaslServerBootstrap(this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().transportConf(), serverSaslContext.secretRegistry());
                        }
                        return transportServerBootstrap;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ NettyRpcEnv org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bootstrapOpt.toList()).asJava();
    }

    public void startServer(String bindAddress, int port) {
        this.server_$eq(this.transportContext().createServer(bindAddress, port, this.createServerBootstraps()));
        this.dispatcher().registerRpcEndpoint(RpcEndpointVerifier$.MODULE$.NAME(), new RpcEndpointVerifier(this, this.dispatcher()));
    }

    @Override
    public RpcAddress address() {
        return this.bitmap$0 ? this.address : this.address$lzycompute();
    }

    @Override
    public RpcEndpointRef setupEndpoint(String name, RpcEndpoint endpoint) {
        block3: {
            block2: {
                String string = name;
                String string2 = RpcNameConstants.WORKER_EP;
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                String string3 = name;
                String string4 = RpcNameConstants.WORKER_INTERNAL_EP;
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
            }
            this.worker_$eq(endpoint);
        }
        return this.dispatcher().registerRpcEndpoint(name, endpoint);
    }

    public boolean checkRegistered() {
        return this.worker() == null ? true : this.worker().checkRegistered();
    }

    @Override
    public Future<RpcEndpointRef> asyncSetupEndpointRefByAddr(RpcEndpointAddress addr) {
        NettyRpcEndpointRef verifier = new NettyRpcEndpointRef(this.celebornConf(), new RpcEndpointAddress(addr.rpcAddress(), RpcEndpointVerifier$.MODULE$.NAME()), this);
        return verifier.ask(new RpcEndpointVerifier.CheckExistence(addr.name()), ClassTag$.MODULE$.Boolean()).flatMap((Function1)new Serializable(this, addr){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyRpcEnv $outer;
            private final RpcEndpointAddress addr$1;

            public final Future<NettyRpcEndpointRef> apply(boolean find) {
                return find ? Future$.MODULE$.successful((Object)new NettyRpcEndpointRef(this.$outer.celebornConf(), this.addr$1, this.$outer)) : Future$.MODULE$.failed((Throwable)new RpcEndpointNotFoundException(this.addr$1.toString()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.addr$1 = addr$1;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    @Override
    public void stop(RpcEndpointRef endpointRef) {
        Predef$.MODULE$.require(endpointRef instanceof NettyRpcEndpointRef);
        this.dispatcher().stop(endpointRef);
    }

    private void postToOutbox(NettyRpcEndpointRef receiver, OutboxMessage message) {
        if (receiver.client() != null && receiver.client().isActive()) {
            message.sendWith(receiver.client());
        } else {
            Outbox targetOutbox;
            Outbox outbox;
            Predef$.MODULE$.require(receiver.address() != null, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Cannot send message to client endpoint with no listen address.";
                }
            });
            Outbox outbox2 = this.outboxes().get(receiver.address());
            if (outbox2 == null) {
                Outbox newOutbox = new Outbox(this, receiver.address());
                Outbox oldOutbox = this.outboxes().putIfAbsent(receiver.address(), newOutbox);
                outbox = oldOutbox == null ? newOutbox : oldOutbox;
            } else {
                outbox = targetOutbox = outbox2;
            }
            if (this.stopped().get()) {
                this.outboxes().remove(receiver.address());
                targetOutbox.stop();
            } else {
                targetOutbox.send(message);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(RequestMessage message) {
        RpcAddress remoteAddr;
        RpcAddress rpcAddress = remoteAddr = message.receiver().address();
        RpcAddress rpcAddress2 = this.address();
        if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
            try {
                this.dispatcher().postOneWayMessage(message);
                return;
            }
            catch (RpcEnvStoppedException rpcEnvStoppedException) {
                this.logDebug((Function0<String>)new Serializable(this, rpcEnvStoppedException){
                    public static final long serialVersionUID = 0L;
                    private final RpcEnvStoppedException e$1;

                    public final String apply() {
                        return this.e$1.getMessage();
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
                return;
            }
        } else {
            this.postToOutbox(message.receiver(), new OneWayOutboxMessage(message.serialize(this)));
            return;
        }
    }

    public TransportClient createClient(RpcAddress address) {
        return this.clientFactory().createClient(address.host(), address.port());
    }

    public <T> Future<T> ask(RequestMessage message, RpcTimeout timeout, ClassTag<T> evidence$1) {
        Promise promise = Promise$.MODULE$.apply();
        RpcAddress remoteAddr = message.receiver().address();
        try {
            RpcAddress rpcAddress = remoteAddr;
            RpcAddress rpcAddress2 = this.address();
            if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
                Promise p = Promise$.MODULE$.apply();
                p.future().onComplete((Function1)new Serializable(this, promise){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyRpcEnv $outer;
                    private final Promise promise$1;

                    public final void apply(Try<Object> x0$1) {
                        Try<Object> try_;
                        block4: {
                            block3: {
                                block2: {
                                    try_ = x0$1;
                                    if (!(try_ instanceof Success)) break block2;
                                    Success success = (Success)try_;
                                    Object response = success.value();
                                    this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onSuccess$1(response, this.promise$1);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(try_ instanceof Failure)) break block4;
                                Failure failure = (Failure)try_;
                                Throwable e = failure.exception();
                                this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, this.promise$1);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw new MatchError(try_);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.promise$1 = promise$1;
                    }
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                this.dispatcher().postLocalMessage(message, (Promise<Object>)p);
            } else {
                RpcOutboxMessage rpcMessage = new RpcOutboxMessage(message.serialize(this), (Function1<Throwable, BoxedUnit>)new Serializable(this, promise){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyRpcEnv $outer;
                    private final Promise promise$1;

                    public final void apply(Throwable e) {
                        this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, this.promise$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.promise$1 = promise$1;
                    }
                }, (Function2<TransportClient, ByteBuffer, BoxedUnit>)new Serializable(this, promise){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyRpcEnv $outer;
                    private final Promise promise$1;

                    public final void apply(TransportClient client, ByteBuffer response) {
                        this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onSuccess$1(this.$outer.deserialize(client, response, ClassTag$.MODULE$.Any()), this.promise$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.promise$1 = promise$1;
                    }
                });
                this.postToOutbox(message.receiver(), rpcMessage);
                promise.future().failed().foreach((Function1)new Serializable(this, rpcMessage){
                    public static final long serialVersionUID = 0L;
                    private final RpcOutboxMessage rpcMessage$1;

                    public final void apply(Throwable x0$2) {
                        Throwable throwable = x0$2;
                        if (throwable instanceof TimeoutException) {
                            this.rpcMessage$1.onTimeout();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    {
                        this.rpcMessage$1 = rpcMessage$1;
                    }
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            }
            ScheduledFuture<?> timeoutCancelable = this.timeoutScheduler().schedule(new Runnable(this, timeout, promise, remoteAddr){
                private final /* synthetic */ NettyRpcEnv $outer;
                private final RpcTimeout timeout$1;
                private final Promise promise$1;
                private final RpcAddress remoteAddr$1;

                public void run() {
                    this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(new TimeoutException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot receive any reply from ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.remoteAddr$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timeout$1.duration()}))).toString()), this.promise$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timeout$1 = timeout$1;
                    this.promise$1 = promise$1;
                    this.remoteAddr$1 = remoteAddr$1;
                }
            }, timeout.duration().toNanos(), TimeUnit.NANOSECONDS);
            promise.future().onComplete((Function1)new Serializable(this, timeoutCancelable){
                public static final long serialVersionUID = 0L;
                private final ScheduledFuture timeoutCancelable$1;

                public final boolean apply(Try<Object> v) {
                    return this.timeoutCancelable$1.cancel(true);
                }
                {
                    this.timeoutCancelable$1 = timeoutCancelable$1;
                }
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return promise.future().mapTo(evidence$1).recover(timeout.addMessageIfTimeout(this.address()), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    public ByteBuffer serialize(Object content) {
        return this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$javaSerializerInstance.serialize(content, ClassTag$.MODULE$.Any());
    }

    public SerializationStream serializeStream(OutputStream out) {
        return this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$javaSerializerInstance.serializeStream(out);
    }

    public <T> T deserialize(TransportClient client, ByteBuffer bytes, ClassTag<T> evidence$2) {
        return (T)NettyRpcEnv$.MODULE$.currentClient().withValue((Object)client, (Function0)new Serializable(this, bytes, evidence$2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyRpcEnv $outer;
            public final ByteBuffer bytes$1;
            public final ClassTag evidence$2$1;

            public final T apply() {
                return this.$outer.deserialize(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deserialize$1 $outer;

                    public final T apply() {
                        return this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$javaSerializerInstance.deserialize(this.$outer.bytes$1, this.$outer.evidence$2$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ NettyRpcEnv org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bytes$1 = bytes$1;
                this.evidence$2$1 = evidence$2$1;
            }
        });
    }

    @Override
    public RpcEndpointRef endpointRef(RpcEndpoint endpoint) {
        return this.dispatcher().getRpcEndpointRef(endpoint);
    }

    @Override
    public void shutdown() {
        this.cleanup();
    }

    @Override
    public void awaitTermination() {
        this.dispatcher().awaitTermination();
    }

    private void cleanup() {
        if (this.stopped().compareAndSet(false, true)) {
            for (Outbox outbox : this.outboxes().values()) {
                this.outboxes().remove(outbox.address());
                outbox.stop();
            }
            Object object = this.timeoutScheduler() == null ? BoxedUnit.UNIT : this.timeoutScheduler().shutdownNow();
            if (this.dispatcher() != null) {
                this.dispatcher().stop();
            }
            if (this.server() != null) {
                this.server().close();
            }
            if (this.clientFactory() != null) {
                this.clientFactory().close();
            }
            if (this.transportContext() != null) {
                this.transportContext().close();
            }
            Object object2 = this.clientConnectionExecutor() == null ? BoxedUnit.UNIT : this.clientConnectionExecutor().shutdownNow();
            if (this._rpcSource() != null) {
                this._rpcSource().destroy();
            }
            return;
        }
    }

    @Override
    public <T> T deserialize(Function0<T> deserializationAction) {
        return (T)NettyRpcEnv$.MODULE$.currentEnv().withValue((Object)this, deserializationAction);
    }

    @Override
    public RpcSource rpcSource() {
        return this._rpcSource();
    }

    public final void org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(Throwable e, Promise promise$1) {
        if (!promise$1.tryFailure(e)) {
            Throwable throwable = e;
            if (throwable instanceof RpcEnvStoppedException) {
                RpcEnvStoppedException rpcEnvStoppedException = (RpcEnvStoppedException)throwable;
                this.logDebug((Function0<String>)new Serializable(this, rpcEnvStoppedException){
                    public static final long serialVersionUID = 0L;
                    private final RpcEnvStoppedException x2$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored failure: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x2$1}));
                    }
                    {
                        this.x2$1 = x2$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logWarning((Function0<String>)new Serializable(this, e){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored failure: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$2}));
                    }
                    {
                        this.e$2 = e$2;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public final void org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onSuccess$1(Object reply2, Promise promise$1) {
        Object object = reply2;
        if (object instanceof RpcFailure) {
            RpcFailure rpcFailure = (RpcFailure)object;
            Throwable e = rpcFailure.e();
            this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (promise$1.trySuccess(object)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logWarning((Function0<String>)new Serializable(this, reply2){
                    public static final long serialVersionUID = 0L;
                    private final Object reply$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reply$1.getClass().getCanonicalName()}));
                    }
                    {
                        this.reply$1 = reply$1;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public NettyRpcEnv(RpcEnvConfig config, JavaSerializerInstance javaSerializerInstance) {
        this.config = config;
        this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$javaSerializerInstance = javaSerializerInstance;
        super(config);
        Logging$class.$init$(this);
        this.celebornConf = config.conf();
        this.securityContext = config.securityContext();
        this.transportConf = Utils$.MODULE$.fromCelebornConf(this.celebornConf().clone(), config.transportModule(), BoxesRunTime.unboxToInt((Object)this.celebornConf().rpcIoThreads().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyRpcEnv $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.config().numUsableCores();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })));
        this._rpcSource = new RpcSource(this.celebornConf(), config.role());
        this.dispatcher = new Dispatcher(this, this._rpcSource());
        this.worker = null;
        this.transportContext = new TransportContext(this.transportConf(), new NettyRpcHandler(this.dispatcher(), this), false, false, (AbstractSource)config.source().orNull(Predef$.MODULE$.$conforms()));
        this.clientFactory = this.transportContext().createClientFactory(this.createClientBootstraps());
        this.timeoutScheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("celeborn-netty-rpc-env-timeout-checker");
        this.clientConnectionExecutor = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("celeborn-netty-rpc-connection-executor", this.celebornConf().rpcConnectThreads(), ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
        this.stopped = new AtomicBoolean(false);
        this.outboxes = JavaUtils.newConcurrentHashMap();
    }
}

