/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.metrics.source;

import com.codahale.metrics.Gauge;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.metrics.source.ThreadPoolSource$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001=\u0011\u0001\u0003\u00165sK\u0006$\u0007k\\8m'>,(oY3\u000b\u0005\r!\u0011AB:pkJ\u001cWM\u0003\u0002\u0006\r\u00059Q.\u001a;sS\u000e\u001c(BA\u0004\t\u0003\u0019\u0019w.\\7p]*\u0011\u0011BC\u0001\tG\u0016dWMY8s]*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!AD!cgR\u0014\u0018m\u0019;T_V\u00148-\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005!1m\u001c8g!\t9\u0002$D\u0001\u0007\u0013\tIbA\u0001\u0007DK2,'m\u001c:o\u0007>tg\r\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\u0011\u0011x\u000e\\3\u0011\u0005u\u0019cB\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\u0012A\u0002)sK\u0012,g-\u0003\u0002%K\t11\u000b\u001e:j]\u001eT!AI\u0010\t\u000b\u001d\u0002A\u0011\u0001\u0015\u0002\rqJg.\u001b;?)\rI#f\u000b\t\u0003#\u0001AQ!\u0006\u0014A\u0002YAQa\u0007\u0014A\u0002qAq!\f\u0001C\u0002\u0013\u0005c&\u0001\u0006t_V\u00148-\u001a(b[\u0016,\u0012a\f\t\u0003aUj\u0011!\r\u0006\u0003eM\nA\u0001\\1oO*\tA'\u0001\u0003kCZ\f\u0017B\u0001\u00132\u0011\u00199\u0004\u0001)A\u0005_\u0005Y1o\\;sG\u0016t\u0015-\\3!\u0011\u0015I\u0004\u0001\"\u0001;\u00039\u0011XmZ5ti\u0016\u00148k\\;sG\u0016$2a\u000f A!\tqB(\u0003\u0002>?\t!QK\\5u\u0011\u0015y\u0004\b1\u0001\u001d\u00039!\bN]3bIB{w\u000e\u001c(b[\u0016DQ!\u0011\u001dA\u0002\t\u000b!\u0003\u001e5sK\u0006$\u0007k\\8m\u000bb,7-\u001e;peB\u00111\tS\u0007\u0002\t*\u0011QIR\u0001\u000bG>t7-\u001e:sK:$(BA$4\u0003\u0011)H/\u001b7\n\u0005%#%A\u0005+ie\u0016\fG\rU8pY\u0016CXmY;u_JDQa\u0013\u0001\u0005\u00021\u000b\u0001#\u001e8sK\u001eL7\u000f^3s'>,(oY3\u0015\u0005mj\u0005\"B K\u0001\u0004a\u0002\"B\u001d\u0001\t\u0003yEcA\u001eQ#\")qH\u0014a\u00019!)!K\u0014a\u0001'\u00069A\u000f\u001b:fC\u0012\u001c\bc\u0001\u0010U-&\u0011Qk\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0007^K!\u0001\u0017#\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016<QA\u0017\u0002\t\u0002m\u000b\u0001\u0003\u00165sK\u0006$\u0007k\\8m'>,(oY3\u0011\u0005Eaf!B\u0001\u0003\u0011\u0003i6C\u0001/_!\tqr,\u0003\u0002a?\t1\u0011I\\=SK\u001aDQa\n/\u0005\u0002\t$\u0012a\u0017\u0005\bIr\u0003\r\u0011\"\u0001f\u0003A!\bN]3bIB{w\u000e\\*pkJ\u001cW-F\u0001g!\rqr-K\u0005\u0003Q~\u0011aa\u00149uS>t\u0007b\u00026]\u0001\u0004%\ta[\u0001\u0015i\"\u0014X-\u00193Q_>d7k\\;sG\u0016|F%Z9\u0015\u0005mb\u0007bB7j\u0003\u0003\u0005\rAZ\u0001\u0004q\u0012\n\u0004BB8]A\u0003&a-A\tuQJ,\u0017\r\u001a)p_2\u001cv.\u001e:dK\u0002BQ!\u001d/\u0005\u0002I\fQ!\u00199qYf$2!K:u\u0011\u0015)\u0002\u000f1\u0001\u0017\u0011\u0015Y\u0002\u000f1\u0001\u001d\u0011\u0015ID\f\"\u0001w)\rYt\u000f\u001f\u0005\u0006\u007fU\u0004\r\u0001\b\u0005\u0006\u0003V\u0004\rA\u0011\u0005\u0006sq#\tA\u001f\u000b\u0004wmd\b\"B z\u0001\u0004a\u0002\"\u0002*z\u0001\u0004\u0019\u0006\"B&]\t\u0003qHCA\u001e\u0000\u0011\u0015yT\u00101\u0001\u001d\u0001")
public class ThreadPoolSource
extends AbstractSource {
    private final String sourceName;

    public static ThreadPoolSource apply(CelebornConf celebornConf, String string) {
        return ThreadPoolSource$.MODULE$.apply(celebornConf, string);
    }

    public static void threadPoolSource_$eq(Option<ThreadPoolSource> option) {
        ThreadPoolSource$.MODULE$.threadPoolSource_$eq(option);
    }

    public static Option<ThreadPoolSource> threadPoolSource() {
        return ThreadPoolSource$.MODULE$.threadPoolSource();
    }

    @Override
    public String sourceName() {
        return this.sourceName;
    }

    public void registerSource(String threadPoolName, ThreadPoolExecutor threadPoolExecutor) {
        Map label = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"threadPool"), (Object)threadPoolName)}));
        this.addGauge("active_thread_count", (Map<String, String>)label, new Gauge<Object>(this, threadPoolExecutor){
            private final ThreadPoolExecutor threadPoolExecutor$1;

            public long getValue() {
                return this.threadPoolExecutor$1.getActiveCount();
            }
            {
                this.threadPoolExecutor$1 = threadPoolExecutor$1;
            }
        });
        this.addGauge("pending_task_count", (Map<String, String>)label, new Gauge<Object>(this, threadPoolExecutor){
            private final ThreadPoolExecutor threadPoolExecutor$1;

            public long getValue() {
                return this.threadPoolExecutor$1.getQueue().size();
            }
            {
                this.threadPoolExecutor$1 = threadPoolExecutor$1;
            }
        });
        this.addGauge("pool_size", (Map<String, String>)label, new Gauge<Object>(this, threadPoolExecutor){
            private final ThreadPoolExecutor threadPoolExecutor$1;

            public long getValue() {
                return this.threadPoolExecutor$1.getPoolSize();
            }
            {
                this.threadPoolExecutor$1 = threadPoolExecutor$1;
            }
        });
        this.addGauge("core_pool_size", (Map<String, String>)label, new Gauge<Object>(this, threadPoolExecutor){
            private final ThreadPoolExecutor threadPoolExecutor$1;

            public long getValue() {
                return this.threadPoolExecutor$1.getCorePoolSize();
            }
            {
                this.threadPoolExecutor$1 = threadPoolExecutor$1;
            }
        });
        this.addGauge("maximum_pool_size", (Map<String, String>)label, new Gauge<Object>(this, threadPoolExecutor){
            private final ThreadPoolExecutor threadPoolExecutor$1;

            public long getValue() {
                return this.threadPoolExecutor$1.getMaximumPoolSize();
            }
            {
                this.threadPoolExecutor$1 = threadPoolExecutor$1;
            }
        });
        this.addGauge("largest_pool_size", (Map<String, String>)label, new Gauge<Object>(this, threadPoolExecutor){
            private final ThreadPoolExecutor threadPoolExecutor$1;

            public long getValue() {
                return this.threadPoolExecutor$1.getLargestPoolSize();
            }
            {
                this.threadPoolExecutor$1 = threadPoolExecutor$1;
            }
        });
        this.addGauge("is_terminating", (Map<String, String>)label, new Gauge<Object>(this, threadPoolExecutor){
            private final ThreadPoolExecutor threadPoolExecutor$1;

            public int getValue() {
                return this.threadPoolExecutor$1.isTerminating() ? 1 : 0;
            }
            {
                this.threadPoolExecutor$1 = threadPoolExecutor$1;
            }
        });
        this.addGauge("is_terminated", (Map<String, String>)label, new Gauge<Object>(this, threadPoolExecutor){
            private final ThreadPoolExecutor threadPoolExecutor$1;

            public int getValue() {
                return this.threadPoolExecutor$1.isTerminated() ? 1 : 0;
            }
            {
                this.threadPoolExecutor$1 = threadPoolExecutor$1;
            }
        });
        this.addGauge("is_shutdown", (Map<String, String>)label, new Gauge<Object>(this, threadPoolExecutor){
            private final ThreadPoolExecutor threadPoolExecutor$1;

            public int getValue() {
                return this.threadPoolExecutor$1.isShutdown() ? 1 : 0;
            }
            {
                this.threadPoolExecutor$1 = threadPoolExecutor$1;
            }
        });
    }

    public void unregisterSource(String threadPoolName) {
        Map label = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"threadPool"), (Object)threadPoolName)}));
        this.removeGauge("active_thread_count", (Map<String, String>)label);
        this.removeGauge("pending_task_count", (Map<String, String>)label);
        this.removeGauge("pool_size", (Map<String, String>)label);
        this.removeGauge("core_pool_size", (Map<String, String>)label);
        this.removeGauge("maximum_pool_size", (Map<String, String>)label);
        this.removeGauge("largest_pool_size", (Map<String, String>)label);
        this.removeGauge("is_terminating", (Map<String, String>)label);
        this.removeGauge("is_terminated", (Map<String, String>)label);
        this.removeGauge("is_shutdown", (Map<String, String>)label);
        this.removeGauge("thread_count", (Map<String, String>)label);
        this.removeGauge("thread_is_terminated_count", (Map<String, String>)label);
        this.removeGauge("thread_is_shutdown_count", (Map<String, String>)label);
    }

    public void registerSource(String threadPoolName, ExecutorService[] threads) {
        Map label = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"threadPool"), (Object)threadPoolName)}));
        this.addGauge("thread_count", (Map<String, String>)label, new Gauge<Object>(this, threads){
            private final ExecutorService[] threads$1;

            public int getValue() {
                return this.threads$1.length;
            }
            {
                this.threads$1 = threads$1;
            }
        });
        this.addGauge("thread_is_terminated_count", (Map<String, String>)label, new Gauge<Object>(this, threads){
            private final ExecutorService[] threads$1;

            public int getValue() {
                return Predef$.MODULE$.refArrayOps((Object[])this.threads$1).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ExecutorService x$1) {
                        return x$1.isTerminated();
                    }
                });
            }
            {
                this.threads$1 = threads$1;
            }
        });
        this.addGauge("thread_is_shutdown_count", (Map<String, String>)label, new Gauge<Object>(this, threads){
            private final ExecutorService[] threads$1;

            public int getValue() {
                return Predef$.MODULE$.refArrayOps((Object[])this.threads$1).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ExecutorService x$2) {
                        return x$2.isShutdown();
                    }
                });
            }
            {
                this.threads$1 = threads$1;
            }
        });
    }

    public ThreadPoolSource(CelebornConf conf, String role) {
        super(conf, role);
        this.sourceName = "ThreadPool";
    }
}

