/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.compress;

import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.celeborn.client.compress.Compressor;
import org.apache.celeborn.client.compress.Lz4Trait;

public class Lz4Compressor
extends Lz4Trait
implements Compressor {
    private final LZ4Compressor compressor = LZ4Factory.fastestInstance().fastCompressor();
    private final Checksum checksum = XXHashFactory.fastestInstance().newStreamingHash32(-1756908916).asChecksum();
    private byte[] compressedBuffer;
    private int compressedTotalSize;

    public Lz4Compressor(int blockSize) {
        this.initCompressBuffer(blockSize);
    }

    @Override
    public void initCompressBuffer(int maxDestLength) {
        int compressedBlockSize = HEADER_LENGTH + maxDestLength;
        this.compressedBuffer = new byte[compressedBlockSize];
        System.arraycopy(MAGIC, 0, this.compressedBuffer, 0, MAGIC_LENGTH);
    }

    @Override
    public void compress(byte[] data, int offset, int length) {
        int compressMethod;
        int compressedLength;
        this.checksum.reset();
        this.checksum.update(data, offset, length);
        int check = (int)this.checksum.getValue();
        int maxDestLength = this.compressor.maxCompressedLength(length);
        if (this.compressedBuffer.length - HEADER_LENGTH < maxDestLength) {
            this.initCompressBuffer(maxDestLength);
        }
        if ((compressedLength = this.compressor.compress(data, offset, length, this.compressedBuffer, HEADER_LENGTH)) >= length) {
            compressMethod = 16;
            compressedLength = length;
            System.arraycopy(data, offset, this.compressedBuffer, HEADER_LENGTH, length);
        } else {
            compressMethod = 32;
        }
        this.compressedBuffer[Lz4Compressor.MAGIC_LENGTH] = (byte)compressMethod;
        this.writeIntLE(compressedLength, this.compressedBuffer, MAGIC_LENGTH + 1);
        this.writeIntLE(length, this.compressedBuffer, MAGIC_LENGTH + 5);
        this.writeIntLE(check, this.compressedBuffer, MAGIC_LENGTH + 9);
        this.compressedTotalSize = HEADER_LENGTH + compressedLength;
    }

    @Override
    public int getCompressedTotalSize() {
        return this.compressedTotalSize;
    }

    @Override
    public byte[] getCompressedBuffer() {
        return this.compressedBuffer;
    }
}

