/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import java.util.Objects;
import org.apache.celeborn.common.network.protocol.Encodable;
import org.apache.celeborn.common.protocol.PbStreamChunkSlice;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;

public final class StreamChunkSlice
implements Encodable {
    public final long streamId;
    public final int chunkIndex;
    public final int offset;
    public final int len;

    public StreamChunkSlice(long streamId, int chunkIndex) {
        this.streamId = streamId;
        this.chunkIndex = chunkIndex;
        this.offset = 0;
        this.len = Integer.MAX_VALUE;
    }

    public StreamChunkSlice(long streamId, int chunkIndex, int offset, int len) {
        this.streamId = streamId;
        this.chunkIndex = chunkIndex;
        this.offset = offset;
        this.len = len;
    }

    @Override
    public int encodedLength() {
        return 20;
    }

    @Override
    public void encode(ByteBuf buffer) {
        buffer.writeLong(this.streamId);
        buffer.writeInt(this.chunkIndex);
        buffer.writeInt(this.offset);
        buffer.writeInt(this.len);
    }

    public static StreamChunkSlice decode(ByteBuf buffer) {
        assert (buffer.readableBytes() >= 20);
        long streamId = buffer.readLong();
        int chunkIndex = buffer.readInt();
        int offset = buffer.readInt();
        int len = buffer.readInt();
        return new StreamChunkSlice(streamId, chunkIndex, offset, len);
    }

    public int hashCode() {
        return Objects.hash(this.streamId, this.chunkIndex, this.offset, this.len);
    }

    public boolean equals(Object other) {
        if (other instanceof StreamChunkSlice) {
            StreamChunkSlice o = (StreamChunkSlice)other;
            return this.streamId == o.streamId && this.chunkIndex == o.chunkIndex && this.offset == o.offset && this.len == o.len;
        }
        return false;
    }

    public String toString() {
        return "StreamChunkSlice[streamId=" + this.streamId + ",chunkIndex=" + this.chunkIndex + ",offset=" + this.offset + ",len=" + this.len + "]";
    }

    public PbStreamChunkSlice toProto() {
        return PbStreamChunkSlice.newBuilder().setStreamId(this.streamId).setChunkIndex(this.chunkIndex).setOffset(this.offset).setLen(this.len).build();
    }

    public static StreamChunkSlice fromProto(PbStreamChunkSlice pb) {
        return new StreamChunkSlice(pb.getStreamId(), pb.getChunkIndex(), pb.getOffset(), pb.getLen());
    }
}

