/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.metrics.source;

import com.codahale.metrics.Gauge;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.metrics.source.ThreadPoolSource$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%a\u0001B\n\u0015\u0001\u0005B\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)\u0011\b\u0001C\u0001u!9a\b\u0001b\u0001\n\u0003z\u0004BB$\u0001A\u0003%\u0001\tC\u0003I\u0001\u0011\u0005\u0011\nC\u0003[\u0001\u0011\u00051\fC\u0003I\u0001\u0011\u0005QlB\u0003h)!\u0005\u0001NB\u0003\u0014)!\u0005\u0011\u000eC\u0003:\u0015\u0011\u0005Q\u000eC\u0004o\u0015\u0001\u0007I\u0011A8\t\u000fMT\u0001\u0019!C\u0001i\"1qO\u0003Q!\nADQ\u0001\u001f\u0006\u0005\u0002eDQ\u0001\u0013\u0006\u0005\u0002qDQ\u0001\u0013\u0006\u0005\u0002}DaA\u0017\u0006\u0005\u0002\u0005\u0015!\u0001\u0005+ie\u0016\fG\rU8pYN{WO]2f\u0015\t)b#\u0001\u0004t_V\u00148-\u001a\u0006\u0003/a\tq!\\3ue&\u001c7O\u0003\u0002\u001a5\u000511m\\7n_:T!a\u0007\u000f\u0002\u0011\r,G.\u001a2pe:T!!\b\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0012aA8sO\u000e\u00011C\u0001\u0001#!\t\u0019C%D\u0001\u0015\u0013\t)CC\u0001\bBEN$(/Y2u'>,(oY3\u0002\t\r|gN\u001a\t\u0003Q%j\u0011\u0001G\u0005\u0003Ua\u0011AbQ3mK\n|'O\\\"p]\u001a\fAA]8mKB\u0011QF\u000e\b\u0003]Q\u0002\"a\f\u001a\u000e\u0003AR!!\r\u0011\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U\u0012\u0014A\u0002\u001fj]&$h\bF\u0002<yu\u0002\"a\t\u0001\t\u000b\u0019\u001a\u0001\u0019A\u0014\t\u000b-\u001a\u0001\u0019\u0001\u0017\u0002\u0015M|WO]2f\u001d\u0006lW-F\u0001A!\t\te)D\u0001C\u0015\t\u0019E)\u0001\u0003mC:<'\"A#\u0002\t)\fg/Y\u0005\u0003o\t\u000b1b]8ve\u000e,g*Y7fA\u0005q!/Z4jgR,'oU8ve\u000e,Gc\u0001&O!B\u00111\nT\u0007\u0002e%\u0011QJ\r\u0002\u0005+:LG\u000fC\u0003P\r\u0001\u0007A&\u0001\buQJ,\u0017\r\u001a)p_2t\u0015-\\3\t\u000bE3\u0001\u0019\u0001*\u0002%QD'/Z1e!>|G.\u0012=fGV$xN\u001d\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000b!bY8oGV\u0014(/\u001a8u\u0015\t9F)\u0001\u0003vi&d\u0017BA-U\u0005I!\u0006N]3bIB{w\u000e\\#yK\u000e,Ho\u001c:\u0002!Ut'/Z4jgR,'oU8ve\u000e,GC\u0001&]\u0011\u0015yu\u00011\u0001-)\rQel\u0018\u0005\u0006\u001f\"\u0001\r\u0001\f\u0005\u0006A\"\u0001\r!Y\u0001\bi\"\u0014X-\u00193t!\rY%\rZ\u0005\u0003GJ\u0012Q!\u0011:sCf\u0004\"aU3\n\u0005\u0019$&aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002!QC'/Z1e!>|GnU8ve\u000e,\u0007CA\u0012\u000b'\tQ!\u000e\u0005\u0002LW&\u0011AN\r\u0002\u0007\u0003:L(+\u001a4\u0015\u0003!\f\u0001\u0003\u001e5sK\u0006$\u0007k\\8m'>,(oY3\u0016\u0003A\u00042aS9<\u0013\t\u0011(G\u0001\u0004PaRLwN\\\u0001\u0015i\"\u0014X-\u00193Q_>d7k\\;sG\u0016|F%Z9\u0015\u0005)+\bb\u0002<\u000e\u0003\u0003\u0005\r\u0001]\u0001\u0004q\u0012\n\u0014!\u0005;ie\u0016\fG\rU8pYN{WO]2fA\u0005)\u0011\r\u001d9msR\u00191H_>\t\u000b\u0019z\u0001\u0019A\u0014\t\u000b-z\u0001\u0019\u0001\u0017\u0015\u0007)kh\u0010C\u0003P!\u0001\u0007A\u0006C\u0003R!\u0001\u0007!\u000bF\u0003K\u0003\u0003\t\u0019\u0001C\u0003P#\u0001\u0007A\u0006C\u0003a#\u0001\u0007\u0011\rF\u0002K\u0003\u000fAQa\u0014\nA\u00021\u0002")
public class ThreadPoolSource
extends AbstractSource {
    private final String sourceName;

    public static ThreadPoolSource apply(CelebornConf conf, String role) {
        return ThreadPoolSource$.MODULE$.apply(conf, role);
    }

    public static void threadPoolSource_$eq(Option<ThreadPoolSource> x$1) {
        ThreadPoolSource$.MODULE$.threadPoolSource_$eq(x$1);
    }

    public static Option<ThreadPoolSource> threadPoolSource() {
        return ThreadPoolSource$.MODULE$.threadPoolSource();
    }

    @Override
    public String sourceName() {
        return this.sourceName;
    }

    public void registerSource(String threadPoolName, ThreadPoolExecutor threadPoolExecutor) {
        Map label = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"threadPool"), (Object)threadPoolName)}));
        this.addGauge("active_thread_count", (Map<String, String>)label, new Gauge<Object>(null, threadPoolExecutor){
            private final ThreadPoolExecutor threadPoolExecutor$1;

            public long getValue() {
                return this.threadPoolExecutor$1.getActiveCount();
            }
            {
                this.threadPoolExecutor$1 = threadPoolExecutor$1;
            }
        });
        this.addGauge("pending_task_count", (Map<String, String>)label, new Gauge<Object>(null, threadPoolExecutor){
            private final ThreadPoolExecutor threadPoolExecutor$1;

            public long getValue() {
                return this.threadPoolExecutor$1.getQueue().size();
            }
            {
                this.threadPoolExecutor$1 = threadPoolExecutor$1;
            }
        });
        this.addGauge("pool_size", (Map<String, String>)label, new Gauge<Object>(null, threadPoolExecutor){
            private final ThreadPoolExecutor threadPoolExecutor$1;

            public long getValue() {
                return this.threadPoolExecutor$1.getPoolSize();
            }
            {
                this.threadPoolExecutor$1 = threadPoolExecutor$1;
            }
        });
        this.addGauge("core_pool_size", (Map<String, String>)label, new Gauge<Object>(null, threadPoolExecutor){
            private final ThreadPoolExecutor threadPoolExecutor$1;

            public long getValue() {
                return this.threadPoolExecutor$1.getCorePoolSize();
            }
            {
                this.threadPoolExecutor$1 = threadPoolExecutor$1;
            }
        });
        this.addGauge("maximum_pool_size", (Map<String, String>)label, new Gauge<Object>(null, threadPoolExecutor){
            private final ThreadPoolExecutor threadPoolExecutor$1;

            public long getValue() {
                return this.threadPoolExecutor$1.getMaximumPoolSize();
            }
            {
                this.threadPoolExecutor$1 = threadPoolExecutor$1;
            }
        });
        this.addGauge("largest_pool_size", (Map<String, String>)label, new Gauge<Object>(null, threadPoolExecutor){
            private final ThreadPoolExecutor threadPoolExecutor$1;

            public long getValue() {
                return this.threadPoolExecutor$1.getLargestPoolSize();
            }
            {
                this.threadPoolExecutor$1 = threadPoolExecutor$1;
            }
        });
        this.addGauge("is_terminating", (Map<String, String>)label, new Gauge<Object>(null, threadPoolExecutor){
            private final ThreadPoolExecutor threadPoolExecutor$1;

            public int getValue() {
                if (this.threadPoolExecutor$1.isTerminating()) {
                    return 1;
                }
                return 0;
            }
            {
                this.threadPoolExecutor$1 = threadPoolExecutor$1;
            }
        });
        this.addGauge("is_terminated", (Map<String, String>)label, new Gauge<Object>(null, threadPoolExecutor){
            private final ThreadPoolExecutor threadPoolExecutor$1;

            public int getValue() {
                if (this.threadPoolExecutor$1.isTerminated()) {
                    return 1;
                }
                return 0;
            }
            {
                this.threadPoolExecutor$1 = threadPoolExecutor$1;
            }
        });
        this.addGauge("is_shutdown", (Map<String, String>)label, new Gauge<Object>(null, threadPoolExecutor){
            private final ThreadPoolExecutor threadPoolExecutor$1;

            public int getValue() {
                if (this.threadPoolExecutor$1.isShutdown()) {
                    return 1;
                }
                return 0;
            }
            {
                this.threadPoolExecutor$1 = threadPoolExecutor$1;
            }
        });
    }

    public void unregisterSource(String threadPoolName) {
        Map label = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"threadPool"), (Object)threadPoolName)}));
        this.removeGauge("active_thread_count", (Map<String, String>)label);
        this.removeGauge("pending_task_count", (Map<String, String>)label);
        this.removeGauge("pool_size", (Map<String, String>)label);
        this.removeGauge("core_pool_size", (Map<String, String>)label);
        this.removeGauge("maximum_pool_size", (Map<String, String>)label);
        this.removeGauge("largest_pool_size", (Map<String, String>)label);
        this.removeGauge("is_terminating", (Map<String, String>)label);
        this.removeGauge("is_terminated", (Map<String, String>)label);
        this.removeGauge("is_shutdown", (Map<String, String>)label);
        this.removeGauge("thread_count", (Map<String, String>)label);
        this.removeGauge("thread_is_terminated_count", (Map<String, String>)label);
        this.removeGauge("thread_is_shutdown_count", (Map<String, String>)label);
    }

    public void registerSource(String threadPoolName, ExecutorService[] threads) {
        Map label = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"threadPool"), (Object)threadPoolName)}));
        this.addGauge("thread_count", (Map<String, String>)label, new Gauge<Object>(null, threads){
            private final ExecutorService[] threads$1;

            public int getValue() {
                return this.threads$1.length;
            }
            {
                this.threads$1 = threads$1;
            }
        });
        this.addGauge("thread_is_terminated_count", (Map<String, String>)label, new Gauge<Object>(null, threads){
            private final ExecutorService[] threads$1;

            public int getValue() {
                return ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])this.threads$1), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)$anon$11.$anonfun$getValue$1(x$1)));
            }

            public static final /* synthetic */ boolean $anonfun$getValue$1(ExecutorService x$1) {
                return x$1.isTerminated();
            }
            {
                this.threads$1 = threads$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getValue$1$adapted(java.util.concurrent.ExecutorService )}, serializedLambda);
            }
        });
        this.addGauge("thread_is_shutdown_count", (Map<String, String>)label, new Gauge<Object>(null, threads){
            private final ExecutorService[] threads$1;

            public int getValue() {
                return ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])this.threads$1), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)$anon$12.$anonfun$getValue$2(x$2)));
            }

            public static final /* synthetic */ boolean $anonfun$getValue$2(ExecutorService x$2) {
                return x$2.isShutdown();
            }
            {
                this.threads$1 = threads$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getValue$2$adapted(java.util.concurrent.ExecutorService )}, serializedLambda);
            }
        });
    }

    public ThreadPoolSource(CelebornConf conf, String role) {
        super(conf, role);
        this.sourceName = "ThreadPool";
    }
}

