/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.identity.UserIdentifier$;
import org.apache.celeborn.common.meta.ApplicationMeta;
import org.apache.celeborn.common.meta.DeviceInfo$;
import org.apache.celeborn.common.meta.DiskFileInfo;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.FileMeta;
import org.apache.celeborn.common.meta.MapFileMeta;
import org.apache.celeborn.common.meta.ReduceFileMeta;
import org.apache.celeborn.common.meta.WorkerEventInfo;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.meta.WorkerInfo$;
import org.apache.celeborn.common.meta.WorkerStatus;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.protocol.PbApplicationMeta;
import org.apache.celeborn.common.protocol.PbChunkOffsets;
import org.apache.celeborn.common.protocol.PbDiskInfo;
import org.apache.celeborn.common.protocol.PbFailedBatches;
import org.apache.celeborn.common.protocol.PbFileInfo;
import org.apache.celeborn.common.protocol.PbFileInfoMap;
import org.apache.celeborn.common.protocol.PbLocationPushFailedBatches;
import org.apache.celeborn.common.protocol.PbPackedPartitionLocations;
import org.apache.celeborn.common.protocol.PbPackedPartitionLocationsPair;
import org.apache.celeborn.common.protocol.PbPackedWorkerResource;
import org.apache.celeborn.common.protocol.PbPartitionLocation;
import org.apache.celeborn.common.protocol.PbResourceConsumption;
import org.apache.celeborn.common.protocol.PbSegmentIndex;
import org.apache.celeborn.common.protocol.PbSnapshotMetaInfo;
import org.apache.celeborn.common.protocol.PbSortedShuffleFileSet;
import org.apache.celeborn.common.protocol.PbStoreVersion;
import org.apache.celeborn.common.protocol.PbUserIdentifier;
import org.apache.celeborn.common.protocol.PbWorkerEventInfo;
import org.apache.celeborn.common.protocol.PbWorkerInfo;
import org.apache.celeborn.common.protocol.PbWorkerResource;
import org.apache.celeborn.common.protocol.PbWorkerStatus;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.util.CollectionUtils;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.common.write.LocationPushFailedBatches;
import org.apache.celeborn.shaded.com.google.protobuf.InvalidProtocolBufferException;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PbSerDeUtils$ {
    public static PbSerDeUtils$ MODULE$;
    private boolean masterPersistWorkerNetworkLocation;

    static {
        new PbSerDeUtils$();
    }

    private boolean masterPersistWorkerNetworkLocation() {
        return this.masterPersistWorkerNetworkLocation;
    }

    private void masterPersistWorkerNetworkLocation_$eq(boolean x$1) {
        this.masterPersistWorkerNetworkLocation = x$1;
    }

    public void setMasterPersistWorkerNetworkLocation(boolean masterPersistWorkerNetworkLocation) {
        this.masterPersistWorkerNetworkLocation_$eq(masterPersistWorkerNetworkLocation);
    }

    public java.util.Set<String> fromPbSortedShuffleFileSet(byte[] data) throws InvalidProtocolBufferException {
        PbSortedShuffleFileSet pbSortedShuffleFileSet = PbSortedShuffleFileSet.parseFrom(data);
        ConcurrentHashMap.KeySetView<String, Boolean> files = ConcurrentHashMap.newKeySet();
        files.addAll(pbSortedShuffleFileSet.getFilesList());
        return files;
    }

    public byte[] toPbSortedShuffleFileSet(java.util.Set<String> files) {
        return PbSortedShuffleFileSet.newBuilder().addAllFiles(files).build().toByteArray();
    }

    public ArrayList<Integer> fromPbStoreVersion(byte[] data) throws InvalidProtocolBufferException {
        PbStoreVersion pbStoreVersion = PbStoreVersion.parseFrom(data);
        ArrayList<Integer> versions = new ArrayList<Integer>();
        versions.add(Predef$.MODULE$.int2Integer(pbStoreVersion.getMajor()));
        versions.add(Predef$.MODULE$.int2Integer(pbStoreVersion.getMinor()));
        return versions;
    }

    public byte[] toPbStoreVersion(int major, int minor) {
        return PbStoreVersion.newBuilder().setMajor(major).setMinor(minor).build().toByteArray();
    }

    public DiskInfo fromPbDiskInfo(PbDiskInfo pbDiskInfo) {
        DiskInfo diskInfo = new DiskInfo(pbDiskInfo.getMountPoint(), pbDiskInfo.getUsableSpace(), pbDiskInfo.getAvgFlushTime(), pbDiskInfo.getAvgFetchTime(), pbDiskInfo.getUsedSlots()).setStatus(Utils$.MODULE$.toDiskStatus(pbDiskInfo.getStatus())).setTotalSpace(pbDiskInfo.getTotalSpace());
        diskInfo.setStorageType(StorageInfo.typesMap.get(BoxesRunTime.boxToInteger((int)pbDiskInfo.getStorageType())));
        return diskInfo;
    }

    public PbDiskInfo toPbDiskInfo(DiskInfo diskInfo) {
        return PbDiskInfo.newBuilder().setMountPoint(diskInfo.mountPoint()).setUsableSpace(diskInfo.actualUsableSpace()).setAvgFlushTime(diskInfo.avgFlushTime()).setAvgFetchTime(diskInfo.avgFetchTime()).setUsedSlots(diskInfo.activeSlots()).setStatus(diskInfo.status().getValue()).setStorageType(diskInfo.storageType().getValue()).setTotalSpace(diskInfo.totalSpace()).build();
    }

    public DiskFileInfo fromPbFileInfo(PbFileInfo pbFileInfo) {
        return this.fromPbFileInfo(pbFileInfo, this.fromPbUserIdentifier(pbFileInfo.getUserIdentifier()));
    }

    public DiskFileInfo fromPbFileInfo(PbFileInfo pbFileInfo, UserIdentifier userIdentifier) {
        FileMeta fileMeta;
        PartitionType partitionType = Utils$.MODULE$.toPartitionType(pbFileInfo.getPartitionType());
        if (((Object)((Object)PartitionType.REDUCE)).equals((Object)partitionType)) {
            fileMeta = new ReduceFileMeta(pbFileInfo.getChunkOffsetsList());
        } else if (((Object)((Object)PartitionType.MAP)).equals((Object)partitionType)) {
            MapFileMeta fileMeta2 = new MapFileMeta(pbFileInfo.getBufferSize(), pbFileInfo.getNumSubpartitions(), pbFileInfo.getIsSegmentGranularityVisible(), pbFileInfo.getPartitionWritingSegmentMap(), this.fromPbSegmentIndexList(pbFileInfo.getSegmentIndexList()));
            fileMeta2.setIsWriterClosed(true);
            fileMeta = fileMeta2;
        } else {
            if (((Object)((Object)PartitionType.MAPGROUP)).equals((Object)partitionType)) {
                throw new NotImplementedError("Map group is not implemented");
            }
            throw new MatchError((Object)partitionType);
        }
        ReduceFileMeta meta = fileMeta;
        return new DiskFileInfo(userIdentifier, pbFileInfo.getPartitionSplitEnabled(), (FileMeta)meta, pbFileInfo.getFilePath(), pbFileInfo.getBytesFlushed());
    }

    private java.util.List<MapFileMeta.SegmentIndex> fromPbSegmentIndexList(java.util.List<PbSegmentIndex> segmentIndexList) {
        return (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(segmentIndexList).asScala()).map((Function1 & Serializable & scala.Serializable)firstBufferIndexToSegment -> new MapFileMeta.SegmentIndex(firstBufferIndexToSegment.getFirstBufferIndexToSegmentMap()), Buffer$.MODULE$.canBuildFrom())).asJava();
    }

    private PbSegmentIndex toPbSegmentIndex(MapFileMeta.SegmentIndex firstBufferIndexToSegment) {
        return PbSegmentIndex.newBuilder().putAllFirstBufferIndexToSegment(firstBufferIndexToSegment.getFirstBufferIndexToSegment()).build();
    }

    public PbFileInfo toPbFileInfo(DiskFileInfo fileInfo) {
        PbFileInfo.Builder builder;
        PbFileInfo.Builder builder2 = PbFileInfo.newBuilder().setFilePath(fileInfo.getFilePath()).setUserIdentifier(this.toPbUserIdentifier(fileInfo.getUserIdentifier())).setBytesFlushed(fileInfo.getFileLength()).setPartitionSplitEnabled(fileInfo.isPartitionSplitEnabled());
        if (fileInfo.getFileMeta() instanceof MapFileMeta) {
            MapFileMeta mapFileMeta = (MapFileMeta)fileInfo.getFileMeta();
            builder2.setPartitionType(PartitionType.MAP.getValue());
            builder2.setBufferSize(mapFileMeta.getBufferSize());
            builder2.setNumSubpartitions(mapFileMeta.getNumSubpartitions());
            builder2.setIsSegmentGranularityVisible(mapFileMeta.isSegmentGranularityVisible());
            builder2.putAllPartitionWritingSegment(mapFileMeta.getSubPartitionWritingSegmentId());
            builder = builder2.addAllSegmentIndex((java.lang.Iterable)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(mapFileMeta.getSubPartitionSegmentIndexes()).asScala()).map((Function1 & Serializable & scala.Serializable)firstBufferIndexToSegment -> MODULE$.toPbSegmentIndex((MapFileMeta.SegmentIndex)firstBufferIndexToSegment), Buffer$.MODULE$.canBuildFrom())).asJava());
        } else {
            ReduceFileMeta reduceFileMeta = (ReduceFileMeta)fileInfo.getFileMeta();
            builder2.setPartitionType(PartitionType.REDUCE.getValue());
            builder = builder2.addAllChunkOffsets(reduceFileMeta.getChunkOffsets());
        }
        return builder2.build();
    }

    public ConcurrentHashMap<String, DiskFileInfo> fromPbFileInfoMap(byte[] data, ConcurrentHashMap<String, UserIdentifier> cache, HashSet<String> mountPoints) throws InvalidProtocolBufferException {
        PbFileInfoMap pbFileInfoMap = PbFileInfoMap.parseFrom(data);
        ConcurrentHashMap<String, DiskFileInfo> fileInfoMap = JavaUtils.newConcurrentHashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(pbFileInfoMap.getValuesMap().entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            DiskFileInfo fileInfo;
            String fileName;
            block2: {
                fileName = (String)entry.getKey();
                PbFileInfo pbFileInfo = (PbFileInfo)entry.getValue();
                PbUserIdentifier pbUserIdentifier = pbFileInfo.getUserIdentifier();
                String userIdentifierKey = new StringBuilder(1).append(pbUserIdentifier.getTenantId()).append("-").append(pbUserIdentifier.getName()).toString();
                if (!cache.containsKey(userIdentifierKey)) {
                    DiskFileInfo fileInfo2 = MODULE$.fromPbFileInfo(pbFileInfo);
                    if (fileInfo2.getFileMeta() instanceof MapFileMeta) {
                        fileInfo2.setMountPoint(DeviceInfo$.MODULE$.getMountPoint(fileInfo2.getFilePath(), mountPoints));
                    }
                    cache.put(userIdentifierKey, fileInfo2.getUserIdentifier());
                    return fileInfoMap.put(fileName, fileInfo2);
                }
                fileInfo = MODULE$.fromPbFileInfo(pbFileInfo, (UserIdentifier)cache.get(userIdentifierKey));
                if (!(fileInfo.getFileMeta() instanceof MapFileMeta)) break block2;
                fileInfo.setMountPoint(DeviceInfo$.MODULE$.getMountPoint(fileInfo.getFilePath(), mountPoints));
            }
            return fileInfoMap.put(fileName, fileInfo);
        });
        return fileInfoMap;
    }

    public byte[] toPbFileInfoMap(ConcurrentHashMap<String, DiskFileInfo> fileInfoMap) {
        ConcurrentHashMap<String, PbFileInfo> pbFileInfoMap = JavaUtils.newConcurrentHashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(fileInfoMap.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> pbFileInfoMap.put((String)entry.getKey(), MODULE$.toPbFileInfo((DiskFileInfo)entry.getValue())));
        return PbFileInfoMap.newBuilder().putAllValues(pbFileInfoMap).build().toByteArray();
    }

    public UserIdentifier fromPbUserIdentifier(PbUserIdentifier pbUserIdentifier) {
        return new UserIdentifier(pbUserIdentifier.getTenantId(), pbUserIdentifier.getName());
    }

    public PbUserIdentifier toPbUserIdentifier(UserIdentifier userIdentifier) {
        return PbUserIdentifier.newBuilder().setTenantId(userIdentifier.tenantId()).setName(userIdentifier.name()).build();
    }

    public ResourceConsumption fromPbResourceConsumption(PbResourceConsumption pbResourceConsumption) {
        return new ResourceConsumption(pbResourceConsumption.getDiskBytesWritten(), pbResourceConsumption.getDiskFileCount(), pbResourceConsumption.getHdfsBytesWritten(), pbResourceConsumption.getHdfsFileCount(), this.fromPbSubResourceConsumptions(pbResourceConsumption.getSubResourceConsumptionsMap()));
    }

    public PbResourceConsumption toPbResourceConsumption(ResourceConsumption resourceConsumption) {
        return PbResourceConsumption.newBuilder().setDiskBytesWritten(resourceConsumption.diskBytesWritten()).setDiskFileCount(resourceConsumption.diskFileCount()).setHdfsBytesWritten(resourceConsumption.hdfsBytesWritten()).setHdfsFileCount(resourceConsumption.hdfsFileCount()).putAllSubResourceConsumptions(this.toPbSubResourceConsumptions(resourceConsumption.subResourceConsumptions())).build();
    }

    public Map<String, ResourceConsumption> fromPbSubResourceConsumptions(Map<String, PbResourceConsumption> pbSubResourceConsumptions) {
        if (CollectionUtils.isEmpty(pbSubResourceConsumptions)) {
            return null;
        }
        return (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbSubResourceConsumptions).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                PbResourceConsumption pbResourceConsumption = (PbResourceConsumption)tuple2._2();
                return new Tuple2((Object)key, (Object)MODULE$.fromPbResourceConsumption(pbResourceConsumption));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public Map<String, PbResourceConsumption> toPbSubResourceConsumptions(Map<String, ResourceConsumption> subResourceConsumptions) {
        if (CollectionUtils.isEmpty(subResourceConsumptions)) {
            return new HashMap<String, PbResourceConsumption>();
        }
        return (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(subResourceConsumptions).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                ResourceConsumption resourceConsumption = (ResourceConsumption)tuple2._2();
                return new Tuple2((Object)key, (Object)MODULE$.toPbResourceConsumption(resourceConsumption));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public Map<UserIdentifier, ResourceConsumption> fromPbUserResourceConsumption(Map<String, PbResourceConsumption> pbUserResourceConsumption) {
        return (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbUserResourceConsumption).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String userIdentifierString = (String)tuple2._1();
                PbResourceConsumption pbResourceConsumption = (PbResourceConsumption)tuple2._2();
                return new Tuple2((Object)UserIdentifier$.MODULE$.apply(userIdentifierString), (Object)MODULE$.fromPbResourceConsumption(pbResourceConsumption));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public Map<String, PbResourceConsumption> toPbUserResourceConsumption(Map<UserIdentifier, ResourceConsumption> userResourceConsumption) {
        return (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(userResourceConsumption).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                UserIdentifier userIdentifier = (UserIdentifier)tuple2._1();
                ResourceConsumption resourceConsumption = (ResourceConsumption)tuple2._2();
                return new Tuple2((Object)userIdentifier.toString(), (Object)MODULE$.toPbResourceConsumption(resourceConsumption));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public WorkerInfo fromPbWorkerInfo(PbWorkerInfo pbWorkerInfo) {
        WorkerInfo workerInfo;
        block1: {
            ConcurrentHashMap<String, DiskInfo> disks = JavaUtils.newConcurrentHashMap();
            if (pbWorkerInfo.getDisksCount() > 0) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbWorkerInfo.getDisksList()).asScala()).foreach((Function1 & Serializable & scala.Serializable)pbDiskInfo -> disks.put(pbDiskInfo.getMountPoint(), MODULE$.fromPbDiskInfo((PbDiskInfo)pbDiskInfo)));
            }
            Map<UserIdentifier, ResourceConsumption> userResourceConsumption = this.fromPbUserResourceConsumption(pbWorkerInfo.getUserResourceConsumptionMap());
            workerInfo = new WorkerInfo(pbWorkerInfo.getHost(), pbWorkerInfo.getRpcPort(), pbWorkerInfo.getPushPort(), pbWorkerInfo.getFetchPort(), pbWorkerInfo.getReplicatePort(), pbWorkerInfo.getInternalPort(), disks, userResourceConsumption);
            if (!this.masterPersistWorkerNetworkLocation()) break block1;
            workerInfo.networkLocation_$eq(pbWorkerInfo.getNetworkLocation());
        }
        return workerInfo;
    }

    public PbWorkerInfo toPbWorkerInfo(WorkerInfo workerInfo, boolean eliminateUserResourceConsumption, boolean eliminateDiskInfo) {
        Object object;
        PbWorkerInfo.Builder builder = PbWorkerInfo.newBuilder().setHost(workerInfo.host()).setRpcPort(workerInfo.rpcPort()).setFetchPort(workerInfo.fetchPort()).setPushPort(workerInfo.pushPort()).setReplicatePort(workerInfo.replicatePort()).setInternalPort(workerInfo.internalPort());
        Object object2 = this.masterPersistWorkerNetworkLocation() ? builder.setNetworkLocation(workerInfo.networkLocation()) : BoxedUnit.UNIT;
        Object object3 = !eliminateUserResourceConsumption ? builder.putAllUserResourceConsumption(this.toPbUserResourceConsumption(workerInfo.userResourceConsumption())) : BoxedUnit.UNIT;
        if (!eliminateDiskInfo) {
            Collection<DiskInfo> diskInfos = workerInfo.diskInfos().values();
            ArrayList pbDiskInfos = new ArrayList();
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(diskInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)diskInfo -> BoxesRunTime.boxToBoolean((boolean)pbDiskInfos.add(PbSerDeUtils$.MODULE$.toPbDiskInfo(diskInfo))));
            object = builder.addAllDisks(pbDiskInfos);
        } else {
            object = BoxedUnit.UNIT;
        }
        return builder.build();
    }

    public PartitionLocation fromPbPartitionLocation(PbPartitionLocation pbLoc) {
        PartitionLocation partitionLocation;
        block2: {
            PartitionLocation.Mode mode = PartitionLocation.Mode.PRIMARY;
            if (pbLoc.getMode().equals(PbPartitionLocation.Mode.Replica)) {
                mode = PartitionLocation.Mode.REPLICA;
            }
            partitionLocation = new PartitionLocation(pbLoc.getId(), pbLoc.getEpoch(), pbLoc.getHost(), pbLoc.getRpcPort(), pbLoc.getPushPort(), pbLoc.getFetchPort(), pbLoc.getReplicatePort(), mode, null, StorageInfo.fromPb(pbLoc.getStorageInfo()), Utils$.MODULE$.byteStringToRoaringBitmap(pbLoc.getMapIdBitmap()));
            if (!pbLoc.hasPeer()) break block2;
            PbPartitionLocation peerPb = pbLoc.getPeer();
            PartitionLocation.Mode peerMode = PartitionLocation.Mode.PRIMARY;
            if (peerPb.getMode() == PbPartitionLocation.Mode.Replica) {
                peerMode = PartitionLocation.Mode.REPLICA;
            }
            PartitionLocation peerLocation = new PartitionLocation(peerPb.getId(), peerPb.getEpoch(), peerPb.getHost(), peerPb.getRpcPort(), peerPb.getPushPort(), peerPb.getFetchPort(), peerPb.getReplicatePort(), peerMode, partitionLocation, StorageInfo.fromPb(peerPb.getStorageInfo()), Utils$.MODULE$.byteStringToRoaringBitmap(peerPb.getMapIdBitmap()));
            partitionLocation.setPeer(peerLocation);
        }
        return partitionLocation;
    }

    public PbPartitionLocation toPbPartitionLocation(PartitionLocation location) {
        Object object;
        PbPartitionLocation.Builder builder = PbPartitionLocation.newBuilder();
        PbPartitionLocation.Builder builder2 = location.getMode() == PartitionLocation.Mode.PRIMARY ? builder.setMode(PbPartitionLocation.Mode.Primary) : builder.setMode(PbPartitionLocation.Mode.Replica);
        builder.setHost(location.getHost()).setEpoch(location.getEpoch()).setId(location.getId()).setRpcPort(location.getRpcPort()).setPushPort(location.getPushPort()).setFetchPort(location.getFetchPort()).setReplicatePort(location.getReplicatePort()).setStorageInfo(StorageInfo.toPb(location.getStorageInfo())).setMapIdBitmap(Utils$.MODULE$.roaringBitmapToByteString(location.getMapIdBitMap()));
        if (location.hasPeer()) {
            PbPartitionLocation.Builder peerBuilder = PbPartitionLocation.newBuilder();
            PbPartitionLocation.Builder builder3 = location.getPeer().getMode() == PartitionLocation.Mode.PRIMARY ? peerBuilder.setMode(PbPartitionLocation.Mode.Primary) : peerBuilder.setMode(PbPartitionLocation.Mode.Replica);
            peerBuilder.setHost(location.getPeer().getHost()).setEpoch(location.getPeer().getEpoch()).setId(location.getPeer().getId()).setRpcPort(location.getPeer().getRpcPort()).setPushPort(location.getPeer().getPushPort()).setFetchPort(location.getPeer().getFetchPort()).setReplicatePort(location.getPeer().getReplicatePort()).setStorageInfo(StorageInfo.toPb(location.getPeer().getStorageInfo())).setMapIdBitmap(Utils$.MODULE$.roaringBitmapToByteString(location.getMapIdBitMap()));
            object = builder.setPeer(peerBuilder.build());
        } else {
            object = BoxedUnit.UNIT;
        }
        return builder.build();
    }

    public HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>> fromPbWorkerResource(Map<String, PbWorkerResource> pbWorkerResource) {
        HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>> slots = new HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>>();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbWorkerResource).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String uniqueId = (String)tuple2._1();
                PbWorkerResource pbWorkerResource = (PbWorkerResource)tuple2._2();
                String networkLocation = pbWorkerResource.getNetworkLocation();
                WorkerInfo workerInfo = WorkerInfo$.MODULE$.fromUniqueId(uniqueId);
                workerInfo.networkLocation_$eq(networkLocation);
                ArrayList primaryPartitionLocation = new ArrayList((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbWorkerResource.getPrimaryPartitionsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbLoc -> MODULE$.fromPbPartitionLocation((PbPartitionLocation)pbLoc), Buffer$.MODULE$.canBuildFrom())).asJava());
                ArrayList replicaPartitionLocation = new ArrayList((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbWorkerResource.getReplicaPartitionsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbLoc -> MODULE$.fromPbPartitionLocation((PbPartitionLocation)pbLoc), Buffer$.MODULE$.canBuildFrom())).asJava());
                return slots.put(workerInfo, new Tuple2(primaryPartitionLocation, replicaPartitionLocation));
            }
            throw new MatchError((Object)tuple2);
        });
        return slots;
    }

    public Map<String, PbWorkerResource> toPbWorkerResource(HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>> workerResource) {
        return (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(workerResource).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                WorkerInfo workerInfo = (WorkerInfo)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    java.util.List primaryLocations = (java.util.List)tuple22._1();
                    java.util.List replicaLocations = (java.util.List)tuple22._2();
                    java.util.List primaryPartitions = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(primaryLocations).asScala()).map((Function1 & Serializable & scala.Serializable)location -> MODULE$.toPbPartitionLocation((PartitionLocation)location), Buffer$.MODULE$.canBuildFrom())).asJava();
                    java.util.List replicaPartitions = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicaLocations).asScala()).map((Function1 & Serializable & scala.Serializable)location -> MODULE$.toPbPartitionLocation((PartitionLocation)location), Buffer$.MODULE$.canBuildFrom())).asJava();
                    PbWorkerResource pbWorkerResource = PbWorkerResource.newBuilder().addAllPrimaryPartitions(primaryPartitions).addAllReplicaPartitions(replicaPartitions).setNetworkLocation(workerInfo.networkLocation()).build();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)workerInfo.toUniqueId()), (Object)pbWorkerResource);
                }
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public PbSnapshotMetaInfo toPbSnapshotMetaInfo(Long estimatedPartitionSize, Map<String, java.util.Set<Integer>> registeredShuffle, java.util.Set<String> hostnameSet, java.util.Set<WorkerInfo> excludedWorkers, java.util.Set<WorkerInfo> manuallyExcludedWorkers, java.util.Set<WorkerInfo> workerLostEvent, Map<String, Long> appHeartbeatTime, java.util.Set<WorkerInfo> workers, Long partitionTotalWritten, Long partitionTotalFileCount, Long shuffleTotalCount, Long applicationTotalCount, Map<String, Long> shuffleFallbackCounts, Map<String, Long> applicationFallbackCounts, ConcurrentHashMap<WorkerInfo, Long> lostWorkers, java.util.Set<WorkerInfo> shutdownWorkers, ConcurrentHashMap<WorkerInfo, WorkerEventInfo> workerEventInfos, ConcurrentHashMap<String, ApplicationMeta> applicationMetas, java.util.Set<WorkerInfo> decommissionWorkers) {
        PbSnapshotMetaInfo.Builder builder = PbSnapshotMetaInfo.newBuilder().setEstimatedPartitionSize(Predef$.MODULE$.Long2long(estimatedPartitionSize)).addAllRegisteredShuffle((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(registeredShuffle).asScala()).flatMap((Function1 & Serializable & scala.Serializable)appIdAndShuffleId -> (scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter((java.util.Set)appIdAndShuffleId._2()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> Utils$.MODULE$.makeShuffleKey((String)appIdAndShuffleId._1(), Predef$.MODULE$.Integer2int(i)), Set$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).asJava()).addAllHostnameSet(hostnameSet).addAllExcludedWorkers((java.lang.Iterable)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(excludedWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.toPbWorkerInfo((WorkerInfo)x$1, true, false), Set$.MODULE$.canBuildFrom())).asJava()).addAllManuallyExcludedWorkers((java.lang.Iterable)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(manuallyExcludedWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.toPbWorkerInfo((WorkerInfo)x$2, true, false), Set$.MODULE$.canBuildFrom())).asJava()).addAllWorkerLostEvents((java.lang.Iterable)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(workerLostEvent).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.toPbWorkerInfo((WorkerInfo)x$3, true, false), Set$.MODULE$.canBuildFrom())).asJava()).putAllAppHeartbeatTime(appHeartbeatTime).addAllWorkers((java.lang.Iterable)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(workers).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.toPbWorkerInfo((WorkerInfo)x$4, true, false), Set$.MODULE$.canBuildFrom())).asJava()).setPartitionTotalWritten(Predef$.MODULE$.Long2long(partitionTotalWritten)).setPartitionTotalFileCount(Predef$.MODULE$.Long2long(partitionTotalFileCount)).setShuffleTotalCount(Predef$.MODULE$.Long2long(shuffleTotalCount)).setApplicationTotalCount(Predef$.MODULE$.Long2long(applicationTotalCount)).putAllShuffleFallbackCounts(shuffleFallbackCounts).putAllApplicationFallbackCounts(applicationFallbackCounts).putAllLostWorkers((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(lostWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                WorkerInfo worker = (WorkerInfo)tuple2._1();
                Long time = (Long)tuple2._2();
                if (worker != null) {
                    WorkerInfo workerInfo = worker;
                    if (time != null) {
                        Long l = time;
                        return new Tuple2((Object)workerInfo.toUniqueId(), (Object)l);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava()).addAllShutdownWorkers((java.lang.Iterable)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(shutdownWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.toPbWorkerInfo((WorkerInfo)x$5, true, false), Set$.MODULE$.canBuildFrom())).asJava()).putAllWorkerEventInfos((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(workerEventInfos).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                WorkerInfo worker = (WorkerInfo)tuple2._1();
                WorkerEventInfo workerEventInfo = (WorkerEventInfo)tuple2._2();
                return new Tuple2((Object)worker.toUniqueId(), (Object)MODULE$.toPbWorkerEventInfo(workerEventInfo));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava()).addAllDecommissionWorkers((java.lang.Iterable)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(decommissionWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.toPbWorkerInfo((WorkerInfo)x$6, true, false), Set$.MODULE$.canBuildFrom())).asJava());
        Map pbApplicationMetas = (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(applicationMetas).asScala()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                String appId = (String)tuple2._1();
                ApplicationMeta applicationMeta = (ApplicationMeta)tuple2._2();
                return new Tuple2((Object)appId, (Object)MODULE$.toPbApplicationMeta(applicationMeta));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava();
        Object object = CollectionUtils.isNotEmpty(pbApplicationMetas) ? builder.putAllApplicationMetas(pbApplicationMetas) : BoxedUnit.UNIT;
        return builder.build();
    }

    public PbApplicationMeta toPbApplicationMeta(ApplicationMeta meta) {
        return PbApplicationMeta.newBuilder().setAppId(meta.appId()).setSecret(meta.secret()).build();
    }

    public ApplicationMeta fromPbApplicationMeta(PbApplicationMeta pbApplicationMeta) {
        return new ApplicationMeta(pbApplicationMeta.getAppId(), pbApplicationMeta.getSecret());
    }

    public PbWorkerStatus toPbWorkerStatus(WorkerStatus workerStatus) {
        return PbWorkerStatus.newBuilder().setState(workerStatus.getState()).setStateStartTime(workerStatus.getStateStartTime()).build();
    }

    public WorkerStatus fromPbWorkerStatus(PbWorkerStatus pbWorkerStatus) {
        return new WorkerStatus(pbWorkerStatus.getState().getNumber(), pbWorkerStatus.getStateStartTime());
    }

    public PbWorkerEventInfo toPbWorkerEventInfo(WorkerEventInfo workerEventInfo) {
        return PbWorkerEventInfo.newBuilder().setEventStartTime(workerEventInfo.getEventStartTime()).setWorkerEventType(workerEventInfo.getEventType()).build();
    }

    public WorkerEventInfo fromPbWorkerEventInfo(PbWorkerEventInfo pbWorkerEventInfo) {
        return new WorkerEventInfo(pbWorkerEventInfo.getWorkerEventType().getNumber(), pbWorkerEventInfo.getEventStartTime());
    }

    private PbPackedPartitionLocations.Builder toPackedPartitionLocation(PbPackedPartitionLocations.Builder pbPackedLocationsBuilder, scala.collection.immutable.Map<String, Object> workerIdIndex, scala.collection.immutable.Map<String, Object> mountPointsIndex, PartitionLocation location) {
        PbPackedPartitionLocations.Builder builder;
        pbPackedLocationsBuilder.addIds(location.getId());
        pbPackedLocationsBuilder.addEpoches(location.getEpoch());
        pbPackedLocationsBuilder.addWorkerIds(BoxesRunTime.unboxToInt((Object)workerIdIndex.apply((Object)location.getWorker().toUniqueId())));
        pbPackedLocationsBuilder.addMapIdBitMap(Utils$.MODULE$.roaringBitmapToByteString(location.getMapIdBitMap()));
        pbPackedLocationsBuilder.addTypes(location.getStorageInfo().getType().getValue());
        pbPackedLocationsBuilder.addMountPoints(BoxesRunTime.unboxToInt((Object)mountPointsIndex.apply((Object)location.getStorageInfo().getMountPoint())));
        pbPackedLocationsBuilder.addFinalResult(location.getStorageInfo().isFinalResult());
        PbPackedPartitionLocations.Builder builder2 = location.getStorageInfo().getFilePath() != null && new StringOps(Predef$.MODULE$.augmentString(location.getStorageInfo().getFilePath())).nonEmpty() ? pbPackedLocationsBuilder.addFilePaths(location.getStorageInfo().getFilePath().substring(location.getStorageInfo().getMountPoint().length())) : pbPackedLocationsBuilder.addFilePaths("");
        pbPackedLocationsBuilder.addAvailableStorageTypes(location.getStorageInfo().availableStorageTypes);
        pbPackedLocationsBuilder.addFileSizes(location.getStorageInfo().getFileSize());
        PbChunkOffsets.Builder chunkOffsets = PbChunkOffsets.newBuilder();
        if (location.getStorageInfo().chunkOffsets != null && !location.getStorageInfo().chunkOffsets.isEmpty()) {
            chunkOffsets.addAllChunkOffset(location.getStorageInfo().chunkOffsets).build();
            builder = pbPackedLocationsBuilder.addChunksOffsets(chunkOffsets);
        } else {
            builder = pbPackedLocationsBuilder.addChunksOffsets(chunkOffsets.build());
        }
        return pbPackedLocationsBuilder.addModes(location.getMode().mode());
    }

    public PbPackedPartitionLocationsPair toPbPackedPartitionLocationsPair(List<PartitionLocation> inputLocations) {
        PbPackedPartitionLocationsPair.Builder packedLocationPairsBuilder = PbPackedPartitionLocationsPair.newBuilder();
        PbPackedPartitionLocations.Builder packedLocationsBuilder = PbPackedPartitionLocations.newBuilder();
        List implicateLocations = (List)((TraversableLike)inputLocations.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getPeer(), List$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)PbSerDeUtils$.$anonfun$toPbPackedPartitionLocationsPair$2(x$8)));
        List allLocations = (List)inputLocations.$plus$plus((GenTraversableOnce)implicateLocations, List$.MODULE$.canBuildFrom());
        ArrayList<String> workerIdList = new ArrayList<String>((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)allLocations.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.getWorker().toUniqueId(), List$.MODULE$.canBuildFrom())).toSet()).asJava());
        scala.collection.immutable.Map workerIdIndex = ((TraversableOnce)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(workerIdList).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ArrayList<String> mountPointsList = new ArrayList<String>((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)allLocations.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getStorageInfo().getMountPoint(), List$.MODULE$.canBuildFrom())).toSet()).asJava());
        scala.collection.immutable.Map mountPointsIndex = ((TraversableOnce)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(mountPointsList).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        packedLocationsBuilder.addAllWorkerIdsSet(workerIdList);
        packedLocationsBuilder.addAllMountPointsSet(mountPointsList);
        scala.collection.immutable.Map locationIndexes = ((TraversableOnce)allLocations.zipWithIndex(List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        allLocations.foreach((Function1 & Serializable & scala.Serializable)location -> {
            MODULE$.toPackedPartitionLocation(packedLocationsBuilder, (scala.collection.immutable.Map<String, Object>)workerIdIndex, (scala.collection.immutable.Map<String, Object>)mountPointsIndex, (PartitionLocation)location);
            if (location.getPeer() != null) {
                return packedLocationPairsBuilder.addPeerIndexes(BoxesRunTime.unboxToInt((Object)locationIndexes.apply((Object)location.getPeer())));
            }
            return packedLocationPairsBuilder.addPeerIndexes(Integer.MAX_VALUE);
        });
        packedLocationPairsBuilder.setInputLocationSize(inputLocations.size());
        return packedLocationPairsBuilder.setLocations(packedLocationsBuilder.build()).build();
    }

    public Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>> fromPbPackedPartitionLocationsPair(PbPackedPartitionLocationsPair pbPartitionLocationsPair) {
        int index;
        ArrayList<PartitionLocation> primaryLocations = new ArrayList<PartitionLocation>();
        ArrayList<PartitionLocation> replicateLocations = new ArrayList<PartitionLocation>();
        PbPackedPartitionLocations pbPackedPartitionLocations = pbPartitionLocationsPair.getLocations();
        int inputLocationSize = pbPartitionLocationsPair.getInputLocationSize();
        java.util.List<Integer> idList = pbPackedPartitionLocations.getIdsList();
        int locationCount = idList.size();
        ArrayList<PartitionLocation> locations = new ArrayList<PartitionLocation>();
        for (index = 0; index < locationCount; ++index) {
            Object object;
            PartitionLocation loc = this.fromPackedPartitionLocations(pbPackedPartitionLocations, index);
            if (index < inputLocationSize) {
                PartitionLocation.Mode mode = loc.getMode();
                PartitionLocation.Mode mode2 = PartitionLocation.Mode.PRIMARY;
                object = BoxesRunTime.boxToBoolean((boolean)(!(mode != null ? !((Object)((Object)mode)).equals((Object)mode2) : mode2 != null) ? primaryLocations.add(loc) : replicateLocations.add(loc)));
            } else {
                object = BoxedUnit.UNIT;
            }
            locations.add(loc);
        }
        for (index = 0; index < locationCount; ++index) {
            int replicateIndex = pbPartitionLocationsPair.getPeerIndexes(index);
            if (replicateIndex == Integer.MAX_VALUE) continue;
            ((PartitionLocation)locations.get(index)).setPeer((PartitionLocation)locations.get(replicateIndex));
        }
        return new Tuple2(primaryLocations, replicateLocations);
    }

    private PartitionLocation fromPackedPartitionLocations(PbPackedPartitionLocations pbPackedPartitionLocations, int index) {
        String filePath;
        String[] workerIdParts = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.parseColonSeparatedHostPorts(pbPackedPartitionLocations.getWorkerIdsSet(pbPackedPartitionLocations.getWorkerIds(index)), 4))).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String string = filePath = pbPackedPartitionLocations.getFilePaths(index);
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            filePath = new StringBuilder(0).append(pbPackedPartitionLocations.getMountPointsSet(pbPackedPartitionLocations.getMountPoints(index))).append(pbPackedPartitionLocations.getFilePaths(index)).toString();
        }
        PartitionLocation.Mode mode = pbPackedPartitionLocations.getModes(index) == PartitionLocation.Mode.PRIMARY.mode() ? PartitionLocation.Mode.PRIMARY : PartitionLocation.Mode.REPLICA;
        StorageInfo storageInfo = pbPackedPartitionLocations.getFileSizesList().isEmpty() || pbPackedPartitionLocations.getChunksOffsetsList().isEmpty() ? new StorageInfo(StorageInfo.typesMap.get(BoxesRunTime.boxToInteger((int)pbPackedPartitionLocations.getTypes(index))), pbPackedPartitionLocations.getMountPointsSet(pbPackedPartitionLocations.getMountPoints(index)), pbPackedPartitionLocations.getFinalResult(index), filePath, pbPackedPartitionLocations.getAvailableStorageTypes(index)) : new StorageInfo(StorageInfo.typesMap.get(BoxesRunTime.boxToInteger((int)pbPackedPartitionLocations.getTypes(index))), pbPackedPartitionLocations.getMountPointsSet(pbPackedPartitionLocations.getMountPoints(index)), pbPackedPartitionLocations.getFinalResult(index), filePath, pbPackedPartitionLocations.getAvailableStorageTypes(index), pbPackedPartitionLocations.getFileSizes(index), pbPackedPartitionLocations.getChunksOffsets(index).getChunkOffsetList());
        return new PartitionLocation(pbPackedPartitionLocations.getIds(index), pbPackedPartitionLocations.getEpoches(index), workerIdParts[0], new StringOps(Predef$.MODULE$.augmentString(workerIdParts[1])).toInt(), new StringOps(Predef$.MODULE$.augmentString(workerIdParts[2])).toInt(), new StringOps(Predef$.MODULE$.augmentString(workerIdParts[3])).toInt(), new StringOps(Predef$.MODULE$.augmentString(workerIdParts[4])).toInt(), mode, null, storageInfo, Utils$.MODULE$.byteStringToRoaringBitmap(pbPackedPartitionLocations.getMapIdBitMap(index)));
    }

    public HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>> fromPbPackedWorkerResource(Map<String, PbPackedWorkerResource> pbWorkerResource) {
        HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>> slots = new HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>>();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbWorkerResource).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String uniqueId = (String)tuple2._1();
                PbPackedWorkerResource pbPackedWorkerResource = (PbPackedWorkerResource)tuple2._2();
                String networkLocation = pbPackedWorkerResource.getNetworkLocation();
                WorkerInfo workerInfo = WorkerInfo$.MODULE$.fromUniqueId(uniqueId);
                workerInfo.networkLocation_$eq(networkLocation);
                Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>> tuple22 = MODULE$.fromPbPackedPartitionLocationsPair(pbPackedWorkerResource.getLocationPairs());
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                java.util.List primaryLocations = (java.util.List)tuple22._1();
                java.util.List replicateLocations = (java.util.List)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)primaryLocations, (Object)replicateLocations);
                java.util.List primaryLocations2 = (java.util.List)tuple23._1();
                java.util.List replicateLocations2 = (java.util.List)tuple23._2();
                return slots.put(workerInfo, new Tuple2((Object)primaryLocations2, (Object)replicateLocations2));
            }
            throw new MatchError((Object)tuple2);
        });
        return slots;
    }

    public Map<String, PbPackedWorkerResource> toPbPackedWorkerResource(HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>> workerResource) {
        return (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(workerResource).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                WorkerInfo workerInfo = (WorkerInfo)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    java.util.List primaryLocations = (java.util.List)tuple22._1();
                    java.util.List replicaLocations = (java.util.List)tuple22._2();
                    PbPackedWorkerResource pbWorkerResource = PbPackedWorkerResource.newBuilder().setLocationPairs(MODULE$.toPbPackedPartitionLocationsPair((List<PartitionLocation>)((List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(primaryLocations).asScala()).toList().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(replicaLocations).asScala()).toList(), List$.MODULE$.canBuildFrom())))).setNetworkLocation(workerInfo.networkLocation()).build();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)workerInfo.toUniqueId()), (Object)pbWorkerResource);
                }
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public PbFailedBatches toPbFailedBatches(java.util.Set<Object> failedBatches) {
        return PbFailedBatches.newBuilder().addAllFailedBatches((java.lang.Iterable)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(failedBatches).asScala()).map((Function1 & Serializable & scala.Serializable)x$13 -> PbSerDeUtils$.$anonfun$toPbFailedBatches$1(BoxesRunTime.unboxToInt((Object)x$13)), Set$.MODULE$.canBuildFrom())).asJava()).build();
    }

    public java.util.Set<Object> fromPbFailedBatches(PbFailedBatches failedBatches) {
        return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(failedBatches.getFailedBatchesList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14), Buffer$.MODULE$.canBuildFrom())).toSet()).asJava();
    }

    public PbLocationPushFailedBatches toPbLocationPushFailedBatches(LocationPushFailedBatches locationPushFailedBatches) {
        PbLocationPushFailedBatches.Builder builder = PbLocationPushFailedBatches.newBuilder();
        builder.putAllFailedBatches((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(locationPushFailedBatches.getFailedBatches()).asScala()).map((Function1 & Serializable & scala.Serializable)item -> new Tuple2(item._1(), (Object)MODULE$.toPbFailedBatches((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter((java.util.Set)item._2()).asScala()).map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15), Set$.MODULE$.canBuildFrom())).toSet()).asJava())), Map$.MODULE$.canBuildFrom())).asJava());
        return builder.build();
    }

    public LocationPushFailedBatches fromPbLocationPushFailedBatches(PbLocationPushFailedBatches pbLocationPushFailedBatches) {
        LocationPushFailedBatches batches = new LocationPushFailedBatches();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbLocationPushFailedBatches.getFailedBatchesMap()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                PbFailedBatches value = (PbFailedBatches)tuple2._2();
                return batches.getFailedBatches().put(key, (java.util.Set<Integer>)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(MODULE$.fromPbFailedBatches(value)).asScala()).map((Function1 & Serializable & scala.Serializable)x$16 -> PbSerDeUtils$.$anonfun$fromPbLocationPushFailedBatches$2(BoxesRunTime.unboxToInt((Object)x$16)), Set$.MODULE$.canBuildFrom())).asJava());
            }
            throw new MatchError((Object)tuple2);
        });
        return batches;
    }

    public static final /* synthetic */ boolean $anonfun$toPbPackedPartitionLocationsPair$2(PartitionLocation x$8) {
        return x$8 == null;
    }

    public static final /* synthetic */ Integer $anonfun$toPbFailedBatches$1(int x$13) {
        return new Integer(x$13);
    }

    public static final /* synthetic */ Integer $anonfun$fromPbLocationPushFailedBatches$2(int x$16) {
        return new Integer(x$16);
    }

    private PbSerDeUtils$() {
        MODULE$ = this;
        this.masterPersistWorkerNetworkLocation = false;
    }
}

