/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.shuffledb;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.celeborn.common.util.PbSerDeUtils;
import org.apache.celeborn.service.deploy.worker.shuffledb.StoreVersion;
import org.apache.commons.io.FileUtils;
import org.fusesource.leveldbjni.JniDBFactory;
import org.fusesource.leveldbjni.internal.NativeDB;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelDBProvider {
    private static final Logger logger = LoggerFactory.getLogger(LevelDBProvider.class);

    public static DB initLevelDB(File dbFile, StoreVersion version) throws IOException {
        DB tmpDb = null;
        if (dbFile != null) {
            Options options = new Options();
            options.createIfMissing(false);
            options.logger((org.iq80.leveldb.Logger)new LevelDBLogger());
            try {
                tmpDb = JniDBFactory.factory.open(dbFile, options);
            }
            catch (NativeDB.DBException e) {
                if (e.isNotFound() || e.getMessage().contains(" does not exist ")) {
                    logger.info("Creating state database at " + dbFile);
                    LevelDBProvider.createIfMissing(options, dbFile);
                    try {
                        tmpDb = JniDBFactory.factory.open(dbFile, options);
                    }
                    catch (NativeDB.DBException dbExc) {
                        throw new IOException("Unable to create state store", dbExc);
                    }
                }
                logger.error("Error opening leveldb file {}.  Creating new file, will not be able to recover state for existing applications", (Object)dbFile, (Object)e);
                if (dbFile.isDirectory()) {
                    for (File f : dbFile.listFiles()) {
                        if (f.delete()) continue;
                        logger.warn("Error deleting {}", (Object)f.getPath());
                    }
                }
                if (!dbFile.delete()) {
                    logger.warn("Error deleting {}", (Object)dbFile.getPath());
                }
                LevelDBProvider.createIfMissing(options, dbFile);
                try {
                    tmpDb = JniDBFactory.factory.open(dbFile, options);
                }
                catch (NativeDB.DBException dbExc) {
                    throw new IOException("Unable to create state store", dbExc);
                }
            }
            try {
                LevelDBProvider.checkVersion(tmpDb, version);
            }
            catch (IOException ioe) {
                tmpDb.close();
                throw ioe;
            }
        }
        return tmpDb;
    }

    private static void createIfMissing(Options dbOptions, File dbFile) {
        logger.info("Creating database file {} if missing", (Object)dbFile);
        dbOptions.createIfMissing(true);
        if (!dbFile.exists()) {
            try {
                FileUtils.forceMkdir((File)dbFile);
            }
            catch (IOException e) {
                logger.warn("Failed to create database file {}", (Object)dbFile, (Object)e);
            }
        }
    }

    public static void checkVersion(DB db, StoreVersion newVersion) throws IOException {
        byte[] bytes = db.get(StoreVersion.KEY);
        if (bytes == null) {
            LevelDBProvider.storeVersion(db, newVersion);
        } else {
            ArrayList versions = PbSerDeUtils.fromPbStoreVersion((byte[])bytes);
            StoreVersion version = new StoreVersion((Integer)versions.get(0), (Integer)versions.get(1));
            if (version.major != newVersion.major) {
                throw new IOException("Cannot read state DB with version " + version + ", incompatible with current version " + newVersion);
            }
            LevelDBProvider.storeVersion(db, newVersion);
        }
    }

    public static void storeVersion(DB db, StoreVersion version) {
        db.put(StoreVersion.KEY, PbSerDeUtils.toPbStoreVersion((int)version.major, (int)version.minor));
    }

    private static class LevelDBLogger
    implements org.iq80.leveldb.Logger {
        private static final Logger LOG = LoggerFactory.getLogger(LevelDBLogger.class);

        private LevelDBLogger() {
        }

        public void log(String message) {
            LOG.info(message);
        }
    }
}

