/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.shuffledb;

import java.io.File;
import java.io.IOException;
import org.apache.celeborn.service.deploy.worker.shuffledb.DB;
import org.apache.celeborn.service.deploy.worker.shuffledb.DBBackend;
import org.apache.celeborn.service.deploy.worker.shuffledb.LevelDB;
import org.apache.celeborn.service.deploy.worker.shuffledb.LevelDBProvider;
import org.apache.celeborn.service.deploy.worker.shuffledb.RocksDB;
import org.apache.celeborn.service.deploy.worker.shuffledb.RocksDBProvider;
import org.apache.celeborn.service.deploy.worker.shuffledb.StoreVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBProvider {
    private static final Logger logger = LoggerFactory.getLogger(DBProvider.class);

    public static DB initDB(DBBackend dbBackend, File dbFile, StoreVersion version) throws IOException {
        if (dbFile != null) {
            switch (dbBackend) {
                case LEVELDB: {
                    org.iq80.leveldb.DB levelDB = LevelDBProvider.initLevelDB(dbFile, version);
                    logger.warn("The LEVELDB is deprecated. Please use ROCKSDB instead.");
                    return levelDB != null ? new LevelDB(levelDB) : null;
                }
                case ROCKSDB: {
                    org.rocksdb.RocksDB rocksDB = RocksDBProvider.initRockDB(dbFile, version);
                    return rocksDB != null ? new RocksDB(rocksDB) : null;
                }
            }
            throw new IllegalArgumentException("Unsupported DBBackend: " + (Object)((Object)dbBackend));
        }
        return null;
    }
}

