/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.ssl;

import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.UUID;

class SSLUtils {
    static final String KEY_PAIR_ALGORITHM = System.getProperty("celeborn.SSLUtils.KEY_PAIR_ALGORITHM", "RSA");
    static final int KEY_PAIR_STRENGTH = Integer.getInteger("celeborn.SSLUtils.KEY_PAIR_STRENGTH", 2048);
    static final long CERTIFICATE_VALIDITY = Long.getLong("celeborn.SSLUtils.CERTIFICATE_VALIDITY_DAYS", 365L) * 24L * 60L * 60L * 1000L;

    SSLUtils() {
    }

    static void generateSelfSignedCertificate(SelfSignedCertificateConfig config) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        PrivateKey privateKey = cert.key();
        X509Certificate certificate = cert.cert();
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        keyStore.setKeyEntry(config.alias, privateKey, config.keyPassword.toCharArray(), new X509Certificate[]{certificate});
        try (FileOutputStream outputStream = new FileOutputStream(config.keystoreFile);){
            keyStore.store(outputStream, config.keystorePassword.toCharArray());
        }
    }

    static class SelfSignedCertificateConfig {
        final File keystoreFile;
        final String alias;
        final String keystorePassword;
        final String keyPassword;

        SelfSignedCertificateConfig() throws IOException {
            this(SelfSignedCertificateConfig.createTempJksFile(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString());
        }

        SelfSignedCertificateConfig(File keystoreFile, String alias, String keystorePassword, String keyPassword) {
            this.keystoreFile = keystoreFile;
            this.alias = alias;
            this.keystorePassword = keystorePassword;
            this.keyPassword = keyPassword;
        }

        private static File createTempJksFile() throws IOException {
            File keystoreFile = File.createTempFile("auto-ssl-", ".jks");
            keystoreFile.deleteOnExit();
            return keystoreFile;
        }
    }
}

