/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DiskFileInfo;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.meta.MemoryFileInfo;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.service.deploy.worker.memory.MemoryManager;
import org.apache.celeborn.service.deploy.worker.storage.DfsTierWriter;
import org.apache.celeborn.service.deploy.worker.storage.FlushNotifier;
import org.apache.celeborn.service.deploy.worker.storage.Flusher;
import org.apache.celeborn.service.deploy.worker.storage.LocalTierWriter;
import org.apache.celeborn.service.deploy.worker.storage.MapPartitionMetaHandler;
import org.apache.celeborn.service.deploy.worker.storage.MemoryTierWriter;
import org.apache.celeborn.service.deploy.worker.storage.PartitionDataWriterContext;
import org.apache.celeborn.service.deploy.worker.storage.PartitionMetaHandler;
import org.apache.celeborn.service.deploy.worker.storage.ReducePartitionMetaHandler;
import org.apache.celeborn.service.deploy.worker.storage.SegmentMapPartitionMetaHandler;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.apache.celeborn.service.deploy.worker.storage.TierWriterBase;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.GenSeqLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001\u0002\b\u0010\u0001yA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001B\u0001B\u0003%\u0001\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0004F\u0001\t\u0007I\u0011\u0002$\t\ry\u0003\u0001\u0015!\u0003H\u0011\u001dy\u0006A1A\u0005\n\u0001Da!\u001a\u0001!\u0002\u0013\t\u0007\"\u00024\u0001\t\u00039\u0007bBA\u000e\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u00037\u0001A\u0011AA\u0014\u0011%\ty\u0004AI\u0001\n\u0003\t\t\u0005C\u0005\u0002X\u0001\t\n\u0011\"\u0001\u0002Z\ti1\u000b^8sC\u001e,\u0007k\u001c7jGfT!\u0001E\t\u0002\u000fM$xN]1hK*\u0011!cE\u0001\u0007o>\u00148.\u001a:\u000b\u0005Q)\u0012A\u00023fa2|\u0017P\u0003\u0002\u0017/\u000591/\u001a:wS\u000e,'B\u0001\r\u001a\u0003!\u0019W\r\\3c_Jt'B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001?\u0015\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u0014,\u001b\u00059#B\u0001\u0015*\u0003!Ig\u000e^3s]\u0006d'B\u0001\u0016\u0018\u0003\u0019\u0019w.\\7p]&\u0011Af\n\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0011\u0005=\u0002T\"A\u0015\n\u0005EJ#\u0001D\"fY\u0016\u0014wN\u001d8D_:4\u0017AD:u_J\fw-Z'b]\u0006<WM\u001d\t\u0003iUj\u0011aD\u0005\u0003m=\u0011ab\u0015;pe\u0006<W-T1oC\u001e,'/\u0001\u0004t_V\u00148-\u001a\t\u0003suj\u0011A\u000f\u0006\u0003omR!\u0001P\u0015\u0002\u000f5,GO]5dg&\u0011aH\u000f\u0002\u000f\u0003\n\u001cHO]1diN{WO]2f\u0003\u0019a\u0014N\\5u}Q!\u0011IQ\"E!\t!\u0004\u0001C\u0003.\t\u0001\u0007a\u0006C\u00033\t\u0001\u00071\u0007C\u00038\t\u0001\u0007\u0001(A\bde\u0016\fG/\u001a$jY\u0016|%\u000fZ3s+\u00059\u0005c\u0001\u0011I\u0015&\u0011\u0011*\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007-\u001bfK\u0004\u0002M#:\u0011Q\nU\u0007\u0002\u001d*\u0011q*H\u0001\u0007yI|w\u000e\u001e \n\u0003\tJ!AU\u0011\u0002\u000fA\f7m[1hK&\u0011A+\u0016\u0002\u0005\u0019&\u001cHO\u0003\u0002SCA\u0011qk\u0017\b\u00031f\u0003\"!T\u0011\n\u0005i\u000b\u0013A\u0002)sK\u0012,g-\u0003\u0002];\n11\u000b\u001e:j]\u001eT!AW\u0011\u0002!\r\u0014X-\u0019;f\r&dWm\u0014:eKJ\u0004\u0013AD3wS\u000e$h)\u001b7f\u001fJ$WM]\u000b\u0002CB\u0019\u0001\u0005\u00132\u0011\t]\u001bgKS\u0005\u0003Iv\u00131!T1q\u0003=)g/[2u\r&dWm\u0014:eKJ\u0004\u0013\u0001F4fi\u00163\u0018n\u0019;fI\u001aKG.Z,sSR,'\u000fF\u0004iW6\u0014(0!\u0005\u0011\u0005QJ\u0017B\u00016\u0010\u00059!\u0016.\u001a:Xe&$XM\u001d\"bg\u0016DQ\u0001\\\u0005A\u0002!\fAbY3mK\n|'O\u001c$jY\u0016DQA\\\u0005A\u0002=\f!\u0004]1si&$\u0018n\u001c8ECR\fwK]5uKJ\u001cuN\u001c;fqR\u0004\"\u0001\u000e9\n\u0005E|!A\u0007)beRLG/[8o\t\u0006$\u0018m\u0016:ji\u0016\u00148i\u001c8uKb$\b\"B:\n\u0001\u0004!\u0018!\u00049beRLG/[8o)f\u0004X\r\u0005\u0002vq6\taO\u0003\u0002xS\u0005A\u0001O]8u_\u000e|G.\u0003\u0002zm\ni\u0001+\u0019:uSRLwN\u001c+za\u0016DQa_\u0005A\u0002q\f\u0001C\\;n!\u0016tG-\u001b8h/JLG/Z:\u0011\u0007u\fi!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u0007CR|W.[2\u000b\t\u0005\r\u0011QA\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\u0004\u0003\u0013\tA!\u001e;jY*\u0011\u00111B\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0010y\u0014Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\bbBA\n\u0013\u0001\u0007\u0011QC\u0001\t]>$\u0018NZ5feB\u0019A'a\u0006\n\u0007\u0005eqBA\u0007GYV\u001c\bNT8uS\u001aLWM]\u0001\u0011GJ,\u0017\r^3GS2,wK]5uKJ$\u0012\u0002[A\u0010\u0003C\t\u0019#!\n\t\u000b9T\u0001\u0019A8\t\u000bMT\u0001\u0019\u0001;\t\u000bmT\u0001\u0019\u0001?\t\u000f\u0005M!\u00021\u0001\u0002\u0016Qi\u0001.!\u000b\u0002,\u00055\u0012qFA\u0019\u0003kAQA\\\u0006A\u0002=DQa]\u0006A\u0002QDQa_\u0006A\u0002qDq!a\u0005\f\u0001\u0004\t)\u0002\u0003\u0005\u00024-\u0001\n\u00111\u0001H\u0003\u0015y'\u000fZ3s\u0011%\t9d\u0003I\u0001\u0002\u0004\tI$A\u0003fm&\u001cG\u000fE\u0002!\u0003wI1!!\u0010\"\u0005\u001d\u0011un\u001c7fC:\f!d\u0019:fCR,g)\u001b7f/JLG/\u001a:%I\u00164\u0017-\u001e7uIU*\"!a\u0011+\u0007\u001d\u000b)e\u000b\u0002\u0002HA!\u0011\u0011JA*\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013!C;oG\",7m[3e\u0015\r\t\t&I\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA+\u0003\u0017\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003i\u0019'/Z1uK\u001aKG.Z,sSR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\tYF\u000b\u0003\u0002:\u0005\u0015\u0003")
public class StoragePolicy
implements Logging {
    private final CelebornConf conf;
    private final StorageManager storageManager;
    private final AbstractSource source;
    private final Option<List<String>> createFileOrder;
    private final Option<Map<String, List<String>>> evictFileOrder;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        StoragePolicy storagePolicy = this;
        synchronized (storagePolicy) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    private Option<List<String>> createFileOrder() {
        return this.createFileOrder;
    }

    private Option<Map<String, List<String>>> evictFileOrder() {
        return this.evictFileOrder;
    }

    public TierWriterBase getEvictedFileWriter(TierWriterBase celebornFile, PartitionDataWriterContext partitionDataWriterContext, PartitionType partitionType, AtomicInteger numPendingWrites, FlushNotifier notifier) {
        TierWriterBase tierWriterBase;
        Object object = new Object();
        try {
            this.evictFileOrder().foreach((Function1 & Serializable & scala.Serializable)order -> {
                StoragePolicy.$anonfun$getEvictedFileWriter$1(this, celebornFile, object, partitionDataWriterContext, partitionType, numPendingWrites, notifier, order);
                return BoxedUnit.UNIT;
            });
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Create evict file failed for ").append(partitionDataWriterContext.getPartitionLocation()).toString());
            tierWriterBase = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tierWriterBase = (TierWriterBase)ex.value();
            }
            throw ex;
        }
        return tierWriterBase;
    }

    public TierWriterBase createFileWriter(PartitionDataWriterContext partitionDataWriterContext, PartitionType partitionType, AtomicInteger numPendingWrites, FlushNotifier notifier) {
        return this.createFileWriter(partitionDataWriterContext, partitionType, numPendingWrites, notifier, this.createFileOrder(), this.createFileWriter$default$6());
    }

    public TierWriterBase createFileWriter(PartitionDataWriterContext partitionDataWriterContext, PartitionType partitionType, AtomicInteger numPendingWrites, FlushNotifier notifier, Option<List<String>> order, boolean evict) {
        Object object = new Object();
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("create file for ").append(partitionDataWriterContext.getShuffleKey()).append(" ").append(partitionDataWriterContext.getPartitionLocation().getFileName()).toString());
            PartitionLocation location = partitionDataWriterContext.getPartitionLocation();
            if (location == null) {
                throw new IllegalStateException("Partition data writer context can not have null partition location");
            }
            if (order.isEmpty()) {
                throw new CelebornIOException("Create file order can not be empty, check your configs");
            }
            int tryCreateFileTypeIndex = evict ? 0 : ((GenSeqLike)order.get()).indexOf((Object)partitionDataWriterContext.getPartitionLocation().getStorageInfo().getType().name());
            int maxSize = ((LinearSeqOptimized)order.get()).length();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(tryCreateFileTypeIndex), maxSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                String storageStr = (String)((LinearSeqOptimized)order.get()).apply(i);
                StorageInfo.Type storageInfoType = StorageInfo.fromStrToType((String)storageStr);
                TierWriterBase file = this.tryCreateFileByType$1(storageInfoType, location, partitionDataWriterContext, numPendingWrites, notifier, partitionType);
                if (file != null) {
                    throw new NonLocalReturnControl(object, (Object)file);
                }
            });
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Could not create file for storage type ").append(location.getStorageInfo().getType()).toString());
            throw new CelebornIOException(new StringBuilder(31).append("Create file failed for context ").append(partitionDataWriterContext.toString()).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (TierWriterBase)ex.value();
        }
    }

    public Option<List<String>> createFileWriter$default$5() {
        return this.createFileOrder();
    }

    public boolean createFileWriter$default$6() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$getEvictedFileWriter$1(StoragePolicy $this, TierWriterBase celebornFile$1, Object nonLocalReturnKey1$1, PartitionDataWriterContext partitionDataWriterContext$1, PartitionType partitionType$1, AtomicInteger numPendingWrites$1, FlushNotifier notifier$1, Map order) {
        Option orderList = order.get((Object)celebornFile$1.storageType().name());
        if (orderList != null) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)$this.createFileWriter(partitionDataWriterContext$1, partitionType$1, numPendingWrites$1, notifier$1, (Option<List<String>>)orderList, true));
        }
    }

    private static final PartitionMetaHandler getPartitionMetaHandler$1(FileInfo fileInfo, PartitionType partitionType$2, PartitionDataWriterContext partitionDataWriterContext$2, FlushNotifier notifier$2) {
        PartitionType partitionType = partitionType$2;
        if (PartitionType.REDUCE.equals(partitionType)) {
            return new ReducePartitionMetaHandler(partitionDataWriterContext$2.isRangeReadFilter(), fileInfo);
        }
        if (PartitionType.MAP.equals(partitionType)) {
            if (partitionDataWriterContext$2.isSegmentGranularityVisible()) {
                return new SegmentMapPartitionMetaHandler((DiskFileInfo)fileInfo, notifier$2);
            }
            return new MapPartitionMetaHandler((DiskFileInfo)fileInfo, notifier$2);
        }
        if (PartitionType.MAPGROUP.equals(partitionType)) {
            return null;
        }
        throw new MatchError((Object)partitionType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final TierWriterBase tryCreateFileByType$1(StorageInfo.Type storageInfoType, PartitionLocation location$1, PartitionDataWriterContext partitionDataWriterContext$2, AtomicInteger numPendingWrites$2, FlushNotifier notifier$2, PartitionType partitionType$2) {
        try {
            PartitionMetaHandler metaHandler;
            DiskFileInfo diskFileInfo;
            Flusher flusher;
            TierWriterBase tierWriterBase;
            block8: {
                block7: {
                    StorageInfo.Type type = storageInfoType;
                    if (StorageInfo.Type.MEMORY.equals(type)) {
                        if (!location$1.getStorageInfo().memoryAvailable()) return null;
                        if (!MemoryManager.instance().memoryFileStorageAvailable()) return null;
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Create memory file for ").append(partitionDataWriterContext$2.getShuffleKey()).append(" ").append(partitionDataWriterContext$2.getPartitionLocation().getFileName()).toString());
                        MemoryFileInfo memoryFileInfo = this.storageManager.createMemoryFileInfo(partitionDataWriterContext$2.getAppId(), partitionDataWriterContext$2.getShuffleId(), location$1.getFileName(), partitionDataWriterContext$2.getUserIdentifier(), partitionDataWriterContext$2.getPartitionType(), partitionDataWriterContext$2.isPartitionSplitEnabled());
                        PartitionMetaHandler metaHandler2 = StoragePolicy.getPartitionMetaHandler$1((FileInfo)memoryFileInfo, partitionType$2, partitionDataWriterContext$2, notifier$2);
                        tierWriterBase = new MemoryTierWriter(this.conf, metaHandler2, numPendingWrites$2, notifier$2, this.source, memoryFileInfo, storageInfoType, partitionDataWriterContext$2, this.storageManager);
                        return tierWriterBase;
                    }
                    if (!(StorageInfo.Type.HDD.equals(type) ? true : (StorageInfo.Type.SSD.equals(type) ? true : (StorageInfo.Type.HDFS.equals(type) ? true : (StorageInfo.Type.OSS.equals(type) ? true : StorageInfo.Type.S3.equals(type)))))) throw new MatchError((Object)type);
                    if (!this.storageManager.localOrDfsStorageAvailable()) return null;
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("create non-memory file for ").append(partitionDataWriterContext$2.getShuffleKey()).append(" ").append(partitionDataWriterContext$2.getPartitionLocation().getFileName()).toString());
                    Tuple3<Flusher, DiskFileInfo, File> tuple3 = this.storageManager.createDiskFile(location$1, partitionDataWriterContext$2.getAppId(), partitionDataWriterContext$2.getShuffleId(), location$1.getFileName(), partitionDataWriterContext$2.getUserIdentifier(), partitionDataWriterContext$2.getPartitionType(), partitionDataWriterContext$2.isPartitionSplitEnabled());
                    if (tuple3 == null) throw new MatchError(tuple3);
                    Flusher flusher2 = (Flusher)tuple3._1();
                    DiskFileInfo diskFileInfo2 = (DiskFileInfo)tuple3._2();
                    File workingDir = (File)tuple3._3();
                    Tuple3 tuple32 = new Tuple3((Object)flusher2, (Object)diskFileInfo2, (Object)workingDir);
                    flusher = (Flusher)tuple32._1();
                    diskFileInfo = (DiskFileInfo)tuple32._2();
                    File workingDir2 = (File)tuple32._3();
                    partitionDataWriterContext$2.setWorkingDir(workingDir2);
                    metaHandler = StoragePolicy.getPartitionMetaHandler$1((FileInfo)diskFileInfo, partitionType$2, partitionDataWriterContext$2, notifier$2);
                    StorageInfo.Type type2 = storageInfoType;
                    StorageInfo.Type type3 = StorageInfo.Type.HDD;
                    if (!(type2 == null ? type3 != null : !type2.equals(type3))) break block7;
                    StorageInfo.Type type4 = storageInfoType;
                    StorageInfo.Type type5 = StorageInfo.Type.SSD;
                    if (type4 != null ? !type4.equals(type5) : type5 != null) break block8;
                }
                if (location$1.getStorageInfo().localDiskAvailable()) {
                    tierWriterBase = new LocalTierWriter(this.conf, metaHandler, numPendingWrites$2, notifier$2, flusher, this.source, diskFileInfo, storageInfoType, partitionDataWriterContext$2, this.storageManager);
                    return tierWriterBase;
                }
            }
            tierWriterBase = new DfsTierWriter(this.conf, metaHandler, numPendingWrites$2, notifier$2, flusher, this.source, diskFileInfo, storageInfoType, partitionDataWriterContext$2, this.storageManager);
            return tierWriterBase;
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("create celeborn file for storage ").append(storageInfoType).append(" failed").toString(), e);
            return null;
        }
    }

    public StoragePolicy(CelebornConf conf, StorageManager storageManager, AbstractSource source) {
        this.conf = conf;
        this.storageManager = storageManager;
        this.source = source;
        Logging.$init$((Logging)this);
        this.createFileOrder = conf.workerStoragePolicyCreateFilePolicy();
        this.evictFileOrder = conf.workerStoragePolicyEvictFilePolicy();
    }
}

