/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.UniformReservoir;
import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.protocol.RpcNameConstants;
import org.apache.celeborn.common.protocol.message.Message;
import org.apache.celeborn.common.rpc.RpcSource;
import org.apache.celeborn.common.rpc.RpcSource$;
import org.apache.celeborn.common.rpc.netty.InboxMessage;
import org.apache.celeborn.common.rpc.netty.OneWayMessage;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier$;
import org.apache.celeborn.common.rpc.netty.RpcMessage;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.shaded.com.google.protobuf.GeneratedMessageV3;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}e!\u0002\u0012$\u0001\u001dj\u0003\u0002\u0003\u001e\u0001\u0005\u000b\u0007I\u0011\u0001\u001f\t\u0011!\u0003!\u0011!Q\u0001\nuB\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\")1\u000b\u0001C\u0001)\"9\u0011\f\u0001b\u0001\n\u0003Q\u0006BB8\u0001A\u0003%1\fC\u0004q\u0001\t\u0007I\u0011B9\t\ra\u0004\u0001\u0015!\u0003s\u0011\u001dI\bA1A\u0005\niDaA \u0001!\u0002\u0013Y\bbB@\u0001\u0005\u0004%IA\u001f\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003|\u0011!\t\u0019\u0001\u0001b\u0001\n\u0013Q\bbBA\u0003\u0001\u0001\u0006Ia\u001f\u0005\t\u0003\u000f\u0001!\u0019!C\u0005c\"9\u0011\u0011\u0002\u0001!\u0002\u0013\u0011\b\u0002CA\u0006\u0001\t\u0007I\u0011B9\t\u000f\u00055\u0001\u0001)A\u0005e\"I\u0011q\u0002\u0001C\u0002\u00135\u0011\u0011\u0003\u0005\t\u00033\u0001\u0001\u0015!\u0004\u0002\u0014!I\u00111\u0004\u0001C\u0002\u00135\u0011Q\u0004\u0005\t\u0003s\u0001\u0001\u0015!\u0004\u0002 !Y\u00111\b\u0001A\u0002\u0003\u0007I\u0011BA\u001f\u0011-\t)\u0005\u0001a\u0001\u0002\u0004%I!a\u0012\t\u0017\u0005M\u0003\u00011A\u0001B\u0003&\u0011q\b\u0005\b\u0003+\u0002A\u0011AA,\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Bq!a\u001a\u0001\t\u0003\tI\u0007C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\"9\u0011q\u0013\u0001\u0005\u0002\u0005e\u0005bBAO\u0001\u0011\u0005\u0011\u0011\u000e\u0002\u0012%B\u001cW*\u001a;sS\u000e\u001cHK]1dW\u0016\u0014(B\u0001\u0013&\u0003\r\u0011\bo\u0019\u0006\u0003M\u001d\naaY8n[>t'B\u0001\u0015*\u0003!\u0019W\r\\3c_Jt'B\u0001\u0016,\u0003\u0019\t\u0007/Y2iK*\tA&A\u0002pe\u001e\u001c2\u0001\u0001\u00185!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0019\te.\u001f*fMB\u0011Q\u0007O\u0007\u0002m)\u0011q'J\u0001\tS:$XM\u001d8bY&\u0011\u0011H\u000e\u0002\b\u0019><w-\u001b8h\u0003\u0011q\u0017-\\3\u0004\u0001U\tQ\b\u0005\u0002?\u000b:\u0011qh\u0011\t\u0003\u0001Bj\u0011!\u0011\u0006\u0003\u0005n\na\u0001\u0010:p_Rt\u0014B\u0001#1\u0003\u0019\u0001&/\u001a3fM&\u0011ai\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011\u0003\u0014!\u00028b[\u0016\u0004\u0013!\u0003:qGN{WO]2f!\tYE*D\u0001$\u0013\ti5EA\u0005Sa\u000e\u001cv.\u001e:dK\u0006!1m\u001c8g!\t\u0001\u0016+D\u0001&\u0013\t\u0011VE\u0001\u0007DK2,'m\u001c:o\u0007>tg-\u0001\u0004=S:LGO\u0010\u000b\u0005+Z;\u0006\f\u0005\u0002L\u0001!)!(\u0002a\u0001{!)\u0011*\u0002a\u0001\u0015\")a*\u0002a\u0001\u001f\u0006a\u0001.[:u_\u001e\u0014\u0018-\\'baV\t1\f\u0005\u0003]Gv*W\"A/\u000b\u0005y{\u0016AC2p]\u000e,(O]3oi*\u0011\u0001-Y\u0001\u0005kRLGNC\u0001c\u0003\u0011Q\u0017M^1\n\u0005\u0011l&!D\"p]\u000e,(O]3oi6\u000b\u0007\u000f\u0005\u0002g[6\tqM\u0003\u0002iS\u00069Q.\u001a;sS\u000e\u001c(B\u00016l\u0003!\u0019w\u000eZ1iC2,'\"\u00017\u0002\u0007\r|W.\u0003\u0002oO\nI\u0001*[:u_\u001e\u0014\u0018-\\\u0001\u000eQ&\u001cHo\\4sC6l\u0015\r\u001d\u0011\u0002\u001d5\f\u00070U;fk\u0016dUM\\4uQV\t!\u000f\u0005\u0002tm6\tAO\u0003\u0002v;\u00061\u0011\r^8nS\u000eL!a\u001e;\u0003\u0015\u0005#x.\\5d\u0019>tw-A\bnCb\fV/Z;f\u0019\u0016tw\r\u001e5!\u0003A\u0019Hn\\<Sa\u000e$\u0006N]3tQ>dG-F\u0001|!\tyC0\u0003\u0002~a\t!Aj\u001c8h\u0003E\u0019Hn\\<Sa\u000e$\u0006N]3tQ>dG\rI\u0001\u0010g2|wO\u00159d\u0013:$XM\u001d<bY\u0006\u00012\u000f\\8x%B\u001c\u0017J\u001c;feZ\fG\u000eI\u0001\u0010eB\u001cG)^7q\u0013:$XM\u001d<bY\u0006\u0001\"\u000f]2Ek6\u0004\u0018J\u001c;feZ\fG\u000eI\u0001\rY\u0006\u001cH\u000fR;naRKW.Z\u0001\u000eY\u0006\u001cH\u000fR;naRKW.\u001a\u0011\u0002\u001f1\f7\u000f^*m_^dun\u001a+j[\u0016\f\u0001\u0003\\1tiNcwn\u001e'pORKW.\u001a\u0011\u0002\u0019U\u001cX\rS5ti><'/Y7\u0016\u0005\u0005M\u0001cA\u0018\u0002\u0016%\u0019\u0011q\u0003\u0019\u0003\u000f\t{w\u000e\\3b]\u0006iQo]3ISN$xn\u001a:b[\u0002\n!BT!N\u000b~c\u0015IQ#M+\t\ty\u0002E\u0004\u0002\"\u0005-\u0012qF\u001f\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005%\u0002'\u0001\u0006d_2dWm\u0019;j_:LA!!\f\u0002$\t\u0019Q*\u00199\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000eb\u0003\u0011a\u0017M\\4\n\u0007\u0019\u000b\u0019$A\u0006O\u00036+u\fT!C\u000b2\u0003\u0013aD9vKV,G*\u001a8hi\"4UO\\2\u0016\u0005\u0005}\u0002\u0003B\u0018\u0002BmL1!a\u00111\u0005%1UO\\2uS>t\u0007'A\nrk\u0016,X\rT3oORDg)\u001e8d?\u0012*\u0017\u000f\u0006\u0003\u0002J\u0005=\u0003cA\u0018\u0002L%\u0019\u0011Q\n\u0019\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003#J\u0012\u0011!a\u0001\u0003\u007f\t1\u0001\u001f\u00132\u0003A\tX/Z;f\u0019\u0016tw\r\u001e5Gk:\u001c\u0007%\u0001\u0003j]&$H\u0003BA%\u00033Bq!a\u0017\u001c\u0001\u0004\ty$\u0001\u0006mK:<G\u000f\u001b$v]\u000e\fq\"\u001e9eCR,\u0007*[:u_\u001e\u0014\u0018-\u001c\u000b\u0007\u0003\u0013\n\t'a\u0019\t\u000bib\u0002\u0019A\u001f\t\r\u0005\u0015D\u00041\u0001|\u0003\u00151\u0018\r\\;f\u0003=)\b\u000fZ1uK6\u000b\u0007\u0010T3oORDGCAA%\u0003)awnZ*m_^\u0014\u0006o\u0019\u000b\t\u0003\u0013\ny'a \u0002\u0004\"9\u0011\u0011\u000f\u0010A\u0002\u0005M\u0014aB7fgN\fw-\u001a\t\u0005\u0003k\nY(\u0004\u0002\u0002x)\u0019\u0011\u0011P\u0012\u0002\u000b9,G\u000f^=\n\t\u0005u\u0014q\u000f\u0002\r\u0013:\u0014w\u000e_'fgN\fw-\u001a\u0005\u0007\u0003\u0003s\u0002\u0019A>\u0002\u0013E,X-^3US6,\u0007BBAC=\u0001\u000710A\u0006qe>\u001cWm]:US6,\u0017A\u0002:fG>\u0014H\r\u0006\u0005\u0002J\u0005-\u00151SAK\u0011\u001d\t\th\ba\u0001\u0003\u001b\u00032aLAH\u0013\r\t\t\n\r\u0002\u0004\u0003:L\bBBAA?\u0001\u00071\u0010\u0003\u0004\u0002\u0006~\u0001\ra_\u0001\u0007kB$\u0017\r^3\u0015\t\u0005%\u00131\u0014\u0005\b\u0003c\u0002\u0003\u0019AA:\u0003\u0011!W/\u001c9")
public class RpcMetricsTracker
implements Logging {
    private final String name;
    private final RpcSource rpcSource;
    private final ConcurrentMap<String, Histogram> histogramMap;
    private final AtomicLong maxQueueLength;
    private final long slowRpcThreshold;
    private final long slowRpcInterval;
    private final long rpcDumpInterval;
    private final AtomicLong lastDumpTime;
    private final AtomicLong lastSlowLogTime;
    private final boolean useHistogram;
    private final Map<String, String> NAME_LABEL;
    private Function0<Object> queueLengthFunc;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        RpcMetricsTracker rpcMetricsTracker = this;
        synchronized (rpcMetricsTracker) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public String name() {
        return this.name;
    }

    public ConcurrentMap<String, Histogram> histogramMap() {
        return this.histogramMap;
    }

    private AtomicLong maxQueueLength() {
        return this.maxQueueLength;
    }

    private long slowRpcThreshold() {
        return this.slowRpcThreshold;
    }

    private long slowRpcInterval() {
        return this.slowRpcInterval;
    }

    private long rpcDumpInterval() {
        return this.rpcDumpInterval;
    }

    private AtomicLong lastDumpTime() {
        return this.lastDumpTime;
    }

    private AtomicLong lastSlowLogTime() {
        return this.lastSlowLogTime;
    }

    private final boolean useHistogram() {
        return this.useHistogram;
    }

    private final Map<String, String> NAME_LABEL() {
        return this.NAME_LABEL;
    }

    private Function0<Object> queueLengthFunc() {
        return this.queueLengthFunc;
    }

    private void queueLengthFunc_$eq(Function0<Object> x$1) {
        this.queueLengthFunc = x$1;
    }

    public void init(Function0<Object> lengthFunc) {
        this.queueLengthFunc_$eq(lengthFunc);
        if (this.name() != null) {
            this.rpcSource.addGauge(RpcSource$.MODULE$.QUEUE_LENGTH(), this.NAME_LABEL(), this.queueLengthFunc());
            this.rpcSource.addTimer(RpcSource$.MODULE$.QUEUE_TIME(), this.NAME_LABEL());
            this.rpcSource.addTimer(RpcSource$.MODULE$.PROCESS_TIME(), this.NAME_LABEL());
            return;
        }
    }

    public void updateHistogram(String name, long value) {
        this.histogramMap().putIfAbsent(name, new Histogram((Reservoir)new UniformReservoir()));
        Histogram histogram = (Histogram)this.histogramMap().get(name);
        histogram.update(value);
    }

    public void updateMaxLength() {
        long len = this.queueLengthFunc().apply$mcJ$sp();
        if (len > this.maxQueueLength().get()) {
            this.maxQueueLength().set(len);
            return;
        }
    }

    private void logSlowRpc(InboxMessage message, long queueTime, long processTime) {
        if (queueTime + processTime > this.slowRpcThreshold()) {
            long lastLogTime = this.lastSlowLogTime().get();
            if (this.slowRpcInterval() < 0L || System.currentTimeMillis() - lastLogTime > this.slowRpcInterval() && this.lastSlowLogTime().compareAndSet(lastLogTime, System.currentTimeMillis())) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(80).append("slow rpc detected: currentQueueSize = ").append(this.queueLengthFunc().apply$mcJ$sp()).append(", queueTime=").append(queueTime).append("(ns) processTime=").append(processTime).append("(ns) message=").append(message).toString());
            }
            long lastTime = this.lastDumpTime().get();
            if (this.useHistogram() && System.currentTimeMillis() - lastTime > this.rpcDumpInterval() && this.lastDumpTime().compareAndSet(lastTime, System.currentTimeMillis())) {
                this.dump();
                return;
            }
            return;
        }
    }

    public void record(Object message, long queueTime, long processTime) {
        String msgName = RpcMetricsTracker.messageName$1(message);
        if (this.useHistogram()) {
            this.updateHistogram(RpcSource$.MODULE$.QUEUE_TIME(), queueTime);
            this.updateHistogram(RpcSource$.MODULE$.PROCESS_TIME(), processTime);
            this.updateHistogram(msgName, processTime);
            return;
        }
        this.rpcSource.updateTimer(RpcSource$.MODULE$.QUEUE_TIME(), queueTime, this.NAME_LABEL());
        this.rpcSource.updateTimer(RpcSource$.MODULE$.PROCESS_TIME(), processTime, this.NAME_LABEL());
        this.rpcSource.updateTimer(msgName, processTime);
    }

    public void update(InboxMessage message) {
        InboxMessage inboxMessage = message;
        if (inboxMessage instanceof RpcMessage) {
            RpcMessage rpcMessage = (RpcMessage)inboxMessage;
            Object content = rpcMessage.content();
            long queueTime = rpcMessage.dequeueTime() - rpcMessage.enqueueTime();
            long processTime = rpcMessage.endProcessTime() - rpcMessage.dequeueTime();
            this.record(content, queueTime, processTime);
            this.logSlowRpc(message, queueTime, processTime);
            return;
        }
        if (inboxMessage instanceof OneWayMessage) {
            OneWayMessage oneWayMessage = (OneWayMessage)inboxMessage;
            Object content = oneWayMessage.content();
            long queueTime = oneWayMessage.dequeueTime() - oneWayMessage.enqueueTime();
            long processTime = oneWayMessage.endProcessTime() - oneWayMessage.dequeueTime();
            this.record(content, queueTime, processTime);
            this.logSlowRpc(message, queueTime, processTime);
            return;
        }
    }

    public void dump() {
        if (!this.useHistogram()) {
            return;
        }
        scala.collection.mutable.StringBuilder builder = new scala.collection.mutable.StringBuilder();
        builder.append(new StringBuilder(35).append("RPC statistics for ").append(this.name()).append(" (time unit: ns)").toString()).append("\n");
        builder.append(new StringBuilder(21).append("current queue size = ").append(this.queueLengthFunc().apply$mcJ$sp()).toString()).append("\n");
        builder.append(new StringBuilder(19).append("max queue length = ").append(this.maxQueueLength().get()).toString()).append("\n");
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(this.histogramMap().entrySet()).asScala()).foreach((Function1 & Serializable)entry -> {
            Histogram histogram = (Histogram)entry.getValue();
            Snapshot snapshot = histogram.getSnapshot();
            builder.append(new StringBuilder(28).append("histogram for ").append(this.name()).append(" RPC metrics: ").toString()).append((String)entry.getKey()).append("\n");
            return builder.append("count: ").append(histogram.getCount()).append("\n").append("min: ").append(snapshot.getMin()).append("\n").append("mean: ").append(snapshot.getMean()).append("\n").append("p50: ").append(snapshot.getMedian()).append("\n").append("p75: ").append(snapshot.get75thPercentile()).append("\n").append("p95: ").append(snapshot.get95thPercentile()).append("\n").append("p99: ").append(snapshot.get99thPercentile()).append("\n").append("max: ").append(snapshot.getMax()).append("\n");
        });
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> builder.toString());
    }

    private static final String messageName$1(Object message) {
        Object object = message;
        if (object instanceof Message) {
            Message message2 = (Message)object;
            return message2.getClass().toString();
        }
        if (object instanceof GeneratedMessageV3) {
            GeneratedMessageV3 generatedMessageV3 = (GeneratedMessageV3)object;
            return generatedMessageV3.getDescriptorForType().getFullName();
        }
        if (object instanceof RpcEndpointVerifier.CheckExistence) {
            return "CheckExistence";
        }
        return "unknown";
    }

    /*
     * Unable to fully structure code
     */
    public RpcMetricsTracker(String name, RpcSource rpcSource, CelebornConf conf) {
        this.name = name;
        this.rpcSource = rpcSource;
        super();
        Logging.$init$(this);
        this.histogramMap = JavaUtils.newConcurrentHashMap();
        this.maxQueueLength = new AtomicLong(0L);
        this.slowRpcThreshold = conf.rpcSlowThresholdNs();
        this.slowRpcInterval = conf.rpcSlowIntervalMs();
        this.rpcDumpInterval = conf.rpcDumpIntervalMs();
        this.lastDumpTime = new AtomicLong(0L);
        this.lastSlowLogTime = new AtomicLong(0L);
        v0 = name;
        var4_4 = RpcNameConstants.LIFECYCLE_MANAGER_EP;
        if (!(v0 == null ? var4_4 != null : v0.equals(var4_4) == false)) ** GOTO lbl-1000
        v1 = name;
        var5_5 = RpcEndpointVerifier$.MODULE$.NAME();
        if (!(v1 != null ? v1.equals(var5_5) == false : var5_5 != null)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        this.useHistogram = v2;
        this.NAME_LABEL = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name)}));
    }
}

