/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.cql3;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TokenRange;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.hadoop.cql3.CqlConfigHelper;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CqlRecordWriter
extends RecordWriter<Map<String, ByteBuffer>, List<ByteBuffer>>
implements org.apache.hadoop.mapred.RecordWriter<Map<String, ByteBuffer>, List<ByteBuffer>>,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(CqlRecordWriter.class);
    protected final Configuration conf;
    protected final int queueSize;
    protected final long batchThreshold;
    protected Progressable progressable;
    protected TaskAttemptContext context;
    private final NativeRingCache ringCache;
    protected final Map<InetAddress, RangeClient> clients;
    protected final ConcurrentHashMap<Session, PreparedStatement> preparedStatements = new ConcurrentHashMap();
    protected final String cql;
    protected List<ColumnMetadata> partitionKeyColumns;
    protected List<ColumnMetadata> clusterColumns;

    CqlRecordWriter(TaskAttemptContext context) throws IOException {
        this(HadoopCompat.getConfiguration((JobContext)context));
        this.context = context;
    }

    CqlRecordWriter(Configuration conf, Progressable progressable) {
        this(conf);
        this.progressable = progressable;
    }

    CqlRecordWriter(Configuration conf) {
        this.conf = conf;
        this.queueSize = conf.getInt("mapreduce.output.columnfamilyoutputformat.queue.size", 32 * FBUtilities.getAvailableProcessors());
        this.batchThreshold = conf.getLong("mapreduce.output.columnfamilyoutputformat.batch.threshold", 32L);
        this.clients = new HashMap<InetAddress, RangeClient>();
        String keyspace = ConfigHelper.getOutputKeyspace(conf);
        try (Cluster cluster = CqlConfigHelper.getOutputCluster(ConfigHelper.getOutputInitialAddress(conf), conf);){
            Metadata metadata = cluster.getMetadata();
            this.ringCache = new NativeRingCache(conf, metadata);
            TableMetadata tableMetadata = metadata.getKeyspace(Metadata.quote((String)keyspace)).getTable(ConfigHelper.getOutputColumnFamily(conf));
            this.clusterColumns = tableMetadata.getClusteringColumns();
            this.partitionKeyColumns = tableMetadata.getPartitionKey();
            String cqlQuery = CqlConfigHelper.getOutputCql(conf).trim();
            if (cqlQuery.toLowerCase(Locale.ENGLISH).startsWith("insert")) {
                throw new UnsupportedOperationException("INSERT with CqlRecordWriter is not supported, please use UPDATE/DELETE statement");
            }
            this.cql = this.appendKeyWhereClauses(cqlQuery);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        this.close();
    }

    @Deprecated
    public void close(Reporter reporter) throws IOException {
        this.close();
    }

    @Override
    public void close() throws IOException {
        IOException clientException = null;
        for (RangeClient client : this.clients.values()) {
            try {
                client.close();
            }
            catch (IOException e) {
                clientException = e;
            }
        }
        if (clientException != null) {
            throw clientException;
        }
    }

    public void write(Map<String, ByteBuffer> keyColumns, List<ByteBuffer> values) throws IOException {
        TokenRange range = this.ringCache.getRange(this.getPartitionKey(keyColumns));
        InetAddress address = this.ringCache.getEndpoints(range).get(0);
        RangeClient client = this.clients.get(address);
        if (client == null) {
            client = new RangeClient(this.ringCache.getEndpoints(range));
            client.start();
            this.clients.put(address, client);
        }
        ArrayList<ByteBuffer> allValues = new ArrayList<ByteBuffer>(values);
        for (ColumnMetadata column : this.partitionKeyColumns) {
            allValues.add(keyColumns.get(column.getName()));
        }
        for (ColumnMetadata column : this.clusterColumns) {
            allValues.add(keyColumns.get(column.getName()));
        }
        client.put(allValues);
        if (this.progressable != null) {
            this.progressable.progress();
        }
        if (this.context != null) {
            HadoopCompat.progress(this.context);
        }
    }

    private static void closeSession(Session session) {
        try {
            if (session != null) {
                session.getCluster().closeAsync();
            }
        }
        catch (Throwable t) {
            logger.warn("Error closing connection", t);
        }
    }

    private ByteBuffer getPartitionKey(Map<String, ByteBuffer> keyColumns) {
        ByteBuffer partitionKey;
        if (this.partitionKeyColumns.size() > 1) {
            ByteBuffer[] keys = new ByteBuffer[this.partitionKeyColumns.size()];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = keyColumns.get(this.partitionKeyColumns.get(i).getName());
            }
            partitionKey = CompositeType.build(ByteBufferAccessor.instance, keys);
        } else {
            partitionKey = keyColumns.get(this.partitionKeyColumns.get(0).getName());
        }
        return partitionKey;
    }

    private String appendKeyWhereClauses(String cqlQuery) {
        String keyWhereClause = "";
        for (ColumnMetadata partitionKey : this.partitionKeyColumns) {
            keyWhereClause = keyWhereClause + String.format("%s = ?", keyWhereClause.isEmpty() ? this.quote(partitionKey.getName()) : " AND " + this.quote(partitionKey.getName()));
        }
        for (ColumnMetadata clusterColumn : this.clusterColumns) {
            keyWhereClause = keyWhereClause + " AND " + this.quote(clusterColumn.getName()) + " = ?";
        }
        return cqlQuery + " WHERE " + keyWhereClause;
    }

    private String quote(String identifier) {
        return "\"" + identifier.replaceAll("\"", "\"\"") + "\"";
    }

    static /* synthetic */ void access$000(Session x0) {
        CqlRecordWriter.closeSession(x0);
    }

    static class NativeRingCache {
        private final Map<TokenRange, Set<Host>> rangeMap;
        private final Metadata metadata;
        private final IPartitioner partitioner;

        public NativeRingCache(Configuration conf, Metadata metadata) {
            this.partitioner = ConfigHelper.getOutputPartitioner(conf);
            this.metadata = metadata;
            String keyspace = ConfigHelper.getOutputKeyspace(conf);
            this.rangeMap = metadata.getTokenRanges().stream().collect(Collectors.toMap(p -> p, p -> metadata.getReplicas('\"' + keyspace + '\"', p)));
        }

        public TokenRange getRange(ByteBuffer key) {
            Token t = this.partitioner.getToken(key);
            com.datastax.driver.core.Token driverToken = this.metadata.newToken(this.partitioner.getTokenFactory().toString(t));
            for (TokenRange range : this.rangeMap.keySet()) {
                if (!range.contains(driverToken)) continue;
                return range;
            }
            throw new RuntimeException("Invalid token information returned by describe_ring: " + this.rangeMap);
        }

        public List<InetAddress> getEndpoints(TokenRange range) {
            Set<Host> hostSet = this.rangeMap.get(range);
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>(hostSet.size());
            for (Host host : hostSet) {
                addresses.add(host.getAddress());
            }
            return addresses;
        }
    }

    public class RangeClient
    extends Thread {
        protected final List<InetAddress> endpoints;
        protected Cluster cluster;
        protected final BlockingQueue<List<ByteBuffer>> queue;
        protected volatile boolean run;
        protected volatile IOException lastException;

        public RangeClient(List<InetAddress> endpoints) {
            super("client-" + endpoints);
            this.cluster = null;
            this.queue = new ArrayBlockingQueue<List<ByteBuffer>>(CqlRecordWriter.this.queueSize);
            this.run = true;
            this.endpoints = endpoints;
        }

        /*
         * Exception decompiling
         */
        public void put(List<ByteBuffer> value) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private PreparedStatement preparedStatement(Session client) {
            PreparedStatement statement = (PreparedStatement)CqlRecordWriter.this.preparedStatements.get(client);
            if (statement == null) {
                PreparedStatement result;
                try {
                    result = client.prepare(CqlRecordWriter.this.cql);
                }
                catch (NoHostAvailableException e) {
                    throw new RuntimeException("failed to prepare cql query " + CqlRecordWriter.this.cql, e);
                }
                PreparedStatement previousId = CqlRecordWriter.this.preparedStatements.putIfAbsent(client, result);
                statement = previousId == null ? result : previousId;
            }
            return statement;
        }

        public void close() throws IOException {
            this.run = false;
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            if (this.lastException != null) {
                throw this.lastException;
            }
        }

        protected void closeInternal() {
            if (this.cluster != null) {
                this.cluster.close();
            }
        }

        private boolean canRetryDriverConnection(Exception e) {
            Throwable cause;
            if (e instanceof DriverException && e.getMessage().contains("Connection thread interrupted")) {
                return true;
            }
            return e instanceof NoHostAvailableException && ((NoHostAvailableException)((Object)e)).getErrors().size() == 1 && (cause = (Throwable)((NoHostAvailableException)((Object)e)).getErrors().values().iterator().next()) != null && cause.getCause() instanceof ClosedByInterruptException;
        }
    }
}

