/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import o.a.c.sidecar.client.shaded.common.response.TokenRangeReplicasResponse;
import o.a.c.sidecar.client.shaded.common.response.data.RingEntry;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.utils.SerializationUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class RingInstanceSerializationTest {
    @Test
    public void testRingSerializesCorrectly() {
        int dcOffset = 0;
        String dataCenter = "DC1";
        int index = 0;
        int initialToken = 0;
        RingInstance ring = new RingInstance(new RingEntry.Builder().address("127.0." + dcOffset + "." + index).port(7000).datacenter(dataCenter).load("0").token(Integer.toString(initialToken + dcOffset + 100 * index)).fqdn(dataCenter + "-i" + index).rack("Rack").hostId("").status("UP").state("NORMAL").owns("").build());
        byte[] bytes = SerializationUtils.serialize(ring);
        RingInstance deserialized = SerializationUtils.deserialize(bytes, RingInstance.class);
        Assertions.assertThat((Object)deserialized).isEqualTo((Object)ring);
    }

    @Test
    public void testRingSerializesFromReplicaMetadata() {
        int dcOffset = 0;
        String dataCenter = "DC1";
        int index = 0;
        TokenRangeReplicasResponse.ReplicaMetadata metadata = new TokenRangeReplicasResponse.ReplicaMetadata("NORMAL", "UP", dataCenter + "-i" + index, "127.0." + dcOffset + "." + index, 7000, dataCenter);
        RingInstance ring = new RingInstance(metadata, "test-cluster");
        byte[] bytes = SerializationUtils.serialize(ring);
        RingInstance deserialized = SerializationUtils.deserialize(bytes, RingInstance.class);
        Assertions.assertThat((Object)deserialized).isEqualTo((Object)ring);
    }
}

