/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.spark.CommonTestUtils;
import org.apache.cassandra.spark.TestRunnable;
import org.apache.cassandra.spark.config.SchemaFeatureSet;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.data.partitioner.CassandraRing;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.utils.FilterUtils;
import org.apache.cassandra.spark.utils.RandomUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.Nullable;
import org.quicktheories.QuickTheory;
import org.quicktheories.core.Gen;
import org.quicktheories.generators.SourceDSL;

public final class TestUtils
extends CommonTestUtils {
    private static SparkSession session() {
        return Holder.SPARK_SESSION;
    }

    private TestUtils() {
        throw new IllegalStateException(String.valueOf(((Object)((Object)this)).getClass()) + " is static utility class and shall not be instantiated");
    }

    public static long countSSTables(Path directory) throws IOException {
        return TestUtils.getFileType(directory, FileType.DATA).count();
    }

    public static Path getFirstFileType(Path directory, FileType fileType) throws IOException {
        return TestUtils.getFileType(directory, fileType).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Could not find %s file", fileType.getFileSuffix())));
    }

    public static Stream<Path> getFileType(Path directory, FileType fileType) throws IOException {
        return Files.list(directory).filter(path -> path.getFileName().toString().endsWith("-" + fileType.getFileSuffix()));
    }

    public static void runTest(TestRunnable test) {
        QuickTheory.qt().forAll(TestUtils.partitioners(), TestUtils.bridges()).checkAssert((partitioner, bridge) -> TestUtils.runTest(partitioner, bridge, test));
    }

    public static void runTest(CassandraVersion version, TestRunnable test) {
        QuickTheory.qt().forAll(TestUtils.partitioners()).checkAssert(partitioner -> TestUtils.runTest(partitioner, version, test));
    }

    public static void runTest(Partitioner partitioner, CassandraVersion version, TestRunnable test) {
        TestUtils.runTest(partitioner, CassandraBridgeFactory.get((CassandraVersion)version), test);
    }

    public static void runTest(Partitioner partitioner, CassandraBridge bridge, TestRunnable test) {
        Path directory = null;
        try {
            directory = Files.createTempDirectory(UUID.randomUUID().toString(), new FileAttribute[0]);
            test.run(partitioner, directory, bridge);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        finally {
            if (directory != null) {
                try {
                    FileUtils.deleteDirectory((File)directory.toFile());
                }
                catch (IOException iOException) {}
            }
        }
    }

    static Dataset<Row> openLocalPartitionSizeSource(CassandraBridge bridge, Partitioner partitioner, Path dir, String keyspace, String createStmt, CassandraVersion version, Set<CqlField.CqlUdt> udts, @Nullable String statsClass) {
        DataFrameReader frameReader = TestUtils.session().read().format("org.apache.cassandra.spark.sparksql.LocalPartitionSizeSource").option("keyspace", keyspace).option("createStmt", createStmt).option("dirs", dir.toAbsolutePath().toString()).option("version", version.toString()).option("useBufferingInputStream", true).option("partitioner", partitioner.name()).option("udts", udts.stream().map(f -> f.createStatement(bridge.cassandraTypes(), keyspace)).collect(Collectors.joining("\n")));
        if (statsClass != null) {
            frameReader = frameReader.option("statsClass", statsClass);
        }
        return frameReader.load();
    }

    public static Dataset<Row> read(Path path, StructType schema) {
        return TestUtils.session().read().format("parquet").option("path", path.toString()).schema(schema).load();
    }

    public static Dataset<Row> openLocalDataset(CassandraBridge bridge, Partitioner partitioner, Path directory, String keyspace, String createStatement, CassandraVersion version, Set<CqlField.CqlUdt> udts, boolean addLastModifiedTimestampColumn, @Nullable String statsClass, @Nullable String filterExpression, String ... columns) {
        DataFrameReader frameReader = TestUtils.session().read().format("org.apache.cassandra.spark.sparksql.LocalDataSource").option("keyspace", keyspace).option("createStmt", createStatement).option("dirs", directory.toAbsolutePath().toString()).option("version", version.toString()).option("useBufferingInputStream", true).option("partitioner", partitioner.name()).option(SchemaFeatureSet.LAST_MODIFIED_TIMESTAMP.optionName(), addLastModifiedTimestampColumn).option("udts", udts.stream().map(udt -> udt.createStatement(bridge.cassandraTypes(), keyspace)).collect(Collectors.joining("\n")));
        if (statsClass != null) {
            frameReader = frameReader.option("statsClass", statsClass);
        }
        Dataset dataset = frameReader.load();
        if (filterExpression != null) {
            dataset = dataset.filter(filterExpression);
        }
        if (columns != null && columns.length > 0) {
            dataset = columns.length == 1 ? dataset.select(columns[0], new String[0]) : dataset.select(columns[0], Arrays.copyOfRange(columns, 1, columns.length));
        }
        return dataset;
    }

    public static ReplicationFactor simpleStrategy() {
        return new ReplicationFactor(ReplicationFactor.ReplicationStrategy.SimpleStrategy, (Map)ImmutableMap.of((Object)"DC1", (Object)3));
    }

    public static ReplicationFactor networkTopologyStrategy() {
        return TestUtils.networkTopologyStrategy((Map<String, Integer>)ImmutableMap.of((Object)"DC1", (Object)3));
    }

    public static ReplicationFactor networkTopologyStrategy(Map<String, Integer> options) {
        return new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, options);
    }

    public static Gen<CassandraVersion> versions() {
        return SourceDSL.arbitrary().pick((Object[])CassandraVersion.implementedVersions());
    }

    public static Gen<CassandraBridge> bridges() {
        return SourceDSL.arbitrary().pick(TestUtils.testableVersions().stream().map(CassandraBridgeFactory::get).collect(Collectors.toList()));
    }

    public static List<CassandraVersion> testableVersions() {
        return ImmutableList.copyOf((Object[])CassandraVersion.implementedVersions());
    }

    public static List<CassandraVersion> filterTestableVersions(List<CassandraVersion> candidates) {
        return TestUtils.testableVersions().stream().filter(candidates::contains).collect(Collectors.toList());
    }

    public static Gen<CqlField.SortOrder> sortOrder() {
        return SourceDSL.arbitrary().enumValues(CqlField.SortOrder.class);
    }

    public static Gen<CassandraVersion> tombstoneVersions() {
        return SourceDSL.arbitrary().pick(TestUtils.tombstoneTestableVersions());
    }

    public static List<CassandraVersion> tombstoneTestableVersions() {
        ImmutableList tombstoneTestableVersions = ImmutableList.of((Object)CassandraVersion.FOURZERO, (Object)CassandraVersion.FIVEZERO);
        return TestUtils.filterTestableVersions((List<CassandraVersion>)tombstoneTestableVersions);
    }

    public static Gen<Partitioner> partitioners() {
        return SourceDSL.arbitrary().enumValues(Partitioner.class);
    }

    public static CassandraRing createRing(Partitioner partitioner, int numInstances) {
        return TestUtils.createRing(partitioner, (Map<String, Integer>)ImmutableMap.of((Object)"DC1", (Object)numInstances));
    }

    public static CassandraRing createRing(Partitioner partitioner, Map<String, Integer> numInstances) {
        Collection instances = numInstances.entrySet().stream().map(dataCenter -> TestUtils.createInstances(partitioner, (Integer)dataCenter.getValue(), (String)dataCenter.getKey())).flatMap(Collection::stream).collect(Collectors.toList());
        Map<String, Integer> dataCenters = numInstances.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, dataCenter -> Math.min((Integer)dataCenter.getValue(), 3)));
        return new CassandraRing(partitioner, "test", new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, dataCenters), instances);
    }

    public static Collection<CassandraInstance> createInstances(Partitioner partitioner, int numInstances, String dataCenter) {
        Preconditions.checkArgument((numInstances > 0 ? 1 : 0) != 0, (Object)"NumInstances must be greater than zero");
        BigInteger split = partitioner.maxToken().subtract(partitioner.minToken()).divide(BigInteger.valueOf(numInstances));
        ArrayList<CassandraInstance> instances = new ArrayList<CassandraInstance>(numInstances);
        BigInteger token = partitioner.minToken();
        for (int instance = 0; instance < numInstances; ++instance) {
            instances.add(new CassandraInstance(token.toString(), "local-i" + instance, dataCenter));
            token = token.add(split);
            Assertions.assertThat((int)token.compareTo(partitioner.maxToken())).isLessThanOrEqualTo(0);
        }
        return instances;
    }

    public static Set<String> getKeys(List<List<String>> values) {
        HashSet<String> filterKeys = new HashSet<String>();
        FilterUtils.cartesianProduct(values).forEach(keys -> {
            String compositeKey = String.join((CharSequence)":", keys);
            filterKeys.add(compositeKey);
        });
        return filterKeys;
    }

    public static String randomLowEntropyString() {
        return new String(TestUtils.randomLowEntropyData(), StandardCharsets.UTF_8);
    }

    public static byte[] randomLowEntropyData() {
        return TestUtils.randomLowEntropyData(RandomUtils.randomPositiveInt((int)15872) + 512);
    }

    public static byte[] randomLowEntropyData(int size) {
        return TestUtils.randomLowEntropyData("Hello world!", size);
    }

    public static byte[] randomLowEntropyData(String str, int size) {
        return StringUtils.repeat((String)str, (int)(size / str.length() + 1)).substring(0, size).getBytes(StandardCharsets.UTF_8);
    }

    public static Range<BigInteger> range(long start, long end) {
        return TestUtils.range(BigInteger.valueOf(start), BigInteger.valueOf(end));
    }

    public static Range<BigInteger> range(BigInteger start, BigInteger end) {
        return Range.openClosed((Comparable)start, (Comparable)end);
    }

    public static void createDirectory(Path directory) {
        try {
            Files.createDirectory(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Holder {
        private static final SparkSession SPARK_SESSION = Holder.createSession();

        private Holder() {
        }

        static SparkSession createSession() {
            return SparkSession.builder().appName("Java Test").config("spark.master", "local").config("spark.sql.caseSensitive", "True").getOrCreate();
        }
    }
}

