/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelMatcher;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaChangeListener;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.cassandra.service.IEndpointLifecycleSubscriber;
import org.apache.cassandra.service.NativeTransportService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.transport.ClientStat;
import org.apache.cassandra.transport.ConnectedClient;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.transport.PipelineConfigurator;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.ProtocolVersionTracker;
import org.apache.cassandra.transport.ServerConnection;
import org.apache.cassandra.transport.messages.EventMessage;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
implements CassandraDaemon.Server {
    private static final Logger logger;
    private static final boolean useEpoll;
    private final ConnectionTracker connectionTracker;
    private final Connection.Factory connectionFactory = new Connection.Factory(){

        @Override
        public Connection newConnection(Channel channel, ProtocolVersion version) {
            return new ServerConnection(channel, version, Server.this.connectionTracker);
        }
    };
    public final InetSocketAddress socket;
    public final EncryptionOptions.TlsEncryptionPolicy tlsEncryptionPolicy;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final PipelineConfigurator pipelineConfigurator;
    private final EventLoopGroup workerGroup;
    private final Dispatcher dispatcher;

    private Server(Builder builder) {
        this.socket = builder.getSocket();
        this.tlsEncryptionPolicy = builder.tlsEncryptionPolicy;
        this.workerGroup = builder.workerGroup != null ? builder.workerGroup : (useEpoll ? new EpollEventLoopGroup() : new NioEventLoopGroup());
        this.dispatcher = new Dispatcher(DatabaseDescriptor.useNativeTransportLegacyFlusher());
        this.pipelineConfigurator = builder.pipelineConfigurator != null ? builder.pipelineConfigurator : new PipelineConfigurator(useEpoll, DatabaseDescriptor.getRpcKeepAlive(), builder.tlsEncryptionPolicy, this.dispatcher);
        EventNotifier notifier = builder.eventNotifier != null ? builder.eventNotifier : new EventNotifier();
        this.connectionTracker = new ConnectionTracker(this.isRunning::get);
        notifier.registerConnectionTracker(this.connectionTracker);
        StorageService.instance.register(notifier);
        Schema.instance.registerListener(notifier);
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    public void stop(boolean force) {
        if (this.isRunning.compareAndSet(true, false)) {
            this.close(force);
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning.get();
    }

    @Override
    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        ChannelFuture bindFuture = this.pipelineConfigurator.initializeChannel(this.workerGroup, this.socket, this.connectionFactory);
        if (!bindFuture.awaitUninterruptibly().isSuccess()) {
            throw new IllegalStateException(String.format("Failed to bind port %d on %s.", this.socket.getPort(), this.socket.getAddress().getHostAddress()), bindFuture.cause());
        }
        this.connectionTracker.allChannels.add(bindFuture.channel());
        this.isRunning.set(true);
    }

    public int countConnectedClients() {
        return this.connectionTracker.countConnectedClients();
    }

    public Map<String, Integer> countConnectedClientsByUser() {
        return this.connectionTracker.countConnectedClientsByUser();
    }

    public List<ConnectedClient> getConnectedClients() {
        ArrayList<ConnectedClient> result = new ArrayList<ConnectedClient>();
        for (Channel c : this.connectionTracker.allChannels) {
            Connection conn = c.attr(Connection.attributeKey).get();
            if (!(conn instanceof ServerConnection)) continue;
            result.add(new ConnectedClient((ServerConnection)conn));
        }
        return result;
    }

    public List<ClientStat> recentClientStats() {
        return this.connectionTracker.protocolVersionTracker.getAll();
    }

    @Override
    public void clearConnectionHistory() {
        this.connectionTracker.protocolVersionTracker.clear();
    }

    private void close(boolean force) {
        if (!force) {
            long deadline = Clock.Global.nanoTime() + DatabaseDescriptor.getNativeTransportTimeout(TimeUnit.NANOSECONDS);
            while (!this.dispatcher.isDone()) {
                if (Clock.Global.nanoTime() > deadline) {
                    logger.warn("Some connections took longer than the native transport timeout to complete");
                    break;
                }
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(100L));
            }
        }
        this.connectionTracker.closeAll();
        logger.info("Stop listening for CQL clients");
    }

    static {
        InternalLoggerFactory.setDefaultFactory(new Slf4JLoggerFactory());
        logger = LoggerFactory.getLogger(Server.class);
        useEpoll = NativeTransportService.useEpoll();
    }

    public static class EventNotifier
    implements SchemaChangeListener,
    IEndpointLifecycleSubscriber {
        private ConnectionTracker connectionTracker;
        private final Map<InetAddressAndPort, LatestEvent> latestEvents = new ConcurrentHashMap<InetAddressAndPort, LatestEvent>();
        private final Set<InetAddressAndPort> endpointsPendingJoinedNotification = ConcurrentHashMap.newKeySet();

        private void registerConnectionTracker(ConnectionTracker connectionTracker) {
            this.connectionTracker = connectionTracker;
        }

        private InetAddressAndPort getNativeAddress(InetAddressAndPort endpoint) {
            try {
                return InetAddressAndPort.getByName(StorageService.instance.getNativeaddress(endpoint, true));
            }
            catch (UnknownHostException e) {
                logger.error("Problem retrieving RPC address for {}", (Object)endpoint, (Object)e);
                return InetAddressAndPort.getByAddressOverrideDefaults(endpoint.getAddress(), DatabaseDescriptor.getNativeTransportPort());
            }
        }

        private void send(InetAddressAndPort endpoint, Event.NodeEvent event) {
            if (logger.isTraceEnabled()) {
                logger.trace("Sending event for endpoint {}, rpc address {}", (Object)endpoint, (Object)event.nodeAddressAndPort());
            }
            if (!endpoint.equals(FBUtilities.getBroadcastAddressAndPort()) && event.nodeAddressAndPort().equals(FBUtilities.getBroadcastNativeAddressAndPort())) {
                return;
            }
            this.send(event);
        }

        private void send(Event event) {
            this.connectionTracker.send(event);
        }

        @Override
        public void onJoinCluster(InetAddressAndPort endpoint) {
            if (!StorageService.instance.isRpcReady(endpoint)) {
                this.endpointsPendingJoinedNotification.add(endpoint);
            } else {
                this.onTopologyChange(endpoint, Event.TopologyChange.newNode(this.getNativeAddress(endpoint)));
            }
        }

        @Override
        public void onLeaveCluster(InetAddressAndPort endpoint) {
            this.onTopologyChange(endpoint, Event.TopologyChange.removedNode(this.getNativeAddress(endpoint)));
        }

        @Override
        public void onMove(InetAddressAndPort endpoint) {
            this.onTopologyChange(endpoint, Event.TopologyChange.movedNode(this.getNativeAddress(endpoint)));
        }

        @Override
        public void onUp(InetAddressAndPort endpoint) {
            if (this.endpointsPendingJoinedNotification.remove(endpoint)) {
                this.onJoinCluster(endpoint);
            }
            this.onStatusChange(endpoint, Event.StatusChange.nodeUp(this.getNativeAddress(endpoint)));
        }

        @Override
        public void onDown(InetAddressAndPort endpoint) {
            this.onStatusChange(endpoint, Event.StatusChange.nodeDown(this.getNativeAddress(endpoint)));
        }

        private void onTopologyChange(InetAddressAndPort endpoint, Event.TopologyChange event) {
            LatestEvent ret;
            LatestEvent prev;
            if (logger.isTraceEnabled()) {
                logger.trace("Topology changed event : {}, {}", (Object)endpoint, (Object)event.change);
            }
            if (((prev = this.latestEvents.get(endpoint)) == null || prev.topology != event.change) && (ret = this.latestEvents.put(endpoint, LatestEvent.forTopologyChange(event.change, prev))) == prev) {
                this.send(endpoint, event);
            }
        }

        private void onStatusChange(InetAddressAndPort endpoint, Event.StatusChange event) {
            LatestEvent ret;
            LatestEvent prev;
            if (logger.isTraceEnabled()) {
                logger.trace("Status changed event : {}, {}", (Object)endpoint, (Object)event.status);
            }
            if (((prev = this.latestEvents.get(endpoint)) == null || prev.status != event.status) && (ret = this.latestEvents.put(endpoint, LatestEvent.forStatusChange(event.status, null))) == prev) {
                this.send(endpoint, event);
            }
        }

        @Override
        public void onCreateKeyspace(KeyspaceMetadata keyspace) {
            this.send(new Event.SchemaChange(Event.SchemaChange.Change.CREATED, keyspace.name));
        }

        @Override
        public void onCreateTable(TableMetadata table) {
            this.send(new Event.SchemaChange(Event.SchemaChange.Change.CREATED, Event.SchemaChange.Target.TABLE, table.keyspace, table.name));
        }

        @Override
        public void onCreateType(UserType type) {
            this.send(new Event.SchemaChange(Event.SchemaChange.Change.CREATED, Event.SchemaChange.Target.TYPE, type.keyspace, type.getNameAsString()));
        }

        @Override
        public void onCreateFunction(UDFunction function) {
            this.send(new Event.SchemaChange(Event.SchemaChange.Change.CREATED, Event.SchemaChange.Target.FUNCTION, function.name().keyspace, function.name().name, AbstractType.asCQLTypeStringList(function.argTypes())));
        }

        @Override
        public void onCreateAggregate(UDAggregate aggregate) {
            this.send(new Event.SchemaChange(Event.SchemaChange.Change.CREATED, Event.SchemaChange.Target.AGGREGATE, aggregate.name().keyspace, aggregate.name().name, AbstractType.asCQLTypeStringList(aggregate.argTypes())));
        }

        @Override
        public void onAlterKeyspace(KeyspaceMetadata before, KeyspaceMetadata after) {
            this.send(new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, after.name));
        }

        @Override
        public void onAlterTable(TableMetadata before, TableMetadata after, boolean affectsStatements) {
            this.send(new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, after.keyspace, after.name));
        }

        @Override
        public void onAlterType(UserType before, UserType after) {
            this.send(new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TYPE, after.keyspace, after.getNameAsString()));
        }

        @Override
        public void onAlterFunction(UDFunction before, UDFunction after) {
            this.send(new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.FUNCTION, after.name().keyspace, after.name().name, AbstractType.asCQLTypeStringList(after.argTypes())));
        }

        @Override
        public void onAlterAggregate(UDAggregate before, UDAggregate after) {
            this.send(new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.AGGREGATE, after.name().keyspace, after.name().name, AbstractType.asCQLTypeStringList(after.argTypes())));
        }

        @Override
        public void onDropKeyspace(KeyspaceMetadata keyspace, boolean dropData) {
            this.send(new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, keyspace.name));
        }

        @Override
        public void onDropTable(TableMetadata table, boolean dropData) {
            this.send(new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, Event.SchemaChange.Target.TABLE, table.keyspace, table.name));
        }

        @Override
        public void onDropType(UserType type) {
            this.send(new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, Event.SchemaChange.Target.TYPE, type.keyspace, type.getNameAsString()));
        }

        @Override
        public void onDropFunction(UDFunction function) {
            this.send(new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, Event.SchemaChange.Target.FUNCTION, function.name().keyspace, function.name().name, AbstractType.asCQLTypeStringList(function.argTypes())));
        }

        @Override
        public void onDropAggregate(UDAggregate aggregate) {
            this.send(new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, Event.SchemaChange.Target.AGGREGATE, aggregate.name().keyspace, aggregate.name().name, AbstractType.asCQLTypeStringList(aggregate.argTypes())));
        }
    }

    private static class LatestEvent {
        public final Event.StatusChange.Status status;
        public final Event.TopologyChange.Change topology;

        private LatestEvent(Event.StatusChange.Status status, Event.TopologyChange.Change topology) {
            this.status = status;
            this.topology = topology;
        }

        public String toString() {
            return String.format("Status %s, Topology %s", new Object[]{this.status, this.topology});
        }

        public static LatestEvent forStatusChange(Event.StatusChange.Status status, LatestEvent prev) {
            return new LatestEvent(status, prev == null ? null : prev.topology);
        }

        public static LatestEvent forTopologyChange(Event.TopologyChange.Change change, LatestEvent prev) {
            return new LatestEvent(prev == null ? null : prev.status, change);
        }
    }

    public static class ConnectionTracker
    implements Connection.Tracker {
        private static final ChannelMatcher PRE_V5_CHANNEL = channel -> channel.attr(Connection.attributeKey).get().getVersion().isSmallerThan(ProtocolVersion.V5);
        public final ChannelGroup allChannels = new DefaultChannelGroup(GlobalEventExecutor.INSTANCE);
        private final EnumMap<Event.Type, ChannelGroup> groups = new EnumMap(Event.Type.class);
        private final ProtocolVersionTracker protocolVersionTracker = new ProtocolVersionTracker();
        private final BooleanSupplier isRunning;

        private ConnectionTracker(BooleanSupplier isRunning) {
            for (Event.Type type : Event.Type.values()) {
                this.groups.put(type, new DefaultChannelGroup(type.toString(), GlobalEventExecutor.INSTANCE));
            }
            this.isRunning = isRunning;
        }

        @Override
        public void addConnection(Channel ch, Connection connection) {
            this.allChannels.add(ch);
            if (ch.remoteAddress() instanceof InetSocketAddress) {
                this.protocolVersionTracker.addConnection(((InetSocketAddress)ch.remoteAddress()).getAddress(), connection.getVersion());
            }
        }

        @Override
        public boolean isRunning() {
            return this.isRunning.getAsBoolean();
        }

        public void register(Event.Type type, Channel ch) {
            this.groups.get((Object)type).add(ch);
        }

        public void send(Event event) {
            ChannelGroup registered = this.groups.get((Object)event.type);
            EventMessage message = new EventMessage(event);
            registered.writeAndFlush(message, PRE_V5_CHANNEL);
            for (Channel c : registered) {
                if (PRE_V5_CHANNEL.matches(c)) continue;
                c.attr(Dispatcher.EVENT_DISPATCHER).get().accept(message);
            }
        }

        void closeAll() {
            this.allChannels.flush().close().awaitUninterruptibly();
        }

        int countConnectedClients() {
            return this.allChannels.size() != 0 ? this.allChannels.size() - 1 : 0;
        }

        Map<String, Integer> countConnectedClientsByUser() {
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            for (Channel c : this.allChannels) {
                Connection connection = c.attr(Connection.attributeKey).get();
                if (!(connection instanceof ServerConnection)) continue;
                ServerConnection conn = (ServerConnection)connection;
                AuthenticatedUser user = conn.getClientState().getUser();
                String name = null != user ? user.getName() : null;
                result.put(name, result.getOrDefault(name, 0) + 1);
            }
            return result;
        }
    }

    public static class Builder {
        private EventLoopGroup workerGroup;
        private EncryptionOptions.TlsEncryptionPolicy tlsEncryptionPolicy = EncryptionOptions.TlsEncryptionPolicy.UNENCRYPTED;
        private InetAddress hostAddr;
        private int port = -1;
        private InetSocketAddress socket;
        private PipelineConfigurator pipelineConfigurator;
        private EventNotifier eventNotifier;

        public Builder withTlsEncryptionPolicy(EncryptionOptions.TlsEncryptionPolicy tlsEncryptionPolicy) {
            this.tlsEncryptionPolicy = tlsEncryptionPolicy;
            return this;
        }

        public Builder withEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.workerGroup = eventLoopGroup;
            return this;
        }

        public Builder withHost(InetAddress host) {
            this.hostAddr = host;
            this.socket = null;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            this.socket = null;
            return this;
        }

        public Builder withPipelineConfigurator(PipelineConfigurator configurator) {
            this.pipelineConfigurator = configurator;
            return this;
        }

        public Builder withEventNotifier(EventNotifier eventNotifier) {
            this.eventNotifier = eventNotifier;
            return this;
        }

        public Server build() {
            return new Server(this);
        }

        private InetSocketAddress getSocket() {
            if (this.socket != null) {
                return this.socket;
            }
            if (this.port == -1) {
                throw new IllegalStateException("Missing port number");
            }
            if (this.hostAddr == null) {
                throw new IllegalStateException("Missing host");
            }
            this.socket = new InetSocketAddress(this.hostAddr, this.port);
            return this.socket;
        }
    }
}

