/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.segment;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.tries.InMemoryTrie;
import org.apache.cassandra.index.sai.postings.PostingList;
import org.apache.cassandra.index.sai.utils.IndexEntry;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.lucene.util.packed.PackedLongValues;

@NotThreadSafe
public class SegmentTrieBuffer {
    private static final int MAX_RECURSIVE_TERM_LENGTH = 128;
    private final InMemoryTrie<PackedLongValues.Builder> trie = new InMemoryTrie(DatabaseDescriptor.getMemtableAllocationType().toBufferType());
    private final PostingsAccumulator postingsAccumulator = new PostingsAccumulator();
    private int numRows;

    public int numRows() {
        return this.numRows;
    }

    public long memoryUsed() {
        return this.trie.sizeOnHeap() + this.postingsAccumulator.heapAllocations();
    }

    public long add(ByteComparable term, int termLength, int segmentRowId) {
        long initialSizeOnHeap = this.trie.sizeOnHeap();
        long reducerHeapSize = this.postingsAccumulator.heapAllocations();
        try {
            this.trie.putSingleton(term, segmentRowId, this.postingsAccumulator, termLength <= 128);
        }
        catch (InMemoryTrie.SpaceExhaustedException e) {
            throw Throwables.unchecked(e);
        }
        ++this.numRows;
        return this.trie.sizeOnHeap() - initialSizeOnHeap + (this.postingsAccumulator.heapAllocations() - reducerHeapSize);
    }

    public Iterator<IndexEntry> iterator() {
        final Iterator iterator = this.trie.entrySet().iterator();
        return new Iterator<IndexEntry>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public IndexEntry next() {
                Map.Entry entry = (Map.Entry)iterator.next();
                final PackedLongValues postings = ((PackedLongValues.Builder)entry.getValue()).build();
                final PackedLongValues.Iterator postingsIterator = postings.iterator();
                return IndexEntry.create((ByteComparable)entry.getKey(), new PostingList(){

                    @Override
                    public long nextPosting() {
                        if (postingsIterator.hasNext()) {
                            return postingsIterator.next();
                        }
                        return Long.MAX_VALUE;
                    }

                    @Override
                    public long size() {
                        return postings.size();
                    }

                    @Override
                    public long advance(long targetRowID) {
                        throw new UnsupportedOperationException();
                    }
                });
            }
        };
    }

    private static class PostingsAccumulator
    implements InMemoryTrie.UpsertTransformer<PackedLongValues.Builder, Integer> {
        private final LongAdder heapAllocations = new LongAdder();

        private PostingsAccumulator() {
        }

        @Override
        public PackedLongValues.Builder apply(PackedLongValues.Builder existing, Integer rowID) {
            if (existing == null) {
                existing = PackedLongValues.deltaPackedBuilder(0.0f);
                this.heapAllocations.add(existing.ramBytesUsed());
            }
            long ramBefore = existing.ramBytesUsed();
            existing.add(rowID.intValue());
            this.heapAllocations.add(existing.ramBytesUsed() - ramBefore);
            return existing;
        }

        long heapAllocations() {
            return this.heapAllocations.longValue();
        }
    }
}

