/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.memtable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.BufferDecoratedKey;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.memtable.AbstractMemtable;
import org.apache.cassandra.db.memtable.AbstractShardedMemtable;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.partitions.AbstractUnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.BTreePartitionData;
import org.apache.cassandra.db.partitions.BTreePartitionUpdater;
import org.apache.cassandra.db.partitions.ImmutableBTreePartition;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.tries.InMemoryTrie;
import org.apache.cassandra.db.tries.Trie;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.index.transactions.UpdateTransaction;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.sstable.SSTableReadsListener;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.metrics.TrieMemtableMetricsView;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.EnsureOnHeap;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.github.jamm.Unmetered;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrieMemtable
extends AbstractShardedMemtable {
    private static final Logger logger = LoggerFactory.getLogger(TrieMemtable.class);
    public static final BufferType BUFFER_TYPE = DatabaseDescriptor.getMemtableAllocationType().toBufferType();
    @VisibleForTesting
    public static final int MAX_RECURSIVE_KEY_LENGTH = 128;
    public static final ByteComparable.Version BYTE_COMPARABLE_VERSION = ByteComparable.Version.OSS50;
    private final AtomicBoolean switchRequested = new AtomicBoolean(false);
    private final MemtableShard[] shards;
    private final Trie<BTreePartitionData> mergedTrie;
    @Unmetered
    private final TrieMemtableMetricsView metrics;

    TrieMemtable(AtomicReference<CommitLogPosition> commitLogLowerBound, TableMetadataRef metadataRef, Memtable.Owner owner, Integer shardCountOption) {
        super(commitLogLowerBound, metadataRef, owner, shardCountOption);
        this.metrics = new TrieMemtableMetricsView(metadataRef.keyspace, metadataRef.name);
        this.shards = TrieMemtable.generatePartitionShards(this.boundaries.shardCount(), this.allocator, metadataRef, this.metrics);
        this.mergedTrie = TrieMemtable.makeMergedTrie(this.shards);
    }

    private static MemtableShard[] generatePartitionShards(int splits, MemtableAllocator allocator, TableMetadataRef metadata, TrieMemtableMetricsView metrics) {
        MemtableShard[] partitionMapContainer = new MemtableShard[splits];
        for (int i = 0; i < splits; ++i) {
            partitionMapContainer[i] = new MemtableShard(metadata, allocator, metrics);
        }
        return partitionMapContainer;
    }

    private static Trie<BTreePartitionData> makeMergedTrie(MemtableShard[] shards) {
        ArrayList<InMemoryTrie<BTreePartitionData>> tries = new ArrayList<InMemoryTrie<BTreePartitionData>>(shards.length);
        for (MemtableShard shard : shards) {
            tries.add(shard.data);
        }
        return Trie.mergeDistinct(tries);
    }

    @Override
    public boolean isClean() {
        for (MemtableShard shard : this.shards) {
            if (shard.isClean()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void discard() {
        super.discard();
        this.metrics.lastFlushShardDataSizes.reset();
        for (MemtableShard shard : this.shards) {
            this.metrics.lastFlushShardDataSizes.update(shard.liveDataSize());
        }
        for (MemtableShard shard : this.shards) {
            shard.data.discardBuffers();
        }
    }

    @Override
    public long put(PartitionUpdate update, UpdateTransaction indexer, OpOrder.Group opGroup) {
        try {
            DecoratedKey key = update.partitionKey();
            MemtableShard shard = this.shards[this.boundaries.getShardForKey(key)];
            long colUpdateTimeDelta = shard.put(key, update, indexer, opGroup);
            if (shard.data.reachedAllocatedSizeThreshold() && !this.switchRequested.getAndSet(true)) {
                logger.info("Scheduling flush due to trie size limit reached.");
                this.owner.signalFlushRequired(this, ColumnFamilyStore.FlushReason.MEMTABLE_LIMIT);
            }
            return colUpdateTimeDelta;
        }
        catch (InMemoryTrie.SpaceExhaustedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public long getLiveDataSize() {
        long total = 0L;
        for (MemtableShard shard : this.shards) {
            total += shard.liveDataSize();
        }
        return total;
    }

    @Override
    public long operationCount() {
        long total = 0L;
        for (MemtableShard shard : this.shards) {
            total += shard.currentOperations();
        }
        return total;
    }

    @Override
    public long partitionCount() {
        int total = 0;
        for (MemtableShard shard : this.shards) {
            total += shard.size();
        }
        return total;
    }

    @Override
    public long getMinTimestamp() {
        long min2 = Long.MAX_VALUE;
        for (MemtableShard shard : this.shards) {
            min2 = Long.min(min2, shard.minTimestamp());
        }
        return min2 != EncodingStats.NO_STATS.minTimestamp ? min2 : -1L;
    }

    @Override
    public long getMinLocalDeletionTime() {
        long min2 = Long.MAX_VALUE;
        for (MemtableShard shard : this.shards) {
            min2 = Long.min(min2, shard.minLocalDeletionTime());
        }
        return min2;
    }

    @Override
    RegularAndStaticColumns columns() {
        for (MemtableShard shard : this.shards) {
            this.columnsCollector.update(shard.columnsCollector);
        }
        return this.columnsCollector.get();
    }

    @Override
    EncodingStats encodingStats() {
        for (MemtableShard shard : this.shards) {
            this.statsCollector.update(shard.statsCollector.get());
        }
        return this.statsCollector.get();
    }

    @Override
    public MemtableUnfilteredPartitionIterator partitionIterator(ColumnFilter columnFilter, DataRange dataRange, SSTableReadsListener readsListener) {
        boolean isBound;
        AbstractBounds<PartitionPosition> keyRange = dataRange.keyRange();
        PartitionPosition left = (PartitionPosition)keyRange.left;
        PartitionPosition right = (PartitionPosition)keyRange.right;
        if (left.isMinimum()) {
            left = null;
        }
        if (right.isMinimum()) {
            right = null;
        }
        boolean includeStart = (isBound = keyRange instanceof Bounds) || keyRange instanceof IncludingExcludingBounds;
        boolean includeStop = isBound || keyRange instanceof Range;
        Trie<BTreePartitionData> subMap = this.mergedTrie.subtrie(left, includeStart, right, includeStop);
        return new MemtableUnfilteredPartitionIterator(this.metadata(), this.allocator.ensureOnHeap(), subMap, columnFilter, dataRange);
    }

    private Partition getPartition(DecoratedKey key) {
        int shardIndex = this.boundaries.getShardForKey(key);
        BTreePartitionData data = (BTreePartitionData)this.shards[shardIndex].data.get(key);
        if (data != null) {
            return TrieMemtable.createPartition(this.metadata(), this.allocator.ensureOnHeap(), key, data);
        }
        return null;
    }

    @Override
    public UnfilteredRowIterator rowIterator(DecoratedKey key, Slices slices, ColumnFilter selectedColumns, boolean reversed, SSTableReadsListener listener) {
        Partition p = this.getPartition(key);
        if (p == null) {
            return null;
        }
        return p.unfilteredIterator(selectedColumns, slices, reversed);
    }

    @Override
    public UnfilteredRowIterator rowIterator(DecoratedKey key) {
        Partition p = this.getPartition(key);
        return p != null ? p.unfilteredIterator() : null;
    }

    private static MemtablePartition createPartition(TableMetadata metadata, EnsureOnHeap ensureOnHeap, DecoratedKey key, BTreePartitionData data) {
        return new MemtablePartition(metadata, ensureOnHeap, key, data);
    }

    private static MemtablePartition getPartitionFromTrieEntry(TableMetadata metadata, EnsureOnHeap ensureOnHeap, Map.Entry<ByteComparable, BTreePartitionData> en) {
        BufferDecoratedKey key = BufferDecoratedKey.fromByteComparable(en.getKey(), BYTE_COMPARABLE_VERSION, metadata.partitioner);
        return TrieMemtable.createPartition(metadata, ensureOnHeap, key, en.getValue());
    }

    public Memtable.FlushablePartitionSet<MemtablePartition> getFlushSet(final PartitionPosition from, final PartitionPosition to) {
        final Trie<BTreePartitionData> toFlush = this.mergedTrie.subtrie(from, true, to, false);
        long keySize = 0L;
        int keyCount = 0;
        Iterator<Map.Entry<ByteComparable, BTreePartitionData>> it = toFlush.entryIterator();
        while (it.hasNext()) {
            Map.Entry<ByteComparable, BTreePartitionData> en = it.next();
            byte[] keyBytes = DecoratedKey.keyFromByteSource(ByteSource.peekable(en.getKey().asComparableBytes(BYTE_COMPARABLE_VERSION)), BYTE_COMPARABLE_VERSION, this.metadata().partitioner);
            keySize += (long)keyBytes.length;
            ++keyCount;
        }
        final long partitionKeySize = keySize;
        final int partitionCount = keyCount;
        return new AbstractMemtable.AbstractFlushablePartitionSet<MemtablePartition>(){

            @Override
            public Memtable memtable() {
                return TrieMemtable.this;
            }

            @Override
            public PartitionPosition from() {
                return from;
            }

            @Override
            public PartitionPosition to() {
                return to;
            }

            @Override
            public long partitionCount() {
                return partitionCount;
            }

            @Override
            public Iterator<MemtablePartition> iterator() {
                return Iterators.transform(toFlush.entryIterator(), entry -> TrieMemtable.getPartitionFromTrieEntry(this.metadata(), EnsureOnHeap.NOOP, entry));
            }

            @Override
            public long partitionKeysSize() {
                return partitionKeySize;
            }
        };
    }

    public static Factory factory(Map<String, String> optionsCopy) {
        String shardsString = optionsCopy.remove("shards");
        Integer shardCount = shardsString != null ? Integer.valueOf(Integer.parseInt(shardsString)) : null;
        return new Factory(shardCount);
    }

    @VisibleForTesting
    public long unusedReservedMemory() {
        long size = 0L;
        for (MemtableShard shard : this.shards) {
            size += shard.data.unusedReservedMemory();
        }
        return size;
    }

    static class Factory
    implements Memtable.Factory {
        final Integer shardCount;

        Factory(Integer shardCount) {
            this.shardCount = shardCount;
        }

        @Override
        public Memtable create(AtomicReference<CommitLogPosition> commitLogLowerBound, TableMetadataRef metadaRef, Memtable.Owner owner) {
            return new TrieMemtable(commitLogLowerBound, metadaRef, owner, this.shardCount);
        }

        @Override
        public TableMetrics.ReleasableMetric createMemtableMetrics(TableMetadataRef metadataRef) {
            TrieMemtableMetricsView metrics = new TrieMemtableMetricsView(metadataRef.keyspace, metadataRef.name);
            return metrics::release;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Factory factory = (Factory)o;
            return Objects.equals(this.shardCount, factory.shardCount);
        }

        public int hashCode() {
            return Objects.hash(this.shardCount);
        }
    }

    static class MemtablePartition
    extends ImmutableBTreePartition {
        private final EnsureOnHeap ensureOnHeap;

        private MemtablePartition(TableMetadata table, EnsureOnHeap ensureOnHeap, DecoratedKey key, BTreePartitionData data) {
            super(table, key, data);
            this.ensureOnHeap = ensureOnHeap;
        }

        @Override
        protected boolean canHaveShadowedData() {
            return true;
        }

        @Override
        public DeletionInfo deletionInfo() {
            return this.ensureOnHeap.applyToDeletionInfo(super.deletionInfo());
        }

        @Override
        public Row staticRow() {
            return this.ensureOnHeap.applyToStatic(super.staticRow());
        }

        @Override
        public DecoratedKey partitionKey() {
            return this.ensureOnHeap.applyToPartitionKey(super.partitionKey());
        }

        @Override
        public Row getRow(Clustering<?> clustering) {
            return this.ensureOnHeap.applyToRow(super.getRow(clustering));
        }

        @Override
        public Row lastRow() {
            return this.ensureOnHeap.applyToRow(super.lastRow());
        }

        @Override
        public UnfilteredRowIterator unfilteredIterator(ColumnFilter selection, Slices slices, boolean reversed) {
            return this.unfilteredIterator(this.holder(), selection, slices, reversed);
        }

        @Override
        public UnfilteredRowIterator unfilteredIterator(ColumnFilter selection, NavigableSet<Clustering<?>> clusteringsInQueryOrder, boolean reversed) {
            return this.ensureOnHeap.applyToPartition(super.unfilteredIterator(selection, clusteringsInQueryOrder, reversed));
        }

        @Override
        public UnfilteredRowIterator unfilteredIterator() {
            return this.unfilteredIterator(ColumnFilter.selection(super.columns()), Slices.ALL, false);
        }

        @Override
        public UnfilteredRowIterator unfilteredIterator(BTreePartitionData current, ColumnFilter selection, Slices slices, boolean reversed) {
            return this.ensureOnHeap.applyToPartition(super.unfilteredIterator(current, selection, slices, reversed));
        }

        @Override
        public Iterator<Row> iterator() {
            return this.ensureOnHeap.applyToPartition(super.iterator());
        }
    }

    static class MemtableUnfilteredPartitionIterator
    extends AbstractUnfilteredPartitionIterator
    implements UnfilteredPartitionIterator {
        private final TableMetadata metadata;
        private final EnsureOnHeap ensureOnHeap;
        private final Iterator<Map.Entry<ByteComparable, BTreePartitionData>> iter;
        private final ColumnFilter columnFilter;
        private final DataRange dataRange;

        public MemtableUnfilteredPartitionIterator(TableMetadata metadata, EnsureOnHeap ensureOnHeap, Trie<BTreePartitionData> source, ColumnFilter columnFilter, DataRange dataRange) {
            this.metadata = metadata;
            this.ensureOnHeap = ensureOnHeap;
            this.iter = source.entryIterator();
            this.columnFilter = columnFilter;
            this.dataRange = dataRange;
        }

        @Override
        public TableMetadata metadata() {
            return this.metadata;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public UnfilteredRowIterator next() {
            MemtablePartition partition = TrieMemtable.getPartitionFromTrieEntry(this.metadata(), this.ensureOnHeap, this.iter.next());
            DecoratedKey key = partition.partitionKey();
            ClusteringIndexFilter filter = this.dataRange.clusteringIndexFilter(key);
            return filter.getUnfilteredRowIterator(this.columnFilter, partition);
        }
    }

    static class MemtableShard {
        private volatile long minTimestamp = Long.MAX_VALUE;
        private volatile long minLocalDeletionTime = Long.MAX_VALUE;
        private volatile long liveDataSize = 0L;
        private volatile long currentOperations = 0L;
        @Unmetered
        private final ReentrantLock writeLock = new ReentrantLock();
        @VisibleForTesting
        final InMemoryTrie<BTreePartitionData> data = new InMemoryTrie(BUFFER_TYPE);
        private final AbstractMemtable.ColumnsCollector columnsCollector;
        private final AbstractMemtable.StatsCollector statsCollector;
        @Unmetered
        private final MemtableAllocator allocator;
        @Unmetered
        private final TrieMemtableMetricsView metrics;

        @VisibleForTesting
        MemtableShard(TableMetadataRef metadata, MemtableAllocator allocator, TrieMemtableMetricsView metrics) {
            this.columnsCollector = new AbstractMemtable.ColumnsCollector(metadata.get().regularAndStaticColumns());
            this.statsCollector = new AbstractMemtable.StatsCollector();
            this.allocator = allocator;
            this.metrics = metrics;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long put(DecoratedKey key, PartitionUpdate update, UpdateTransaction indexer, OpOrder.Group opGroup) throws InMemoryTrie.SpaceExhaustedException {
            BTreePartitionUpdater updater = new BTreePartitionUpdater(this.allocator, this.allocator.cloner(opGroup), opGroup, indexer);
            boolean locked = this.writeLock.tryLock();
            if (locked) {
                this.metrics.uncontendedPuts.inc();
            } else {
                this.metrics.contendedPuts.inc();
                long lockStartTime = Clock.Global.nanoTime();
                this.writeLock.lock();
                this.metrics.contentionTime.addNano(Clock.Global.nanoTime() - lockStartTime);
            }
            try {
                try {
                    long onHeap = this.data.sizeOnHeap();
                    long offHeap = this.data.sizeOffHeap();
                    this.data.putSingleton(key, update, updater::mergePartitions, key.getKeyLength() < 128);
                    this.allocator.offHeap().adjust(this.data.sizeOffHeap() - offHeap, opGroup);
                    this.allocator.onHeap().adjust(this.data.sizeOnHeap() - onHeap, opGroup);
                }
                finally {
                    this.minTimestamp = Math.min(this.minTimestamp, update.stats().minTimestamp);
                    this.minLocalDeletionTime = Math.min(this.minLocalDeletionTime, update.stats().minLocalDeletionTime);
                    this.liveDataSize += updater.dataSize;
                    this.currentOperations += (long)update.operationCount();
                    this.columnsCollector.update(update.columns());
                    this.statsCollector.update(update.stats());
                }
            }
            finally {
                this.writeLock.unlock();
            }
            return updater.colUpdateTimeDelta;
        }

        public boolean isClean() {
            return this.data.isEmpty();
        }

        public int size() {
            return this.data.valuesCount();
        }

        long minTimestamp() {
            return this.minTimestamp;
        }

        long liveDataSize() {
            return this.liveDataSize;
        }

        long currentOperations() {
            return this.currentOperations;
        }

        long minLocalDeletionTime() {
            return this.minLocalDeletionTime;
        }
    }
}

