/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.function.BiFunction;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.NativeFunction;
import org.apache.cassandra.cql3.functions.NativeFunctions;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.NumberType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.exceptions.InvalidRequestException;

public final class MathFcts {
    public static void addFunctionsTo(NativeFunctions functions) {
        ImmutableList<CounterColumnType> numericTypes = ImmutableList.of(ByteType.instance, ShortType.instance, Int32Type.instance, FloatType.instance, LongType.instance, DoubleType.instance, IntegerType.instance, DecimalType.instance, CounterColumnType.instance);
        numericTypes.stream().map(t2 -> ImmutableList.of(MathFcts.absFct(t2), MathFcts.expFct(t2), MathFcts.logFct(t2), MathFcts.log10Fct(t2), MathFcts.roundFct(t2))).flatMap(Collection::stream).forEach(functions::add);
    }

    public static NativeFunction absFct(NumberType<?> type) {
        return MathFcts.mathFct("abs", type, NumberType::abs);
    }

    public static NativeFunction expFct(NumberType<?> type) {
        return MathFcts.mathFct("exp", type, NumberType::exp);
    }

    public static NativeFunction logFct(NumberType<?> type) {
        return MathFcts.mathFct("log", type, NumberType::log);
    }

    public static NativeFunction log10Fct(NumberType<?> type) {
        return MathFcts.mathFct("log10", type, NumberType::log10);
    }

    public static NativeFunction roundFct(NumberType<?> type) {
        return MathFcts.mathFct("round", type, NumberType::round);
    }

    private static NativeFunction mathFct(String name, final NumberType<?> type, final BiFunction<NumberType<?>, Number, ByteBuffer> f) {
        return new NativeScalarFunction(name, type, new AbstractType[]{type}){

            @Override
            public ByteBuffer execute(Arguments arguments) throws InvalidRequestException {
                Number number = (Number)arguments.get(0);
                if (number == null) {
                    return null;
                }
                return (ByteBuffer)f.apply(type, number);
            }
        };
    }

    private MathFcts() {
    }
}

