/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.threads.CleaningThread;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.threads.Threads;
import org.jetbrains.annotations.NotNull;

public class NamedThreadFactory
extends ThreadGroup
implements ThreadFactory {
    private final AtomicInteger id = new AtomicInteger();
    private final String nameShadow;
    private final Boolean daemonShadow;
    private final Integer priority;
    private final StackTrace createdHere;
    private final boolean inEventLoop;

    public NamedThreadFactory(String name) {
        this(name, null, null);
    }

    public NamedThreadFactory(String name, Boolean daemon) {
        this(name, daemon, null);
    }

    public NamedThreadFactory(String name, Boolean daemon, Integer priority) {
        this(name, daemon, priority, false);
    }

    public NamedThreadFactory(String name, Boolean daemon, Integer priority, boolean inEventLoop) {
        super(name);
        this.nameShadow = name;
        this.daemonShadow = daemon;
        this.priority = priority;
        this.inEventLoop = inEventLoop;
        this.createdHere = Jvm.isResourceTracing() ? new StackTrace("NamedThreadFactory created here") : null;
    }

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable r) {
        int idSnapshot = this.id.getAndIncrement();
        String nameN = Threads.threadGroupPrefix() + (idSnapshot == 0 ? this.nameShadow : this.nameShadow + '-' + idSnapshot);
        CleaningThread t2 = new CleaningThread(r, nameN, this.inEventLoop);
        ThreadDump.add(t2, this.createdHere);
        if (this.daemonShadow != null) {
            t2.setDaemon(this.daemonShadow);
        }
        if (this.priority != null) {
            t2.setPriority(this.priority);
        }
        return t2;
    }

    public void interruptAll() {
        Thread[] list = new Thread[this.activeCount() + 1];
        super.enumerate(list);
        for (Thread thread : list) {
            if (thread == null) continue;
            thread.interrupt();
        }
    }
}

