/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import org.jetbrains.annotations.Nullable;

public class StackTrace
extends Throwable {
    public StackTrace() {
        this("stack trace");
    }

    public StackTrace(String message) {
        this(message, null);
    }

    public StackTrace(String message, Throwable cause) {
        super(message + " on " + Thread.currentThread().getName(), cause);
    }

    @Nullable
    public static StackTrace forThread(Thread t2) {
        if (t2 == null) {
            return null;
        }
        StackTrace st = new StackTrace(t2.toString());
        StackTraceElement[] stackTrace = t2.getStackTrace();
        int start = 0;
        if (stackTrace.length > 2 && stackTrace[0].isNativeMethod()) {
            ++start;
        }
        if (start > 0) {
            StackTraceElement[] ste2 = new StackTraceElement[stackTrace.length - start];
            System.arraycopy(stackTrace, start, ste2, 0, ste2.length);
            stackTrace = ste2;
        }
        st.setStackTrace(stackTrace);
        return st;
    }
}

